// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.GoogleAdsAllVersions;
import com.google.ads.googleads.v3.services.AccountBudgetProposalServiceClient;
import com.google.ads.googleads.v3.services.AccountBudgetProposalServiceSettings;
import com.google.ads.googleads.v3.services.AccountBudgetServiceClient;
import com.google.ads.googleads.v3.services.AccountBudgetServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupAdAssetViewServiceClient;
import com.google.ads.googleads.v3.services.AdGroupAdAssetViewServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupAdLabelServiceClient;
import com.google.ads.googleads.v3.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupAdServiceClient;
import com.google.ads.googleads.v3.services.AdGroupAdServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupAudienceViewServiceClient;
import com.google.ads.googleads.v3.services.AdGroupAudienceViewServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupBidModifierServiceClient;
import com.google.ads.googleads.v3.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupCriterionLabelServiceClient;
import com.google.ads.googleads.v3.services.AdGroupCriterionLabelServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupCriterionServiceClient;
import com.google.ads.googleads.v3.services.AdGroupCriterionServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupCriterionSimulationServiceClient;
import com.google.ads.googleads.v3.services.AdGroupCriterionSimulationServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupExtensionSettingServiceClient;
import com.google.ads.googleads.v3.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupFeedServiceClient;
import com.google.ads.googleads.v3.services.AdGroupFeedServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupLabelServiceClient;
import com.google.ads.googleads.v3.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupServiceClient;
import com.google.ads.googleads.v3.services.AdGroupServiceSettings;
import com.google.ads.googleads.v3.services.AdGroupSimulationServiceClient;
import com.google.ads.googleads.v3.services.AdGroupSimulationServiceSettings;
import com.google.ads.googleads.v3.services.AdParameterServiceClient;
import com.google.ads.googleads.v3.services.AdParameterServiceSettings;
import com.google.ads.googleads.v3.services.AdScheduleViewServiceClient;
import com.google.ads.googleads.v3.services.AdScheduleViewServiceSettings;
import com.google.ads.googleads.v3.services.AdServiceClient;
import com.google.ads.googleads.v3.services.AdServiceSettings;
import com.google.ads.googleads.v3.services.AgeRangeViewServiceClient;
import com.google.ads.googleads.v3.services.AgeRangeViewServiceSettings;
import com.google.ads.googleads.v3.services.AssetServiceClient;
import com.google.ads.googleads.v3.services.AssetServiceSettings;
import com.google.ads.googleads.v3.services.BiddingStrategyServiceClient;
import com.google.ads.googleads.v3.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v3.services.BillingSetupServiceClient;
import com.google.ads.googleads.v3.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v3.services.CampaignAudienceViewServiceClient;
import com.google.ads.googleads.v3.services.CampaignAudienceViewServiceSettings;
import com.google.ads.googleads.v3.services.CampaignBidModifierServiceClient;
import com.google.ads.googleads.v3.services.CampaignBidModifierServiceSettings;
import com.google.ads.googleads.v3.services.CampaignBudgetServiceClient;
import com.google.ads.googleads.v3.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v3.services.CampaignCriterionServiceClient;
import com.google.ads.googleads.v3.services.CampaignCriterionServiceSettings;
import com.google.ads.googleads.v3.services.CampaignCriterionSimulationServiceClient;
import com.google.ads.googleads.v3.services.CampaignCriterionSimulationServiceSettings;
import com.google.ads.googleads.v3.services.CampaignDraftServiceClient;
import com.google.ads.googleads.v3.services.CampaignDraftServiceSettings;
import com.google.ads.googleads.v3.services.CampaignExperimentServiceClient;
import com.google.ads.googleads.v3.services.CampaignExperimentServiceSettings;
import com.google.ads.googleads.v3.services.CampaignExtensionSettingServiceClient;
import com.google.ads.googleads.v3.services.CampaignExtensionSettingServiceSettings;
import com.google.ads.googleads.v3.services.CampaignFeedServiceClient;
import com.google.ads.googleads.v3.services.CampaignFeedServiceSettings;
import com.google.ads.googleads.v3.services.CampaignLabelServiceClient;
import com.google.ads.googleads.v3.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v3.services.CampaignServiceClient;
import com.google.ads.googleads.v3.services.CampaignServiceSettings;
import com.google.ads.googleads.v3.services.CampaignSharedSetServiceClient;
import com.google.ads.googleads.v3.services.CampaignSharedSetServiceSettings;
import com.google.ads.googleads.v3.services.CarrierConstantServiceClient;
import com.google.ads.googleads.v3.services.CarrierConstantServiceSettings;
import com.google.ads.googleads.v3.services.ChangeStatusServiceClient;
import com.google.ads.googleads.v3.services.ChangeStatusServiceSettings;
import com.google.ads.googleads.v3.services.ClickViewServiceClient;
import com.google.ads.googleads.v3.services.ClickViewServiceSettings;
import com.google.ads.googleads.v3.services.ConversionActionServiceClient;
import com.google.ads.googleads.v3.services.ConversionActionServiceSettings;
import com.google.ads.googleads.v3.services.ConversionAdjustmentUploadServiceClient;
import com.google.ads.googleads.v3.services.ConversionAdjustmentUploadServiceSettings;
import com.google.ads.googleads.v3.services.ConversionUploadServiceClient;
import com.google.ads.googleads.v3.services.ConversionUploadServiceSettings;
import com.google.ads.googleads.v3.services.CurrencyConstantServiceClient;
import com.google.ads.googleads.v3.services.CurrencyConstantServiceSettings;
import com.google.ads.googleads.v3.services.CustomInterestServiceClient;
import com.google.ads.googleads.v3.services.CustomInterestServiceSettings;
import com.google.ads.googleads.v3.services.CustomerClientLinkServiceClient;
import com.google.ads.googleads.v3.services.CustomerClientLinkServiceSettings;
import com.google.ads.googleads.v3.services.CustomerClientServiceClient;
import com.google.ads.googleads.v3.services.CustomerClientServiceSettings;
import com.google.ads.googleads.v3.services.CustomerExtensionSettingServiceClient;
import com.google.ads.googleads.v3.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v3.services.CustomerFeedServiceClient;
import com.google.ads.googleads.v3.services.CustomerFeedServiceSettings;
import com.google.ads.googleads.v3.services.CustomerLabelServiceClient;
import com.google.ads.googleads.v3.services.CustomerLabelServiceSettings;
import com.google.ads.googleads.v3.services.CustomerManagerLinkServiceClient;
import com.google.ads.googleads.v3.services.CustomerManagerLinkServiceSettings;
import com.google.ads.googleads.v3.services.CustomerNegativeCriterionServiceClient;
import com.google.ads.googleads.v3.services.CustomerNegativeCriterionServiceSettings;
import com.google.ads.googleads.v3.services.CustomerServiceClient;
import com.google.ads.googleads.v3.services.CustomerServiceSettings;
import com.google.ads.googleads.v3.services.DetailPlacementViewServiceClient;
import com.google.ads.googleads.v3.services.DetailPlacementViewServiceSettings;
import com.google.ads.googleads.v3.services.DisplayKeywordViewServiceClient;
import com.google.ads.googleads.v3.services.DisplayKeywordViewServiceSettings;
import com.google.ads.googleads.v3.services.DistanceViewServiceClient;
import com.google.ads.googleads.v3.services.DistanceViewServiceSettings;
import com.google.ads.googleads.v3.services.DomainCategoryServiceClient;
import com.google.ads.googleads.v3.services.DomainCategoryServiceSettings;
import com.google.ads.googleads.v3.services.DynamicSearchAdsSearchTermViewServiceClient;
import com.google.ads.googleads.v3.services.DynamicSearchAdsSearchTermViewServiceSettings;
import com.google.ads.googleads.v3.services.ExpandedLandingPageViewServiceClient;
import com.google.ads.googleads.v3.services.ExpandedLandingPageViewServiceSettings;
import com.google.ads.googleads.v3.services.ExtensionFeedItemServiceClient;
import com.google.ads.googleads.v3.services.ExtensionFeedItemServiceSettings;
import com.google.ads.googleads.v3.services.FeedItemServiceClient;
import com.google.ads.googleads.v3.services.FeedItemServiceSettings;
import com.google.ads.googleads.v3.services.FeedItemTargetServiceClient;
import com.google.ads.googleads.v3.services.FeedItemTargetServiceSettings;
import com.google.ads.googleads.v3.services.FeedMappingServiceClient;
import com.google.ads.googleads.v3.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v3.services.FeedPlaceholderViewServiceClient;
import com.google.ads.googleads.v3.services.FeedPlaceholderViewServiceSettings;
import com.google.ads.googleads.v3.services.FeedServiceClient;
import com.google.ads.googleads.v3.services.FeedServiceSettings;
import com.google.ads.googleads.v3.services.GenderViewServiceClient;
import com.google.ads.googleads.v3.services.GenderViewServiceSettings;
import com.google.ads.googleads.v3.services.GeoTargetConstantServiceClient;
import com.google.ads.googleads.v3.services.GeoTargetConstantServiceSettings;
import com.google.ads.googleads.v3.services.GeographicViewServiceClient;
import com.google.ads.googleads.v3.services.GeographicViewServiceSettings;
import com.google.ads.googleads.v3.services.GoogleAdsFieldServiceClient;
import com.google.ads.googleads.v3.services.GoogleAdsFieldServiceSettings;
import com.google.ads.googleads.v3.services.GoogleAdsServiceClient;
import com.google.ads.googleads.v3.services.GoogleAdsServiceSettings;
import com.google.ads.googleads.v3.services.GoogleAdsVersion;
import com.google.ads.googleads.v3.services.GroupPlacementViewServiceClient;
import com.google.ads.googleads.v3.services.GroupPlacementViewServiceSettings;
import com.google.ads.googleads.v3.services.HotelGroupViewServiceClient;
import com.google.ads.googleads.v3.services.HotelGroupViewServiceSettings;
import com.google.ads.googleads.v3.services.HotelPerformanceViewServiceClient;
import com.google.ads.googleads.v3.services.HotelPerformanceViewServiceSettings;
import com.google.ads.googleads.v3.services.InvoiceServiceClient;
import com.google.ads.googleads.v3.services.InvoiceServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanAdGroupServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanAdGroupServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanCampaignServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanIdeaServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanIdeaServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanKeywordServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanKeywordServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanNegativeKeywordServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanNegativeKeywordServiceSettings;
import com.google.ads.googleads.v3.services.KeywordPlanServiceClient;
import com.google.ads.googleads.v3.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v3.services.KeywordViewServiceClient;
import com.google.ads.googleads.v3.services.KeywordViewServiceSettings;
import com.google.ads.googleads.v3.services.LabelServiceClient;
import com.google.ads.googleads.v3.services.LabelServiceSettings;
import com.google.ads.googleads.v3.services.LandingPageViewServiceClient;
import com.google.ads.googleads.v3.services.LandingPageViewServiceSettings;
import com.google.ads.googleads.v3.services.LanguageConstantServiceClient;
import com.google.ads.googleads.v3.services.LanguageConstantServiceSettings;
import com.google.ads.googleads.v3.services.LocationViewServiceClient;
import com.google.ads.googleads.v3.services.LocationViewServiceSettings;
import com.google.ads.googleads.v3.services.ManagedPlacementViewServiceClient;
import com.google.ads.googleads.v3.services.ManagedPlacementViewServiceSettings;
import com.google.ads.googleads.v3.services.MediaFileServiceClient;
import com.google.ads.googleads.v3.services.MediaFileServiceSettings;
import com.google.ads.googleads.v3.services.MerchantCenterLinkServiceClient;
import com.google.ads.googleads.v3.services.MerchantCenterLinkServiceSettings;
import com.google.ads.googleads.v3.services.MobileAppCategoryConstantServiceClient;
import com.google.ads.googleads.v3.services.MobileAppCategoryConstantServiceSettings;
import com.google.ads.googleads.v3.services.MobileDeviceConstantServiceClient;
import com.google.ads.googleads.v3.services.MobileDeviceConstantServiceSettings;
import com.google.ads.googleads.v3.services.MutateJobServiceClient;
import com.google.ads.googleads.v3.services.MutateJobServiceSettings;
import com.google.ads.googleads.v3.services.OfflineUserDataJobServiceClient;
import com.google.ads.googleads.v3.services.OfflineUserDataJobServiceSettings;
import com.google.ads.googleads.v3.services.OperatingSystemVersionConstantServiceClient;
import com.google.ads.googleads.v3.services.OperatingSystemVersionConstantServiceSettings;
import com.google.ads.googleads.v3.services.PaidOrganicSearchTermViewServiceClient;
import com.google.ads.googleads.v3.services.PaidOrganicSearchTermViewServiceSettings;
import com.google.ads.googleads.v3.services.ParentalStatusViewServiceClient;
import com.google.ads.googleads.v3.services.ParentalStatusViewServiceSettings;
import com.google.ads.googleads.v3.services.PaymentsAccountServiceClient;
import com.google.ads.googleads.v3.services.PaymentsAccountServiceSettings;
import com.google.ads.googleads.v3.services.ProductBiddingCategoryConstantServiceClient;
import com.google.ads.googleads.v3.services.ProductBiddingCategoryConstantServiceSettings;
import com.google.ads.googleads.v3.services.ProductGroupViewServiceClient;
import com.google.ads.googleads.v3.services.ProductGroupViewServiceSettings;
import com.google.ads.googleads.v3.services.ReachPlanServiceClient;
import com.google.ads.googleads.v3.services.ReachPlanServiceSettings;
import com.google.ads.googleads.v3.services.RecommendationServiceClient;
import com.google.ads.googleads.v3.services.RecommendationServiceSettings;
import com.google.ads.googleads.v3.services.RemarketingActionServiceClient;
import com.google.ads.googleads.v3.services.RemarketingActionServiceSettings;
import com.google.ads.googleads.v3.services.SearchTermViewServiceClient;
import com.google.ads.googleads.v3.services.SearchTermViewServiceSettings;
import com.google.ads.googleads.v3.services.SharedCriterionServiceClient;
import com.google.ads.googleads.v3.services.SharedCriterionServiceSettings;
import com.google.ads.googleads.v3.services.SharedSetServiceClient;
import com.google.ads.googleads.v3.services.SharedSetServiceSettings;
import com.google.ads.googleads.v3.services.ShoppingPerformanceViewServiceClient;
import com.google.ads.googleads.v3.services.ShoppingPerformanceViewServiceSettings;
import com.google.ads.googleads.v3.services.TopicConstantServiceClient;
import com.google.ads.googleads.v3.services.TopicConstantServiceSettings;
import com.google.ads.googleads.v3.services.TopicViewServiceClient;
import com.google.ads.googleads.v3.services.TopicViewServiceSettings;
import com.google.ads.googleads.v3.services.UserDataServiceClient;
import com.google.ads.googleads.v3.services.UserDataServiceSettings;
import com.google.ads.googleads.v3.services.UserInterestServiceClient;
import com.google.ads.googleads.v3.services.UserInterestServiceSettings;
import com.google.ads.googleads.v3.services.UserListServiceClient;
import com.google.ads.googleads.v3.services.UserListServiceSettings;
import com.google.ads.googleads.v3.services.UserLocationViewServiceClient;
import com.google.ads.googleads.v3.services.UserLocationViewServiceSettings;
import com.google.ads.googleads.v3.services.VideoServiceClient;
import com.google.ads.googleads.v3.services.VideoServiceSettings;
import com.google.ads.googleads.v4.services.AccountLinkServiceClient;
import com.google.ads.googleads.v4.services.AccountLinkServiceSettings;
import com.google.ads.googleads.v4.services.BatchJobServiceClient;
import com.google.ads.googleads.v4.services.BatchJobServiceSettings;
import com.google.ads.googleads.v4.services.IncomeRangeViewServiceClient;
import com.google.ads.googleads.v4.services.IncomeRangeViewServiceSettings;
import com.google.ads.googleads.v4.services.KeywordPlanAdGroupKeywordServiceClient;
import com.google.ads.googleads.v4.services.KeywordPlanAdGroupKeywordServiceSettings;
import com.google.ads.googleads.v4.services.KeywordPlanCampaignKeywordServiceClient;
import com.google.ads.googleads.v4.services.KeywordPlanCampaignKeywordServiceSettings;
import com.google.ads.googleads.v4.services.ThirdPartyAppAnalyticsLinkServiceClient;
import com.google.ads.googleads.v4.services.ThirdPartyAppAnalyticsLinkServiceSettings;
import com.google.ads.googleads.v5.services.CampaignAssetServiceClient;
import com.google.ads.googleads.v5.services.CampaignAssetServiceSettings;
import com.google.ads.googleads.v6.services.CombinedAudienceServiceClient;
import com.google.ads.googleads.v6.services.CombinedAudienceServiceSettings;
import com.google.ads.googleads.v6.services.CustomAudienceServiceClient;
import com.google.ads.googleads.v6.services.CustomAudienceServiceSettings;
import com.google.ads.googleads.v6.services.CustomerUserAccessServiceClient;
import com.google.ads.googleads.v6.services.CustomerUserAccessServiceSettings;
import com.google.ads.googleads.v6.services.FeedItemSetLinkServiceClient;
import com.google.ads.googleads.v6.services.FeedItemSetLinkServiceSettings;
import com.google.ads.googleads.v6.services.FeedItemSetServiceClient;
import com.google.ads.googleads.v6.services.FeedItemSetServiceSettings;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.SortedSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class GeneratedCatalog extends AbstractCatalog {
  private static GeneratedCatalog instance;

  static {
    try {
      instance = new GeneratedCatalog(VersionCatalog.getCatalog());
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InstantiationException e) {
      throw new RuntimeException(e);
    }
  }

  private final ImmutableSortedSet<Version> supportedVersions;

  /**
   * Creates a new constant catalog from a known collection of versions. */
  public GeneratedCatalog(ImmutableSet<Version> versions) {
    supportedVersions = ImmutableSortedSet.copyOf(versions);
  }

  public static GeneratedCatalog getDefault() {
    return instance;
  }

  public SortedSet<Version> getSupportedVersions() {
    return supportedVersions;
  }

  public Version getLatestVersion() {
    return getSupportedVersions().first();
  }

  public GoogleAdsAllVersions createAllVersionsClient(TransportChannelProvider provider,
      Credentials credentials) {
    return new GoogleAdsAllVersions() {
      @Override
      public GoogleAdsVersion getVersion3() {
        return new V3Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v4.services.GoogleAdsVersion getVersion4() {
        return new V4Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v5.services.GoogleAdsVersion getVersion5() {
        return new V5Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v6.services.GoogleAdsVersion getVersion6() {
        return new V6Client(provider, credentials);
      }

      @Override
      public com.google.ads.googleads.v6.services.GoogleAdsVersion getLatestVersion() {
        return getVersion6();
      }
    };
  }

  private static class V3Client implements GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V3Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient() {
      try {
        AccountBudgetProposalServiceSettings settings =
          AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountBudgetServiceClient createAccountBudgetServiceClient() {
      try {
        AccountBudgetServiceSettings settings =
          AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient() {
      try {
        AdGroupAdAssetViewServiceSettings settings =
          AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient() {
      try {
        AdGroupAdLabelServiceSettings settings =
          AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAdServiceClient createAdGroupAdServiceClient() {
      try {
        AdGroupAdServiceSettings settings =
          AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient() {
      try {
        AdGroupAudienceViewServiceSettings settings =
          AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient() {
      try {
        AdGroupBidModifierServiceSettings settings =
          AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient() {
      try {
        AdGroupCriterionLabelServiceSettings settings =
          AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionServiceClient createAdGroupCriterionServiceClient() {
      try {
        AdGroupCriterionServiceSettings settings =
          AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient() {
      try {
        AdGroupCriterionSimulationServiceSettings settings =
          AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient() {
      try {
        AdGroupExtensionSettingServiceSettings settings =
          AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupFeedServiceClient createAdGroupFeedServiceClient() {
      try {
        AdGroupFeedServiceSettings settings =
          AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupLabelServiceClient createAdGroupLabelServiceClient() {
      try {
        AdGroupLabelServiceSettings settings =
          AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupServiceClient createAdGroupServiceClient() {
      try {
        AdGroupServiceSettings settings =
          AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdGroupSimulationServiceClient createAdGroupSimulationServiceClient() {
      try {
        AdGroupSimulationServiceSettings settings =
          AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdParameterServiceClient createAdParameterServiceClient() {
      try {
        AdParameterServiceSettings settings =
          AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdScheduleViewServiceClient createAdScheduleViewServiceClient() {
      try {
        AdScheduleViewServiceSettings settings =
          AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AdServiceClient createAdServiceClient() {
      try {
        AdServiceSettings settings =
          AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AgeRangeViewServiceClient createAgeRangeViewServiceClient() {
      try {
        AgeRangeViewServiceSettings settings =
          AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AssetServiceClient createAssetServiceClient() {
      try {
        AssetServiceSettings settings =
          AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BiddingStrategyServiceClient createBiddingStrategyServiceClient() {
      try {
        BiddingStrategyServiceSettings settings =
          BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BillingSetupServiceClient createBillingSetupServiceClient() {
      try {
        BillingSetupServiceSettings settings =
          BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient() {
      try {
        CampaignAudienceViewServiceSettings settings =
          CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBidModifierServiceClient createCampaignBidModifierServiceClient() {
      try {
        CampaignBidModifierServiceSettings settings =
          CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignBudgetServiceClient createCampaignBudgetServiceClient() {
      try {
        CampaignBudgetServiceSettings settings =
          CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionServiceClient createCampaignCriterionServiceClient() {
      try {
        CampaignCriterionServiceSettings settings =
          CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        CampaignCriterionSimulationServiceSettings settings =
          CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignDraftServiceClient createCampaignDraftServiceClient() {
      try {
        CampaignDraftServiceSettings settings =
          CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExperimentServiceClient createCampaignExperimentServiceClient() {
      try {
        CampaignExperimentServiceSettings settings =
          CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient() {
      try {
        CampaignExtensionSettingServiceSettings settings =
          CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignFeedServiceClient createCampaignFeedServiceClient() {
      try {
        CampaignFeedServiceSettings settings =
          CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignLabelServiceClient createCampaignLabelServiceClient() {
      try {
        CampaignLabelServiceSettings settings =
          CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignServiceClient createCampaignServiceClient() {
      try {
        CampaignServiceSettings settings =
          CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignSharedSetServiceClient createCampaignSharedSetServiceClient() {
      try {
        CampaignSharedSetServiceSettings settings =
          CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CarrierConstantServiceClient createCarrierConstantServiceClient() {
      try {
        CarrierConstantServiceSettings settings =
          CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ChangeStatusServiceClient createChangeStatusServiceClient() {
      try {
        ChangeStatusServiceSettings settings =
          ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ClickViewServiceClient createClickViewServiceClient() {
      try {
        ClickViewServiceSettings settings =
          ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionActionServiceClient createConversionActionServiceClient() {
      try {
        ConversionActionServiceSettings settings =
          ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient() {
      try {
        ConversionAdjustmentUploadServiceSettings settings =
          ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ConversionUploadServiceClient createConversionUploadServiceClient() {
      try {
        ConversionUploadServiceSettings settings =
          ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CurrencyConstantServiceClient createCurrencyConstantServiceClient() {
      try {
        CurrencyConstantServiceSettings settings =
          CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomInterestServiceClient createCustomInterestServiceClient() {
      try {
        CustomInterestServiceSettings settings =
          CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientLinkServiceClient createCustomerClientLinkServiceClient() {
      try {
        CustomerClientLinkServiceSettings settings =
          CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerClientServiceClient createCustomerClientServiceClient() {
      try {
        CustomerClientServiceSettings settings =
          CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient() {
      try {
        CustomerExtensionSettingServiceSettings settings =
          CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerFeedServiceClient createCustomerFeedServiceClient() {
      try {
        CustomerFeedServiceSettings settings =
          CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerLabelServiceClient createCustomerLabelServiceClient() {
      try {
        CustomerLabelServiceSettings settings =
          CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient() {
      try {
        CustomerManagerLinkServiceSettings settings =
          CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient() {
      try {
        CustomerNegativeCriterionServiceSettings settings =
          CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerServiceClient createCustomerServiceClient() {
      try {
        CustomerServiceSettings settings =
          CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DetailPlacementViewServiceClient createDetailPlacementViewServiceClient() {
      try {
        DetailPlacementViewServiceSettings settings =
          DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient() {
      try {
        DisplayKeywordViewServiceSettings settings =
          DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DistanceViewServiceClient createDistanceViewServiceClient() {
      try {
        DistanceViewServiceSettings settings =
          DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DomainCategoryServiceClient createDomainCategoryServiceClient() {
      try {
        DomainCategoryServiceSettings settings =
          DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        DynamicSearchAdsSearchTermViewServiceSettings settings =
          DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient() {
      try {
        ExpandedLandingPageViewServiceSettings settings =
          ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient() {
      try {
        ExtensionFeedItemServiceSettings settings =
          ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemServiceClient createFeedItemServiceClient() {
      try {
        FeedItemServiceSettings settings =
          FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemTargetServiceClient createFeedItemTargetServiceClient() {
      try {
        FeedItemTargetServiceSettings settings =
          FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedMappingServiceClient createFeedMappingServiceClient() {
      try {
        FeedMappingServiceSettings settings =
          FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient() {
      try {
        FeedPlaceholderViewServiceSettings settings =
          FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedServiceClient createFeedServiceClient() {
      try {
        FeedServiceSettings settings =
          FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GenderViewServiceClient createGenderViewServiceClient() {
      try {
        GenderViewServiceSettings settings =
          GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeoTargetConstantServiceClient createGeoTargetConstantServiceClient() {
      try {
        GeoTargetConstantServiceSettings settings =
          GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GeographicViewServiceClient createGeographicViewServiceClient() {
      try {
        GeographicViewServiceSettings settings =
          GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient() {
      try {
        GoogleAdsFieldServiceSettings settings =
          GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GoogleAdsServiceClient createGoogleAdsServiceClient() {
      try {
        GoogleAdsServiceSettings settings =
          GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public GroupPlacementViewServiceClient createGroupPlacementViewServiceClient() {
      try {
        GroupPlacementViewServiceSettings settings =
          GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public HotelGroupViewServiceClient createHotelGroupViewServiceClient() {
      try {
        HotelGroupViewServiceSettings settings =
          HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient() {
      try {
        HotelPerformanceViewServiceSettings settings =
          HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public InvoiceServiceClient createInvoiceServiceClient() {
      try {
        InvoiceServiceSettings settings =
          InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient() {
      try {
        KeywordPlanAdGroupServiceSettings settings =
          KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient() {
      try {
        KeywordPlanCampaignServiceSettings settings =
          KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient() {
      try {
        KeywordPlanIdeaServiceSettings settings =
          KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanKeywordServiceClient createKeywordPlanKeywordServiceClient() {
      try {
        KeywordPlanKeywordServiceSettings settings =
          KeywordPlanKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanNegativeKeywordServiceClient createKeywordPlanNegativeKeywordServiceClient() {
      try {
        KeywordPlanNegativeKeywordServiceSettings settings =
          KeywordPlanNegativeKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanNegativeKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanServiceClient createKeywordPlanServiceClient() {
      try {
        KeywordPlanServiceSettings settings =
          KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordViewServiceClient createKeywordViewServiceClient() {
      try {
        KeywordViewServiceSettings settings =
          KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LabelServiceClient createLabelServiceClient() {
      try {
        LabelServiceSettings settings =
          LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LandingPageViewServiceClient createLandingPageViewServiceClient() {
      try {
        LandingPageViewServiceSettings settings =
          LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LanguageConstantServiceClient createLanguageConstantServiceClient() {
      try {
        LanguageConstantServiceSettings settings =
          LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public LocationViewServiceClient createLocationViewServiceClient() {
      try {
        LocationViewServiceSettings settings =
          LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient() {
      try {
        ManagedPlacementViewServiceSettings settings =
          ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MediaFileServiceClient createMediaFileServiceClient() {
      try {
        MediaFileServiceSettings settings =
          MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient() {
      try {
        MerchantCenterLinkServiceSettings settings =
          MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient() {
      try {
        MobileAppCategoryConstantServiceSettings settings =
          MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient() {
      try {
        MobileDeviceConstantServiceSettings settings =
          MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public MutateJobServiceClient createMutateJobServiceClient() {
      try {
        MutateJobServiceSettings settings =
          MutateJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return MutateJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient() {
      try {
        OfflineUserDataJobServiceSettings settings =
          OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        OperatingSystemVersionConstantServiceSettings settings =
          OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient() {
      try {
        PaidOrganicSearchTermViewServiceSettings settings =
          PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ParentalStatusViewServiceClient createParentalStatusViewServiceClient() {
      try {
        ParentalStatusViewServiceSettings settings =
          ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public PaymentsAccountServiceClient createPaymentsAccountServiceClient() {
      try {
        PaymentsAccountServiceSettings settings =
          PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        ProductBiddingCategoryConstantServiceSettings settings =
          ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ProductGroupViewServiceClient createProductGroupViewServiceClient() {
      try {
        ProductGroupViewServiceSettings settings =
          ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ReachPlanServiceClient createReachPlanServiceClient() {
      try {
        ReachPlanServiceSettings settings =
          ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RecommendationServiceClient createRecommendationServiceClient() {
      try {
        RecommendationServiceSettings settings =
          RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public RemarketingActionServiceClient createRemarketingActionServiceClient() {
      try {
        RemarketingActionServiceSettings settings =
          RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SearchTermViewServiceClient createSearchTermViewServiceClient() {
      try {
        SearchTermViewServiceSettings settings =
          SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedCriterionServiceClient createSharedCriterionServiceClient() {
      try {
        SharedCriterionServiceSettings settings =
          SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public SharedSetServiceClient createSharedSetServiceClient() {
      try {
        SharedSetServiceSettings settings =
          SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient() {
      try {
        ShoppingPerformanceViewServiceSettings settings =
          ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TopicConstantServiceClient createTopicConstantServiceClient() {
      try {
        TopicConstantServiceSettings settings =
          TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public TopicViewServiceClient createTopicViewServiceClient() {
      try {
        TopicViewServiceSettings settings =
          TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserDataServiceClient createUserDataServiceClient() {
      try {
        UserDataServiceSettings settings =
          UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserInterestServiceClient createUserInterestServiceClient() {
      try {
        UserInterestServiceSettings settings =
          UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserListServiceClient createUserListServiceClient() {
      try {
        UserListServiceSettings settings =
          UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public UserLocationViewServiceClient createUserLocationViewServiceClient() {
      try {
        UserLocationViewServiceSettings settings =
          UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public VideoServiceClient createVideoServiceClient() {
      try {
        VideoServiceSettings settings =
          VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V4Client implements com.google.ads.googleads.v4.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V4Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v4.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v4.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AccountBudgetServiceClient createAccountBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AccountBudgetServiceSettings settings =
          com.google.ads.googleads.v4.services.AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public AccountLinkServiceClient createAccountLinkServiceClient() {
      try {
        AccountLinkServiceSettings settings =
          AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupAdAssetViewServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupAudienceViewServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v4.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdGroupSimulationServiceClient createAdGroupSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdGroupSimulationServiceSettings settings =
          com.google.ads.googleads.v4.services.AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v4.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdScheduleViewServiceClient createAdScheduleViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AdScheduleViewServiceSettings settings =
          com.google.ads.googleads.v4.services.AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v4.services.AdServiceSettings settings =
          com.google.ads.googleads.v4.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AgeRangeViewServiceClient createAgeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.AgeRangeViewServiceSettings settings =
          com.google.ads.googleads.v4.services.AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v4.services.AssetServiceSettings settings =
          com.google.ads.googleads.v4.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public BatchJobServiceClient createBatchJobServiceClient() {
      try {
        BatchJobServiceSettings settings =
          BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v4.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v4.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignAudienceViewServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v4.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CarrierConstantServiceClient createCarrierConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CarrierConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ChangeStatusServiceClient createChangeStatusServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ChangeStatusServiceSettings settings =
          com.google.ads.googleads.v4.services.ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ClickViewServiceClient createClickViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ClickViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v4.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v4.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v4.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CurrencyConstantServiceClient createCurrencyConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CurrencyConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerClientServiceClient createCustomerClientServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerClientServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v4.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.DetailPlacementViewServiceClient createDetailPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.DetailPlacementViewServiceSettings settings =
          com.google.ads.googleads.v4.services.DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.DisplayKeywordViewServiceSettings settings =
          com.google.ads.googleads.v4.services.DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.DistanceViewServiceClient createDistanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.DistanceViewServiceSettings settings =
          com.google.ads.googleads.v4.services.DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.DomainCategoryServiceClient createDomainCategoryServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.DomainCategoryServiceSettings settings =
          com.google.ads.googleads.v4.services.DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.DynamicSearchAdsSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v4.services.DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ExpandedLandingPageViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v4.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v4.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v4.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v4.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.FeedPlaceholderViewServiceSettings settings =
          com.google.ads.googleads.v4.services.FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v4.services.FeedServiceSettings settings =
          com.google.ads.googleads.v4.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GenderViewServiceClient createGenderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GenderViewServiceSettings settings =
          com.google.ads.googleads.v4.services.GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GeographicViewServiceClient createGeographicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GeographicViewServiceSettings settings =
          com.google.ads.googleads.v4.services.GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v4.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v4.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.GroupPlacementViewServiceClient createGroupPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.GroupPlacementViewServiceSettings settings =
          com.google.ads.googleads.v4.services.GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.HotelGroupViewServiceClient createHotelGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.HotelGroupViewServiceSettings settings =
          com.google.ads.googleads.v4.services.HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.HotelPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v4.services.HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public IncomeRangeViewServiceClient createIncomeRangeViewServiceClient() {
      try {
        IncomeRangeViewServiceSettings settings =
          IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v4.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v4.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient() {
      try {
        KeywordPlanAdGroupKeywordServiceSettings settings =
          KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v4.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient() {
      try {
        KeywordPlanCampaignKeywordServiceSettings settings =
          KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v4.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v4.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v4.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.KeywordViewServiceClient createKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.KeywordViewServiceSettings settings =
          com.google.ads.googleads.v4.services.KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v4.services.LabelServiceSettings settings =
          com.google.ads.googleads.v4.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.LandingPageViewServiceClient createLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.LandingPageViewServiceSettings settings =
          com.google.ads.googleads.v4.services.LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.LanguageConstantServiceClient createLanguageConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.LanguageConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.LocationViewServiceClient createLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.LocationViewServiceSettings settings =
          com.google.ads.googleads.v4.services.LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ManagedPlacementViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v4.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v4.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.MobileAppCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.MobileDeviceConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v4.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.OperatingSystemVersionConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.PaidOrganicSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v4.services.PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ParentalStatusViewServiceClient createParentalStatusViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ParentalStatusViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v4.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ProductBiddingCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ProductGroupViewServiceClient createProductGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ProductGroupViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v4.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v4.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v4.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.SearchTermViewServiceClient createSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.SearchTermViewServiceSettings settings =
          com.google.ads.googleads.v4.services.SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v4.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v4.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.ShoppingPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v4.services.ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient() {
      try {
        ThirdPartyAppAnalyticsLinkServiceSettings settings =
          ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.TopicConstantServiceClient createTopicConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.TopicConstantServiceSettings settings =
          com.google.ads.googleads.v4.services.TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.TopicViewServiceClient createTopicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.TopicViewServiceSettings settings =
          com.google.ads.googleads.v4.services.TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v4.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.UserInterestServiceClient createUserInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.UserInterestServiceSettings settings =
          com.google.ads.googleads.v4.services.UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.UserListServiceSettings settings =
          com.google.ads.googleads.v4.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.UserLocationViewServiceClient createUserLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v4.services.UserLocationViewServiceSettings settings =
          com.google.ads.googleads.v4.services.UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v4.services.VideoServiceClient createVideoServiceClient() {
      try {
        com.google.ads.googleads.v4.services.VideoServiceSettings settings =
          com.google.ads.googleads.v4.services.VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v4.services.VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V5Client implements com.google.ads.googleads.v5.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V5Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v5.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v5.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AccountBudgetServiceClient createAccountBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AccountBudgetServiceSettings settings =
          com.google.ads.googleads.v5.services.AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v5.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupAdAssetViewServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupAudienceViewServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v5.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdGroupSimulationServiceClient createAdGroupSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdGroupSimulationServiceSettings settings =
          com.google.ads.googleads.v5.services.AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v5.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdScheduleViewServiceClient createAdScheduleViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AdScheduleViewServiceSettings settings =
          com.google.ads.googleads.v5.services.AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v5.services.AdServiceSettings settings =
          com.google.ads.googleads.v5.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AgeRangeViewServiceClient createAgeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.AgeRangeViewServiceSettings settings =
          com.google.ads.googleads.v5.services.AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v5.services.AssetServiceSettings settings =
          com.google.ads.googleads.v5.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v5.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v5.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v5.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CampaignAssetServiceClient createCampaignAssetServiceClient() {
      try {
        CampaignAssetServiceSettings settings =
          CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignAudienceViewServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v5.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CarrierConstantServiceClient createCarrierConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CarrierConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ChangeStatusServiceClient createChangeStatusServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ChangeStatusServiceSettings settings =
          com.google.ads.googleads.v5.services.ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ClickViewServiceClient createClickViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ClickViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v5.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v5.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v5.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CurrencyConstantServiceClient createCurrencyConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CurrencyConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerClientServiceClient createCustomerClientServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerClientServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v5.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.DetailPlacementViewServiceClient createDetailPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.DetailPlacementViewServiceSettings settings =
          com.google.ads.googleads.v5.services.DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.DisplayKeywordViewServiceSettings settings =
          com.google.ads.googleads.v5.services.DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.DistanceViewServiceClient createDistanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.DistanceViewServiceSettings settings =
          com.google.ads.googleads.v5.services.DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.DomainCategoryServiceClient createDomainCategoryServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.DomainCategoryServiceSettings settings =
          com.google.ads.googleads.v5.services.DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.DynamicSearchAdsSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v5.services.DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ExpandedLandingPageViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v5.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v5.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v5.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v5.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.FeedPlaceholderViewServiceSettings settings =
          com.google.ads.googleads.v5.services.FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v5.services.FeedServiceSettings settings =
          com.google.ads.googleads.v5.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GenderViewServiceClient createGenderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GenderViewServiceSettings settings =
          com.google.ads.googleads.v5.services.GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GeographicViewServiceClient createGeographicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GeographicViewServiceSettings settings =
          com.google.ads.googleads.v5.services.GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v5.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v5.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.GroupPlacementViewServiceClient createGroupPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.GroupPlacementViewServiceSettings settings =
          com.google.ads.googleads.v5.services.GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.HotelGroupViewServiceClient createHotelGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.HotelGroupViewServiceSettings settings =
          com.google.ads.googleads.v5.services.HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.HotelPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v5.services.HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.IncomeRangeViewServiceClient createIncomeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.IncomeRangeViewServiceSettings settings =
          com.google.ads.googleads.v5.services.IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v5.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v5.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.KeywordViewServiceClient createKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.KeywordViewServiceSettings settings =
          com.google.ads.googleads.v5.services.KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v5.services.LabelServiceSettings settings =
          com.google.ads.googleads.v5.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.LandingPageViewServiceClient createLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.LandingPageViewServiceSettings settings =
          com.google.ads.googleads.v5.services.LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.LanguageConstantServiceClient createLanguageConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.LanguageConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.LocationViewServiceClient createLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.LocationViewServiceSettings settings =
          com.google.ads.googleads.v5.services.LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ManagedPlacementViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v5.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v5.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.MobileAppCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.MobileDeviceConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v5.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.OperatingSystemVersionConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.PaidOrganicSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v5.services.PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ParentalStatusViewServiceClient createParentalStatusViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ParentalStatusViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v5.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ProductBiddingCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ProductGroupViewServiceClient createProductGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ProductGroupViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v5.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v5.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v5.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.SearchTermViewServiceClient createSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.SearchTermViewServiceSettings settings =
          com.google.ads.googleads.v5.services.SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v5.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v5.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ShoppingPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v5.services.ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v5.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.TopicConstantServiceClient createTopicConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.TopicConstantServiceSettings settings =
          com.google.ads.googleads.v5.services.TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.TopicViewServiceClient createTopicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.TopicViewServiceSettings settings =
          com.google.ads.googleads.v5.services.TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v5.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.UserInterestServiceClient createUserInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.UserInterestServiceSettings settings =
          com.google.ads.googleads.v5.services.UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.UserListServiceSettings settings =
          com.google.ads.googleads.v5.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.UserLocationViewServiceClient createUserLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v5.services.UserLocationViewServiceSettings settings =
          com.google.ads.googleads.v5.services.UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v5.services.VideoServiceClient createVideoServiceClient() {
      try {
        com.google.ads.googleads.v5.services.VideoServiceSettings settings =
          com.google.ads.googleads.v5.services.VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v5.services.VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }

  private static class V6Client implements com.google.ads.googleads.v6.services.GoogleAdsVersion {
    private final TransportChannelProvider provider;

    private final Credentials credentials;

    public V6Client(TransportChannelProvider provider, Credentials credentials) {
      this.provider = provider;
      this.credentials = credentials;
    }

    @Override
    public com.google.ads.googleads.v6.services.AccountBudgetProposalServiceClient createAccountBudgetProposalServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AccountBudgetProposalServiceSettings settings =
          com.google.ads.googleads.v6.services.AccountBudgetProposalServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AccountBudgetProposalServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AccountBudgetServiceClient createAccountBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AccountBudgetServiceSettings settings =
          com.google.ads.googleads.v6.services.AccountBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AccountBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AccountLinkServiceClient createAccountLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AccountLinkServiceSettings settings =
          com.google.ads.googleads.v6.services.AccountLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AccountLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupAdAssetViewServiceClient createAdGroupAdAssetViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupAdAssetViewServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupAdAssetViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupAdAssetViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupAdLabelServiceClient createAdGroupAdLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupAdLabelServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupAdLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupAdLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupAdServiceClient createAdGroupAdServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupAdServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupAdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupAdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupAudienceViewServiceClient createAdGroupAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupAudienceViewServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupBidModifierServiceClient createAdGroupBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupBidModifierServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupCriterionLabelServiceClient createAdGroupCriterionLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupCriterionLabelServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupCriterionLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupCriterionLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupCriterionServiceClient createAdGroupCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupCriterionServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupCriterionSimulationServiceClient createAdGroupCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupExtensionSettingServiceClient createAdGroupExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupFeedServiceClient createAdGroupFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupFeedServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupLabelServiceClient createAdGroupLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupLabelServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupServiceClient createAdGroupServiceClient() {
      try {
        com.google.ads.googleads.v6.services.AdGroupServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdGroupSimulationServiceClient createAdGroupSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdGroupSimulationServiceSettings settings =
          com.google.ads.googleads.v6.services.AdGroupSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdGroupSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdParameterServiceClient createAdParameterServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdParameterServiceSettings settings =
          com.google.ads.googleads.v6.services.AdParameterServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdParameterServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdScheduleViewServiceClient createAdScheduleViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AdScheduleViewServiceSettings settings =
          com.google.ads.googleads.v6.services.AdScheduleViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdScheduleViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AdServiceClient createAdServiceClient() {
      try {
        com.google.ads.googleads.v6.services.AdServiceSettings settings =
          com.google.ads.googleads.v6.services.AdServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AdServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AgeRangeViewServiceClient createAgeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.AgeRangeViewServiceSettings settings =
          com.google.ads.googleads.v6.services.AgeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AgeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.AssetServiceClient createAssetServiceClient() {
      try {
        com.google.ads.googleads.v6.services.AssetServiceSettings settings =
          com.google.ads.googleads.v6.services.AssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.AssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.BatchJobServiceClient createBatchJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.BatchJobServiceSettings settings =
          com.google.ads.googleads.v6.services.BatchJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.BatchJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.BiddingStrategyServiceClient createBiddingStrategyServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.BiddingStrategyServiceSettings settings =
          com.google.ads.googleads.v6.services.BiddingStrategyServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.BiddingStrategyServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.BillingSetupServiceClient createBillingSetupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.BillingSetupServiceSettings settings =
          com.google.ads.googleads.v6.services.BillingSetupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.BillingSetupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignAssetServiceClient createCampaignAssetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignAssetServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignAssetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignAssetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignAudienceViewServiceClient createCampaignAudienceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignAudienceViewServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignAudienceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignAudienceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignBidModifierServiceClient createCampaignBidModifierServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignBidModifierServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignBidModifierServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignBidModifierServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignBudgetServiceClient createCampaignBudgetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignBudgetServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignBudgetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignBudgetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignCriterionServiceClient createCampaignCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignCriterionServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignCriterionSimulationServiceClient createCampaignCriterionSimulationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignCriterionSimulationServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignCriterionSimulationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignCriterionSimulationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignDraftServiceClient createCampaignDraftServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignDraftServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignDraftServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignDraftServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignExperimentServiceClient createCampaignExperimentServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignExperimentServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignExperimentServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignExperimentServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignExtensionSettingServiceClient createCampaignExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignFeedServiceClient createCampaignFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignFeedServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignLabelServiceClient createCampaignLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignLabelServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignServiceClient createCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CampaignSharedSetServiceClient createCampaignSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CampaignSharedSetServiceSettings settings =
          com.google.ads.googleads.v6.services.CampaignSharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CampaignSharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CarrierConstantServiceClient createCarrierConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CarrierConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.CarrierConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CarrierConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ChangeStatusServiceClient createChangeStatusServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ChangeStatusServiceSettings settings =
          com.google.ads.googleads.v6.services.ChangeStatusServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ChangeStatusServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ClickViewServiceClient createClickViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ClickViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ClickViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ClickViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CombinedAudienceServiceClient createCombinedAudienceServiceClient() {
      try {
        CombinedAudienceServiceSettings settings =
          CombinedAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CombinedAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ConversionActionServiceClient createConversionActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ConversionActionServiceSettings settings =
          com.google.ads.googleads.v6.services.ConversionActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ConversionActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ConversionAdjustmentUploadServiceClient createConversionAdjustmentUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ConversionAdjustmentUploadServiceSettings settings =
          com.google.ads.googleads.v6.services.ConversionAdjustmentUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ConversionAdjustmentUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ConversionUploadServiceClient createConversionUploadServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ConversionUploadServiceSettings settings =
          com.google.ads.googleads.v6.services.ConversionUploadServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ConversionUploadServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CurrencyConstantServiceClient createCurrencyConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CurrencyConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.CurrencyConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CurrencyConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomAudienceServiceClient createCustomAudienceServiceClient() {
      try {
        CustomAudienceServiceSettings settings =
          CustomAudienceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomAudienceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomInterestServiceClient createCustomInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomInterestServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerClientLinkServiceClient createCustomerClientLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerClientLinkServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerClientLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerClientLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerClientServiceClient createCustomerClientServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerClientServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerClientServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerClientServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerExtensionSettingServiceClient createCustomerExtensionSettingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerExtensionSettingServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerExtensionSettingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerExtensionSettingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerFeedServiceClient createCustomerFeedServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerFeedServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerFeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerFeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerLabelServiceClient createCustomerLabelServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerLabelServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerLabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerLabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerManagerLinkServiceClient createCustomerManagerLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerManagerLinkServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerManagerLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerManagerLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerNegativeCriterionServiceClient createCustomerNegativeCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerNegativeCriterionServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerNegativeCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerNegativeCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.CustomerServiceClient createCustomerServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.CustomerServiceSettings settings =
          com.google.ads.googleads.v6.services.CustomerServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.CustomerServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public CustomerUserAccessServiceClient createCustomerUserAccessServiceClient() {
      try {
        CustomerUserAccessServiceSettings settings =
          CustomerUserAccessServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return CustomerUserAccessServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.DetailPlacementViewServiceClient createDetailPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.DetailPlacementViewServiceSettings settings =
          com.google.ads.googleads.v6.services.DetailPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.DetailPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.DisplayKeywordViewServiceClient createDisplayKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.DisplayKeywordViewServiceSettings settings =
          com.google.ads.googleads.v6.services.DisplayKeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.DisplayKeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.DistanceViewServiceClient createDistanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.DistanceViewServiceSettings settings =
          com.google.ads.googleads.v6.services.DistanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.DistanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.DomainCategoryServiceClient createDomainCategoryServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.DomainCategoryServiceSettings settings =
          com.google.ads.googleads.v6.services.DomainCategoryServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.DomainCategoryServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.DynamicSearchAdsSearchTermViewServiceClient createDynamicSearchAdsSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.DynamicSearchAdsSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v6.services.DynamicSearchAdsSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.DynamicSearchAdsSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ExpandedLandingPageViewServiceClient createExpandedLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ExpandedLandingPageViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ExpandedLandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ExpandedLandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ExtensionFeedItemServiceClient createExtensionFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ExtensionFeedItemServiceSettings settings =
          com.google.ads.googleads.v6.services.ExtensionFeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ExtensionFeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.FeedItemServiceClient createFeedItemServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.FeedItemServiceSettings settings =
          com.google.ads.googleads.v6.services.FeedItemServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.FeedItemServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetLinkServiceClient createFeedItemSetLinkServiceClient() {
      try {
        FeedItemSetLinkServiceSettings settings =
          FeedItemSetLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public FeedItemSetServiceClient createFeedItemSetServiceClient() {
      try {
        FeedItemSetServiceSettings settings =
          FeedItemSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return FeedItemSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.FeedItemTargetServiceClient createFeedItemTargetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.FeedItemTargetServiceSettings settings =
          com.google.ads.googleads.v6.services.FeedItemTargetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.FeedItemTargetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.FeedMappingServiceClient createFeedMappingServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.FeedMappingServiceSettings settings =
          com.google.ads.googleads.v6.services.FeedMappingServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.FeedMappingServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.FeedPlaceholderViewServiceClient createFeedPlaceholderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.FeedPlaceholderViewServiceSettings settings =
          com.google.ads.googleads.v6.services.FeedPlaceholderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.FeedPlaceholderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.FeedServiceClient createFeedServiceClient() {
      try {
        com.google.ads.googleads.v6.services.FeedServiceSettings settings =
          com.google.ads.googleads.v6.services.FeedServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.FeedServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GenderViewServiceClient createGenderViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GenderViewServiceSettings settings =
          com.google.ads.googleads.v6.services.GenderViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GenderViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GeoTargetConstantServiceClient createGeoTargetConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GeoTargetConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.GeoTargetConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GeoTargetConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GeographicViewServiceClient createGeographicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GeographicViewServiceSettings settings =
          com.google.ads.googleads.v6.services.GeographicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GeographicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GoogleAdsFieldServiceClient createGoogleAdsFieldServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GoogleAdsFieldServiceSettings settings =
          com.google.ads.googleads.v6.services.GoogleAdsFieldServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GoogleAdsFieldServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GoogleAdsServiceClient createGoogleAdsServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GoogleAdsServiceSettings settings =
          com.google.ads.googleads.v6.services.GoogleAdsServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GoogleAdsServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.GroupPlacementViewServiceClient createGroupPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.GroupPlacementViewServiceSettings settings =
          com.google.ads.googleads.v6.services.GroupPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.GroupPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.HotelGroupViewServiceClient createHotelGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.HotelGroupViewServiceSettings settings =
          com.google.ads.googleads.v6.services.HotelGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.HotelGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.HotelPerformanceViewServiceClient createHotelPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.HotelPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v6.services.HotelPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.HotelPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.IncomeRangeViewServiceClient createIncomeRangeViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.IncomeRangeViewServiceSettings settings =
          com.google.ads.googleads.v6.services.IncomeRangeViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.IncomeRangeViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.InvoiceServiceClient createInvoiceServiceClient() {
      try {
        com.google.ads.googleads.v6.services.InvoiceServiceSettings settings =
          com.google.ads.googleads.v6.services.InvoiceServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.InvoiceServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanAdGroupKeywordServiceClient createKeywordPlanAdGroupKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanAdGroupKeywordServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanAdGroupKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanAdGroupKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanAdGroupServiceClient createKeywordPlanAdGroupServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanAdGroupServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanAdGroupServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanAdGroupServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanCampaignKeywordServiceClient createKeywordPlanCampaignKeywordServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanCampaignKeywordServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanCampaignKeywordServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanCampaignKeywordServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanCampaignServiceClient createKeywordPlanCampaignServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanCampaignServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanCampaignServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanCampaignServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanIdeaServiceClient createKeywordPlanIdeaServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanIdeaServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanIdeaServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanIdeaServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordPlanServiceClient createKeywordPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordPlanServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.KeywordViewServiceClient createKeywordViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.KeywordViewServiceSettings settings =
          com.google.ads.googleads.v6.services.KeywordViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.KeywordViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.LabelServiceClient createLabelServiceClient() {
      try {
        com.google.ads.googleads.v6.services.LabelServiceSettings settings =
          com.google.ads.googleads.v6.services.LabelServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.LabelServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.LandingPageViewServiceClient createLandingPageViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.LandingPageViewServiceSettings settings =
          com.google.ads.googleads.v6.services.LandingPageViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.LandingPageViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.LanguageConstantServiceClient createLanguageConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.LanguageConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.LanguageConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.LanguageConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.LocationViewServiceClient createLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.LocationViewServiceSettings settings =
          com.google.ads.googleads.v6.services.LocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.LocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ManagedPlacementViewServiceClient createManagedPlacementViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ManagedPlacementViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ManagedPlacementViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ManagedPlacementViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.MediaFileServiceClient createMediaFileServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.MediaFileServiceSettings settings =
          com.google.ads.googleads.v6.services.MediaFileServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.MediaFileServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.MerchantCenterLinkServiceClient createMerchantCenterLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.MerchantCenterLinkServiceSettings settings =
          com.google.ads.googleads.v6.services.MerchantCenterLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.MerchantCenterLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.MobileAppCategoryConstantServiceClient createMobileAppCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.MobileAppCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.MobileAppCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.MobileAppCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.MobileDeviceConstantServiceClient createMobileDeviceConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.MobileDeviceConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.MobileDeviceConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.MobileDeviceConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.OfflineUserDataJobServiceClient createOfflineUserDataJobServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.OfflineUserDataJobServiceSettings settings =
          com.google.ads.googleads.v6.services.OfflineUserDataJobServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.OfflineUserDataJobServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.OperatingSystemVersionConstantServiceClient createOperatingSystemVersionConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.OperatingSystemVersionConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.OperatingSystemVersionConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.OperatingSystemVersionConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.PaidOrganicSearchTermViewServiceClient createPaidOrganicSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.PaidOrganicSearchTermViewServiceSettings settings =
          com.google.ads.googleads.v6.services.PaidOrganicSearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.PaidOrganicSearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ParentalStatusViewServiceClient createParentalStatusViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ParentalStatusViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ParentalStatusViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ParentalStatusViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.PaymentsAccountServiceClient createPaymentsAccountServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.PaymentsAccountServiceSettings settings =
          com.google.ads.googleads.v6.services.PaymentsAccountServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.PaymentsAccountServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ProductBiddingCategoryConstantServiceClient createProductBiddingCategoryConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ProductBiddingCategoryConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.ProductBiddingCategoryConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ProductBiddingCategoryConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ProductGroupViewServiceClient createProductGroupViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ProductGroupViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ProductGroupViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ProductGroupViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ReachPlanServiceClient createReachPlanServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ReachPlanServiceSettings settings =
          com.google.ads.googleads.v6.services.ReachPlanServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ReachPlanServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.RecommendationServiceClient createRecommendationServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.RecommendationServiceSettings settings =
          com.google.ads.googleads.v6.services.RecommendationServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.RecommendationServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.RemarketingActionServiceClient createRemarketingActionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.RemarketingActionServiceSettings settings =
          com.google.ads.googleads.v6.services.RemarketingActionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.RemarketingActionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.SearchTermViewServiceClient createSearchTermViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.SearchTermViewServiceSettings settings =
          com.google.ads.googleads.v6.services.SearchTermViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.SearchTermViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.SharedCriterionServiceClient createSharedCriterionServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.SharedCriterionServiceSettings settings =
          com.google.ads.googleads.v6.services.SharedCriterionServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.SharedCriterionServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.SharedSetServiceClient createSharedSetServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.SharedSetServiceSettings settings =
          com.google.ads.googleads.v6.services.SharedSetServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.SharedSetServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ShoppingPerformanceViewServiceClient createShoppingPerformanceViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ShoppingPerformanceViewServiceSettings settings =
          com.google.ads.googleads.v6.services.ShoppingPerformanceViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ShoppingPerformanceViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.ThirdPartyAppAnalyticsLinkServiceClient createThirdPartyAppAnalyticsLinkServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.ThirdPartyAppAnalyticsLinkServiceSettings settings =
          com.google.ads.googleads.v6.services.ThirdPartyAppAnalyticsLinkServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.ThirdPartyAppAnalyticsLinkServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.TopicConstantServiceClient createTopicConstantServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.TopicConstantServiceSettings settings =
          com.google.ads.googleads.v6.services.TopicConstantServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.TopicConstantServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.TopicViewServiceClient createTopicViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.TopicViewServiceSettings settings =
          com.google.ads.googleads.v6.services.TopicViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.TopicViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.UserDataServiceClient createUserDataServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.UserDataServiceSettings settings =
          com.google.ads.googleads.v6.services.UserDataServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.UserDataServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.UserInterestServiceClient createUserInterestServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.UserInterestServiceSettings settings =
          com.google.ads.googleads.v6.services.UserInterestServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.UserInterestServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.UserListServiceClient createUserListServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.UserListServiceSettings settings =
          com.google.ads.googleads.v6.services.UserListServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.UserListServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.UserLocationViewServiceClient createUserLocationViewServiceClient(
        ) {
      try {
        com.google.ads.googleads.v6.services.UserLocationViewServiceSettings settings =
          com.google.ads.googleads.v6.services.UserLocationViewServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.UserLocationViewServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }

    @Override
    public com.google.ads.googleads.v6.services.VideoServiceClient createVideoServiceClient() {
      try {
        com.google.ads.googleads.v6.services.VideoServiceSettings settings =
          com.google.ads.googleads.v6.services.VideoServiceSettings.newBuilder()
            .setCredentialsProvider(FixedCredentialsProvider.create(credentials))
            .setTransportChannelProvider(provider)
            .build();
        return com.google.ads.googleads.v6.services.VideoServiceClient.create(settings);
      } catch (IOException e) {
        throw new RuntimeException(e);
      }
    }
  }
}
