// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.catalog;

import com.google.ads.googleads.lib.utils.messageproxy.DefaultMessageProxyProvider;
import com.google.ads.googleads.lib.utils.messageproxy.generated.v3.CreateCustomerClientRequestMessageProxy;
import com.google.ads.googleads.lib.utils.messageproxy.generated.v3.CustomerUserAccessMessageProxy;
import com.google.ads.googleads.lib.utils.messageproxy.generated.v3.FeedMessageProxy;
import com.google.ads.googleads.lib.utils.messageproxy.generated.v3.SearchGoogleAdsResponseMessageProxy;
import com.google.ads.googleads.lib.utils.messageproxy.generated.v3.SearchGoogleAdsStreamResponseMessageProxy;
import com.google.ads.googleads.v3.errors.GoogleAdsException;
import com.google.ads.googleads.v3.services.GoogleAdsVersion;
import com.google.common.collect.ImmutableSet;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class VersionCatalog {
  protected static ImmutableSet<Version> getCatalog() throws IllegalAccessException,
      InstantiationException {
    ImmutableSet.Builder<Version> builder = ImmutableSet.builder();
    builder.add(new Version(
          "v3",
          new GoogleAdsException.Factory(),
          GoogleAdsVersion.class,
          new DefaultMessageProxyProvider(
            new SearchGoogleAdsStreamResponseMessageProxy(),
            new SearchGoogleAdsResponseMessageProxy(),
            new CustomerUserAccessMessageProxy(),
            new FeedMessageProxy(),
            new CreateCustomerClientRequestMessageProxy())));
    builder.add(new Version(
          "v4",
          new com.google.ads.googleads.v4.errors.GoogleAdsException.Factory(),
          com.google.ads.googleads.v4.services.GoogleAdsVersion.class,
          new DefaultMessageProxyProvider(
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v4.SearchGoogleAdsStreamResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v4.SearchGoogleAdsResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v4.CustomerUserAccessMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v4.FeedMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v4.CreateCustomerClientRequestMessageProxy())));
    builder.add(new Version(
          "v5",
          new com.google.ads.googleads.v5.errors.GoogleAdsException.Factory(),
          com.google.ads.googleads.v5.services.GoogleAdsVersion.class,
          new DefaultMessageProxyProvider(
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v5.SearchGoogleAdsStreamResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v5.SearchGoogleAdsResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v5.CustomerUserAccessMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v5.FeedMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v5.CreateCustomerClientRequestMessageProxy())));
    builder.add(new Version(
          "v6",
          new com.google.ads.googleads.v6.errors.GoogleAdsException.Factory(),
          com.google.ads.googleads.v6.services.GoogleAdsVersion.class,
          new DefaultMessageProxyProvider(
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v6.SearchGoogleAdsStreamResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v6.SearchGoogleAdsResponseMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v6.CustomerUserAccessMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v6.FeedMessageProxy(),
            new com.google.ads.googleads.lib.utils.messageproxy.generated.v6.CreateCustomerClientRequestMessageProxy())));
    return builder.build();
  }
}
