package com.google.ads.googleads.lib.logging;

import com.google.common.collect.ImmutableMap;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Event_Detail extends Event.Detail {

  private final Status responseStatus;

  private final boolean success;

  private final String methodName;

  private final String endpoint;

  private final ImmutableMap<String, String> rawRequestHeaders;

  private final ImmutableMap<String, String> scrubbedRequestHeaders;

  private final Metadata responseHeaderMetadata;

  private final Metadata responseTrailerMetadata;

  private final Object response;

  private final Object request;

  private AutoValue_Event_Detail(
      @Nullable Status responseStatus,
      boolean success,
      @Nullable String methodName,
      @Nullable String endpoint,
      @Nullable ImmutableMap<String, String> rawRequestHeaders,
      ImmutableMap<String, String> scrubbedRequestHeaders,
      @Nullable Metadata responseHeaderMetadata,
      @Nullable Metadata responseTrailerMetadata,
      @Nullable Object response,
      @Nullable Object request) {
    this.responseStatus = responseStatus;
    this.success = success;
    this.methodName = methodName;
    this.endpoint = endpoint;
    this.rawRequestHeaders = rawRequestHeaders;
    this.scrubbedRequestHeaders = scrubbedRequestHeaders;
    this.responseHeaderMetadata = responseHeaderMetadata;
    this.responseTrailerMetadata = responseTrailerMetadata;
    this.response = response;
    this.request = request;
  }

  @Nullable
  @Override
  public Status getResponseStatus() {
    return responseStatus;
  }

  @Override
  public boolean isSuccess() {
    return success;
  }

  @Nullable
  @Override
  public String getMethodName() {
    return methodName;
  }

  @Nullable
  @Override
  public String getEndpoint() {
    return endpoint;
  }

  @Nullable
  @Override
  public ImmutableMap<String, String> getRawRequestHeaders() {
    return rawRequestHeaders;
  }

  @Override
  public ImmutableMap<String, String> getScrubbedRequestHeaders() {
    return scrubbedRequestHeaders;
  }

  @Nullable
  @Override
  public Metadata getResponseHeaderMetadata() {
    return responseHeaderMetadata;
  }

  @Nullable
  @Override
  public Metadata getResponseTrailerMetadata() {
    return responseTrailerMetadata;
  }

  @Nullable
  @Override
  public Object getResponse() {
    return response;
  }

  @Nullable
  @Override
  public Object getRequest() {
    return request;
  }

  @Override
  public String toString() {
    return "Detail{"
        + "responseStatus=" + responseStatus + ", "
        + "success=" + success + ", "
        + "methodName=" + methodName + ", "
        + "endpoint=" + endpoint + ", "
        + "rawRequestHeaders=" + rawRequestHeaders + ", "
        + "scrubbedRequestHeaders=" + scrubbedRequestHeaders + ", "
        + "responseHeaderMetadata=" + responseHeaderMetadata + ", "
        + "responseTrailerMetadata=" + responseTrailerMetadata + ", "
        + "response=" + response + ", "
        + "request=" + request
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Event.Detail) {
      Event.Detail that = (Event.Detail) o;
      return (this.responseStatus == null ? that.getResponseStatus() == null : this.responseStatus.equals(that.getResponseStatus()))
          && this.success == that.isSuccess()
          && (this.methodName == null ? that.getMethodName() == null : this.methodName.equals(that.getMethodName()))
          && (this.endpoint == null ? that.getEndpoint() == null : this.endpoint.equals(that.getEndpoint()))
          && (this.rawRequestHeaders == null ? that.getRawRequestHeaders() == null : this.rawRequestHeaders.equals(that.getRawRequestHeaders()))
          && this.scrubbedRequestHeaders.equals(that.getScrubbedRequestHeaders())
          && (this.responseHeaderMetadata == null ? that.getResponseHeaderMetadata() == null : this.responseHeaderMetadata.equals(that.getResponseHeaderMetadata()))
          && (this.responseTrailerMetadata == null ? that.getResponseTrailerMetadata() == null : this.responseTrailerMetadata.equals(that.getResponseTrailerMetadata()))
          && (this.response == null ? that.getResponse() == null : this.response.equals(that.getResponse()))
          && (this.request == null ? that.getRequest() == null : this.request.equals(that.getRequest()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (responseStatus == null) ? 0 : responseStatus.hashCode();
    h$ *= 1000003;
    h$ ^= success ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (methodName == null) ? 0 : methodName.hashCode();
    h$ *= 1000003;
    h$ ^= (endpoint == null) ? 0 : endpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (rawRequestHeaders == null) ? 0 : rawRequestHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= scrubbedRequestHeaders.hashCode();
    h$ *= 1000003;
    h$ ^= (responseHeaderMetadata == null) ? 0 : responseHeaderMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= (responseTrailerMetadata == null) ? 0 : responseTrailerMetadata.hashCode();
    h$ *= 1000003;
    h$ ^= (response == null) ? 0 : response.hashCode();
    h$ *= 1000003;
    h$ ^= (request == null) ? 0 : request.hashCode();
    return h$;
  }

  static final class Builder extends Event.Detail.Builder {
    private Status responseStatus;
    private Boolean success;
    private String methodName;
    private String endpoint;
    private ImmutableMap<String, String> rawRequestHeaders;
    private ImmutableMap<String, String> scrubbedRequestHeaders;
    private Metadata responseHeaderMetadata;
    private Metadata responseTrailerMetadata;
    private Object response;
    private Object request;
    Builder() {
    }
    @Override
    public Event.Detail.Builder setResponseStatus(Status responseStatus) {
      this.responseStatus = responseStatus;
      return this;
    }
    @Override
    public Event.Detail.Builder setSuccess(boolean success) {
      this.success = success;
      return this;
    }
    @Override
    public Event.Detail.Builder setMethodName(String methodName) {
      this.methodName = methodName;
      return this;
    }
    @Override
    public Event.Detail.Builder setEndpoint(String endpoint) {
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public Event.Detail.Builder setRawRequestHeaders(Map<String, String> rawRequestHeaders) {
      this.rawRequestHeaders = (rawRequestHeaders == null ? null : ImmutableMap.copyOf(rawRequestHeaders));
      return this;
    }
    @Override
    public Event.Detail.Builder setScrubbedRequestHeaders(Map<String, String> scrubbedRequestHeaders) {
      this.scrubbedRequestHeaders = ImmutableMap.copyOf(scrubbedRequestHeaders);
      return this;
    }
    @Override
    public Event.Detail.Builder setResponseHeaderMetadata(Metadata responseHeaderMetadata) {
      this.responseHeaderMetadata = responseHeaderMetadata;
      return this;
    }
    @Override
    public Event.Detail.Builder setResponseTrailerMetadata(Metadata responseTrailerMetadata) {
      this.responseTrailerMetadata = responseTrailerMetadata;
      return this;
    }
    @Override
    public Event.Detail.Builder setResponse(Object response) {
      this.response = response;
      return this;
    }
    @Override
    public Event.Detail.Builder setRequest(Object request) {
      this.request = request;
      return this;
    }
    @Override
    public Event.Detail build() {
      String missing = "";
      if (this.success == null) {
        missing += " success";
      }
      if (this.scrubbedRequestHeaders == null) {
        missing += " scrubbedRequestHeaders";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Event_Detail(
          this.responseStatus,
          this.success,
          this.methodName,
          this.endpoint,
          this.rawRequestHeaders,
          this.scrubbedRequestHeaders,
          this.responseHeaderMetadata,
          this.responseTrailerMetadata,
          this.response,
          this.request);
    }
  }

}
