package com.google.ads.googleads.lib.logging;

import io.grpc.Status;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Event_Summary extends Event.Summary {

  private final Status responseStatus;

  private final boolean success;

  private final String methodName;

  private final String endpoint;

  private final String customerId;

  private final String requestId;

  private AutoValue_Event_Summary(
      @Nullable Status responseStatus,
      boolean success,
      @Nullable String methodName,
      @Nullable String endpoint,
      @Nullable String customerId,
      @Nullable String requestId) {
    this.responseStatus = responseStatus;
    this.success = success;
    this.methodName = methodName;
    this.endpoint = endpoint;
    this.customerId = customerId;
    this.requestId = requestId;
  }

  @Nullable
  @Override
  public Status getResponseStatus() {
    return responseStatus;
  }

  @Override
  public boolean isSuccess() {
    return success;
  }

  @Nullable
  @Override
  public String getMethodName() {
    return methodName;
  }

  @Nullable
  @Override
  public String getEndpoint() {
    return endpoint;
  }

  @Nullable
  @Override
  public String getCustomerId() {
    return customerId;
  }

  @Nullable
  @Override
  public String getRequestId() {
    return requestId;
  }

  @Override
  public String toString() {
    return "Summary{"
        + "responseStatus=" + responseStatus + ", "
        + "success=" + success + ", "
        + "methodName=" + methodName + ", "
        + "endpoint=" + endpoint + ", "
        + "customerId=" + customerId + ", "
        + "requestId=" + requestId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Event.Summary) {
      Event.Summary that = (Event.Summary) o;
      return (this.responseStatus == null ? that.getResponseStatus() == null : this.responseStatus.equals(that.getResponseStatus()))
          && this.success == that.isSuccess()
          && (this.methodName == null ? that.getMethodName() == null : this.methodName.equals(that.getMethodName()))
          && (this.endpoint == null ? that.getEndpoint() == null : this.endpoint.equals(that.getEndpoint()))
          && (this.customerId == null ? that.getCustomerId() == null : this.customerId.equals(that.getCustomerId()))
          && (this.requestId == null ? that.getRequestId() == null : this.requestId.equals(that.getRequestId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (responseStatus == null) ? 0 : responseStatus.hashCode();
    h$ *= 1000003;
    h$ ^= success ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= (methodName == null) ? 0 : methodName.hashCode();
    h$ *= 1000003;
    h$ ^= (endpoint == null) ? 0 : endpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (customerId == null) ? 0 : customerId.hashCode();
    h$ *= 1000003;
    h$ ^= (requestId == null) ? 0 : requestId.hashCode();
    return h$;
  }

  static final class Builder extends Event.Summary.Builder {
    private Status responseStatus;
    private Boolean success;
    private String methodName;
    private String endpoint;
    private String customerId;
    private String requestId;
    Builder() {
    }
    @Override
    public Event.Summary.Builder setResponseStatus(Status responseStatus) {
      this.responseStatus = responseStatus;
      return this;
    }
    @Override
    public Event.Summary.Builder setSuccess(boolean success) {
      this.success = success;
      return this;
    }
    @Override
    public Event.Summary.Builder setMethodName(String methodName) {
      this.methodName = methodName;
      return this;
    }
    @Override
    public Event.Summary.Builder setEndpoint(String endpoint) {
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public Event.Summary.Builder setCustomerId(String customerId) {
      this.customerId = customerId;
      return this;
    }
    @Override
    public Event.Summary.Builder setRequestId(String requestId) {
      this.requestId = requestId;
      return this;
    }
    @Override
    public Event.Summary build() {
      String missing = "";
      if (this.success == null) {
        missing += " success";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Event_Summary(
          this.responseStatus,
          this.success,
          this.methodName,
          this.endpoint,
          this.customerId,
          this.requestId);
    }
  }

}
