// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.google.ads.googleads.lib.utils.messageproxy.generated.v6;

import com.google.ads.googleads.lib.utils.messageproxy.SearchResponseProxy;
import com.google.ads.googleads.v6.services.SearchGoogleAdsResponse;
import java.util.List;
import javax.annotation.Generated;

@Generated("GoogleAdsCatalogAnnotationProcessor")
public class SearchGoogleAdsResponseMessageProxy implements SearchResponseProxy<SearchGoogleAdsResponse, SearchGoogleAdsResponse.Builder> {
  @Override
  public List<String> getFieldMaskPaths(SearchGoogleAdsResponse message) {
    return message.getFieldMask().getPathsList();
  }

  @Override
  public SearchGoogleAdsResponse.Builder setCustomerUserAccessEmailAddressIfPresent(
      SearchGoogleAdsResponse.Builder builder, String toSet) {
    builder.getResultsBuilderList().stream()
        .filter(row -> row.hasCustomerUserAccess() && row.getCustomerUserAccess().hasEmailAddress())
        .forEach(row -> row.getCustomerUserAccessBuilder().setEmailAddress(toSet));
    return builder;
  }

  @Override
  public SearchGoogleAdsResponse.Builder setCustomerUserAccessInviterEmailAddressIfPresent(
      SearchGoogleAdsResponse.Builder builder, String toSet) {
    builder.getResultsBuilderList().stream()
        .filter(row -> row.hasCustomerUserAccess() && row.getCustomerUserAccessBuilder().hasInviterUserEmailAddress())
        .forEach(row -> row.getCustomerUserAccessBuilder().setInviterUserEmailAddress(toSet));
    return builder;
  }

  @Override
  public SearchGoogleAdsResponse.Builder setChangeEventUserEmailIfPresent(
      SearchGoogleAdsResponse.Builder builder, String toSet) {
    builder.getResultsBuilderList().stream()
        .filter(row -> row.hasChangeEvent() && !row.getChangeEvent().getUserEmail().isEmpty())
        .forEach(row -> row.getChangeEventBuilder().setUserEmail(toSet));
    return builder;
  }

  @Override
  public SearchGoogleAdsResponse.Builder setPlacesLocationFeedDataEmailAddressIfPresent(
      SearchGoogleAdsResponse.Builder builder, String toSet) {
    builder.getResultsBuilderList().stream()
        .filter(row -> row.hasFeed() && row.getFeed().hasPlacesLocationFeedData() && row.getFeed().getPlacesLocationFeedData().hasEmailAddress())
        .forEach(row -> row.getFeedBuilder().getPlacesLocationFeedDataBuilder().setEmailAddress(toSet));
    return builder;
  }
}
