// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v4/resources/account_budget.proto

package com.google.ads.googleads.v4.resources;

/**
 * <pre>
 * An account-level budget. It contains information about the budget itself,
 * as well as the most recently approved changes to the budget and proposed
 * changes that are pending approval. The proposed changes that are pending
 * approval, if any, are found in 'pending_proposal'.  Effective details about
 * the budget are found in fields prefixed 'approved_', 'adjusted_' and those
 * without a prefix.  Since some effective details may differ from what the user
 * had originally requested (e.g. spending limit), these differences are
 * juxtaposed via 'proposed_', 'approved_', and possibly 'adjusted_' fields.
 * This resource is mutated using AccountBudgetProposal and cannot be mutated
 * directly. A budget may have at most one pending proposal at any given time.
 * It is read through pending_proposal.
 * Once approved, a budget may be subject to adjustments, such as credit
 * adjustments.  Adjustments create differences between the 'approved' and
 * 'adjusted' fields, which would otherwise be identical.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v4.resources.AccountBudget}
 */
public final class AccountBudget extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v4.resources.AccountBudget)
    AccountBudgetOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AccountBudget.newBuilder() to construct.
  private AccountBudget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AccountBudget() {
    resourceName_ = "";
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AccountBudget();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AccountBudget(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            resourceName_ = s;
            break;
          }
          case 18: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (id_ != null) {
              subBuilder = id_.toBuilder();
            }
            id_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(id_);
              id_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (billingSetup_ != null) {
              subBuilder = billingSetup_.toBuilder();
            }
            billingSetup_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(billingSetup_);
              billingSetup_ = subBuilder.buildPartial();
            }

            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            status_ = rawValue;
            break;
          }
          case 42: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (name_ != null) {
              subBuilder = name_.toBuilder();
            }
            name_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(name_);
              name_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (proposedStartDateTime_ != null) {
              subBuilder = proposedStartDateTime_.toBuilder();
            }
            proposedStartDateTime_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(proposedStartDateTime_);
              proposedStartDateTime_ = subBuilder.buildPartial();
            }

            break;
          }
          case 58: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (approvedStartDateTime_ != null) {
              subBuilder = approvedStartDateTime_.toBuilder();
            }
            approvedStartDateTime_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(approvedStartDateTime_);
              approvedStartDateTime_ = subBuilder.buildPartial();
            }

            break;
          }
          case 66: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (proposedEndTimeCase_ == 8) {
              subBuilder = ((com.google.protobuf.StringValue) proposedEndTime_).toBuilder();
            }
            proposedEndTime_ =
                input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.StringValue) proposedEndTime_);
              proposedEndTime_ = subBuilder.buildPartial();
            }
            proposedEndTimeCase_ = 8;
            break;
          }
          case 72: {
            int rawValue = input.readEnum();
            proposedEndTimeCase_ = 9;
            proposedEndTime_ = rawValue;
            break;
          }
          case 82: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (approvedEndTimeCase_ == 10) {
              subBuilder = ((com.google.protobuf.StringValue) approvedEndTime_).toBuilder();
            }
            approvedEndTime_ =
                input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.StringValue) approvedEndTime_);
              approvedEndTime_ = subBuilder.buildPartial();
            }
            approvedEndTimeCase_ = 10;
            break;
          }
          case 88: {
            int rawValue = input.readEnum();
            approvedEndTimeCase_ = 11;
            approvedEndTime_ = rawValue;
            break;
          }
          case 98: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (proposedSpendingLimitCase_ == 12) {
              subBuilder = ((com.google.protobuf.Int64Value) proposedSpendingLimit_).toBuilder();
            }
            proposedSpendingLimit_ =
                input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.Int64Value) proposedSpendingLimit_);
              proposedSpendingLimit_ = subBuilder.buildPartial();
            }
            proposedSpendingLimitCase_ = 12;
            break;
          }
          case 104: {
            int rawValue = input.readEnum();
            proposedSpendingLimitCase_ = 13;
            proposedSpendingLimit_ = rawValue;
            break;
          }
          case 114: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (approvedSpendingLimitCase_ == 14) {
              subBuilder = ((com.google.protobuf.Int64Value) approvedSpendingLimit_).toBuilder();
            }
            approvedSpendingLimit_ =
                input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.Int64Value) approvedSpendingLimit_);
              approvedSpendingLimit_ = subBuilder.buildPartial();
            }
            approvedSpendingLimitCase_ = 14;
            break;
          }
          case 120: {
            int rawValue = input.readEnum();
            approvedSpendingLimitCase_ = 15;
            approvedSpendingLimit_ = rawValue;
            break;
          }
          case 130: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (adjustedSpendingLimitCase_ == 16) {
              subBuilder = ((com.google.protobuf.Int64Value) adjustedSpendingLimit_).toBuilder();
            }
            adjustedSpendingLimit_ =
                input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.protobuf.Int64Value) adjustedSpendingLimit_);
              adjustedSpendingLimit_ = subBuilder.buildPartial();
            }
            adjustedSpendingLimitCase_ = 16;
            break;
          }
          case 136: {
            int rawValue = input.readEnum();
            adjustedSpendingLimitCase_ = 17;
            adjustedSpendingLimit_ = rawValue;
            break;
          }
          case 146: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (totalAdjustmentsMicros_ != null) {
              subBuilder = totalAdjustmentsMicros_.toBuilder();
            }
            totalAdjustmentsMicros_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(totalAdjustmentsMicros_);
              totalAdjustmentsMicros_ = subBuilder.buildPartial();
            }

            break;
          }
          case 154: {
            com.google.protobuf.Int64Value.Builder subBuilder = null;
            if (amountServedMicros_ != null) {
              subBuilder = amountServedMicros_.toBuilder();
            }
            amountServedMicros_ = input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(amountServedMicros_);
              amountServedMicros_ = subBuilder.buildPartial();
            }

            break;
          }
          case 162: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (purchaseOrderNumber_ != null) {
              subBuilder = purchaseOrderNumber_.toBuilder();
            }
            purchaseOrderNumber_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(purchaseOrderNumber_);
              purchaseOrderNumber_ = subBuilder.buildPartial();
            }

            break;
          }
          case 170: {
            com.google.protobuf.StringValue.Builder subBuilder = null;
            if (notes_ != null) {
              subBuilder = notes_.toBuilder();
            }
            notes_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(notes_);
              notes_ = subBuilder.buildPartial();
            }

            break;
          }
          case 178: {
            com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder subBuilder = null;
            if (pendingProposal_ != null) {
              subBuilder = pendingProposal_.toBuilder();
            }
            pendingProposal_ = input.readMessage(com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(pendingProposal_);
              pendingProposal_ = subBuilder.buildPartial();
            }

            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v4.resources.AccountBudget.class, com.google.ads.googleads.v4.resources.AccountBudget.Builder.class);
  }

  public interface PendingAccountBudgetProposalOrBuilder extends
      // @@protoc_insertion_point(interface_extends:google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the accountBudgetProposal field is set.
     */
    boolean hasAccountBudgetProposal();
    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The accountBudgetProposal.
     */
    com.google.protobuf.StringValue getAccountBudgetProposal();
    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    com.google.protobuf.StringValueOrBuilder getAccountBudgetProposalOrBuilder();

    /**
     * <pre>
     * Output only. The type of this proposal, e.g. END to end the budget associated
     * with this proposal.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for proposalType.
     */
    int getProposalTypeValue();
    /**
     * <pre>
     * Output only. The type of this proposal, e.g. END to end the budget associated
     * with this proposal.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposalType.
     */
    com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType getProposalType();

    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the name field is set.
     */
    boolean hasName();
    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The name.
     */
    com.google.protobuf.StringValue getName();
    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getNameOrBuilder();

    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the startDateTime field is set.
     */
    boolean hasStartDateTime();
    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDateTime.
     */
    com.google.protobuf.StringValue getStartDateTime();
    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getStartDateTimeOrBuilder();

    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the purchaseOrderNumber field is set.
     */
    boolean hasPurchaseOrderNumber();
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The purchaseOrderNumber.
     */
    com.google.protobuf.StringValue getPurchaseOrderNumber();
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getPurchaseOrderNumberOrBuilder();

    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the notes field is set.
     */
    boolean hasNotes();
    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The notes.
     */
    com.google.protobuf.StringValue getNotes();
    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getNotesOrBuilder();

    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the creationDateTime field is set.
     */
    boolean hasCreationDateTime();
    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The creationDateTime.
     */
    com.google.protobuf.StringValue getCreationDateTime();
    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getCreationDateTimeOrBuilder();

    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the endDateTime field is set.
     */
    boolean hasEndDateTime();
    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDateTime.
     */
    com.google.protobuf.StringValue getEndDateTime();
    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.StringValueOrBuilder getEndDateTimeOrBuilder();

    /**
     * <pre>
     * Output only. The end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for endTimeType.
     */
    int getEndTimeTypeValue();
    /**
     * <pre>
     * Output only. The end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endTimeType.
     */
    com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getEndTimeType();

    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the spendingLimitMicros field is set.
     */
    boolean hasSpendingLimitMicros();
    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The spendingLimitMicros.
     */
    com.google.protobuf.Int64Value getSpendingLimitMicros();
    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    com.google.protobuf.Int64ValueOrBuilder getSpendingLimitMicrosOrBuilder();

    /**
     * <pre>
     * Output only. The spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for spendingLimitType.
     */
    int getSpendingLimitTypeValue();
    /**
     * <pre>
     * Output only. The spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The spendingLimitType.
     */
    com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getSpendingLimitType();

    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.EndTimeCase getEndTimeCase();

    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.SpendingLimitCase getSpendingLimitCase();
  }
  /**
   * <pre>
   * A pending proposal associated with the enclosing account-level budget,
   * if applicable.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal}
   */
  public static final class PendingAccountBudgetProposal extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)
      PendingAccountBudgetProposalOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PendingAccountBudgetProposal.newBuilder() to construct.
    private PendingAccountBudgetProposal(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PendingAccountBudgetProposal() {
      proposalType_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(
        UnusedPrivateParameter unused) {
      return new PendingAccountBudgetProposal();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PendingAccountBudgetProposal(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (accountBudgetProposal_ != null) {
                subBuilder = accountBudgetProposal_.toBuilder();
              }
              accountBudgetProposal_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(accountBudgetProposal_);
                accountBudgetProposal_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              proposalType_ = rawValue;
              break;
            }
            case 26: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (name_ != null) {
                subBuilder = name_.toBuilder();
              }
              name_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(name_);
                name_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (startDateTime_ != null) {
                subBuilder = startDateTime_.toBuilder();
              }
              startDateTime_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(startDateTime_);
                startDateTime_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (endTimeCase_ == 5) {
                subBuilder = ((com.google.protobuf.StringValue) endTime_).toBuilder();
              }
              endTime_ =
                  input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.StringValue) endTime_);
                endTime_ = subBuilder.buildPartial();
              }
              endTimeCase_ = 5;
              break;
            }
            case 48: {
              int rawValue = input.readEnum();
              endTimeCase_ = 6;
              endTime_ = rawValue;
              break;
            }
            case 58: {
              com.google.protobuf.Int64Value.Builder subBuilder = null;
              if (spendingLimitCase_ == 7) {
                subBuilder = ((com.google.protobuf.Int64Value) spendingLimit_).toBuilder();
              }
              spendingLimit_ =
                  input.readMessage(com.google.protobuf.Int64Value.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.protobuf.Int64Value) spendingLimit_);
                spendingLimit_ = subBuilder.buildPartial();
              }
              spendingLimitCase_ = 7;
              break;
            }
            case 64: {
              int rawValue = input.readEnum();
              spendingLimitCase_ = 8;
              spendingLimit_ = rawValue;
              break;
            }
            case 74: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (purchaseOrderNumber_ != null) {
                subBuilder = purchaseOrderNumber_.toBuilder();
              }
              purchaseOrderNumber_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(purchaseOrderNumber_);
                purchaseOrderNumber_ = subBuilder.buildPartial();
              }

              break;
            }
            case 82: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (notes_ != null) {
                subBuilder = notes_.toBuilder();
              }
              notes_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(notes_);
                notes_ = subBuilder.buildPartial();
              }

              break;
            }
            case 90: {
              com.google.protobuf.StringValue.Builder subBuilder = null;
              if (creationDateTime_ != null) {
                subBuilder = creationDateTime_.toBuilder();
              }
              creationDateTime_ = input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(creationDateTime_);
                creationDateTime_ = subBuilder.buildPartial();
              }

              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_PendingAccountBudgetProposal_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_PendingAccountBudgetProposal_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.class, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder.class);
    }

    private int endTimeCase_ = 0;
    private java.lang.Object endTime_;
    public enum EndTimeCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      END_DATE_TIME(5),
      END_TIME_TYPE(6),
      ENDTIME_NOT_SET(0);
      private final int value;
      private EndTimeCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static EndTimeCase valueOf(int value) {
        return forNumber(value);
      }

      public static EndTimeCase forNumber(int value) {
        switch (value) {
          case 5: return END_DATE_TIME;
          case 6: return END_TIME_TYPE;
          case 0: return ENDTIME_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public EndTimeCase
    getEndTimeCase() {
      return EndTimeCase.forNumber(
          endTimeCase_);
    }

    private int spendingLimitCase_ = 0;
    private java.lang.Object spendingLimit_;
    public enum SpendingLimitCase
        implements com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SPENDING_LIMIT_MICROS(7),
      SPENDING_LIMIT_TYPE(8),
      SPENDINGLIMIT_NOT_SET(0);
      private final int value;
      private SpendingLimitCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SpendingLimitCase valueOf(int value) {
        return forNumber(value);
      }

      public static SpendingLimitCase forNumber(int value) {
        switch (value) {
          case 7: return SPENDING_LIMIT_MICROS;
          case 8: return SPENDING_LIMIT_TYPE;
          case 0: return SPENDINGLIMIT_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public SpendingLimitCase
    getSpendingLimitCase() {
      return SpendingLimitCase.forNumber(
          spendingLimitCase_);
    }

    public static final int ACCOUNT_BUDGET_PROPOSAL_FIELD_NUMBER = 1;
    private com.google.protobuf.StringValue accountBudgetProposal_;
    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the accountBudgetProposal field is set.
     */
    @java.lang.Override
    public boolean hasAccountBudgetProposal() {
      return accountBudgetProposal_ != null;
    }
    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The accountBudgetProposal.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getAccountBudgetProposal() {
      return accountBudgetProposal_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : accountBudgetProposal_;
    }
    /**
     * <pre>
     * Output only. The resource name of the proposal.
     * AccountBudgetProposal resource names have the form:
     * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getAccountBudgetProposalOrBuilder() {
      return getAccountBudgetProposal();
    }

    public static final int PROPOSAL_TYPE_FIELD_NUMBER = 2;
    private int proposalType_;
    /**
     * <pre>
     * Output only. The type of this proposal, e.g. END to end the budget associated
     * with this proposal.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for proposalType.
     */
    @java.lang.Override public int getProposalTypeValue() {
      return proposalType_;
    }
    /**
     * <pre>
     * Output only. The type of this proposal, e.g. END to end the budget associated
     * with this proposal.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposalType.
     */
    @java.lang.Override public com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType getProposalType() {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType result = com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.valueOf(proposalType_);
      return result == null ? com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.UNRECOGNIZED : result;
    }

    public static final int NAME_FIELD_NUMBER = 3;
    private com.google.protobuf.StringValue name_;
    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the name field is set.
     */
    @java.lang.Override
    public boolean hasName() {
      return name_ != null;
    }
    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The name.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getName() {
      return name_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : name_;
    }
    /**
     * <pre>
     * Output only. The name to assign to the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getNameOrBuilder() {
      return getName();
    }

    public static final int START_DATE_TIME_FIELD_NUMBER = 4;
    private com.google.protobuf.StringValue startDateTime_;
    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the startDateTime field is set.
     */
    @java.lang.Override
    public boolean hasStartDateTime() {
      return startDateTime_ != null;
    }
    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDateTime.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getStartDateTime() {
      return startDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : startDateTime_;
    }
    /**
     * <pre>
     * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getStartDateTimeOrBuilder() {
      return getStartDateTime();
    }

    public static final int PURCHASE_ORDER_NUMBER_FIELD_NUMBER = 9;
    private com.google.protobuf.StringValue purchaseOrderNumber_;
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the purchaseOrderNumber field is set.
     */
    @java.lang.Override
    public boolean hasPurchaseOrderNumber() {
      return purchaseOrderNumber_ != null;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The purchaseOrderNumber.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getPurchaseOrderNumber() {
      return purchaseOrderNumber_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getPurchaseOrderNumberOrBuilder() {
      return getPurchaseOrderNumber();
    }

    public static final int NOTES_FIELD_NUMBER = 10;
    private com.google.protobuf.StringValue notes_;
    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the notes field is set.
     */
    @java.lang.Override
    public boolean hasNotes() {
      return notes_ != null;
    }
    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The notes.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getNotes() {
      return notes_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : notes_;
    }
    /**
     * <pre>
     * Output only. Notes associated with this budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getNotesOrBuilder() {
      return getNotes();
    }

    public static final int CREATION_DATE_TIME_FIELD_NUMBER = 11;
    private com.google.protobuf.StringValue creationDateTime_;
    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the creationDateTime field is set.
     */
    @java.lang.Override
    public boolean hasCreationDateTime() {
      return creationDateTime_ != null;
    }
    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The creationDateTime.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getCreationDateTime() {
      return creationDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : creationDateTime_;
    }
    /**
     * <pre>
     * Output only. The time when this account-level budget proposal was created.
     * Formatted as yyyy-MM-dd HH:mm:ss.
     * </pre>
     *
     * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getCreationDateTimeOrBuilder() {
      return getCreationDateTime();
    }

    public static final int END_DATE_TIME_FIELD_NUMBER = 5;
    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the endDateTime field is set.
     */
    @java.lang.Override
    public boolean hasEndDateTime() {
      return endTimeCase_ == 5;
    }
    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDateTime.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getEndDateTime() {
      if (endTimeCase_ == 5) {
         return (com.google.protobuf.StringValue) endTime_;
      }
      return com.google.protobuf.StringValue.getDefaultInstance();
    }
    /**
     * <pre>
     * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getEndDateTimeOrBuilder() {
      if (endTimeCase_ == 5) {
         return (com.google.protobuf.StringValue) endTime_;
      }
      return com.google.protobuf.StringValue.getDefaultInstance();
    }

    public static final int END_TIME_TYPE_FIELD_NUMBER = 6;
    /**
     * <pre>
     * Output only. The end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for endTimeType.
     */
    public int getEndTimeTypeValue() {
      if (endTimeCase_ == 6) {
        return (java.lang.Integer) endTime_;
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endTimeType.
     */
    public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getEndTimeType() {
      if (endTimeCase_ == 6) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
            (java.lang.Integer) endTime_);
        return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
    }

    public static final int SPENDING_LIMIT_MICROS_FIELD_NUMBER = 7;
    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the spendingLimitMicros field is set.
     */
    @java.lang.Override
    public boolean hasSpendingLimitMicros() {
      return spendingLimitCase_ == 7;
    }
    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The spendingLimitMicros.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getSpendingLimitMicros() {
      if (spendingLimitCase_ == 7) {
         return (com.google.protobuf.Int64Value) spendingLimit_;
      }
      return com.google.protobuf.Int64Value.getDefaultInstance();
    }
    /**
     * <pre>
     * Output only. The spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getSpendingLimitMicrosOrBuilder() {
      if (spendingLimitCase_ == 7) {
         return (com.google.protobuf.Int64Value) spendingLimit_;
      }
      return com.google.protobuf.Int64Value.getDefaultInstance();
    }

    public static final int SPENDING_LIMIT_TYPE_FIELD_NUMBER = 8;
    /**
     * <pre>
     * Output only. The spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for spendingLimitType.
     */
    public int getSpendingLimitTypeValue() {
      if (spendingLimitCase_ == 8) {
        return (java.lang.Integer) spendingLimit_;
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The spendingLimitType.
     */
    public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getSpendingLimitType() {
      if (spendingLimitCase_ == 8) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
            (java.lang.Integer) spendingLimit_);
        return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (accountBudgetProposal_ != null) {
        output.writeMessage(1, getAccountBudgetProposal());
      }
      if (proposalType_ != com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.UNSPECIFIED.getNumber()) {
        output.writeEnum(2, proposalType_);
      }
      if (name_ != null) {
        output.writeMessage(3, getName());
      }
      if (startDateTime_ != null) {
        output.writeMessage(4, getStartDateTime());
      }
      if (endTimeCase_ == 5) {
        output.writeMessage(5, (com.google.protobuf.StringValue) endTime_);
      }
      if (endTimeCase_ == 6) {
        output.writeEnum(6, ((java.lang.Integer) endTime_));
      }
      if (spendingLimitCase_ == 7) {
        output.writeMessage(7, (com.google.protobuf.Int64Value) spendingLimit_);
      }
      if (spendingLimitCase_ == 8) {
        output.writeEnum(8, ((java.lang.Integer) spendingLimit_));
      }
      if (purchaseOrderNumber_ != null) {
        output.writeMessage(9, getPurchaseOrderNumber());
      }
      if (notes_ != null) {
        output.writeMessage(10, getNotes());
      }
      if (creationDateTime_ != null) {
        output.writeMessage(11, getCreationDateTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (accountBudgetProposal_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getAccountBudgetProposal());
      }
      if (proposalType_ != com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, proposalType_);
      }
      if (name_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getName());
      }
      if (startDateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getStartDateTime());
      }
      if (endTimeCase_ == 5) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, (com.google.protobuf.StringValue) endTime_);
      }
      if (endTimeCase_ == 6) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, ((java.lang.Integer) endTime_));
      }
      if (spendingLimitCase_ == 7) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, (com.google.protobuf.Int64Value) spendingLimit_);
      }
      if (spendingLimitCase_ == 8) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(8, ((java.lang.Integer) spendingLimit_));
      }
      if (purchaseOrderNumber_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getPurchaseOrderNumber());
      }
      if (notes_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getNotes());
      }
      if (creationDateTime_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, getCreationDateTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)) {
        return super.equals(obj);
      }
      com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal other = (com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal) obj;

      if (hasAccountBudgetProposal() != other.hasAccountBudgetProposal()) return false;
      if (hasAccountBudgetProposal()) {
        if (!getAccountBudgetProposal()
            .equals(other.getAccountBudgetProposal())) return false;
      }
      if (proposalType_ != other.proposalType_) return false;
      if (hasName() != other.hasName()) return false;
      if (hasName()) {
        if (!getName()
            .equals(other.getName())) return false;
      }
      if (hasStartDateTime() != other.hasStartDateTime()) return false;
      if (hasStartDateTime()) {
        if (!getStartDateTime()
            .equals(other.getStartDateTime())) return false;
      }
      if (hasPurchaseOrderNumber() != other.hasPurchaseOrderNumber()) return false;
      if (hasPurchaseOrderNumber()) {
        if (!getPurchaseOrderNumber()
            .equals(other.getPurchaseOrderNumber())) return false;
      }
      if (hasNotes() != other.hasNotes()) return false;
      if (hasNotes()) {
        if (!getNotes()
            .equals(other.getNotes())) return false;
      }
      if (hasCreationDateTime() != other.hasCreationDateTime()) return false;
      if (hasCreationDateTime()) {
        if (!getCreationDateTime()
            .equals(other.getCreationDateTime())) return false;
      }
      if (!getEndTimeCase().equals(other.getEndTimeCase())) return false;
      switch (endTimeCase_) {
        case 5:
          if (!getEndDateTime()
              .equals(other.getEndDateTime())) return false;
          break;
        case 6:
          if (getEndTimeTypeValue()
              != other.getEndTimeTypeValue()) return false;
          break;
        case 0:
        default:
      }
      if (!getSpendingLimitCase().equals(other.getSpendingLimitCase())) return false;
      switch (spendingLimitCase_) {
        case 7:
          if (!getSpendingLimitMicros()
              .equals(other.getSpendingLimitMicros())) return false;
          break;
        case 8:
          if (getSpendingLimitTypeValue()
              != other.getSpendingLimitTypeValue()) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAccountBudgetProposal()) {
        hash = (37 * hash) + ACCOUNT_BUDGET_PROPOSAL_FIELD_NUMBER;
        hash = (53 * hash) + getAccountBudgetProposal().hashCode();
      }
      hash = (37 * hash) + PROPOSAL_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + proposalType_;
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasStartDateTime()) {
        hash = (37 * hash) + START_DATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartDateTime().hashCode();
      }
      if (hasPurchaseOrderNumber()) {
        hash = (37 * hash) + PURCHASE_ORDER_NUMBER_FIELD_NUMBER;
        hash = (53 * hash) + getPurchaseOrderNumber().hashCode();
      }
      if (hasNotes()) {
        hash = (37 * hash) + NOTES_FIELD_NUMBER;
        hash = (53 * hash) + getNotes().hashCode();
      }
      if (hasCreationDateTime()) {
        hash = (37 * hash) + CREATION_DATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getCreationDateTime().hashCode();
      }
      switch (endTimeCase_) {
        case 5:
          hash = (37 * hash) + END_DATE_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getEndDateTime().hashCode();
          break;
        case 6:
          hash = (37 * hash) + END_TIME_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getEndTimeTypeValue();
          break;
        case 0:
        default:
      }
      switch (spendingLimitCase_) {
        case 7:
          hash = (37 * hash) + SPENDING_LIMIT_MICROS_FIELD_NUMBER;
          hash = (53 * hash) + getSpendingLimitMicros().hashCode();
          break;
        case 8:
          hash = (37 * hash) + SPENDING_LIMIT_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getSpendingLimitTypeValue();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A pending proposal associated with the enclosing account-level budget,
     * if applicable.
     * </pre>
     *
     * Protobuf type {@code google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_PendingAccountBudgetProposal_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_PendingAccountBudgetProposal_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.class, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder.class);
      }

      // Construct using com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (accountBudgetProposalBuilder_ == null) {
          accountBudgetProposal_ = null;
        } else {
          accountBudgetProposal_ = null;
          accountBudgetProposalBuilder_ = null;
        }
        proposalType_ = 0;

        if (nameBuilder_ == null) {
          name_ = null;
        } else {
          name_ = null;
          nameBuilder_ = null;
        }
        if (startDateTimeBuilder_ == null) {
          startDateTime_ = null;
        } else {
          startDateTime_ = null;
          startDateTimeBuilder_ = null;
        }
        if (purchaseOrderNumberBuilder_ == null) {
          purchaseOrderNumber_ = null;
        } else {
          purchaseOrderNumber_ = null;
          purchaseOrderNumberBuilder_ = null;
        }
        if (notesBuilder_ == null) {
          notes_ = null;
        } else {
          notes_ = null;
          notesBuilder_ = null;
        }
        if (creationDateTimeBuilder_ == null) {
          creationDateTime_ = null;
        } else {
          creationDateTime_ = null;
          creationDateTimeBuilder_ = null;
        }
        endTimeCase_ = 0;
        endTime_ = null;
        spendingLimitCase_ = 0;
        spendingLimit_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_PendingAccountBudgetProposal_descriptor;
      }

      @java.lang.Override
      public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal getDefaultInstanceForType() {
        return com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal build() {
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal buildPartial() {
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal result = new com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal(this);
        if (accountBudgetProposalBuilder_ == null) {
          result.accountBudgetProposal_ = accountBudgetProposal_;
        } else {
          result.accountBudgetProposal_ = accountBudgetProposalBuilder_.build();
        }
        result.proposalType_ = proposalType_;
        if (nameBuilder_ == null) {
          result.name_ = name_;
        } else {
          result.name_ = nameBuilder_.build();
        }
        if (startDateTimeBuilder_ == null) {
          result.startDateTime_ = startDateTime_;
        } else {
          result.startDateTime_ = startDateTimeBuilder_.build();
        }
        if (purchaseOrderNumberBuilder_ == null) {
          result.purchaseOrderNumber_ = purchaseOrderNumber_;
        } else {
          result.purchaseOrderNumber_ = purchaseOrderNumberBuilder_.build();
        }
        if (notesBuilder_ == null) {
          result.notes_ = notes_;
        } else {
          result.notes_ = notesBuilder_.build();
        }
        if (creationDateTimeBuilder_ == null) {
          result.creationDateTime_ = creationDateTime_;
        } else {
          result.creationDateTime_ = creationDateTimeBuilder_.build();
        }
        if (endTimeCase_ == 5) {
          if (endDateTimeBuilder_ == null) {
            result.endTime_ = endTime_;
          } else {
            result.endTime_ = endDateTimeBuilder_.build();
          }
        }
        if (endTimeCase_ == 6) {
          result.endTime_ = endTime_;
        }
        if (spendingLimitCase_ == 7) {
          if (spendingLimitMicrosBuilder_ == null) {
            result.spendingLimit_ = spendingLimit_;
          } else {
            result.spendingLimit_ = spendingLimitMicrosBuilder_.build();
          }
        }
        if (spendingLimitCase_ == 8) {
          result.spendingLimit_ = spendingLimit_;
        }
        result.endTimeCase_ = endTimeCase_;
        result.spendingLimitCase_ = spendingLimitCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal) {
          return mergeFrom((com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal other) {
        if (other == com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.getDefaultInstance()) return this;
        if (other.hasAccountBudgetProposal()) {
          mergeAccountBudgetProposal(other.getAccountBudgetProposal());
        }
        if (other.proposalType_ != 0) {
          setProposalTypeValue(other.getProposalTypeValue());
        }
        if (other.hasName()) {
          mergeName(other.getName());
        }
        if (other.hasStartDateTime()) {
          mergeStartDateTime(other.getStartDateTime());
        }
        if (other.hasPurchaseOrderNumber()) {
          mergePurchaseOrderNumber(other.getPurchaseOrderNumber());
        }
        if (other.hasNotes()) {
          mergeNotes(other.getNotes());
        }
        if (other.hasCreationDateTime()) {
          mergeCreationDateTime(other.getCreationDateTime());
        }
        switch (other.getEndTimeCase()) {
          case END_DATE_TIME: {
            mergeEndDateTime(other.getEndDateTime());
            break;
          }
          case END_TIME_TYPE: {
            setEndTimeTypeValue(other.getEndTimeTypeValue());
            break;
          }
          case ENDTIME_NOT_SET: {
            break;
          }
        }
        switch (other.getSpendingLimitCase()) {
          case SPENDING_LIMIT_MICROS: {
            mergeSpendingLimitMicros(other.getSpendingLimitMicros());
            break;
          }
          case SPENDING_LIMIT_TYPE: {
            setSpendingLimitTypeValue(other.getSpendingLimitTypeValue());
            break;
          }
          case SPENDINGLIMIT_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int endTimeCase_ = 0;
      private java.lang.Object endTime_;
      public EndTimeCase
          getEndTimeCase() {
        return EndTimeCase.forNumber(
            endTimeCase_);
      }

      public Builder clearEndTime() {
        endTimeCase_ = 0;
        endTime_ = null;
        onChanged();
        return this;
      }

      private int spendingLimitCase_ = 0;
      private java.lang.Object spendingLimit_;
      public SpendingLimitCase
          getSpendingLimitCase() {
        return SpendingLimitCase.forNumber(
            spendingLimitCase_);
      }

      public Builder clearSpendingLimit() {
        spendingLimitCase_ = 0;
        spendingLimit_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.StringValue accountBudgetProposal_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> accountBudgetProposalBuilder_;
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       * @return Whether the accountBudgetProposal field is set.
       */
      public boolean hasAccountBudgetProposal() {
        return accountBudgetProposalBuilder_ != null || accountBudgetProposal_ != null;
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       * @return The accountBudgetProposal.
       */
      public com.google.protobuf.StringValue getAccountBudgetProposal() {
        if (accountBudgetProposalBuilder_ == null) {
          return accountBudgetProposal_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : accountBudgetProposal_;
        } else {
          return accountBudgetProposalBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public Builder setAccountBudgetProposal(com.google.protobuf.StringValue value) {
        if (accountBudgetProposalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          accountBudgetProposal_ = value;
          onChanged();
        } else {
          accountBudgetProposalBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public Builder setAccountBudgetProposal(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (accountBudgetProposalBuilder_ == null) {
          accountBudgetProposal_ = builderForValue.build();
          onChanged();
        } else {
          accountBudgetProposalBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public Builder mergeAccountBudgetProposal(com.google.protobuf.StringValue value) {
        if (accountBudgetProposalBuilder_ == null) {
          if (accountBudgetProposal_ != null) {
            accountBudgetProposal_ =
              com.google.protobuf.StringValue.newBuilder(accountBudgetProposal_).mergeFrom(value).buildPartial();
          } else {
            accountBudgetProposal_ = value;
          }
          onChanged();
        } else {
          accountBudgetProposalBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public Builder clearAccountBudgetProposal() {
        if (accountBudgetProposalBuilder_ == null) {
          accountBudgetProposal_ = null;
          onChanged();
        } else {
          accountBudgetProposal_ = null;
          accountBudgetProposalBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public com.google.protobuf.StringValue.Builder getAccountBudgetProposalBuilder() {
        
        onChanged();
        return getAccountBudgetProposalFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      public com.google.protobuf.StringValueOrBuilder getAccountBudgetProposalOrBuilder() {
        if (accountBudgetProposalBuilder_ != null) {
          return accountBudgetProposalBuilder_.getMessageOrBuilder();
        } else {
          return accountBudgetProposal_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : accountBudgetProposal_;
        }
      }
      /**
       * <pre>
       * Output only. The resource name of the proposal.
       * AccountBudgetProposal resource names have the form:
       * `customers/{customer_id}/accountBudgetProposals/{account_budget_proposal_id}`
       * </pre>
       *
       * <code>.google.protobuf.StringValue account_budget_proposal = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getAccountBudgetProposalFieldBuilder() {
        if (accountBudgetProposalBuilder_ == null) {
          accountBudgetProposalBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getAccountBudgetProposal(),
                  getParentForChildren(),
                  isClean());
          accountBudgetProposal_ = null;
        }
        return accountBudgetProposalBuilder_;
      }

      private int proposalType_ = 0;
      /**
       * <pre>
       * Output only. The type of this proposal, e.g. END to end the budget associated
       * with this proposal.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The enum numeric value on the wire for proposalType.
       */
      @java.lang.Override public int getProposalTypeValue() {
        return proposalType_;
      }
      /**
       * <pre>
       * Output only. The type of this proposal, e.g. END to end the budget associated
       * with this proposal.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The enum numeric value on the wire for proposalType to set.
       * @return This builder for chaining.
       */
      public Builder setProposalTypeValue(int value) {
        
        proposalType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The type of this proposal, e.g. END to end the budget associated
       * with this proposal.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The proposalType.
       */
      @java.lang.Override
      public com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType getProposalType() {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType result = com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.valueOf(proposalType_);
        return result == null ? com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Output only. The type of this proposal, e.g. END to end the budget associated
       * with this proposal.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The proposalType to set.
       * @return This builder for chaining.
       */
      public Builder setProposalType(com.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        proposalType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The type of this proposal, e.g. END to end the budget associated
       * with this proposal.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.AccountBudgetProposalTypeEnum.AccountBudgetProposalType proposal_type = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearProposalType() {
        
        proposalType_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.StringValue name_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> nameBuilder_;
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the name field is set.
       */
      public boolean hasName() {
        return nameBuilder_ != null || name_ != null;
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The name.
       */
      public com.google.protobuf.StringValue getName() {
        if (nameBuilder_ == null) {
          return name_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : name_;
        } else {
          return nameBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setName(com.google.protobuf.StringValue value) {
        if (nameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          onChanged();
        } else {
          nameBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setName(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (nameBuilder_ == null) {
          name_ = builderForValue.build();
          onChanged();
        } else {
          nameBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeName(com.google.protobuf.StringValue value) {
        if (nameBuilder_ == null) {
          if (name_ != null) {
            name_ =
              com.google.protobuf.StringValue.newBuilder(name_).mergeFrom(value).buildPartial();
          } else {
            name_ = value;
          }
          onChanged();
        } else {
          nameBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearName() {
        if (nameBuilder_ == null) {
          name_ = null;
          onChanged();
        } else {
          name_ = null;
          nameBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getNameBuilder() {
        
        onChanged();
        return getNameFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValueOrBuilder getNameOrBuilder() {
        if (nameBuilder_ != null) {
          return nameBuilder_.getMessageOrBuilder();
        } else {
          return name_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : name_;
        }
      }
      /**
       * <pre>
       * Output only. The name to assign to the account-level budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue name = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getNameFieldBuilder() {
        if (nameBuilder_ == null) {
          nameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getName(),
                  getParentForChildren(),
                  isClean());
          name_ = null;
        }
        return nameBuilder_;
      }

      private com.google.protobuf.StringValue startDateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> startDateTimeBuilder_;
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the startDateTime field is set.
       */
      public boolean hasStartDateTime() {
        return startDateTimeBuilder_ != null || startDateTime_ != null;
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The startDateTime.
       */
      public com.google.protobuf.StringValue getStartDateTime() {
        if (startDateTimeBuilder_ == null) {
          return startDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : startDateTime_;
        } else {
          return startDateTimeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setStartDateTime(com.google.protobuf.StringValue value) {
        if (startDateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startDateTime_ = value;
          onChanged();
        } else {
          startDateTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setStartDateTime(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (startDateTimeBuilder_ == null) {
          startDateTime_ = builderForValue.build();
          onChanged();
        } else {
          startDateTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeStartDateTime(com.google.protobuf.StringValue value) {
        if (startDateTimeBuilder_ == null) {
          if (startDateTime_ != null) {
            startDateTime_ =
              com.google.protobuf.StringValue.newBuilder(startDateTime_).mergeFrom(value).buildPartial();
          } else {
            startDateTime_ = value;
          }
          onChanged();
        } else {
          startDateTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearStartDateTime() {
        if (startDateTimeBuilder_ == null) {
          startDateTime_ = null;
          onChanged();
        } else {
          startDateTime_ = null;
          startDateTimeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getStartDateTimeBuilder() {
        
        onChanged();
        return getStartDateTimeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValueOrBuilder getStartDateTimeOrBuilder() {
        if (startDateTimeBuilder_ != null) {
          return startDateTimeBuilder_.getMessageOrBuilder();
        } else {
          return startDateTime_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : startDateTime_;
        }
      }
      /**
       * <pre>
       * Output only. The start time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue start_date_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getStartDateTimeFieldBuilder() {
        if (startDateTimeBuilder_ == null) {
          startDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getStartDateTime(),
                  getParentForChildren(),
                  isClean());
          startDateTime_ = null;
        }
        return startDateTimeBuilder_;
      }

      private com.google.protobuf.StringValue purchaseOrderNumber_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> purchaseOrderNumberBuilder_;
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the purchaseOrderNumber field is set.
       */
      public boolean hasPurchaseOrderNumber() {
        return purchaseOrderNumberBuilder_ != null || purchaseOrderNumber_ != null;
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The purchaseOrderNumber.
       */
      public com.google.protobuf.StringValue getPurchaseOrderNumber() {
        if (purchaseOrderNumberBuilder_ == null) {
          return purchaseOrderNumber_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
        } else {
          return purchaseOrderNumberBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setPurchaseOrderNumber(com.google.protobuf.StringValue value) {
        if (purchaseOrderNumberBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          purchaseOrderNumber_ = value;
          onChanged();
        } else {
          purchaseOrderNumberBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setPurchaseOrderNumber(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (purchaseOrderNumberBuilder_ == null) {
          purchaseOrderNumber_ = builderForValue.build();
          onChanged();
        } else {
          purchaseOrderNumberBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergePurchaseOrderNumber(com.google.protobuf.StringValue value) {
        if (purchaseOrderNumberBuilder_ == null) {
          if (purchaseOrderNumber_ != null) {
            purchaseOrderNumber_ =
              com.google.protobuf.StringValue.newBuilder(purchaseOrderNumber_).mergeFrom(value).buildPartial();
          } else {
            purchaseOrderNumber_ = value;
          }
          onChanged();
        } else {
          purchaseOrderNumberBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearPurchaseOrderNumber() {
        if (purchaseOrderNumberBuilder_ == null) {
          purchaseOrderNumber_ = null;
          onChanged();
        } else {
          purchaseOrderNumber_ = null;
          purchaseOrderNumberBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getPurchaseOrderNumberBuilder() {
        
        onChanged();
        return getPurchaseOrderNumberFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValueOrBuilder getPurchaseOrderNumberOrBuilder() {
        if (purchaseOrderNumberBuilder_ != null) {
          return purchaseOrderNumberBuilder_.getMessageOrBuilder();
        } else {
          return purchaseOrderNumber_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
        }
      }
      /**
       * <pre>
       * Output only. A purchase order number is a value that helps users reference this budget
       * in their monthly invoices.
       * </pre>
       *
       * <code>.google.protobuf.StringValue purchase_order_number = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getPurchaseOrderNumberFieldBuilder() {
        if (purchaseOrderNumberBuilder_ == null) {
          purchaseOrderNumberBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getPurchaseOrderNumber(),
                  getParentForChildren(),
                  isClean());
          purchaseOrderNumber_ = null;
        }
        return purchaseOrderNumberBuilder_;
      }

      private com.google.protobuf.StringValue notes_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> notesBuilder_;
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the notes field is set.
       */
      public boolean hasNotes() {
        return notesBuilder_ != null || notes_ != null;
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The notes.
       */
      public com.google.protobuf.StringValue getNotes() {
        if (notesBuilder_ == null) {
          return notes_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : notes_;
        } else {
          return notesBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setNotes(com.google.protobuf.StringValue value) {
        if (notesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          notes_ = value;
          onChanged();
        } else {
          notesBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setNotes(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (notesBuilder_ == null) {
          notes_ = builderForValue.build();
          onChanged();
        } else {
          notesBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeNotes(com.google.protobuf.StringValue value) {
        if (notesBuilder_ == null) {
          if (notes_ != null) {
            notes_ =
              com.google.protobuf.StringValue.newBuilder(notes_).mergeFrom(value).buildPartial();
          } else {
            notes_ = value;
          }
          onChanged();
        } else {
          notesBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearNotes() {
        if (notesBuilder_ == null) {
          notes_ = null;
          onChanged();
        } else {
          notes_ = null;
          notesBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getNotesBuilder() {
        
        onChanged();
        return getNotesFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValueOrBuilder getNotesOrBuilder() {
        if (notesBuilder_ != null) {
          return notesBuilder_.getMessageOrBuilder();
        } else {
          return notes_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : notes_;
        }
      }
      /**
       * <pre>
       * Output only. Notes associated with this budget.
       * </pre>
       *
       * <code>.google.protobuf.StringValue notes = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getNotesFieldBuilder() {
        if (notesBuilder_ == null) {
          notesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getNotes(),
                  getParentForChildren(),
                  isClean());
          notes_ = null;
        }
        return notesBuilder_;
      }

      private com.google.protobuf.StringValue creationDateTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> creationDateTimeBuilder_;
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the creationDateTime field is set.
       */
      public boolean hasCreationDateTime() {
        return creationDateTimeBuilder_ != null || creationDateTime_ != null;
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The creationDateTime.
       */
      public com.google.protobuf.StringValue getCreationDateTime() {
        if (creationDateTimeBuilder_ == null) {
          return creationDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : creationDateTime_;
        } else {
          return creationDateTimeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setCreationDateTime(com.google.protobuf.StringValue value) {
        if (creationDateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          creationDateTime_ = value;
          onChanged();
        } else {
          creationDateTimeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setCreationDateTime(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (creationDateTimeBuilder_ == null) {
          creationDateTime_ = builderForValue.build();
          onChanged();
        } else {
          creationDateTimeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeCreationDateTime(com.google.protobuf.StringValue value) {
        if (creationDateTimeBuilder_ == null) {
          if (creationDateTime_ != null) {
            creationDateTime_ =
              com.google.protobuf.StringValue.newBuilder(creationDateTime_).mergeFrom(value).buildPartial();
          } else {
            creationDateTime_ = value;
          }
          onChanged();
        } else {
          creationDateTimeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearCreationDateTime() {
        if (creationDateTimeBuilder_ == null) {
          creationDateTime_ = null;
          onChanged();
        } else {
          creationDateTime_ = null;
          creationDateTimeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getCreationDateTimeBuilder() {
        
        onChanged();
        return getCreationDateTimeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValueOrBuilder getCreationDateTimeOrBuilder() {
        if (creationDateTimeBuilder_ != null) {
          return creationDateTimeBuilder_.getMessageOrBuilder();
        } else {
          return creationDateTime_ == null ?
              com.google.protobuf.StringValue.getDefaultInstance() : creationDateTime_;
        }
      }
      /**
       * <pre>
       * Output only. The time when this account-level budget proposal was created.
       * Formatted as yyyy-MM-dd HH:mm:ss.
       * </pre>
       *
       * <code>.google.protobuf.StringValue creation_date_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getCreationDateTimeFieldBuilder() {
        if (creationDateTimeBuilder_ == null) {
          creationDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  getCreationDateTime(),
                  getParentForChildren(),
                  isClean());
          creationDateTime_ = null;
        }
        return creationDateTimeBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> endDateTimeBuilder_;
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the endDateTime field is set.
       */
      @java.lang.Override
      public boolean hasEndDateTime() {
        return endTimeCase_ == 5;
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The endDateTime.
       */
      @java.lang.Override
      public com.google.protobuf.StringValue getEndDateTime() {
        if (endDateTimeBuilder_ == null) {
          if (endTimeCase_ == 5) {
            return (com.google.protobuf.StringValue) endTime_;
          }
          return com.google.protobuf.StringValue.getDefaultInstance();
        } else {
          if (endTimeCase_ == 5) {
            return endDateTimeBuilder_.getMessage();
          }
          return com.google.protobuf.StringValue.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setEndDateTime(com.google.protobuf.StringValue value) {
        if (endDateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTime_ = value;
          onChanged();
        } else {
          endDateTimeBuilder_.setMessage(value);
        }
        endTimeCase_ = 5;
        return this;
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setEndDateTime(
          com.google.protobuf.StringValue.Builder builderForValue) {
        if (endDateTimeBuilder_ == null) {
          endTime_ = builderForValue.build();
          onChanged();
        } else {
          endDateTimeBuilder_.setMessage(builderForValue.build());
        }
        endTimeCase_ = 5;
        return this;
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeEndDateTime(com.google.protobuf.StringValue value) {
        if (endDateTimeBuilder_ == null) {
          if (endTimeCase_ == 5 &&
              endTime_ != com.google.protobuf.StringValue.getDefaultInstance()) {
            endTime_ = com.google.protobuf.StringValue.newBuilder((com.google.protobuf.StringValue) endTime_)
                .mergeFrom(value).buildPartial();
          } else {
            endTime_ = value;
          }
          onChanged();
        } else {
          if (endTimeCase_ == 5) {
            endDateTimeBuilder_.mergeFrom(value);
          }
          endDateTimeBuilder_.setMessage(value);
        }
        endTimeCase_ = 5;
        return this;
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearEndDateTime() {
        if (endDateTimeBuilder_ == null) {
          if (endTimeCase_ == 5) {
            endTimeCase_ = 0;
            endTime_ = null;
            onChanged();
          }
        } else {
          if (endTimeCase_ == 5) {
            endTimeCase_ = 0;
            endTime_ = null;
          }
          endDateTimeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.StringValue.Builder getEndDateTimeBuilder() {
        return getEndDateTimeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      @java.lang.Override
      public com.google.protobuf.StringValueOrBuilder getEndDateTimeOrBuilder() {
        if ((endTimeCase_ == 5) && (endDateTimeBuilder_ != null)) {
          return endDateTimeBuilder_.getMessageOrBuilder();
        } else {
          if (endTimeCase_ == 5) {
            return (com.google.protobuf.StringValue) endTime_;
          }
          return com.google.protobuf.StringValue.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Output only. The end time in yyyy-MM-dd HH:mm:ss format.
       * </pre>
       *
       * <code>.google.protobuf.StringValue end_date_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
          getEndDateTimeFieldBuilder() {
        if (endDateTimeBuilder_ == null) {
          if (!(endTimeCase_ == 5)) {
            endTime_ = com.google.protobuf.StringValue.getDefaultInstance();
          }
          endDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                  (com.google.protobuf.StringValue) endTime_,
                  getParentForChildren(),
                  isClean());
          endTime_ = null;
        }
        endTimeCase_ = 5;
        onChanged();;
        return endDateTimeBuilder_;
      }

      /**
       * <pre>
       * Output only. The end time as a well-defined type, e.g. FOREVER.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The enum numeric value on the wire for endTimeType.
       */
      @java.lang.Override
      public int getEndTimeTypeValue() {
        if (endTimeCase_ == 6) {
          return ((java.lang.Integer) endTime_).intValue();
        }
        return 0;
      }
      /**
       * <pre>
       * Output only. The end time as a well-defined type, e.g. FOREVER.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The enum numeric value on the wire for endTimeType to set.
       * @return This builder for chaining.
       */
      public Builder setEndTimeTypeValue(int value) {
        endTimeCase_ = 6;
        endTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The end time as a well-defined type, e.g. FOREVER.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The endTimeType.
       */
      @java.lang.Override
      public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getEndTimeType() {
        if (endTimeCase_ == 6) {
          @SuppressWarnings("deprecation")
          com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
              (java.lang.Integer) endTime_);
          return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
        }
        return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
      }
      /**
       * <pre>
       * Output only. The end time as a well-defined type, e.g. FOREVER.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The endTimeType to set.
       * @return This builder for chaining.
       */
      public Builder setEndTimeType(com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTimeCase_ = 6;
        endTime_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The end time as a well-defined type, e.g. FOREVER.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType end_time_type = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearEndTimeType() {
        if (endTimeCase_ == 6) {
          endTimeCase_ = 0;
          endTime_ = null;
          onChanged();
        }
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> spendingLimitMicrosBuilder_;
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return Whether the spendingLimitMicros field is set.
       */
      @java.lang.Override
      public boolean hasSpendingLimitMicros() {
        return spendingLimitCase_ == 7;
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The spendingLimitMicros.
       */
      @java.lang.Override
      public com.google.protobuf.Int64Value getSpendingLimitMicros() {
        if (spendingLimitMicrosBuilder_ == null) {
          if (spendingLimitCase_ == 7) {
            return (com.google.protobuf.Int64Value) spendingLimit_;
          }
          return com.google.protobuf.Int64Value.getDefaultInstance();
        } else {
          if (spendingLimitCase_ == 7) {
            return spendingLimitMicrosBuilder_.getMessage();
          }
          return com.google.protobuf.Int64Value.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setSpendingLimitMicros(com.google.protobuf.Int64Value value) {
        if (spendingLimitMicrosBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spendingLimit_ = value;
          onChanged();
        } else {
          spendingLimitMicrosBuilder_.setMessage(value);
        }
        spendingLimitCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder setSpendingLimitMicros(
          com.google.protobuf.Int64Value.Builder builderForValue) {
        if (spendingLimitMicrosBuilder_ == null) {
          spendingLimit_ = builderForValue.build();
          onChanged();
        } else {
          spendingLimitMicrosBuilder_.setMessage(builderForValue.build());
        }
        spendingLimitCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder mergeSpendingLimitMicros(com.google.protobuf.Int64Value value) {
        if (spendingLimitMicrosBuilder_ == null) {
          if (spendingLimitCase_ == 7 &&
              spendingLimit_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
            spendingLimit_ = com.google.protobuf.Int64Value.newBuilder((com.google.protobuf.Int64Value) spendingLimit_)
                .mergeFrom(value).buildPartial();
          } else {
            spendingLimit_ = value;
          }
          onChanged();
        } else {
          if (spendingLimitCase_ == 7) {
            spendingLimitMicrosBuilder_.mergeFrom(value);
          }
          spendingLimitMicrosBuilder_.setMessage(value);
        }
        spendingLimitCase_ = 7;
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public Builder clearSpendingLimitMicros() {
        if (spendingLimitMicrosBuilder_ == null) {
          if (spendingLimitCase_ == 7) {
            spendingLimitCase_ = 0;
            spendingLimit_ = null;
            onChanged();
          }
        } else {
          if (spendingLimitCase_ == 7) {
            spendingLimitCase_ = 0;
            spendingLimit_ = null;
          }
          spendingLimitMicrosBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      public com.google.protobuf.Int64Value.Builder getSpendingLimitMicrosBuilder() {
        return getSpendingLimitMicrosFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      @java.lang.Override
      public com.google.protobuf.Int64ValueOrBuilder getSpendingLimitMicrosOrBuilder() {
        if ((spendingLimitCase_ == 7) && (spendingLimitMicrosBuilder_ != null)) {
          return spendingLimitMicrosBuilder_.getMessageOrBuilder();
        } else {
          if (spendingLimitCase_ == 7) {
            return (com.google.protobuf.Int64Value) spendingLimit_;
          }
          return com.google.protobuf.Int64Value.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Output only. The spending limit in micros.  One million is equivalent to
       * one unit.
       * </pre>
       *
       * <code>.google.protobuf.Int64Value spending_limit_micros = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
          getSpendingLimitMicrosFieldBuilder() {
        if (spendingLimitMicrosBuilder_ == null) {
          if (!(spendingLimitCase_ == 7)) {
            spendingLimit_ = com.google.protobuf.Int64Value.getDefaultInstance();
          }
          spendingLimitMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                  (com.google.protobuf.Int64Value) spendingLimit_,
                  getParentForChildren(),
                  isClean());
          spendingLimit_ = null;
        }
        spendingLimitCase_ = 7;
        onChanged();;
        return spendingLimitMicrosBuilder_;
      }

      /**
       * <pre>
       * Output only. The spending limit as a well-defined type, e.g. INFINITE.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The enum numeric value on the wire for spendingLimitType.
       */
      @java.lang.Override
      public int getSpendingLimitTypeValue() {
        if (spendingLimitCase_ == 8) {
          return ((java.lang.Integer) spendingLimit_).intValue();
        }
        return 0;
      }
      /**
       * <pre>
       * Output only. The spending limit as a well-defined type, e.g. INFINITE.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The enum numeric value on the wire for spendingLimitType to set.
       * @return This builder for chaining.
       */
      public Builder setSpendingLimitTypeValue(int value) {
        spendingLimitCase_ = 8;
        spendingLimit_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit as a well-defined type, e.g. INFINITE.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return The spendingLimitType.
       */
      @java.lang.Override
      public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getSpendingLimitType() {
        if (spendingLimitCase_ == 8) {
          @SuppressWarnings("deprecation")
          com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
              (java.lang.Integer) spendingLimit_);
          return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
        }
        return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
      }
      /**
       * <pre>
       * Output only. The spending limit as a well-defined type, e.g. INFINITE.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @param value The spendingLimitType to set.
       * @return This builder for chaining.
       */
      public Builder setSpendingLimitType(com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        spendingLimitCase_ = 8;
        spendingLimit_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Output only. The spending limit as a well-defined type, e.g. INFINITE.
       * </pre>
       *
       * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType spending_limit_type = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       * @return This builder for chaining.
       */
      public Builder clearSpendingLimitType() {
        if (spendingLimitCase_ == 8) {
          spendingLimitCase_ = 0;
          spendingLimit_ = null;
          onChanged();
        }
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)
    }

    // @@protoc_insertion_point(class_scope:google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal)
    private static final com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal();
    }

    public static com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PendingAccountBudgetProposal>
        PARSER = new com.google.protobuf.AbstractParser<PendingAccountBudgetProposal>() {
      @java.lang.Override
      public PendingAccountBudgetProposal parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PendingAccountBudgetProposal(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<PendingAccountBudgetProposal> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PendingAccountBudgetProposal> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private int proposedEndTimeCase_ = 0;
  private java.lang.Object proposedEndTime_;
  public enum ProposedEndTimeCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROPOSED_END_DATE_TIME(8),
    PROPOSED_END_TIME_TYPE(9),
    PROPOSEDENDTIME_NOT_SET(0);
    private final int value;
    private ProposedEndTimeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProposedEndTimeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProposedEndTimeCase forNumber(int value) {
      switch (value) {
        case 8: return PROPOSED_END_DATE_TIME;
        case 9: return PROPOSED_END_TIME_TYPE;
        case 0: return PROPOSEDENDTIME_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ProposedEndTimeCase
  getProposedEndTimeCase() {
    return ProposedEndTimeCase.forNumber(
        proposedEndTimeCase_);
  }

  private int approvedEndTimeCase_ = 0;
  private java.lang.Object approvedEndTime_;
  public enum ApprovedEndTimeCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APPROVED_END_DATE_TIME(10),
    APPROVED_END_TIME_TYPE(11),
    APPROVEDENDTIME_NOT_SET(0);
    private final int value;
    private ApprovedEndTimeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApprovedEndTimeCase valueOf(int value) {
      return forNumber(value);
    }

    public static ApprovedEndTimeCase forNumber(int value) {
      switch (value) {
        case 10: return APPROVED_END_DATE_TIME;
        case 11: return APPROVED_END_TIME_TYPE;
        case 0: return APPROVEDENDTIME_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ApprovedEndTimeCase
  getApprovedEndTimeCase() {
    return ApprovedEndTimeCase.forNumber(
        approvedEndTimeCase_);
  }

  private int proposedSpendingLimitCase_ = 0;
  private java.lang.Object proposedSpendingLimit_;
  public enum ProposedSpendingLimitCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    PROPOSED_SPENDING_LIMIT_MICROS(12),
    PROPOSED_SPENDING_LIMIT_TYPE(13),
    PROPOSEDSPENDINGLIMIT_NOT_SET(0);
    private final int value;
    private ProposedSpendingLimitCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProposedSpendingLimitCase valueOf(int value) {
      return forNumber(value);
    }

    public static ProposedSpendingLimitCase forNumber(int value) {
      switch (value) {
        case 12: return PROPOSED_SPENDING_LIMIT_MICROS;
        case 13: return PROPOSED_SPENDING_LIMIT_TYPE;
        case 0: return PROPOSEDSPENDINGLIMIT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ProposedSpendingLimitCase
  getProposedSpendingLimitCase() {
    return ProposedSpendingLimitCase.forNumber(
        proposedSpendingLimitCase_);
  }

  private int approvedSpendingLimitCase_ = 0;
  private java.lang.Object approvedSpendingLimit_;
  public enum ApprovedSpendingLimitCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APPROVED_SPENDING_LIMIT_MICROS(14),
    APPROVED_SPENDING_LIMIT_TYPE(15),
    APPROVEDSPENDINGLIMIT_NOT_SET(0);
    private final int value;
    private ApprovedSpendingLimitCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApprovedSpendingLimitCase valueOf(int value) {
      return forNumber(value);
    }

    public static ApprovedSpendingLimitCase forNumber(int value) {
      switch (value) {
        case 14: return APPROVED_SPENDING_LIMIT_MICROS;
        case 15: return APPROVED_SPENDING_LIMIT_TYPE;
        case 0: return APPROVEDSPENDINGLIMIT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public ApprovedSpendingLimitCase
  getApprovedSpendingLimitCase() {
    return ApprovedSpendingLimitCase.forNumber(
        approvedSpendingLimitCase_);
  }

  private int adjustedSpendingLimitCase_ = 0;
  private java.lang.Object adjustedSpendingLimit_;
  public enum AdjustedSpendingLimitCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ADJUSTED_SPENDING_LIMIT_MICROS(16),
    ADJUSTED_SPENDING_LIMIT_TYPE(17),
    ADJUSTEDSPENDINGLIMIT_NOT_SET(0);
    private final int value;
    private AdjustedSpendingLimitCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AdjustedSpendingLimitCase valueOf(int value) {
      return forNumber(value);
    }

    public static AdjustedSpendingLimitCase forNumber(int value) {
      switch (value) {
        case 16: return ADJUSTED_SPENDING_LIMIT_MICROS;
        case 17: return ADJUSTED_SPENDING_LIMIT_TYPE;
        case 0: return ADJUSTEDSPENDINGLIMIT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public AdjustedSpendingLimitCase
  getAdjustedSpendingLimitCase() {
    return AdjustedSpendingLimitCase.forNumber(
        adjustedSpendingLimitCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object resourceName_;
  /**
   * <pre>
   * Output only. The resource name of the account-level budget.
   * AccountBudget resource names have the form:
   * `customers/{customer_id}/accountBudgets/{account_budget_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the account-level budget.
   * AccountBudget resource names have the form:
   * `customers/{customer_id}/accountBudgets/{account_budget_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 2;
  private com.google.protobuf.Int64Value id_;
  /**
   * <pre>
   * Output only. The ID of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return id_ != null;
  }
  /**
   * <pre>
   * Output only. The ID of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getId() {
    return id_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : id_;
  }
  /**
   * <pre>
   * Output only. The ID of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getIdOrBuilder() {
    return getId();
  }

  public static final int BILLING_SETUP_FIELD_NUMBER = 3;
  private com.google.protobuf.StringValue billingSetup_;
  /**
   * <pre>
   * Output only. The resource name of the billing setup associated with this account-level
   * budget.  BillingSetup resource names have the form:
   * `customers/{customer_id}/billingSetups/{billing_setup_id}`
   * </pre>
   *
   * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the billingSetup field is set.
   */
  @java.lang.Override
  public boolean hasBillingSetup() {
    return billingSetup_ != null;
  }
  /**
   * <pre>
   * Output only. The resource name of the billing setup associated with this account-level
   * budget.  BillingSetup resource names have the form:
   * `customers/{customer_id}/billingSetups/{billing_setup_id}`
   * </pre>
   *
   * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The billingSetup.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getBillingSetup() {
    return billingSetup_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : billingSetup_;
  }
  /**
   * <pre>
   * Output only. The resource name of the billing setup associated with this account-level
   * budget.  BillingSetup resource names have the form:
   * `customers/{customer_id}/billingSetups/{billing_setup_id}`
   * </pre>
   *
   * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getBillingSetupOrBuilder() {
    return getBillingSetup();
  }

  public static final int STATUS_FIELD_NUMBER = 4;
  private int status_;
  /**
   * <pre>
   * Output only. The status of this account-level budget.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. The status of this account-level budget.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus getStatus() {
    @SuppressWarnings("deprecation")
    com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus result = com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.valueOf(status_);
    return result == null ? com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.UNRECOGNIZED : result;
  }

  public static final int NAME_FIELD_NUMBER = 5;
  private com.google.protobuf.StringValue name_;
  /**
   * <pre>
   * Output only. The name of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return name_ != null;
  }
  /**
   * <pre>
   * Output only. The name of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The name.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getName() {
    return name_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : name_;
  }
  /**
   * <pre>
   * Output only. The name of the account-level budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getNameOrBuilder() {
    return getName();
  }

  public static final int PROPOSED_START_DATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.StringValue proposedStartDateTime_;
  /**
   * <pre>
   * Output only. The proposed start time of the account-level budget in
   * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
   * this is the time of request.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the proposedStartDateTime field is set.
   */
  @java.lang.Override
  public boolean hasProposedStartDateTime() {
    return proposedStartDateTime_ != null;
  }
  /**
   * <pre>
   * Output only. The proposed start time of the account-level budget in
   * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
   * this is the time of request.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The proposedStartDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getProposedStartDateTime() {
    return proposedStartDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : proposedStartDateTime_;
  }
  /**
   * <pre>
   * Output only. The proposed start time of the account-level budget in
   * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
   * this is the time of request.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getProposedStartDateTimeOrBuilder() {
    return getProposedStartDateTime();
  }

  public static final int APPROVED_START_DATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.StringValue approvedStartDateTime_;
  /**
   * <pre>
   * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
   * format.
   * For example, if a new budget is approved after the proposed start time,
   * the approved start time is the time of approval.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the approvedStartDateTime field is set.
   */
  @java.lang.Override
  public boolean hasApprovedStartDateTime() {
    return approvedStartDateTime_ != null;
  }
  /**
   * <pre>
   * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
   * format.
   * For example, if a new budget is approved after the proposed start time,
   * the approved start time is the time of approval.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvedStartDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getApprovedStartDateTime() {
    return approvedStartDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : approvedStartDateTime_;
  }
  /**
   * <pre>
   * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
   * format.
   * For example, if a new budget is approved after the proposed start time,
   * the approved start time is the time of approval.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getApprovedStartDateTimeOrBuilder() {
    return getApprovedStartDateTime();
  }

  public static final int TOTAL_ADJUSTMENTS_MICROS_FIELD_NUMBER = 18;
  private com.google.protobuf.Int64Value totalAdjustmentsMicros_;
  /**
   * <pre>
   * Output only. The total adjustments amount.
   * An example of an adjustment is courtesy credits.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the totalAdjustmentsMicros field is set.
   */
  @java.lang.Override
  public boolean hasTotalAdjustmentsMicros() {
    return totalAdjustmentsMicros_ != null;
  }
  /**
   * <pre>
   * Output only. The total adjustments amount.
   * An example of an adjustment is courtesy credits.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The totalAdjustmentsMicros.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getTotalAdjustmentsMicros() {
    return totalAdjustmentsMicros_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : totalAdjustmentsMicros_;
  }
  /**
   * <pre>
   * Output only. The total adjustments amount.
   * An example of an adjustment is courtesy credits.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getTotalAdjustmentsMicrosOrBuilder() {
    return getTotalAdjustmentsMicros();
  }

  public static final int AMOUNT_SERVED_MICROS_FIELD_NUMBER = 19;
  private com.google.protobuf.Int64Value amountServedMicros_;
  /**
   * <pre>
   * Output only. The value of Ads that have been served, in micros.
   * This includes overdelivery costs, in which case a credit might be
   * automatically applied to the budget (see total_adjustments_micros).
   * </pre>
   *
   * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the amountServedMicros field is set.
   */
  @java.lang.Override
  public boolean hasAmountServedMicros() {
    return amountServedMicros_ != null;
  }
  /**
   * <pre>
   * Output only. The value of Ads that have been served, in micros.
   * This includes overdelivery costs, in which case a credit might be
   * automatically applied to the budget (see total_adjustments_micros).
   * </pre>
   *
   * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The amountServedMicros.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getAmountServedMicros() {
    return amountServedMicros_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : amountServedMicros_;
  }
  /**
   * <pre>
   * Output only. The value of Ads that have been served, in micros.
   * This includes overdelivery costs, in which case a credit might be
   * automatically applied to the budget (see total_adjustments_micros).
   * </pre>
   *
   * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getAmountServedMicrosOrBuilder() {
    return getAmountServedMicros();
  }

  public static final int PURCHASE_ORDER_NUMBER_FIELD_NUMBER = 20;
  private com.google.protobuf.StringValue purchaseOrderNumber_;
  /**
   * <pre>
   * Output only. A purchase order number is a value that helps users reference this budget
   * in their monthly invoices.
   * </pre>
   *
   * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the purchaseOrderNumber field is set.
   */
  @java.lang.Override
  public boolean hasPurchaseOrderNumber() {
    return purchaseOrderNumber_ != null;
  }
  /**
   * <pre>
   * Output only. A purchase order number is a value that helps users reference this budget
   * in their monthly invoices.
   * </pre>
   *
   * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The purchaseOrderNumber.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getPurchaseOrderNumber() {
    return purchaseOrderNumber_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
  }
  /**
   * <pre>
   * Output only. A purchase order number is a value that helps users reference this budget
   * in their monthly invoices.
   * </pre>
   *
   * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getPurchaseOrderNumberOrBuilder() {
    return getPurchaseOrderNumber();
  }

  public static final int NOTES_FIELD_NUMBER = 21;
  private com.google.protobuf.StringValue notes_;
  /**
   * <pre>
   * Output only. Notes associated with the budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the notes field is set.
   */
  @java.lang.Override
  public boolean hasNotes() {
    return notes_ != null;
  }
  /**
   * <pre>
   * Output only. Notes associated with the budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The notes.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getNotes() {
    return notes_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : notes_;
  }
  /**
   * <pre>
   * Output only. Notes associated with the budget.
   * </pre>
   *
   * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getNotesOrBuilder() {
    return getNotes();
  }

  public static final int PENDING_PROPOSAL_FIELD_NUMBER = 22;
  private com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pendingProposal_;
  /**
   * <pre>
   * Output only. The pending proposal to modify this budget, if applicable.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the pendingProposal field is set.
   */
  @java.lang.Override
  public boolean hasPendingProposal() {
    return pendingProposal_ != null;
  }
  /**
   * <pre>
   * Output only. The pending proposal to modify this budget, if applicable.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The pendingProposal.
   */
  @java.lang.Override
  public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal getPendingProposal() {
    return pendingProposal_ == null ? com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.getDefaultInstance() : pendingProposal_;
  }
  /**
   * <pre>
   * Output only. The pending proposal to modify this budget, if applicable.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder getPendingProposalOrBuilder() {
    return getPendingProposal();
  }

  public static final int PROPOSED_END_DATE_TIME_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the proposedEndDateTime field is set.
   */
  @java.lang.Override
  public boolean hasProposedEndDateTime() {
    return proposedEndTimeCase_ == 8;
  }
  /**
   * <pre>
   * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The proposedEndDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getProposedEndDateTime() {
    if (proposedEndTimeCase_ == 8) {
       return (com.google.protobuf.StringValue) proposedEndTime_;
    }
    return com.google.protobuf.StringValue.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getProposedEndDateTimeOrBuilder() {
    if (proposedEndTimeCase_ == 8) {
       return (com.google.protobuf.StringValue) proposedEndTime_;
    }
    return com.google.protobuf.StringValue.getDefaultInstance();
  }

  public static final int PROPOSED_END_TIME_TYPE_FIELD_NUMBER = 9;
  /**
   * <pre>
   * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for proposedEndTimeType.
   */
  public int getProposedEndTimeTypeValue() {
    if (proposedEndTimeCase_ == 9) {
      return (java.lang.Integer) proposedEndTime_;
    }
    return 0;
  }
  /**
   * <pre>
   * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The proposedEndTimeType.
   */
  public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getProposedEndTimeType() {
    if (proposedEndTimeCase_ == 9) {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
          (java.lang.Integer) proposedEndTime_);
      return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
    }
    return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
  }

  public static final int APPROVED_END_DATE_TIME_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the approvedEndDateTime field is set.
   */
  @java.lang.Override
  public boolean hasApprovedEndDateTime() {
    return approvedEndTimeCase_ == 10;
  }
  /**
   * <pre>
   * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvedEndDateTime.
   */
  @java.lang.Override
  public com.google.protobuf.StringValue getApprovedEndDateTime() {
    if (approvedEndTimeCase_ == 10) {
       return (com.google.protobuf.StringValue) approvedEndTime_;
    }
    return com.google.protobuf.StringValue.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
   * </pre>
   *
   * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.StringValueOrBuilder getApprovedEndDateTimeOrBuilder() {
    if (approvedEndTimeCase_ == 10) {
       return (com.google.protobuf.StringValue) approvedEndTime_;
    }
    return com.google.protobuf.StringValue.getDefaultInstance();
  }

  public static final int APPROVED_END_TIME_TYPE_FIELD_NUMBER = 11;
  /**
   * <pre>
   * Output only. The approved end time as a well-defined type, e.g. FOREVER.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for approvedEndTimeType.
   */
  public int getApprovedEndTimeTypeValue() {
    if (approvedEndTimeCase_ == 11) {
      return (java.lang.Integer) approvedEndTime_;
    }
    return 0;
  }
  /**
   * <pre>
   * Output only. The approved end time as a well-defined type, e.g. FOREVER.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvedEndTimeType.
   */
  public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getApprovedEndTimeType() {
    if (approvedEndTimeCase_ == 11) {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
          (java.lang.Integer) approvedEndTime_);
      return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
    }
    return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
  }

  public static final int PROPOSED_SPENDING_LIMIT_MICROS_FIELD_NUMBER = 12;
  /**
   * <pre>
   * Output only. The proposed spending limit in micros.  One million is equivalent to
   * one unit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the proposedSpendingLimitMicros field is set.
   */
  @java.lang.Override
  public boolean hasProposedSpendingLimitMicros() {
    return proposedSpendingLimitCase_ == 12;
  }
  /**
   * <pre>
   * Output only. The proposed spending limit in micros.  One million is equivalent to
   * one unit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The proposedSpendingLimitMicros.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getProposedSpendingLimitMicros() {
    if (proposedSpendingLimitCase_ == 12) {
       return (com.google.protobuf.Int64Value) proposedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. The proposed spending limit in micros.  One million is equivalent to
   * one unit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getProposedSpendingLimitMicrosOrBuilder() {
    if (proposedSpendingLimitCase_ == 12) {
       return (com.google.protobuf.Int64Value) proposedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }

  public static final int PROPOSED_SPENDING_LIMIT_TYPE_FIELD_NUMBER = 13;
  /**
   * <pre>
   * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for proposedSpendingLimitType.
   */
  public int getProposedSpendingLimitTypeValue() {
    if (proposedSpendingLimitCase_ == 13) {
      return (java.lang.Integer) proposedSpendingLimit_;
    }
    return 0;
  }
  /**
   * <pre>
   * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The proposedSpendingLimitType.
   */
  public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getProposedSpendingLimitType() {
    if (proposedSpendingLimitCase_ == 13) {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
          (java.lang.Integer) proposedSpendingLimit_);
      return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
    }
    return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
  }

  public static final int APPROVED_SPENDING_LIMIT_MICROS_FIELD_NUMBER = 14;
  /**
   * <pre>
   * Output only. The approved spending limit in micros.  One million is equivalent to
   * one unit.  This will only be populated if the proposed spending limit
   * is finite, and will always be greater than or equal to the
   * proposed spending limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the approvedSpendingLimitMicros field is set.
   */
  @java.lang.Override
  public boolean hasApprovedSpendingLimitMicros() {
    return approvedSpendingLimitCase_ == 14;
  }
  /**
   * <pre>
   * Output only. The approved spending limit in micros.  One million is equivalent to
   * one unit.  This will only be populated if the proposed spending limit
   * is finite, and will always be greater than or equal to the
   * proposed spending limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvedSpendingLimitMicros.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getApprovedSpendingLimitMicros() {
    if (approvedSpendingLimitCase_ == 14) {
       return (com.google.protobuf.Int64Value) approvedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. The approved spending limit in micros.  One million is equivalent to
   * one unit.  This will only be populated if the proposed spending limit
   * is finite, and will always be greater than or equal to the
   * proposed spending limit.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getApprovedSpendingLimitMicrosOrBuilder() {
    if (approvedSpendingLimitCase_ == 14) {
       return (com.google.protobuf.Int64Value) approvedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }

  public static final int APPROVED_SPENDING_LIMIT_TYPE_FIELD_NUMBER = 15;
  /**
   * <pre>
   * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
   * will only be populated if the approved spending limit is INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for approvedSpendingLimitType.
   */
  public int getApprovedSpendingLimitTypeValue() {
    if (approvedSpendingLimitCase_ == 15) {
      return (java.lang.Integer) approvedSpendingLimit_;
    }
    return 0;
  }
  /**
   * <pre>
   * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
   * will only be populated if the approved spending limit is INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The approvedSpendingLimitType.
   */
  public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getApprovedSpendingLimitType() {
    if (approvedSpendingLimitCase_ == 15) {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
          (java.lang.Integer) approvedSpendingLimit_);
      return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
    }
    return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
  }

  public static final int ADJUSTED_SPENDING_LIMIT_MICROS_FIELD_NUMBER = 16;
  /**
   * <pre>
   * Output only. The adjusted spending limit in micros.  One million is equivalent to
   * one unit.
   * If the approved spending limit is finite, the adjusted
   * spending limit may vary depending on the types of adjustments applied
   * to this budget, if applicable.
   * The different kinds of adjustments are described here:
   * https://support.google.com/google-ads/answer/1704323
   * For example, a debit adjustment reduces how much the account is
   * allowed to spend.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the adjustedSpendingLimitMicros field is set.
   */
  @java.lang.Override
  public boolean hasAdjustedSpendingLimitMicros() {
    return adjustedSpendingLimitCase_ == 16;
  }
  /**
   * <pre>
   * Output only. The adjusted spending limit in micros.  One million is equivalent to
   * one unit.
   * If the approved spending limit is finite, the adjusted
   * spending limit may vary depending on the types of adjustments applied
   * to this budget, if applicable.
   * The different kinds of adjustments are described here:
   * https://support.google.com/google-ads/answer/1704323
   * For example, a debit adjustment reduces how much the account is
   * allowed to spend.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adjustedSpendingLimitMicros.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getAdjustedSpendingLimitMicros() {
    if (adjustedSpendingLimitCase_ == 16) {
       return (com.google.protobuf.Int64Value) adjustedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. The adjusted spending limit in micros.  One million is equivalent to
   * one unit.
   * If the approved spending limit is finite, the adjusted
   * spending limit may vary depending on the types of adjustments applied
   * to this budget, if applicable.
   * The different kinds of adjustments are described here:
   * https://support.google.com/google-ads/answer/1704323
   * For example, a debit adjustment reduces how much the account is
   * allowed to spend.
   * </pre>
   *
   * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getAdjustedSpendingLimitMicrosOrBuilder() {
    if (adjustedSpendingLimitCase_ == 16) {
       return (com.google.protobuf.Int64Value) adjustedSpendingLimit_;
    }
    return com.google.protobuf.Int64Value.getDefaultInstance();
  }

  public static final int ADJUSTED_SPENDING_LIMIT_TYPE_FIELD_NUMBER = 17;
  /**
   * <pre>
   * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
   * This will only be populated if the adjusted spending limit is INFINITE,
   * which is guaranteed to be true if the approved spending limit is
   * INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for adjustedSpendingLimitType.
   */
  public int getAdjustedSpendingLimitTypeValue() {
    if (adjustedSpendingLimitCase_ == 17) {
      return (java.lang.Integer) adjustedSpendingLimit_;
    }
    return 0;
  }
  /**
   * <pre>
   * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
   * This will only be populated if the adjusted spending limit is INFINITE,
   * which is guaranteed to be true if the approved spending limit is
   * INFINITE.
   * </pre>
   *
   * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adjustedSpendingLimitType.
   */
  public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getAdjustedSpendingLimitType() {
    if (adjustedSpendingLimitCase_ == 17) {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
          (java.lang.Integer) adjustedSpendingLimit_);
      return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
    }
    return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getResourceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (id_ != null) {
      output.writeMessage(2, getId());
    }
    if (billingSetup_ != null) {
      output.writeMessage(3, getBillingSetup());
    }
    if (status_ != com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, status_);
    }
    if (name_ != null) {
      output.writeMessage(5, getName());
    }
    if (proposedStartDateTime_ != null) {
      output.writeMessage(6, getProposedStartDateTime());
    }
    if (approvedStartDateTime_ != null) {
      output.writeMessage(7, getApprovedStartDateTime());
    }
    if (proposedEndTimeCase_ == 8) {
      output.writeMessage(8, (com.google.protobuf.StringValue) proposedEndTime_);
    }
    if (proposedEndTimeCase_ == 9) {
      output.writeEnum(9, ((java.lang.Integer) proposedEndTime_));
    }
    if (approvedEndTimeCase_ == 10) {
      output.writeMessage(10, (com.google.protobuf.StringValue) approvedEndTime_);
    }
    if (approvedEndTimeCase_ == 11) {
      output.writeEnum(11, ((java.lang.Integer) approvedEndTime_));
    }
    if (proposedSpendingLimitCase_ == 12) {
      output.writeMessage(12, (com.google.protobuf.Int64Value) proposedSpendingLimit_);
    }
    if (proposedSpendingLimitCase_ == 13) {
      output.writeEnum(13, ((java.lang.Integer) proposedSpendingLimit_));
    }
    if (approvedSpendingLimitCase_ == 14) {
      output.writeMessage(14, (com.google.protobuf.Int64Value) approvedSpendingLimit_);
    }
    if (approvedSpendingLimitCase_ == 15) {
      output.writeEnum(15, ((java.lang.Integer) approvedSpendingLimit_));
    }
    if (adjustedSpendingLimitCase_ == 16) {
      output.writeMessage(16, (com.google.protobuf.Int64Value) adjustedSpendingLimit_);
    }
    if (adjustedSpendingLimitCase_ == 17) {
      output.writeEnum(17, ((java.lang.Integer) adjustedSpendingLimit_));
    }
    if (totalAdjustmentsMicros_ != null) {
      output.writeMessage(18, getTotalAdjustmentsMicros());
    }
    if (amountServedMicros_ != null) {
      output.writeMessage(19, getAmountServedMicros());
    }
    if (purchaseOrderNumber_ != null) {
      output.writeMessage(20, getPurchaseOrderNumber());
    }
    if (notes_ != null) {
      output.writeMessage(21, getNotes());
    }
    if (pendingProposal_ != null) {
      output.writeMessage(22, getPendingProposal());
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getResourceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (id_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getId());
    }
    if (billingSetup_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getBillingSetup());
    }
    if (status_ != com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, status_);
    }
    if (name_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getName());
    }
    if (proposedStartDateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getProposedStartDateTime());
    }
    if (approvedStartDateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getApprovedStartDateTime());
    }
    if (proposedEndTimeCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.protobuf.StringValue) proposedEndTime_);
    }
    if (proposedEndTimeCase_ == 9) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(9, ((java.lang.Integer) proposedEndTime_));
    }
    if (approvedEndTimeCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (com.google.protobuf.StringValue) approvedEndTime_);
    }
    if (approvedEndTimeCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(11, ((java.lang.Integer) approvedEndTime_));
    }
    if (proposedSpendingLimitCase_ == 12) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, (com.google.protobuf.Int64Value) proposedSpendingLimit_);
    }
    if (proposedSpendingLimitCase_ == 13) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(13, ((java.lang.Integer) proposedSpendingLimit_));
    }
    if (approvedSpendingLimitCase_ == 14) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(14, (com.google.protobuf.Int64Value) approvedSpendingLimit_);
    }
    if (approvedSpendingLimitCase_ == 15) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(15, ((java.lang.Integer) approvedSpendingLimit_));
    }
    if (adjustedSpendingLimitCase_ == 16) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(16, (com.google.protobuf.Int64Value) adjustedSpendingLimit_);
    }
    if (adjustedSpendingLimitCase_ == 17) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(17, ((java.lang.Integer) adjustedSpendingLimit_));
    }
    if (totalAdjustmentsMicros_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(18, getTotalAdjustmentsMicros());
    }
    if (amountServedMicros_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(19, getAmountServedMicros());
    }
    if (purchaseOrderNumber_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(20, getPurchaseOrderNumber());
    }
    if (notes_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(21, getNotes());
    }
    if (pendingProposal_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(22, getPendingProposal());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v4.resources.AccountBudget)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v4.resources.AccountBudget other = (com.google.ads.googleads.v4.resources.AccountBudget) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (!getId()
          .equals(other.getId())) return false;
    }
    if (hasBillingSetup() != other.hasBillingSetup()) return false;
    if (hasBillingSetup()) {
      if (!getBillingSetup()
          .equals(other.getBillingSetup())) return false;
    }
    if (status_ != other.status_) return false;
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName()
          .equals(other.getName())) return false;
    }
    if (hasProposedStartDateTime() != other.hasProposedStartDateTime()) return false;
    if (hasProposedStartDateTime()) {
      if (!getProposedStartDateTime()
          .equals(other.getProposedStartDateTime())) return false;
    }
    if (hasApprovedStartDateTime() != other.hasApprovedStartDateTime()) return false;
    if (hasApprovedStartDateTime()) {
      if (!getApprovedStartDateTime()
          .equals(other.getApprovedStartDateTime())) return false;
    }
    if (hasTotalAdjustmentsMicros() != other.hasTotalAdjustmentsMicros()) return false;
    if (hasTotalAdjustmentsMicros()) {
      if (!getTotalAdjustmentsMicros()
          .equals(other.getTotalAdjustmentsMicros())) return false;
    }
    if (hasAmountServedMicros() != other.hasAmountServedMicros()) return false;
    if (hasAmountServedMicros()) {
      if (!getAmountServedMicros()
          .equals(other.getAmountServedMicros())) return false;
    }
    if (hasPurchaseOrderNumber() != other.hasPurchaseOrderNumber()) return false;
    if (hasPurchaseOrderNumber()) {
      if (!getPurchaseOrderNumber()
          .equals(other.getPurchaseOrderNumber())) return false;
    }
    if (hasNotes() != other.hasNotes()) return false;
    if (hasNotes()) {
      if (!getNotes()
          .equals(other.getNotes())) return false;
    }
    if (hasPendingProposal() != other.hasPendingProposal()) return false;
    if (hasPendingProposal()) {
      if (!getPendingProposal()
          .equals(other.getPendingProposal())) return false;
    }
    if (!getProposedEndTimeCase().equals(other.getProposedEndTimeCase())) return false;
    switch (proposedEndTimeCase_) {
      case 8:
        if (!getProposedEndDateTime()
            .equals(other.getProposedEndDateTime())) return false;
        break;
      case 9:
        if (getProposedEndTimeTypeValue()
            != other.getProposedEndTimeTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getApprovedEndTimeCase().equals(other.getApprovedEndTimeCase())) return false;
    switch (approvedEndTimeCase_) {
      case 10:
        if (!getApprovedEndDateTime()
            .equals(other.getApprovedEndDateTime())) return false;
        break;
      case 11:
        if (getApprovedEndTimeTypeValue()
            != other.getApprovedEndTimeTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getProposedSpendingLimitCase().equals(other.getProposedSpendingLimitCase())) return false;
    switch (proposedSpendingLimitCase_) {
      case 12:
        if (!getProposedSpendingLimitMicros()
            .equals(other.getProposedSpendingLimitMicros())) return false;
        break;
      case 13:
        if (getProposedSpendingLimitTypeValue()
            != other.getProposedSpendingLimitTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getApprovedSpendingLimitCase().equals(other.getApprovedSpendingLimitCase())) return false;
    switch (approvedSpendingLimitCase_) {
      case 14:
        if (!getApprovedSpendingLimitMicros()
            .equals(other.getApprovedSpendingLimitMicros())) return false;
        break;
      case 15:
        if (getApprovedSpendingLimitTypeValue()
            != other.getApprovedSpendingLimitTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!getAdjustedSpendingLimitCase().equals(other.getAdjustedSpendingLimitCase())) return false;
    switch (adjustedSpendingLimitCase_) {
      case 16:
        if (!getAdjustedSpendingLimitMicros()
            .equals(other.getAdjustedSpendingLimitMicros())) return false;
        break;
      case 17:
        if (getAdjustedSpendingLimitTypeValue()
            != other.getAdjustedSpendingLimitTypeValue()) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
    }
    if (hasBillingSetup()) {
      hash = (37 * hash) + BILLING_SETUP_FIELD_NUMBER;
      hash = (53 * hash) + getBillingSetup().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasProposedStartDateTime()) {
      hash = (37 * hash) + PROPOSED_START_DATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getProposedStartDateTime().hashCode();
    }
    if (hasApprovedStartDateTime()) {
      hash = (37 * hash) + APPROVED_START_DATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getApprovedStartDateTime().hashCode();
    }
    if (hasTotalAdjustmentsMicros()) {
      hash = (37 * hash) + TOTAL_ADJUSTMENTS_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + getTotalAdjustmentsMicros().hashCode();
    }
    if (hasAmountServedMicros()) {
      hash = (37 * hash) + AMOUNT_SERVED_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + getAmountServedMicros().hashCode();
    }
    if (hasPurchaseOrderNumber()) {
      hash = (37 * hash) + PURCHASE_ORDER_NUMBER_FIELD_NUMBER;
      hash = (53 * hash) + getPurchaseOrderNumber().hashCode();
    }
    if (hasNotes()) {
      hash = (37 * hash) + NOTES_FIELD_NUMBER;
      hash = (53 * hash) + getNotes().hashCode();
    }
    if (hasPendingProposal()) {
      hash = (37 * hash) + PENDING_PROPOSAL_FIELD_NUMBER;
      hash = (53 * hash) + getPendingProposal().hashCode();
    }
    switch (proposedEndTimeCase_) {
      case 8:
        hash = (37 * hash) + PROPOSED_END_DATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getProposedEndDateTime().hashCode();
        break;
      case 9:
        hash = (37 * hash) + PROPOSED_END_TIME_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getProposedEndTimeTypeValue();
        break;
      case 0:
      default:
    }
    switch (approvedEndTimeCase_) {
      case 10:
        hash = (37 * hash) + APPROVED_END_DATE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getApprovedEndDateTime().hashCode();
        break;
      case 11:
        hash = (37 * hash) + APPROVED_END_TIME_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getApprovedEndTimeTypeValue();
        break;
      case 0:
      default:
    }
    switch (proposedSpendingLimitCase_) {
      case 12:
        hash = (37 * hash) + PROPOSED_SPENDING_LIMIT_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + getProposedSpendingLimitMicros().hashCode();
        break;
      case 13:
        hash = (37 * hash) + PROPOSED_SPENDING_LIMIT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getProposedSpendingLimitTypeValue();
        break;
      case 0:
      default:
    }
    switch (approvedSpendingLimitCase_) {
      case 14:
        hash = (37 * hash) + APPROVED_SPENDING_LIMIT_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + getApprovedSpendingLimitMicros().hashCode();
        break;
      case 15:
        hash = (37 * hash) + APPROVED_SPENDING_LIMIT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getApprovedSpendingLimitTypeValue();
        break;
      case 0:
      default:
    }
    switch (adjustedSpendingLimitCase_) {
      case 16:
        hash = (37 * hash) + ADJUSTED_SPENDING_LIMIT_MICROS_FIELD_NUMBER;
        hash = (53 * hash) + getAdjustedSpendingLimitMicros().hashCode();
        break;
      case 17:
        hash = (37 * hash) + ADJUSTED_SPENDING_LIMIT_TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getAdjustedSpendingLimitTypeValue();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v4.resources.AccountBudget parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v4.resources.AccountBudget prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An account-level budget. It contains information about the budget itself,
   * as well as the most recently approved changes to the budget and proposed
   * changes that are pending approval. The proposed changes that are pending
   * approval, if any, are found in 'pending_proposal'.  Effective details about
   * the budget are found in fields prefixed 'approved_', 'adjusted_' and those
   * without a prefix.  Since some effective details may differ from what the user
   * had originally requested (e.g. spending limit), these differences are
   * juxtaposed via 'proposed_', 'approved_', and possibly 'adjusted_' fields.
   * This resource is mutated using AccountBudgetProposal and cannot be mutated
   * directly. A budget may have at most one pending proposal at any given time.
   * It is read through pending_proposal.
   * Once approved, a budget may be subject to adjustments, such as credit
   * adjustments.  Adjustments create differences between the 'approved' and
   * 'adjusted' fields, which would otherwise be identical.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v4.resources.AccountBudget}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v4.resources.AccountBudget)
      com.google.ads.googleads.v4.resources.AccountBudgetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v4.resources.AccountBudget.class, com.google.ads.googleads.v4.resources.AccountBudget.Builder.class);
    }

    // Construct using com.google.ads.googleads.v4.resources.AccountBudget.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceName_ = "";

      if (idBuilder_ == null) {
        id_ = null;
      } else {
        id_ = null;
        idBuilder_ = null;
      }
      if (billingSetupBuilder_ == null) {
        billingSetup_ = null;
      } else {
        billingSetup_ = null;
        billingSetupBuilder_ = null;
      }
      status_ = 0;

      if (nameBuilder_ == null) {
        name_ = null;
      } else {
        name_ = null;
        nameBuilder_ = null;
      }
      if (proposedStartDateTimeBuilder_ == null) {
        proposedStartDateTime_ = null;
      } else {
        proposedStartDateTime_ = null;
        proposedStartDateTimeBuilder_ = null;
      }
      if (approvedStartDateTimeBuilder_ == null) {
        approvedStartDateTime_ = null;
      } else {
        approvedStartDateTime_ = null;
        approvedStartDateTimeBuilder_ = null;
      }
      if (totalAdjustmentsMicrosBuilder_ == null) {
        totalAdjustmentsMicros_ = null;
      } else {
        totalAdjustmentsMicros_ = null;
        totalAdjustmentsMicrosBuilder_ = null;
      }
      if (amountServedMicrosBuilder_ == null) {
        amountServedMicros_ = null;
      } else {
        amountServedMicros_ = null;
        amountServedMicrosBuilder_ = null;
      }
      if (purchaseOrderNumberBuilder_ == null) {
        purchaseOrderNumber_ = null;
      } else {
        purchaseOrderNumber_ = null;
        purchaseOrderNumberBuilder_ = null;
      }
      if (notesBuilder_ == null) {
        notes_ = null;
      } else {
        notes_ = null;
        notesBuilder_ = null;
      }
      if (pendingProposalBuilder_ == null) {
        pendingProposal_ = null;
      } else {
        pendingProposal_ = null;
        pendingProposalBuilder_ = null;
      }
      proposedEndTimeCase_ = 0;
      proposedEndTime_ = null;
      approvedEndTimeCase_ = 0;
      approvedEndTime_ = null;
      proposedSpendingLimitCase_ = 0;
      proposedSpendingLimit_ = null;
      approvedSpendingLimitCase_ = 0;
      approvedSpendingLimit_ = null;
      adjustedSpendingLimitCase_ = 0;
      adjustedSpendingLimit_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v4.resources.AccountBudgetProto.internal_static_google_ads_googleads_v4_resources_AccountBudget_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v4.resources.AccountBudget getDefaultInstanceForType() {
      return com.google.ads.googleads.v4.resources.AccountBudget.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v4.resources.AccountBudget build() {
      com.google.ads.googleads.v4.resources.AccountBudget result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v4.resources.AccountBudget buildPartial() {
      com.google.ads.googleads.v4.resources.AccountBudget result = new com.google.ads.googleads.v4.resources.AccountBudget(this);
      result.resourceName_ = resourceName_;
      if (idBuilder_ == null) {
        result.id_ = id_;
      } else {
        result.id_ = idBuilder_.build();
      }
      if (billingSetupBuilder_ == null) {
        result.billingSetup_ = billingSetup_;
      } else {
        result.billingSetup_ = billingSetupBuilder_.build();
      }
      result.status_ = status_;
      if (nameBuilder_ == null) {
        result.name_ = name_;
      } else {
        result.name_ = nameBuilder_.build();
      }
      if (proposedStartDateTimeBuilder_ == null) {
        result.proposedStartDateTime_ = proposedStartDateTime_;
      } else {
        result.proposedStartDateTime_ = proposedStartDateTimeBuilder_.build();
      }
      if (approvedStartDateTimeBuilder_ == null) {
        result.approvedStartDateTime_ = approvedStartDateTime_;
      } else {
        result.approvedStartDateTime_ = approvedStartDateTimeBuilder_.build();
      }
      if (totalAdjustmentsMicrosBuilder_ == null) {
        result.totalAdjustmentsMicros_ = totalAdjustmentsMicros_;
      } else {
        result.totalAdjustmentsMicros_ = totalAdjustmentsMicrosBuilder_.build();
      }
      if (amountServedMicrosBuilder_ == null) {
        result.amountServedMicros_ = amountServedMicros_;
      } else {
        result.amountServedMicros_ = amountServedMicrosBuilder_.build();
      }
      if (purchaseOrderNumberBuilder_ == null) {
        result.purchaseOrderNumber_ = purchaseOrderNumber_;
      } else {
        result.purchaseOrderNumber_ = purchaseOrderNumberBuilder_.build();
      }
      if (notesBuilder_ == null) {
        result.notes_ = notes_;
      } else {
        result.notes_ = notesBuilder_.build();
      }
      if (pendingProposalBuilder_ == null) {
        result.pendingProposal_ = pendingProposal_;
      } else {
        result.pendingProposal_ = pendingProposalBuilder_.build();
      }
      if (proposedEndTimeCase_ == 8) {
        if (proposedEndDateTimeBuilder_ == null) {
          result.proposedEndTime_ = proposedEndTime_;
        } else {
          result.proposedEndTime_ = proposedEndDateTimeBuilder_.build();
        }
      }
      if (proposedEndTimeCase_ == 9) {
        result.proposedEndTime_ = proposedEndTime_;
      }
      if (approvedEndTimeCase_ == 10) {
        if (approvedEndDateTimeBuilder_ == null) {
          result.approvedEndTime_ = approvedEndTime_;
        } else {
          result.approvedEndTime_ = approvedEndDateTimeBuilder_.build();
        }
      }
      if (approvedEndTimeCase_ == 11) {
        result.approvedEndTime_ = approvedEndTime_;
      }
      if (proposedSpendingLimitCase_ == 12) {
        if (proposedSpendingLimitMicrosBuilder_ == null) {
          result.proposedSpendingLimit_ = proposedSpendingLimit_;
        } else {
          result.proposedSpendingLimit_ = proposedSpendingLimitMicrosBuilder_.build();
        }
      }
      if (proposedSpendingLimitCase_ == 13) {
        result.proposedSpendingLimit_ = proposedSpendingLimit_;
      }
      if (approvedSpendingLimitCase_ == 14) {
        if (approvedSpendingLimitMicrosBuilder_ == null) {
          result.approvedSpendingLimit_ = approvedSpendingLimit_;
        } else {
          result.approvedSpendingLimit_ = approvedSpendingLimitMicrosBuilder_.build();
        }
      }
      if (approvedSpendingLimitCase_ == 15) {
        result.approvedSpendingLimit_ = approvedSpendingLimit_;
      }
      if (adjustedSpendingLimitCase_ == 16) {
        if (adjustedSpendingLimitMicrosBuilder_ == null) {
          result.adjustedSpendingLimit_ = adjustedSpendingLimit_;
        } else {
          result.adjustedSpendingLimit_ = adjustedSpendingLimitMicrosBuilder_.build();
        }
      }
      if (adjustedSpendingLimitCase_ == 17) {
        result.adjustedSpendingLimit_ = adjustedSpendingLimit_;
      }
      result.proposedEndTimeCase_ = proposedEndTimeCase_;
      result.approvedEndTimeCase_ = approvedEndTimeCase_;
      result.proposedSpendingLimitCase_ = proposedSpendingLimitCase_;
      result.approvedSpendingLimitCase_ = approvedSpendingLimitCase_;
      result.adjustedSpendingLimitCase_ = adjustedSpendingLimitCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v4.resources.AccountBudget) {
        return mergeFrom((com.google.ads.googleads.v4.resources.AccountBudget)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v4.resources.AccountBudget other) {
      if (other == com.google.ads.googleads.v4.resources.AccountBudget.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (other.hasId()) {
        mergeId(other.getId());
      }
      if (other.hasBillingSetup()) {
        mergeBillingSetup(other.getBillingSetup());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.hasName()) {
        mergeName(other.getName());
      }
      if (other.hasProposedStartDateTime()) {
        mergeProposedStartDateTime(other.getProposedStartDateTime());
      }
      if (other.hasApprovedStartDateTime()) {
        mergeApprovedStartDateTime(other.getApprovedStartDateTime());
      }
      if (other.hasTotalAdjustmentsMicros()) {
        mergeTotalAdjustmentsMicros(other.getTotalAdjustmentsMicros());
      }
      if (other.hasAmountServedMicros()) {
        mergeAmountServedMicros(other.getAmountServedMicros());
      }
      if (other.hasPurchaseOrderNumber()) {
        mergePurchaseOrderNumber(other.getPurchaseOrderNumber());
      }
      if (other.hasNotes()) {
        mergeNotes(other.getNotes());
      }
      if (other.hasPendingProposal()) {
        mergePendingProposal(other.getPendingProposal());
      }
      switch (other.getProposedEndTimeCase()) {
        case PROPOSED_END_DATE_TIME: {
          mergeProposedEndDateTime(other.getProposedEndDateTime());
          break;
        }
        case PROPOSED_END_TIME_TYPE: {
          setProposedEndTimeTypeValue(other.getProposedEndTimeTypeValue());
          break;
        }
        case PROPOSEDENDTIME_NOT_SET: {
          break;
        }
      }
      switch (other.getApprovedEndTimeCase()) {
        case APPROVED_END_DATE_TIME: {
          mergeApprovedEndDateTime(other.getApprovedEndDateTime());
          break;
        }
        case APPROVED_END_TIME_TYPE: {
          setApprovedEndTimeTypeValue(other.getApprovedEndTimeTypeValue());
          break;
        }
        case APPROVEDENDTIME_NOT_SET: {
          break;
        }
      }
      switch (other.getProposedSpendingLimitCase()) {
        case PROPOSED_SPENDING_LIMIT_MICROS: {
          mergeProposedSpendingLimitMicros(other.getProposedSpendingLimitMicros());
          break;
        }
        case PROPOSED_SPENDING_LIMIT_TYPE: {
          setProposedSpendingLimitTypeValue(other.getProposedSpendingLimitTypeValue());
          break;
        }
        case PROPOSEDSPENDINGLIMIT_NOT_SET: {
          break;
        }
      }
      switch (other.getApprovedSpendingLimitCase()) {
        case APPROVED_SPENDING_LIMIT_MICROS: {
          mergeApprovedSpendingLimitMicros(other.getApprovedSpendingLimitMicros());
          break;
        }
        case APPROVED_SPENDING_LIMIT_TYPE: {
          setApprovedSpendingLimitTypeValue(other.getApprovedSpendingLimitTypeValue());
          break;
        }
        case APPROVEDSPENDINGLIMIT_NOT_SET: {
          break;
        }
      }
      switch (other.getAdjustedSpendingLimitCase()) {
        case ADJUSTED_SPENDING_LIMIT_MICROS: {
          mergeAdjustedSpendingLimitMicros(other.getAdjustedSpendingLimitMicros());
          break;
        }
        case ADJUSTED_SPENDING_LIMIT_TYPE: {
          setAdjustedSpendingLimitTypeValue(other.getAdjustedSpendingLimitTypeValue());
          break;
        }
        case ADJUSTEDSPENDINGLIMIT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ads.googleads.v4.resources.AccountBudget parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ads.googleads.v4.resources.AccountBudget) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int proposedEndTimeCase_ = 0;
    private java.lang.Object proposedEndTime_;
    public ProposedEndTimeCase
        getProposedEndTimeCase() {
      return ProposedEndTimeCase.forNumber(
          proposedEndTimeCase_);
    }

    public Builder clearProposedEndTime() {
      proposedEndTimeCase_ = 0;
      proposedEndTime_ = null;
      onChanged();
      return this;
    }

    private int approvedEndTimeCase_ = 0;
    private java.lang.Object approvedEndTime_;
    public ApprovedEndTimeCase
        getApprovedEndTimeCase() {
      return ApprovedEndTimeCase.forNumber(
          approvedEndTimeCase_);
    }

    public Builder clearApprovedEndTime() {
      approvedEndTimeCase_ = 0;
      approvedEndTime_ = null;
      onChanged();
      return this;
    }

    private int proposedSpendingLimitCase_ = 0;
    private java.lang.Object proposedSpendingLimit_;
    public ProposedSpendingLimitCase
        getProposedSpendingLimitCase() {
      return ProposedSpendingLimitCase.forNumber(
          proposedSpendingLimitCase_);
    }

    public Builder clearProposedSpendingLimit() {
      proposedSpendingLimitCase_ = 0;
      proposedSpendingLimit_ = null;
      onChanged();
      return this;
    }

    private int approvedSpendingLimitCase_ = 0;
    private java.lang.Object approvedSpendingLimit_;
    public ApprovedSpendingLimitCase
        getApprovedSpendingLimitCase() {
      return ApprovedSpendingLimitCase.forNumber(
          approvedSpendingLimitCase_);
    }

    public Builder clearApprovedSpendingLimit() {
      approvedSpendingLimitCase_ = 0;
      approvedSpendingLimit_ = null;
      onChanged();
      return this;
    }

    private int adjustedSpendingLimitCase_ = 0;
    private java.lang.Object adjustedSpendingLimit_;
    public AdjustedSpendingLimitCase
        getAdjustedSpendingLimitCase() {
      return AdjustedSpendingLimitCase.forNumber(
          adjustedSpendingLimitCase_);
    }

    public Builder clearAdjustedSpendingLimit() {
      adjustedSpendingLimitCase_ = 0;
      adjustedSpendingLimit_ = null;
      onChanged();
      return this;
    }


    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the account-level budget.
     * AccountBudget resource names have the form:
     * `customers/{customer_id}/accountBudgets/{account_budget_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the account-level budget.
     * AccountBudget resource names have the form:
     * `customers/{customer_id}/accountBudgets/{account_budget_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the account-level budget.
     * AccountBudget resource names have the form:
     * `customers/{customer_id}/accountBudgets/{account_budget_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the account-level budget.
     * AccountBudget resource names have the form:
     * `customers/{customer_id}/accountBudgets/{account_budget_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      
      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the account-level budget.
     * AccountBudget resource names have the form:
     * `customers/{customer_id}/accountBudgets/{account_budget_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      resourceName_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value id_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> idBuilder_;
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the id field is set.
     */
    public boolean hasId() {
      return idBuilder_ != null || id_ != null;
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    public com.google.protobuf.Int64Value getId() {
      if (idBuilder_ == null) {
        return id_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : id_;
      } else {
        return idBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setId(com.google.protobuf.Int64Value value) {
      if (idBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        id_ = value;
        onChanged();
      } else {
        idBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setId(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (idBuilder_ == null) {
        id_ = builderForValue.build();
        onChanged();
      } else {
        idBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeId(com.google.protobuf.Int64Value value) {
      if (idBuilder_ == null) {
        if (id_ != null) {
          id_ =
            com.google.protobuf.Int64Value.newBuilder(id_).mergeFrom(value).buildPartial();
        } else {
          id_ = value;
        }
        onChanged();
      } else {
        idBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearId() {
      if (idBuilder_ == null) {
        id_ = null;
        onChanged();
      } else {
        id_ = null;
        idBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getIdBuilder() {
      
      onChanged();
      return getIdFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getIdOrBuilder() {
      if (idBuilder_ != null) {
        return idBuilder_.getMessageOrBuilder();
      } else {
        return id_ == null ?
            com.google.protobuf.Int64Value.getDefaultInstance() : id_;
      }
    }
    /**
     * <pre>
     * Output only. The ID of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getIdFieldBuilder() {
      if (idBuilder_ == null) {
        idBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                getId(),
                getParentForChildren(),
                isClean());
        id_ = null;
      }
      return idBuilder_;
    }

    private com.google.protobuf.StringValue billingSetup_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> billingSetupBuilder_;
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the billingSetup field is set.
     */
    public boolean hasBillingSetup() {
      return billingSetupBuilder_ != null || billingSetup_ != null;
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The billingSetup.
     */
    public com.google.protobuf.StringValue getBillingSetup() {
      if (billingSetupBuilder_ == null) {
        return billingSetup_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : billingSetup_;
      } else {
        return billingSetupBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public Builder setBillingSetup(com.google.protobuf.StringValue value) {
      if (billingSetupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        billingSetup_ = value;
        onChanged();
      } else {
        billingSetupBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public Builder setBillingSetup(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (billingSetupBuilder_ == null) {
        billingSetup_ = builderForValue.build();
        onChanged();
      } else {
        billingSetupBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public Builder mergeBillingSetup(com.google.protobuf.StringValue value) {
      if (billingSetupBuilder_ == null) {
        if (billingSetup_ != null) {
          billingSetup_ =
            com.google.protobuf.StringValue.newBuilder(billingSetup_).mergeFrom(value).buildPartial();
        } else {
          billingSetup_ = value;
        }
        onChanged();
      } else {
        billingSetupBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public Builder clearBillingSetup() {
      if (billingSetupBuilder_ == null) {
        billingSetup_ = null;
        onChanged();
      } else {
        billingSetup_ = null;
        billingSetupBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public com.google.protobuf.StringValue.Builder getBillingSetupBuilder() {
      
      onChanged();
      return getBillingSetupFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    public com.google.protobuf.StringValueOrBuilder getBillingSetupOrBuilder() {
      if (billingSetupBuilder_ != null) {
        return billingSetupBuilder_.getMessageOrBuilder();
      } else {
        return billingSetup_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : billingSetup_;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the billing setup associated with this account-level
     * budget.  BillingSetup resource names have the form:
     * `customers/{customer_id}/billingSetups/{billing_setup_id}`
     * </pre>
     *
     * <code>.google.protobuf.StringValue billing_setup = 3 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getBillingSetupFieldBuilder() {
      if (billingSetupBuilder_ == null) {
        billingSetupBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getBillingSetup(),
                getParentForChildren(),
                isClean());
        billingSetup_ = null;
      }
      return billingSetupBuilder_;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. The status of this account-level budget.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. The status of this account-level budget.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of this account-level budget.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus getStatus() {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus result = com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.valueOf(status_);
      return result == null ? com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The status of this account-level budget.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of this account-level budget.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.AccountBudgetStatusEnum.AccountBudgetStatus status = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.StringValue name_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> nameBuilder_;
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return nameBuilder_ != null || name_ != null;
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The name.
     */
    public com.google.protobuf.StringValue getName() {
      if (nameBuilder_ == null) {
        return name_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : name_;
      } else {
        return nameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setName(com.google.protobuf.StringValue value) {
      if (nameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        onChanged();
      } else {
        nameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setName(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (nameBuilder_ == null) {
        name_ = builderForValue.build();
        onChanged();
      } else {
        nameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeName(com.google.protobuf.StringValue value) {
      if (nameBuilder_ == null) {
        if (name_ != null) {
          name_ =
            com.google.protobuf.StringValue.newBuilder(name_).mergeFrom(value).buildPartial();
        } else {
          name_ = value;
        }
        onChanged();
      } else {
        nameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearName() {
      if (nameBuilder_ == null) {
        name_ = null;
        onChanged();
      } else {
        name_ = null;
        nameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getNameBuilder() {
      
      onChanged();
      return getNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValueOrBuilder getNameOrBuilder() {
      if (nameBuilder_ != null) {
        return nameBuilder_.getMessageOrBuilder();
      } else {
        return name_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : name_;
      }
    }
    /**
     * <pre>
     * Output only. The name of the account-level budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue name = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getNameFieldBuilder() {
      if (nameBuilder_ == null) {
        nameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getName(),
                getParentForChildren(),
                isClean());
        name_ = null;
      }
      return nameBuilder_;
    }

    private com.google.protobuf.StringValue proposedStartDateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> proposedStartDateTimeBuilder_;
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the proposedStartDateTime field is set.
     */
    public boolean hasProposedStartDateTime() {
      return proposedStartDateTimeBuilder_ != null || proposedStartDateTime_ != null;
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposedStartDateTime.
     */
    public com.google.protobuf.StringValue getProposedStartDateTime() {
      if (proposedStartDateTimeBuilder_ == null) {
        return proposedStartDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : proposedStartDateTime_;
      } else {
        return proposedStartDateTimeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedStartDateTime(com.google.protobuf.StringValue value) {
      if (proposedStartDateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        proposedStartDateTime_ = value;
        onChanged();
      } else {
        proposedStartDateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedStartDateTime(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (proposedStartDateTimeBuilder_ == null) {
        proposedStartDateTime_ = builderForValue.build();
        onChanged();
      } else {
        proposedStartDateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeProposedStartDateTime(com.google.protobuf.StringValue value) {
      if (proposedStartDateTimeBuilder_ == null) {
        if (proposedStartDateTime_ != null) {
          proposedStartDateTime_ =
            com.google.protobuf.StringValue.newBuilder(proposedStartDateTime_).mergeFrom(value).buildPartial();
        } else {
          proposedStartDateTime_ = value;
        }
        onChanged();
      } else {
        proposedStartDateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearProposedStartDateTime() {
      if (proposedStartDateTimeBuilder_ == null) {
        proposedStartDateTime_ = null;
        onChanged();
      } else {
        proposedStartDateTime_ = null;
        proposedStartDateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getProposedStartDateTimeBuilder() {
      
      onChanged();
      return getProposedStartDateTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValueOrBuilder getProposedStartDateTimeOrBuilder() {
      if (proposedStartDateTimeBuilder_ != null) {
        return proposedStartDateTimeBuilder_.getMessageOrBuilder();
      } else {
        return proposedStartDateTime_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : proposedStartDateTime_;
      }
    }
    /**
     * <pre>
     * Output only. The proposed start time of the account-level budget in
     * yyyy-MM-dd HH:mm:ss format.  If a start time type of NOW was proposed,
     * this is the time of request.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_start_date_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getProposedStartDateTimeFieldBuilder() {
      if (proposedStartDateTimeBuilder_ == null) {
        proposedStartDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getProposedStartDateTime(),
                getParentForChildren(),
                isClean());
        proposedStartDateTime_ = null;
      }
      return proposedStartDateTimeBuilder_;
    }

    private com.google.protobuf.StringValue approvedStartDateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> approvedStartDateTimeBuilder_;
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the approvedStartDateTime field is set.
     */
    public boolean hasApprovedStartDateTime() {
      return approvedStartDateTimeBuilder_ != null || approvedStartDateTime_ != null;
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvedStartDateTime.
     */
    public com.google.protobuf.StringValue getApprovedStartDateTime() {
      if (approvedStartDateTimeBuilder_ == null) {
        return approvedStartDateTime_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : approvedStartDateTime_;
      } else {
        return approvedStartDateTimeBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedStartDateTime(com.google.protobuf.StringValue value) {
      if (approvedStartDateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approvedStartDateTime_ = value;
        onChanged();
      } else {
        approvedStartDateTimeBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedStartDateTime(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (approvedStartDateTimeBuilder_ == null) {
        approvedStartDateTime_ = builderForValue.build();
        onChanged();
      } else {
        approvedStartDateTimeBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeApprovedStartDateTime(com.google.protobuf.StringValue value) {
      if (approvedStartDateTimeBuilder_ == null) {
        if (approvedStartDateTime_ != null) {
          approvedStartDateTime_ =
            com.google.protobuf.StringValue.newBuilder(approvedStartDateTime_).mergeFrom(value).buildPartial();
        } else {
          approvedStartDateTime_ = value;
        }
        onChanged();
      } else {
        approvedStartDateTimeBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearApprovedStartDateTime() {
      if (approvedStartDateTimeBuilder_ == null) {
        approvedStartDateTime_ = null;
        onChanged();
      } else {
        approvedStartDateTime_ = null;
        approvedStartDateTimeBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getApprovedStartDateTimeBuilder() {
      
      onChanged();
      return getApprovedStartDateTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValueOrBuilder getApprovedStartDateTimeOrBuilder() {
      if (approvedStartDateTimeBuilder_ != null) {
        return approvedStartDateTimeBuilder_.getMessageOrBuilder();
      } else {
        return approvedStartDateTime_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : approvedStartDateTime_;
      }
    }
    /**
     * <pre>
     * Output only. The approved start time of the account-level budget in yyyy-MM-dd HH:mm:ss
     * format.
     * For example, if a new budget is approved after the proposed start time,
     * the approved start time is the time of approval.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_start_date_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getApprovedStartDateTimeFieldBuilder() {
      if (approvedStartDateTimeBuilder_ == null) {
        approvedStartDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getApprovedStartDateTime(),
                getParentForChildren(),
                isClean());
        approvedStartDateTime_ = null;
      }
      return approvedStartDateTimeBuilder_;
    }

    private com.google.protobuf.Int64Value totalAdjustmentsMicros_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> totalAdjustmentsMicrosBuilder_;
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the totalAdjustmentsMicros field is set.
     */
    public boolean hasTotalAdjustmentsMicros() {
      return totalAdjustmentsMicrosBuilder_ != null || totalAdjustmentsMicros_ != null;
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The totalAdjustmentsMicros.
     */
    public com.google.protobuf.Int64Value getTotalAdjustmentsMicros() {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        return totalAdjustmentsMicros_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : totalAdjustmentsMicros_;
      } else {
        return totalAdjustmentsMicrosBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTotalAdjustmentsMicros(com.google.protobuf.Int64Value value) {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        totalAdjustmentsMicros_ = value;
        onChanged();
      } else {
        totalAdjustmentsMicrosBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTotalAdjustmentsMicros(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        totalAdjustmentsMicros_ = builderForValue.build();
        onChanged();
      } else {
        totalAdjustmentsMicrosBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTotalAdjustmentsMicros(com.google.protobuf.Int64Value value) {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        if (totalAdjustmentsMicros_ != null) {
          totalAdjustmentsMicros_ =
            com.google.protobuf.Int64Value.newBuilder(totalAdjustmentsMicros_).mergeFrom(value).buildPartial();
        } else {
          totalAdjustmentsMicros_ = value;
        }
        onChanged();
      } else {
        totalAdjustmentsMicrosBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTotalAdjustmentsMicros() {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        totalAdjustmentsMicros_ = null;
        onChanged();
      } else {
        totalAdjustmentsMicros_ = null;
        totalAdjustmentsMicrosBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getTotalAdjustmentsMicrosBuilder() {
      
      onChanged();
      return getTotalAdjustmentsMicrosFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getTotalAdjustmentsMicrosOrBuilder() {
      if (totalAdjustmentsMicrosBuilder_ != null) {
        return totalAdjustmentsMicrosBuilder_.getMessageOrBuilder();
      } else {
        return totalAdjustmentsMicros_ == null ?
            com.google.protobuf.Int64Value.getDefaultInstance() : totalAdjustmentsMicros_;
      }
    }
    /**
     * <pre>
     * Output only. The total adjustments amount.
     * An example of an adjustment is courtesy credits.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value total_adjustments_micros = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getTotalAdjustmentsMicrosFieldBuilder() {
      if (totalAdjustmentsMicrosBuilder_ == null) {
        totalAdjustmentsMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                getTotalAdjustmentsMicros(),
                getParentForChildren(),
                isClean());
        totalAdjustmentsMicros_ = null;
      }
      return totalAdjustmentsMicrosBuilder_;
    }

    private com.google.protobuf.Int64Value amountServedMicros_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> amountServedMicrosBuilder_;
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the amountServedMicros field is set.
     */
    public boolean hasAmountServedMicros() {
      return amountServedMicrosBuilder_ != null || amountServedMicros_ != null;
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The amountServedMicros.
     */
    public com.google.protobuf.Int64Value getAmountServedMicros() {
      if (amountServedMicrosBuilder_ == null) {
        return amountServedMicros_ == null ? com.google.protobuf.Int64Value.getDefaultInstance() : amountServedMicros_;
      } else {
        return amountServedMicrosBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAmountServedMicros(com.google.protobuf.Int64Value value) {
      if (amountServedMicrosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        amountServedMicros_ = value;
        onChanged();
      } else {
        amountServedMicrosBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAmountServedMicros(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (amountServedMicrosBuilder_ == null) {
        amountServedMicros_ = builderForValue.build();
        onChanged();
      } else {
        amountServedMicrosBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeAmountServedMicros(com.google.protobuf.Int64Value value) {
      if (amountServedMicrosBuilder_ == null) {
        if (amountServedMicros_ != null) {
          amountServedMicros_ =
            com.google.protobuf.Int64Value.newBuilder(amountServedMicros_).mergeFrom(value).buildPartial();
        } else {
          amountServedMicros_ = value;
        }
        onChanged();
      } else {
        amountServedMicrosBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearAmountServedMicros() {
      if (amountServedMicrosBuilder_ == null) {
        amountServedMicros_ = null;
        onChanged();
      } else {
        amountServedMicros_ = null;
        amountServedMicrosBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getAmountServedMicrosBuilder() {
      
      onChanged();
      return getAmountServedMicrosFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getAmountServedMicrosOrBuilder() {
      if (amountServedMicrosBuilder_ != null) {
        return amountServedMicrosBuilder_.getMessageOrBuilder();
      } else {
        return amountServedMicros_ == null ?
            com.google.protobuf.Int64Value.getDefaultInstance() : amountServedMicros_;
      }
    }
    /**
     * <pre>
     * Output only. The value of Ads that have been served, in micros.
     * This includes overdelivery costs, in which case a credit might be
     * automatically applied to the budget (see total_adjustments_micros).
     * </pre>
     *
     * <code>.google.protobuf.Int64Value amount_served_micros = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getAmountServedMicrosFieldBuilder() {
      if (amountServedMicrosBuilder_ == null) {
        amountServedMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                getAmountServedMicros(),
                getParentForChildren(),
                isClean());
        amountServedMicros_ = null;
      }
      return amountServedMicrosBuilder_;
    }

    private com.google.protobuf.StringValue purchaseOrderNumber_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> purchaseOrderNumberBuilder_;
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the purchaseOrderNumber field is set.
     */
    public boolean hasPurchaseOrderNumber() {
      return purchaseOrderNumberBuilder_ != null || purchaseOrderNumber_ != null;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The purchaseOrderNumber.
     */
    public com.google.protobuf.StringValue getPurchaseOrderNumber() {
      if (purchaseOrderNumberBuilder_ == null) {
        return purchaseOrderNumber_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
      } else {
        return purchaseOrderNumberBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPurchaseOrderNumber(com.google.protobuf.StringValue value) {
      if (purchaseOrderNumberBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purchaseOrderNumber_ = value;
        onChanged();
      } else {
        purchaseOrderNumberBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPurchaseOrderNumber(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (purchaseOrderNumberBuilder_ == null) {
        purchaseOrderNumber_ = builderForValue.build();
        onChanged();
      } else {
        purchaseOrderNumberBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergePurchaseOrderNumber(com.google.protobuf.StringValue value) {
      if (purchaseOrderNumberBuilder_ == null) {
        if (purchaseOrderNumber_ != null) {
          purchaseOrderNumber_ =
            com.google.protobuf.StringValue.newBuilder(purchaseOrderNumber_).mergeFrom(value).buildPartial();
        } else {
          purchaseOrderNumber_ = value;
        }
        onChanged();
      } else {
        purchaseOrderNumberBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearPurchaseOrderNumber() {
      if (purchaseOrderNumberBuilder_ == null) {
        purchaseOrderNumber_ = null;
        onChanged();
      } else {
        purchaseOrderNumber_ = null;
        purchaseOrderNumberBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getPurchaseOrderNumberBuilder() {
      
      onChanged();
      return getPurchaseOrderNumberFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValueOrBuilder getPurchaseOrderNumberOrBuilder() {
      if (purchaseOrderNumberBuilder_ != null) {
        return purchaseOrderNumberBuilder_.getMessageOrBuilder();
      } else {
        return purchaseOrderNumber_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : purchaseOrderNumber_;
      }
    }
    /**
     * <pre>
     * Output only. A purchase order number is a value that helps users reference this budget
     * in their monthly invoices.
     * </pre>
     *
     * <code>.google.protobuf.StringValue purchase_order_number = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getPurchaseOrderNumberFieldBuilder() {
      if (purchaseOrderNumberBuilder_ == null) {
        purchaseOrderNumberBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getPurchaseOrderNumber(),
                getParentForChildren(),
                isClean());
        purchaseOrderNumber_ = null;
      }
      return purchaseOrderNumberBuilder_;
    }

    private com.google.protobuf.StringValue notes_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> notesBuilder_;
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the notes field is set.
     */
    public boolean hasNotes() {
      return notesBuilder_ != null || notes_ != null;
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The notes.
     */
    public com.google.protobuf.StringValue getNotes() {
      if (notesBuilder_ == null) {
        return notes_ == null ? com.google.protobuf.StringValue.getDefaultInstance() : notes_;
      } else {
        return notesBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setNotes(com.google.protobuf.StringValue value) {
      if (notesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notes_ = value;
        onChanged();
      } else {
        notesBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setNotes(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (notesBuilder_ == null) {
        notes_ = builderForValue.build();
        onChanged();
      } else {
        notesBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeNotes(com.google.protobuf.StringValue value) {
      if (notesBuilder_ == null) {
        if (notes_ != null) {
          notes_ =
            com.google.protobuf.StringValue.newBuilder(notes_).mergeFrom(value).buildPartial();
        } else {
          notes_ = value;
        }
        onChanged();
      } else {
        notesBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearNotes() {
      if (notesBuilder_ == null) {
        notes_ = null;
        onChanged();
      } else {
        notes_ = null;
        notesBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getNotesBuilder() {
      
      onChanged();
      return getNotesFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValueOrBuilder getNotesOrBuilder() {
      if (notesBuilder_ != null) {
        return notesBuilder_.getMessageOrBuilder();
      } else {
        return notes_ == null ?
            com.google.protobuf.StringValue.getDefaultInstance() : notes_;
      }
    }
    /**
     * <pre>
     * Output only. Notes associated with the budget.
     * </pre>
     *
     * <code>.google.protobuf.StringValue notes = 21 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getNotesFieldBuilder() {
      if (notesBuilder_ == null) {
        notesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                getNotes(),
                getParentForChildren(),
                isClean());
        notes_ = null;
      }
      return notesBuilder_;
    }

    private com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pendingProposal_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder> pendingProposalBuilder_;
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the pendingProposal field is set.
     */
    public boolean hasPendingProposal() {
      return pendingProposalBuilder_ != null || pendingProposal_ != null;
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The pendingProposal.
     */
    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal getPendingProposal() {
      if (pendingProposalBuilder_ == null) {
        return pendingProposal_ == null ? com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.getDefaultInstance() : pendingProposal_;
      } else {
        return pendingProposalBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPendingProposal(com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal value) {
      if (pendingProposalBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pendingProposal_ = value;
        onChanged();
      } else {
        pendingProposalBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPendingProposal(
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder builderForValue) {
      if (pendingProposalBuilder_ == null) {
        pendingProposal_ = builderForValue.build();
        onChanged();
      } else {
        pendingProposalBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergePendingProposal(com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal value) {
      if (pendingProposalBuilder_ == null) {
        if (pendingProposal_ != null) {
          pendingProposal_ =
            com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.newBuilder(pendingProposal_).mergeFrom(value).buildPartial();
        } else {
          pendingProposal_ = value;
        }
        onChanged();
      } else {
        pendingProposalBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearPendingProposal() {
      if (pendingProposalBuilder_ == null) {
        pendingProposal_ = null;
        onChanged();
      } else {
        pendingProposal_ = null;
        pendingProposalBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder getPendingProposalBuilder() {
      
      onChanged();
      return getPendingProposalFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder getPendingProposalOrBuilder() {
      if (pendingProposalBuilder_ != null) {
        return pendingProposalBuilder_.getMessageOrBuilder();
      } else {
        return pendingProposal_ == null ?
            com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.getDefaultInstance() : pendingProposal_;
      }
    }
    /**
     * <pre>
     * Output only. The pending proposal to modify this budget, if applicable.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal pending_proposal = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder> 
        getPendingProposalFieldBuilder() {
      if (pendingProposalBuilder_ == null) {
        pendingProposalBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposal.Builder, com.google.ads.googleads.v4.resources.AccountBudget.PendingAccountBudgetProposalOrBuilder>(
                getPendingProposal(),
                getParentForChildren(),
                isClean());
        pendingProposal_ = null;
      }
      return pendingProposalBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> proposedEndDateTimeBuilder_;
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the proposedEndDateTime field is set.
     */
    @java.lang.Override
    public boolean hasProposedEndDateTime() {
      return proposedEndTimeCase_ == 8;
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposedEndDateTime.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getProposedEndDateTime() {
      if (proposedEndDateTimeBuilder_ == null) {
        if (proposedEndTimeCase_ == 8) {
          return (com.google.protobuf.StringValue) proposedEndTime_;
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      } else {
        if (proposedEndTimeCase_ == 8) {
          return proposedEndDateTimeBuilder_.getMessage();
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedEndDateTime(com.google.protobuf.StringValue value) {
      if (proposedEndDateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        proposedEndTime_ = value;
        onChanged();
      } else {
        proposedEndDateTimeBuilder_.setMessage(value);
      }
      proposedEndTimeCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedEndDateTime(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (proposedEndDateTimeBuilder_ == null) {
        proposedEndTime_ = builderForValue.build();
        onChanged();
      } else {
        proposedEndDateTimeBuilder_.setMessage(builderForValue.build());
      }
      proposedEndTimeCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeProposedEndDateTime(com.google.protobuf.StringValue value) {
      if (proposedEndDateTimeBuilder_ == null) {
        if (proposedEndTimeCase_ == 8 &&
            proposedEndTime_ != com.google.protobuf.StringValue.getDefaultInstance()) {
          proposedEndTime_ = com.google.protobuf.StringValue.newBuilder((com.google.protobuf.StringValue) proposedEndTime_)
              .mergeFrom(value).buildPartial();
        } else {
          proposedEndTime_ = value;
        }
        onChanged();
      } else {
        if (proposedEndTimeCase_ == 8) {
          proposedEndDateTimeBuilder_.mergeFrom(value);
        }
        proposedEndDateTimeBuilder_.setMessage(value);
      }
      proposedEndTimeCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearProposedEndDateTime() {
      if (proposedEndDateTimeBuilder_ == null) {
        if (proposedEndTimeCase_ == 8) {
          proposedEndTimeCase_ = 0;
          proposedEndTime_ = null;
          onChanged();
        }
      } else {
        if (proposedEndTimeCase_ == 8) {
          proposedEndTimeCase_ = 0;
          proposedEndTime_ = null;
        }
        proposedEndDateTimeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getProposedEndDateTimeBuilder() {
      return getProposedEndDateTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getProposedEndDateTimeOrBuilder() {
      if ((proposedEndTimeCase_ == 8) && (proposedEndDateTimeBuilder_ != null)) {
        return proposedEndDateTimeBuilder_.getMessageOrBuilder();
      } else {
        if (proposedEndTimeCase_ == 8) {
          return (com.google.protobuf.StringValue) proposedEndTime_;
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The proposed end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue proposed_end_date_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getProposedEndDateTimeFieldBuilder() {
      if (proposedEndDateTimeBuilder_ == null) {
        if (!(proposedEndTimeCase_ == 8)) {
          proposedEndTime_ = com.google.protobuf.StringValue.getDefaultInstance();
        }
        proposedEndDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                (com.google.protobuf.StringValue) proposedEndTime_,
                getParentForChildren(),
                isClean());
        proposedEndTime_ = null;
      }
      proposedEndTimeCase_ = 8;
      onChanged();;
      return proposedEndDateTimeBuilder_;
    }

    /**
     * <pre>
     * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for proposedEndTimeType.
     */
    @java.lang.Override
    public int getProposedEndTimeTypeValue() {
      if (proposedEndTimeCase_ == 9) {
        return ((java.lang.Integer) proposedEndTime_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for proposedEndTimeType to set.
     * @return This builder for chaining.
     */
    public Builder setProposedEndTimeTypeValue(int value) {
      proposedEndTimeCase_ = 9;
      proposedEndTime_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposedEndTimeType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getProposedEndTimeType() {
      if (proposedEndTimeCase_ == 9) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
            (java.lang.Integer) proposedEndTime_);
        return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
    }
    /**
     * <pre>
     * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The proposedEndTimeType to set.
     * @return This builder for chaining.
     */
    public Builder setProposedEndTimeType(com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proposedEndTimeCase_ = 9;
      proposedEndTime_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType proposed_end_time_type = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProposedEndTimeType() {
      if (proposedEndTimeCase_ == 9) {
        proposedEndTimeCase_ = 0;
        proposedEndTime_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> approvedEndDateTimeBuilder_;
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the approvedEndDateTime field is set.
     */
    @java.lang.Override
    public boolean hasApprovedEndDateTime() {
      return approvedEndTimeCase_ == 10;
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvedEndDateTime.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getApprovedEndDateTime() {
      if (approvedEndDateTimeBuilder_ == null) {
        if (approvedEndTimeCase_ == 10) {
          return (com.google.protobuf.StringValue) approvedEndTime_;
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      } else {
        if (approvedEndTimeCase_ == 10) {
          return approvedEndDateTimeBuilder_.getMessage();
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedEndDateTime(com.google.protobuf.StringValue value) {
      if (approvedEndDateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approvedEndTime_ = value;
        onChanged();
      } else {
        approvedEndDateTimeBuilder_.setMessage(value);
      }
      approvedEndTimeCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedEndDateTime(
        com.google.protobuf.StringValue.Builder builderForValue) {
      if (approvedEndDateTimeBuilder_ == null) {
        approvedEndTime_ = builderForValue.build();
        onChanged();
      } else {
        approvedEndDateTimeBuilder_.setMessage(builderForValue.build());
      }
      approvedEndTimeCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeApprovedEndDateTime(com.google.protobuf.StringValue value) {
      if (approvedEndDateTimeBuilder_ == null) {
        if (approvedEndTimeCase_ == 10 &&
            approvedEndTime_ != com.google.protobuf.StringValue.getDefaultInstance()) {
          approvedEndTime_ = com.google.protobuf.StringValue.newBuilder((com.google.protobuf.StringValue) approvedEndTime_)
              .mergeFrom(value).buildPartial();
        } else {
          approvedEndTime_ = value;
        }
        onChanged();
      } else {
        if (approvedEndTimeCase_ == 10) {
          approvedEndDateTimeBuilder_.mergeFrom(value);
        }
        approvedEndDateTimeBuilder_.setMessage(value);
      }
      approvedEndTimeCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearApprovedEndDateTime() {
      if (approvedEndDateTimeBuilder_ == null) {
        if (approvedEndTimeCase_ == 10) {
          approvedEndTimeCase_ = 0;
          approvedEndTime_ = null;
          onChanged();
        }
      } else {
        if (approvedEndTimeCase_ == 10) {
          approvedEndTimeCase_ = 0;
          approvedEndTime_ = null;
        }
        approvedEndDateTimeBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.StringValue.Builder getApprovedEndDateTimeBuilder() {
      return getApprovedEndDateTimeFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getApprovedEndDateTimeOrBuilder() {
      if ((approvedEndTimeCase_ == 10) && (approvedEndDateTimeBuilder_ != null)) {
        return approvedEndDateTimeBuilder_.getMessageOrBuilder();
      } else {
        if (approvedEndTimeCase_ == 10) {
          return (com.google.protobuf.StringValue) approvedEndTime_;
        }
        return com.google.protobuf.StringValue.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The approved end time in yyyy-MM-dd HH:mm:ss format.
     * </pre>
     *
     * <code>.google.protobuf.StringValue approved_end_date_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder> 
        getApprovedEndDateTimeFieldBuilder() {
      if (approvedEndDateTimeBuilder_ == null) {
        if (!(approvedEndTimeCase_ == 10)) {
          approvedEndTime_ = com.google.protobuf.StringValue.getDefaultInstance();
        }
        approvedEndDateTimeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.StringValue, com.google.protobuf.StringValue.Builder, com.google.protobuf.StringValueOrBuilder>(
                (com.google.protobuf.StringValue) approvedEndTime_,
                getParentForChildren(),
                isClean());
        approvedEndTime_ = null;
      }
      approvedEndTimeCase_ = 10;
      onChanged();;
      return approvedEndDateTimeBuilder_;
    }

    /**
     * <pre>
     * Output only. The approved end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for approvedEndTimeType.
     */
    @java.lang.Override
    public int getApprovedEndTimeTypeValue() {
      if (approvedEndTimeCase_ == 11) {
        return ((java.lang.Integer) approvedEndTime_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The approved end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for approvedEndTimeType to set.
     * @return This builder for chaining.
     */
    public Builder setApprovedEndTimeTypeValue(int value) {
      approvedEndTimeCase_ = 11;
      approvedEndTime_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvedEndTimeType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType getApprovedEndTimeType() {
      if (approvedEndTimeCase_ == 11) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType result = com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.valueOf(
            (java.lang.Integer) approvedEndTime_);
        return result == null ? com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType.UNSPECIFIED;
    }
    /**
     * <pre>
     * Output only. The approved end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The approvedEndTimeType to set.
     * @return This builder for chaining.
     */
    public Builder setApprovedEndTimeType(com.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      approvedEndTimeCase_ = 11;
      approvedEndTime_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The approved end time as a well-defined type, e.g. FOREVER.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.TimeTypeEnum.TimeType approved_end_time_type = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearApprovedEndTimeType() {
      if (approvedEndTimeCase_ == 11) {
        approvedEndTimeCase_ = 0;
        approvedEndTime_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> proposedSpendingLimitMicrosBuilder_;
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the proposedSpendingLimitMicros field is set.
     */
    @java.lang.Override
    public boolean hasProposedSpendingLimitMicros() {
      return proposedSpendingLimitCase_ == 12;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposedSpendingLimitMicros.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getProposedSpendingLimitMicros() {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        if (proposedSpendingLimitCase_ == 12) {
          return (com.google.protobuf.Int64Value) proposedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      } else {
        if (proposedSpendingLimitCase_ == 12) {
          return proposedSpendingLimitMicrosBuilder_.getMessage();
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        proposedSpendingLimit_ = value;
        onChanged();
      } else {
        proposedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      proposedSpendingLimitCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setProposedSpendingLimitMicros(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        proposedSpendingLimit_ = builderForValue.build();
        onChanged();
      } else {
        proposedSpendingLimitMicrosBuilder_.setMessage(builderForValue.build());
      }
      proposedSpendingLimitCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeProposedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        if (proposedSpendingLimitCase_ == 12 &&
            proposedSpendingLimit_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          proposedSpendingLimit_ = com.google.protobuf.Int64Value.newBuilder((com.google.protobuf.Int64Value) proposedSpendingLimit_)
              .mergeFrom(value).buildPartial();
        } else {
          proposedSpendingLimit_ = value;
        }
        onChanged();
      } else {
        if (proposedSpendingLimitCase_ == 12) {
          proposedSpendingLimitMicrosBuilder_.mergeFrom(value);
        }
        proposedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      proposedSpendingLimitCase_ = 12;
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearProposedSpendingLimitMicros() {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        if (proposedSpendingLimitCase_ == 12) {
          proposedSpendingLimitCase_ = 0;
          proposedSpendingLimit_ = null;
          onChanged();
        }
      } else {
        if (proposedSpendingLimitCase_ == 12) {
          proposedSpendingLimitCase_ = 0;
          proposedSpendingLimit_ = null;
        }
        proposedSpendingLimitMicrosBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getProposedSpendingLimitMicrosBuilder() {
      return getProposedSpendingLimitMicrosFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getProposedSpendingLimitMicrosOrBuilder() {
      if ((proposedSpendingLimitCase_ == 12) && (proposedSpendingLimitMicrosBuilder_ != null)) {
        return proposedSpendingLimitMicrosBuilder_.getMessageOrBuilder();
      } else {
        if (proposedSpendingLimitCase_ == 12) {
          return (com.google.protobuf.Int64Value) proposedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The proposed spending limit in micros.  One million is equivalent to
     * one unit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value proposed_spending_limit_micros = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getProposedSpendingLimitMicrosFieldBuilder() {
      if (proposedSpendingLimitMicrosBuilder_ == null) {
        if (!(proposedSpendingLimitCase_ == 12)) {
          proposedSpendingLimit_ = com.google.protobuf.Int64Value.getDefaultInstance();
        }
        proposedSpendingLimitMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                (com.google.protobuf.Int64Value) proposedSpendingLimit_,
                getParentForChildren(),
                isClean());
        proposedSpendingLimit_ = null;
      }
      proposedSpendingLimitCase_ = 12;
      onChanged();;
      return proposedSpendingLimitMicrosBuilder_;
    }

    /**
     * <pre>
     * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for proposedSpendingLimitType.
     */
    @java.lang.Override
    public int getProposedSpendingLimitTypeValue() {
      if (proposedSpendingLimitCase_ == 13) {
        return ((java.lang.Integer) proposedSpendingLimit_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for proposedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setProposedSpendingLimitTypeValue(int value) {
      proposedSpendingLimitCase_ = 13;
      proposedSpendingLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The proposedSpendingLimitType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getProposedSpendingLimitType() {
      if (proposedSpendingLimitCase_ == 13) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
            (java.lang.Integer) proposedSpendingLimit_);
        return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The proposedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setProposedSpendingLimitType(com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      proposedSpendingLimitCase_ = 13;
      proposedSpendingLimit_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The proposed spending limit as a well-defined type, e.g. INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType proposed_spending_limit_type = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearProposedSpendingLimitType() {
      if (proposedSpendingLimitCase_ == 13) {
        proposedSpendingLimitCase_ = 0;
        proposedSpendingLimit_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> approvedSpendingLimitMicrosBuilder_;
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the approvedSpendingLimitMicros field is set.
     */
    @java.lang.Override
    public boolean hasApprovedSpendingLimitMicros() {
      return approvedSpendingLimitCase_ == 14;
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvedSpendingLimitMicros.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getApprovedSpendingLimitMicros() {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        if (approvedSpendingLimitCase_ == 14) {
          return (com.google.protobuf.Int64Value) approvedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      } else {
        if (approvedSpendingLimitCase_ == 14) {
          return approvedSpendingLimitMicrosBuilder_.getMessage();
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        approvedSpendingLimit_ = value;
        onChanged();
      } else {
        approvedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      approvedSpendingLimitCase_ = 14;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setApprovedSpendingLimitMicros(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        approvedSpendingLimit_ = builderForValue.build();
        onChanged();
      } else {
        approvedSpendingLimitMicrosBuilder_.setMessage(builderForValue.build());
      }
      approvedSpendingLimitCase_ = 14;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeApprovedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        if (approvedSpendingLimitCase_ == 14 &&
            approvedSpendingLimit_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          approvedSpendingLimit_ = com.google.protobuf.Int64Value.newBuilder((com.google.protobuf.Int64Value) approvedSpendingLimit_)
              .mergeFrom(value).buildPartial();
        } else {
          approvedSpendingLimit_ = value;
        }
        onChanged();
      } else {
        if (approvedSpendingLimitCase_ == 14) {
          approvedSpendingLimitMicrosBuilder_.mergeFrom(value);
        }
        approvedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      approvedSpendingLimitCase_ = 14;
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearApprovedSpendingLimitMicros() {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        if (approvedSpendingLimitCase_ == 14) {
          approvedSpendingLimitCase_ = 0;
          approvedSpendingLimit_ = null;
          onChanged();
        }
      } else {
        if (approvedSpendingLimitCase_ == 14) {
          approvedSpendingLimitCase_ = 0;
          approvedSpendingLimit_ = null;
        }
        approvedSpendingLimitMicrosBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getApprovedSpendingLimitMicrosBuilder() {
      return getApprovedSpendingLimitMicrosFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getApprovedSpendingLimitMicrosOrBuilder() {
      if ((approvedSpendingLimitCase_ == 14) && (approvedSpendingLimitMicrosBuilder_ != null)) {
        return approvedSpendingLimitMicrosBuilder_.getMessageOrBuilder();
      } else {
        if (approvedSpendingLimitCase_ == 14) {
          return (com.google.protobuf.Int64Value) approvedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The approved spending limit in micros.  One million is equivalent to
     * one unit.  This will only be populated if the proposed spending limit
     * is finite, and will always be greater than or equal to the
     * proposed spending limit.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value approved_spending_limit_micros = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getApprovedSpendingLimitMicrosFieldBuilder() {
      if (approvedSpendingLimitMicrosBuilder_ == null) {
        if (!(approvedSpendingLimitCase_ == 14)) {
          approvedSpendingLimit_ = com.google.protobuf.Int64Value.getDefaultInstance();
        }
        approvedSpendingLimitMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                (com.google.protobuf.Int64Value) approvedSpendingLimit_,
                getParentForChildren(),
                isClean());
        approvedSpendingLimit_ = null;
      }
      approvedSpendingLimitCase_ = 14;
      onChanged();;
      return approvedSpendingLimitMicrosBuilder_;
    }

    /**
     * <pre>
     * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
     * will only be populated if the approved spending limit is INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for approvedSpendingLimitType.
     */
    @java.lang.Override
    public int getApprovedSpendingLimitTypeValue() {
      if (approvedSpendingLimitCase_ == 15) {
        return ((java.lang.Integer) approvedSpendingLimit_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
     * will only be populated if the approved spending limit is INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for approvedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setApprovedSpendingLimitTypeValue(int value) {
      approvedSpendingLimitCase_ = 15;
      approvedSpendingLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
     * will only be populated if the approved spending limit is INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The approvedSpendingLimitType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getApprovedSpendingLimitType() {
      if (approvedSpendingLimitCase_ == 15) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
            (java.lang.Integer) approvedSpendingLimit_);
        return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
    }
    /**
     * <pre>
     * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
     * will only be populated if the approved spending limit is INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The approvedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setApprovedSpendingLimitType(com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      approvedSpendingLimitCase_ = 15;
      approvedSpendingLimit_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The approved spending limit as a well-defined type, e.g. INFINITE.  This
     * will only be populated if the approved spending limit is INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType approved_spending_limit_type = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearApprovedSpendingLimitType() {
      if (approvedSpendingLimitCase_ == 15) {
        approvedSpendingLimitCase_ = 0;
        approvedSpendingLimit_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> adjustedSpendingLimitMicrosBuilder_;
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the adjustedSpendingLimitMicros field is set.
     */
    @java.lang.Override
    public boolean hasAdjustedSpendingLimitMicros() {
      return adjustedSpendingLimitCase_ == 16;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adjustedSpendingLimitMicros.
     */
    @java.lang.Override
    public com.google.protobuf.Int64Value getAdjustedSpendingLimitMicros() {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        if (adjustedSpendingLimitCase_ == 16) {
          return (com.google.protobuf.Int64Value) adjustedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      } else {
        if (adjustedSpendingLimitCase_ == 16) {
          return adjustedSpendingLimitMicrosBuilder_.getMessage();
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdjustedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        adjustedSpendingLimit_ = value;
        onChanged();
      } else {
        adjustedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      adjustedSpendingLimitCase_ = 16;
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setAdjustedSpendingLimitMicros(
        com.google.protobuf.Int64Value.Builder builderForValue) {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        adjustedSpendingLimit_ = builderForValue.build();
        onChanged();
      } else {
        adjustedSpendingLimitMicrosBuilder_.setMessage(builderForValue.build());
      }
      adjustedSpendingLimitCase_ = 16;
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeAdjustedSpendingLimitMicros(com.google.protobuf.Int64Value value) {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        if (adjustedSpendingLimitCase_ == 16 &&
            adjustedSpendingLimit_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          adjustedSpendingLimit_ = com.google.protobuf.Int64Value.newBuilder((com.google.protobuf.Int64Value) adjustedSpendingLimit_)
              .mergeFrom(value).buildPartial();
        } else {
          adjustedSpendingLimit_ = value;
        }
        onChanged();
      } else {
        if (adjustedSpendingLimitCase_ == 16) {
          adjustedSpendingLimitMicrosBuilder_.mergeFrom(value);
        }
        adjustedSpendingLimitMicrosBuilder_.setMessage(value);
      }
      adjustedSpendingLimitCase_ = 16;
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearAdjustedSpendingLimitMicros() {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        if (adjustedSpendingLimitCase_ == 16) {
          adjustedSpendingLimitCase_ = 0;
          adjustedSpendingLimit_ = null;
          onChanged();
        }
      } else {
        if (adjustedSpendingLimitCase_ == 16) {
          adjustedSpendingLimitCase_ = 0;
          adjustedSpendingLimit_ = null;
        }
        adjustedSpendingLimitMicrosBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.protobuf.Int64Value.Builder getAdjustedSpendingLimitMicrosBuilder() {
      return getAdjustedSpendingLimitMicrosFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int64ValueOrBuilder getAdjustedSpendingLimitMicrosOrBuilder() {
      if ((adjustedSpendingLimitCase_ == 16) && (adjustedSpendingLimitMicrosBuilder_ != null)) {
        return adjustedSpendingLimitMicrosBuilder_.getMessageOrBuilder();
      } else {
        if (adjustedSpendingLimitCase_ == 16) {
          return (com.google.protobuf.Int64Value) adjustedSpendingLimit_;
        }
        return com.google.protobuf.Int64Value.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit in micros.  One million is equivalent to
     * one unit.
     * If the approved spending limit is finite, the adjusted
     * spending limit may vary depending on the types of adjustments applied
     * to this budget, if applicable.
     * The different kinds of adjustments are described here:
     * https://support.google.com/google-ads/answer/1704323
     * For example, a debit adjustment reduces how much the account is
     * allowed to spend.
     * </pre>
     *
     * <code>.google.protobuf.Int64Value adjusted_spending_limit_micros = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder> 
        getAdjustedSpendingLimitMicrosFieldBuilder() {
      if (adjustedSpendingLimitMicrosBuilder_ == null) {
        if (!(adjustedSpendingLimitCase_ == 16)) {
          adjustedSpendingLimit_ = com.google.protobuf.Int64Value.getDefaultInstance();
        }
        adjustedSpendingLimitMicrosBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value, com.google.protobuf.Int64Value.Builder, com.google.protobuf.Int64ValueOrBuilder>(
                (com.google.protobuf.Int64Value) adjustedSpendingLimit_,
                getParentForChildren(),
                isClean());
        adjustedSpendingLimit_ = null;
      }
      adjustedSpendingLimitCase_ = 16;
      onChanged();;
      return adjustedSpendingLimitMicrosBuilder_;
    }

    /**
     * <pre>
     * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
     * This will only be populated if the adjusted spending limit is INFINITE,
     * which is guaranteed to be true if the approved spending limit is
     * INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for adjustedSpendingLimitType.
     */
    @java.lang.Override
    public int getAdjustedSpendingLimitTypeValue() {
      if (adjustedSpendingLimitCase_ == 17) {
        return ((java.lang.Integer) adjustedSpendingLimit_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
     * This will only be populated if the adjusted spending limit is INFINITE,
     * which is guaranteed to be true if the approved spending limit is
     * INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for adjustedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setAdjustedSpendingLimitTypeValue(int value) {
      adjustedSpendingLimitCase_ = 17;
      adjustedSpendingLimit_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
     * This will only be populated if the adjusted spending limit is INFINITE,
     * which is guaranteed to be true if the approved spending limit is
     * INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adjustedSpendingLimitType.
     */
    @java.lang.Override
    public com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType getAdjustedSpendingLimitType() {
      if (adjustedSpendingLimitCase_ == 17) {
        @SuppressWarnings("deprecation")
        com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType result = com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.valueOf(
            (java.lang.Integer) adjustedSpendingLimit_);
        return result == null ? com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNRECOGNIZED : result;
      }
      return com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType.UNSPECIFIED;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
     * This will only be populated if the adjusted spending limit is INFINITE,
     * which is guaranteed to be true if the approved spending limit is
     * INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The adjustedSpendingLimitType to set.
     * @return This builder for chaining.
     */
    public Builder setAdjustedSpendingLimitType(com.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      adjustedSpendingLimitCase_ = 17;
      adjustedSpendingLimit_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The adjusted spending limit as a well-defined type, e.g. INFINITE.
     * This will only be populated if the adjusted spending limit is INFINITE,
     * which is guaranteed to be true if the approved spending limit is
     * INFINITE.
     * </pre>
     *
     * <code>.google.ads.googleads.v4.enums.SpendingLimitTypeEnum.SpendingLimitType adjusted_spending_limit_type = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAdjustedSpendingLimitType() {
      if (adjustedSpendingLimitCase_ == 17) {
        adjustedSpendingLimitCase_ = 0;
        adjustedSpendingLimit_ = null;
        onChanged();
      }
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v4.resources.AccountBudget)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v4.resources.AccountBudget)
  private static final com.google.ads.googleads.v4.resources.AccountBudget DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v4.resources.AccountBudget();
  }

  public static com.google.ads.googleads.v4.resources.AccountBudget getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AccountBudget>
      PARSER = new com.google.protobuf.AbstractParser<AccountBudget>() {
    @java.lang.Override
    public AccountBudget parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AccountBudget(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AccountBudget> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AccountBudget> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v4.resources.AccountBudget getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

