// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v5/resources/ad_group_simulation.proto

package com.google.ads.googleads.v5.resources;

/**
 * <pre>
 * An ad group simulation. Supported combinations of advertising
 * channel type, simulation type and simulation modification method is
 * detailed below respectively.
 * 1. SEARCH - CPC_BID - DEFAULT
 * 2. SEARCH - CPC_BID - UNIFORM
 * 3. SEARCH - TARGET_CPA - UNIFORM
 * 4. SEARCH - TARGET_ROAS - UNIFORM
 * 5. DISPLAY - CPC_BID - DEFAULT
 * 6. DISPLAY - CPC_BID - UNIFORM
 * 7. DISPLAY - TARGET_CPA - UNIFORM
 * 8. VIDEO - CPV_BID - DEFAULT
 * 9. VIDEO - CPV_BID - UNIFORM
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v5.resources.AdGroupSimulation}
 */
public final class AdGroupSimulation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v5.resources.AdGroupSimulation)
    AdGroupSimulationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupSimulation.newBuilder() to construct.
  private AdGroupSimulation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupSimulation() {
    resourceName_ = "";
    type_ = 0;
    modificationMethod_ = 0;
    startDate_ = "";
    endDate_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AdGroupSimulation();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AdGroupSimulation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            resourceName_ = s;
            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            modificationMethod_ = rawValue;
            break;
          }
          case 66: {
            com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder subBuilder = null;
            if (pointListCase_ == 8) {
              subBuilder = ((com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_).toBuilder();
            }
            pointList_ =
                input.readMessage(com.google.ads.googleads.v5.common.CpcBidSimulationPointList.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_);
              pointList_ = subBuilder.buildPartial();
            }
            pointListCase_ = 8;
            break;
          }
          case 74: {
            com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder subBuilder = null;
            if (pointListCase_ == 9) {
              subBuilder = ((com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_).toBuilder();
            }
            pointList_ =
                input.readMessage(com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_);
              pointList_ = subBuilder.buildPartial();
            }
            pointListCase_ = 9;
            break;
          }
          case 82: {
            com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder subBuilder = null;
            if (pointListCase_ == 10) {
              subBuilder = ((com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_).toBuilder();
            }
            pointList_ =
                input.readMessage(com.google.ads.googleads.v5.common.CpvBidSimulationPointList.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_);
              pointList_ = subBuilder.buildPartial();
            }
            pointListCase_ = 10;
            break;
          }
          case 90: {
            com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder subBuilder = null;
            if (pointListCase_ == 11) {
              subBuilder = ((com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_).toBuilder();
            }
            pointList_ =
                input.readMessage(com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_);
              pointList_ = subBuilder.buildPartial();
            }
            pointListCase_ = 11;
            break;
          }
          case 96: {
            bitField0_ |= 0x00000001;
            adGroupId_ = input.readInt64();
            break;
          }
          case 106: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000002;
            startDate_ = s;
            break;
          }
          case 114: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000004;
            endDate_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v5.resources.AdGroupSimulationProto.internal_static_google_ads_googleads_v5_resources_AdGroupSimulation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v5.resources.AdGroupSimulationProto.internal_static_google_ads_googleads_v5_resources_AdGroupSimulation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v5.resources.AdGroupSimulation.class, com.google.ads.googleads.v5.resources.AdGroupSimulation.Builder.class);
  }

  private int bitField0_;
  private int pointListCase_ = 0;
  private java.lang.Object pointList_;
  public enum PointListCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CPC_BID_POINT_LIST(8),
    CPV_BID_POINT_LIST(10),
    TARGET_CPA_POINT_LIST(9),
    TARGET_ROAS_POINT_LIST(11),
    POINTLIST_NOT_SET(0);
    private final int value;
    private PointListCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PointListCase valueOf(int value) {
      return forNumber(value);
    }

    public static PointListCase forNumber(int value) {
      switch (value) {
        case 8: return CPC_BID_POINT_LIST;
        case 10: return CPV_BID_POINT_LIST;
        case 9: return TARGET_CPA_POINT_LIST;
        case 11: return TARGET_ROAS_POINT_LIST;
        case 0: return POINTLIST_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public PointListCase
  getPointListCase() {
    return PointListCase.forNumber(
        pointListCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object resourceName_;
  /**
   * <pre>
   * Output only. The resource name of the ad group simulation.
   * Ad group simulation resource names have the form:
   * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the ad group simulation.
   * Ad group simulation resource names have the form:
   * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AD_GROUP_ID_FIELD_NUMBER = 12;
  private long adGroupId_;
  /**
   * <pre>
   * Output only. Ad group id of the simulation.
   * </pre>
   *
   * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the adGroupId field is set.
   */
  @java.lang.Override
  public boolean hasAdGroupId() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. Ad group id of the simulation.
   * </pre>
   *
   * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adGroupId.
   */
  @java.lang.Override
  public long getAdGroupId() {
    return adGroupId_;
  }

  public static final int TYPE_FIELD_NUMBER = 3;
  private int type_;
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Output only. The field that the simulation modifies.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The type.
   */
  @java.lang.Override public com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType getType() {
    @SuppressWarnings("deprecation")
    com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.valueOf(type_);
    return result == null ? com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
  }

  public static final int MODIFICATION_METHOD_FIELD_NUMBER = 4;
  private int modificationMethod_;
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for modificationMethod.
   */
  @java.lang.Override public int getModificationMethodValue() {
    return modificationMethod_;
  }
  /**
   * <pre>
   * Output only. How the simulation modifies the field.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The modificationMethod.
   */
  @java.lang.Override public com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
    @SuppressWarnings("deprecation")
    com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.valueOf(modificationMethod_);
    return result == null ? com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
  }

  public static final int START_DATE_FIELD_NUMBER = 13;
  private volatile java.lang.Object startDate_;
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
   * </pre>
   *
   * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the startDate field is set.
   */
  @java.lang.Override
  public boolean hasStartDate() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
   * </pre>
   *
   * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The startDate.
   */
  @java.lang.Override
  public java.lang.String getStartDate() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      startDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
   * </pre>
   *
   * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for startDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getStartDateBytes() {
    java.lang.Object ref = startDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      startDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int END_DATE_FIELD_NUMBER = 14;
  private volatile java.lang.Object endDate_;
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
   * </pre>
   *
   * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the endDate field is set.
   */
  @java.lang.Override
  public boolean hasEndDate() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
   * </pre>
   *
   * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The endDate.
   */
  @java.lang.Override
  public java.lang.String getEndDate() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endDate_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
   * </pre>
   *
   * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for endDate.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getEndDateBytes() {
    java.lang.Object ref = endDate_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      endDate_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CPC_BID_POINT_LIST_FIELD_NUMBER = 8;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the cpcBidPointList field is set.
   */
  @java.lang.Override
  public boolean hasCpcBidPointList() {
    return pointListCase_ == 8;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The cpcBidPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.CpcBidSimulationPointList getCpcBidPointList() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPC_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
    if (pointListCase_ == 8) {
       return (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
  }

  public static final int CPV_BID_POINT_LIST_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPV_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the cpvBidPointList field is set.
   */
  @java.lang.Override
  public boolean hasCpvBidPointList() {
    return pointListCase_ == 10;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPV_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The cpvBidPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.CpvBidSimulationPointList getCpvBidPointList() {
    if (pointListCase_ == 10) {
       return (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is CPV_BID.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.CpvBidSimulationPointListOrBuilder getCpvBidPointListOrBuilder() {
    if (pointListCase_ == 10) {
       return (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_CPA_POINT_LIST_FIELD_NUMBER = 9;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetCpaPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetCpaPointList() {
    return pointListCase_ == 9;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetCpaPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.TargetCpaSimulationPointList getTargetCpaPointList() {
    if (pointListCase_ == 9) {
       return (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_CPA.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
    if (pointListCase_ == 9) {
       return (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
  }

  public static final int TARGET_ROAS_POINT_LIST_FIELD_NUMBER = 11;
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the targetRoasPointList field is set.
   */
  @java.lang.Override
  public boolean hasTargetRoasPointList() {
    return pointListCase_ == 11;
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The targetRoasPointList.
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.TargetRoasSimulationPointList getTargetRoasPointList() {
    if (pointListCase_ == 11) {
       return (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
  }
  /**
   * <pre>
   * Output only. Simulation points if the simulation type is TARGET_ROAS.
   * </pre>
   *
   * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v5.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
    if (pointListCase_ == 11) {
       return (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_;
    }
    return com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getResourceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      output.writeEnum(4, modificationMethod_);
    }
    if (pointListCase_ == 8) {
      output.writeMessage(8, (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 9) {
      output.writeMessage(9, (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 10) {
      output.writeMessage(10, (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 11) {
      output.writeMessage(11, (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(12, adGroupId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, startDate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, endDate_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getResourceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (type_ != com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, type_);
    }
    if (modificationMethod_ != com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, modificationMethod_);
    }
    if (pointListCase_ == 8) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 9) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_);
    }
    if (pointListCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_);
    }
    if (pointListCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(12, adGroupId_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, startDate_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, endDate_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v5.resources.AdGroupSimulation)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v5.resources.AdGroupSimulation other = (com.google.ads.googleads.v5.resources.AdGroupSimulation) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasAdGroupId() != other.hasAdGroupId()) return false;
    if (hasAdGroupId()) {
      if (getAdGroupId()
          != other.getAdGroupId()) return false;
    }
    if (type_ != other.type_) return false;
    if (modificationMethod_ != other.modificationMethod_) return false;
    if (hasStartDate() != other.hasStartDate()) return false;
    if (hasStartDate()) {
      if (!getStartDate()
          .equals(other.getStartDate())) return false;
    }
    if (hasEndDate() != other.hasEndDate()) return false;
    if (hasEndDate()) {
      if (!getEndDate()
          .equals(other.getEndDate())) return false;
    }
    if (!getPointListCase().equals(other.getPointListCase())) return false;
    switch (pointListCase_) {
      case 8:
        if (!getCpcBidPointList()
            .equals(other.getCpcBidPointList())) return false;
        break;
      case 10:
        if (!getCpvBidPointList()
            .equals(other.getCpvBidPointList())) return false;
        break;
      case 9:
        if (!getTargetCpaPointList()
            .equals(other.getTargetCpaPointList())) return false;
        break;
      case 11:
        if (!getTargetRoasPointList()
            .equals(other.getTargetRoasPointList())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasAdGroupId()) {
      hash = (37 * hash) + AD_GROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getAdGroupId());
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODIFICATION_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + modificationMethod_;
    if (hasStartDate()) {
      hash = (37 * hash) + START_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getStartDate().hashCode();
    }
    if (hasEndDate()) {
      hash = (37 * hash) + END_DATE_FIELD_NUMBER;
      hash = (53 * hash) + getEndDate().hashCode();
    }
    switch (pointListCase_) {
      case 8:
        hash = (37 * hash) + CPC_BID_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getCpcBidPointList().hashCode();
        break;
      case 10:
        hash = (37 * hash) + CPV_BID_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getCpvBidPointList().hashCode();
        break;
      case 9:
        hash = (37 * hash) + TARGET_CPA_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetCpaPointList().hashCode();
        break;
      case 11:
        hash = (37 * hash) + TARGET_ROAS_POINT_LIST_FIELD_NUMBER;
        hash = (53 * hash) + getTargetRoasPointList().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v5.resources.AdGroupSimulation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v5.resources.AdGroupSimulation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An ad group simulation. Supported combinations of advertising
   * channel type, simulation type and simulation modification method is
   * detailed below respectively.
   * 1. SEARCH - CPC_BID - DEFAULT
   * 2. SEARCH - CPC_BID - UNIFORM
   * 3. SEARCH - TARGET_CPA - UNIFORM
   * 4. SEARCH - TARGET_ROAS - UNIFORM
   * 5. DISPLAY - CPC_BID - DEFAULT
   * 6. DISPLAY - CPC_BID - UNIFORM
   * 7. DISPLAY - TARGET_CPA - UNIFORM
   * 8. VIDEO - CPV_BID - DEFAULT
   * 9. VIDEO - CPV_BID - UNIFORM
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v5.resources.AdGroupSimulation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v5.resources.AdGroupSimulation)
      com.google.ads.googleads.v5.resources.AdGroupSimulationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v5.resources.AdGroupSimulationProto.internal_static_google_ads_googleads_v5_resources_AdGroupSimulation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v5.resources.AdGroupSimulationProto.internal_static_google_ads_googleads_v5_resources_AdGroupSimulation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v5.resources.AdGroupSimulation.class, com.google.ads.googleads.v5.resources.AdGroupSimulation.Builder.class);
    }

    // Construct using com.google.ads.googleads.v5.resources.AdGroupSimulation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceName_ = "";

      adGroupId_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;

      modificationMethod_ = 0;

      startDate_ = "";
      bitField0_ = (bitField0_ & ~0x00000002);
      endDate_ = "";
      bitField0_ = (bitField0_ & ~0x00000004);
      pointListCase_ = 0;
      pointList_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v5.resources.AdGroupSimulationProto.internal_static_google_ads_googleads_v5_resources_AdGroupSimulation_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v5.resources.AdGroupSimulation getDefaultInstanceForType() {
      return com.google.ads.googleads.v5.resources.AdGroupSimulation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v5.resources.AdGroupSimulation build() {
      com.google.ads.googleads.v5.resources.AdGroupSimulation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v5.resources.AdGroupSimulation buildPartial() {
      com.google.ads.googleads.v5.resources.AdGroupSimulation result = new com.google.ads.googleads.v5.resources.AdGroupSimulation(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.resourceName_ = resourceName_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adGroupId_ = adGroupId_;
        to_bitField0_ |= 0x00000001;
      }
      result.type_ = type_;
      result.modificationMethod_ = modificationMethod_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        to_bitField0_ |= 0x00000002;
      }
      result.startDate_ = startDate_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        to_bitField0_ |= 0x00000004;
      }
      result.endDate_ = endDate_;
      if (pointListCase_ == 8) {
        if (cpcBidPointListBuilder_ == null) {
          result.pointList_ = pointList_;
        } else {
          result.pointList_ = cpcBidPointListBuilder_.build();
        }
      }
      if (pointListCase_ == 10) {
        if (cpvBidPointListBuilder_ == null) {
          result.pointList_ = pointList_;
        } else {
          result.pointList_ = cpvBidPointListBuilder_.build();
        }
      }
      if (pointListCase_ == 9) {
        if (targetCpaPointListBuilder_ == null) {
          result.pointList_ = pointList_;
        } else {
          result.pointList_ = targetCpaPointListBuilder_.build();
        }
      }
      if (pointListCase_ == 11) {
        if (targetRoasPointListBuilder_ == null) {
          result.pointList_ = pointList_;
        } else {
          result.pointList_ = targetRoasPointListBuilder_.build();
        }
      }
      result.bitField0_ = to_bitField0_;
      result.pointListCase_ = pointListCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v5.resources.AdGroupSimulation) {
        return mergeFrom((com.google.ads.googleads.v5.resources.AdGroupSimulation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v5.resources.AdGroupSimulation other) {
      if (other == com.google.ads.googleads.v5.resources.AdGroupSimulation.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (other.hasAdGroupId()) {
        setAdGroupId(other.getAdGroupId());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.modificationMethod_ != 0) {
        setModificationMethodValue(other.getModificationMethodValue());
      }
      if (other.hasStartDate()) {
        bitField0_ |= 0x00000002;
        startDate_ = other.startDate_;
        onChanged();
      }
      if (other.hasEndDate()) {
        bitField0_ |= 0x00000004;
        endDate_ = other.endDate_;
        onChanged();
      }
      switch (other.getPointListCase()) {
        case CPC_BID_POINT_LIST: {
          mergeCpcBidPointList(other.getCpcBidPointList());
          break;
        }
        case CPV_BID_POINT_LIST: {
          mergeCpvBidPointList(other.getCpvBidPointList());
          break;
        }
        case TARGET_CPA_POINT_LIST: {
          mergeTargetCpaPointList(other.getTargetCpaPointList());
          break;
        }
        case TARGET_ROAS_POINT_LIST: {
          mergeTargetRoasPointList(other.getTargetRoasPointList());
          break;
        }
        case POINTLIST_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ads.googleads.v5.resources.AdGroupSimulation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ads.googleads.v5.resources.AdGroupSimulation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int pointListCase_ = 0;
    private java.lang.Object pointList_;
    public PointListCase
        getPointListCase() {
      return PointListCase.forNumber(
          pointListCase_);
    }

    public Builder clearPointList() {
      pointListCase_ = 0;
      pointList_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the ad group simulation.
     * Ad group simulation resource names have the form:
     * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group simulation.
     * Ad group simulation resource names have the form:
     * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group simulation.
     * Ad group simulation resource names have the form:
     * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group simulation.
     * Ad group simulation resource names have the form:
     * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      
      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the ad group simulation.
     * Ad group simulation resource names have the form:
     * `customers/{customer_id}/adGroupSimulations/{ad_group_id}~{type}~{modification_method}~{start_date}~{end_date}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      resourceName_ = value;
      onChanged();
      return this;
    }

    private long adGroupId_ ;
    /**
     * <pre>
     * Output only. Ad group id of the simulation.
     * </pre>
     *
     * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the adGroupId field is set.
     */
    @java.lang.Override
    public boolean hasAdGroupId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Output only. Ad group id of the simulation.
     * </pre>
     *
     * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adGroupId.
     */
    @java.lang.Override
    public long getAdGroupId() {
      return adGroupId_;
    }
    /**
     * <pre>
     * Output only. Ad group id of the simulation.
     * </pre>
     *
     * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The adGroupId to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupId(long value) {
      bitField0_ |= 0x00000001;
      adGroupId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Ad group id of the simulation.
     * </pre>
     *
     * <code>int64 ad_group_id = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAdGroupId() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adGroupId_ = 0L;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The type.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType getType() {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType result = com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.valueOf(type_);
      return result == null ? com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The field that the simulation modifies.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationTypeEnum.SimulationType type = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private int modificationMethod_ = 0;
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for modificationMethod.
     */
    @java.lang.Override public int getModificationMethodValue() {
      return modificationMethod_;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethodValue(int value) {
      
      modificationMethod_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The modificationMethod.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod getModificationMethod() {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod result = com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.valueOf(modificationMethod_);
      return result == null ? com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The modificationMethod to set.
     * @return This builder for chaining.
     */
    public Builder setModificationMethod(com.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      modificationMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. How the simulation modifies the field.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.enums.SimulationModificationMethodEnum.SimulationModificationMethod modification_method = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearModificationMethod() {
      
      modificationMethod_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object startDate_ = "";
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the startDate field is set.
     */
    public boolean hasStartDate() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The startDate.
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        startDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for startDate.
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDate(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
      startDate_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStartDate() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startDate_ = getDefaultInstance().getStartDate();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. First day on which the simulation is based, in YYYY-MM-DD format.
     * </pre>
     *
     * <code>string start_date = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for startDate to set.
     * @return This builder for chaining.
     */
    public Builder setStartDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000002;
      startDate_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object endDate_ = "";
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the endDate field is set.
     */
    public boolean hasEndDate() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The endDate.
     */
    public java.lang.String getEndDate() {
      java.lang.Object ref = endDate_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endDate_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for endDate.
     */
    public com.google.protobuf.ByteString
        getEndDateBytes() {
      java.lang.Object ref = endDate_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        endDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDate(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
      endDate_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearEndDate() {
      bitField0_ = (bitField0_ & ~0x00000004);
      endDate_ = getDefaultInstance().getEndDate();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Last day on which the simulation is based, in YYYY-MM-DD format
     * </pre>
     *
     * <code>string end_date = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for endDate to set.
     * @return This builder for chaining.
     */
    public Builder setEndDateBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000004;
      endDate_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.CpcBidSimulationPointList, com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpcBidSimulationPointListOrBuilder> cpcBidPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the cpcBidPointList field is set.
     */
    @java.lang.Override
    public boolean hasCpcBidPointList() {
      return pointListCase_ == 8;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The cpcBidPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.CpcBidSimulationPointList getCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 8) {
          return cpcBidPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(com.google.ads.googleads.v5.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpcBidPointList(
        com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder builderForValue) {
      if (cpcBidPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        cpcBidPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeCpcBidPointList(com.google.ads.googleads.v5.common.CpcBidSimulationPointList value) {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8 &&
            pointList_ != com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v5.common.CpcBidSimulationPointList.newBuilder((com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 8) {
          cpcBidPointListBuilder_.mergeFrom(value);
        }
        cpcBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 8;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearCpcBidPointList() {
      if (cpcBidPointListBuilder_ == null) {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 8) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        cpcBidPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder getCpcBidPointListBuilder() {
      return getCpcBidPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.CpcBidSimulationPointListOrBuilder getCpcBidPointListOrBuilder() {
      if ((pointListCase_ == 8) && (cpcBidPointListBuilder_ != null)) {
        return cpcBidPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 8) {
          return (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPC_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpcBidSimulationPointList cpc_bid_point_list = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.CpcBidSimulationPointList, com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpcBidSimulationPointListOrBuilder> 
        getCpcBidPointListFieldBuilder() {
      if (cpcBidPointListBuilder_ == null) {
        if (!(pointListCase_ == 8)) {
          pointList_ = com.google.ads.googleads.v5.common.CpcBidSimulationPointList.getDefaultInstance();
        }
        cpcBidPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v5.common.CpcBidSimulationPointList, com.google.ads.googleads.v5.common.CpcBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpcBidSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v5.common.CpcBidSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 8;
      onChanged();;
      return cpcBidPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.CpvBidSimulationPointList, com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpvBidSimulationPointListOrBuilder> cpvBidPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the cpvBidPointList field is set.
     */
    @java.lang.Override
    public boolean hasCpvBidPointList() {
      return pointListCase_ == 10;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The cpvBidPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.CpvBidSimulationPointList getCpvBidPointList() {
      if (cpvBidPointListBuilder_ == null) {
        if (pointListCase_ == 10) {
          return (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 10) {
          return cpvBidPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpvBidPointList(com.google.ads.googleads.v5.common.CpvBidSimulationPointList value) {
      if (cpvBidPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        cpvBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setCpvBidPointList(
        com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder builderForValue) {
      if (cpvBidPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        cpvBidPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeCpvBidPointList(com.google.ads.googleads.v5.common.CpvBidSimulationPointList value) {
      if (cpvBidPointListBuilder_ == null) {
        if (pointListCase_ == 10 &&
            pointList_ != com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v5.common.CpvBidSimulationPointList.newBuilder((com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 10) {
          cpvBidPointListBuilder_.mergeFrom(value);
        }
        cpvBidPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 10;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearCpvBidPointList() {
      if (cpvBidPointListBuilder_ == null) {
        if (pointListCase_ == 10) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 10) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        cpvBidPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder getCpvBidPointListBuilder() {
      return getCpvBidPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.CpvBidSimulationPointListOrBuilder getCpvBidPointListOrBuilder() {
      if ((pointListCase_ == 10) && (cpvBidPointListBuilder_ != null)) {
        return cpvBidPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 10) {
          return (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is CPV_BID.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.CpvBidSimulationPointList cpv_bid_point_list = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.CpvBidSimulationPointList, com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpvBidSimulationPointListOrBuilder> 
        getCpvBidPointListFieldBuilder() {
      if (cpvBidPointListBuilder_ == null) {
        if (!(pointListCase_ == 10)) {
          pointList_ = com.google.ads.googleads.v5.common.CpvBidSimulationPointList.getDefaultInstance();
        }
        cpvBidPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v5.common.CpvBidSimulationPointList, com.google.ads.googleads.v5.common.CpvBidSimulationPointList.Builder, com.google.ads.googleads.v5.common.CpvBidSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v5.common.CpvBidSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 10;
      onChanged();;
      return cpvBidPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.TargetCpaSimulationPointList, com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetCpaSimulationPointListOrBuilder> targetCpaPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetCpaPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetCpaPointList() {
      return pointListCase_ == 9;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetCpaPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.TargetCpaSimulationPointList getTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 9) {
          return (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 9) {
          return targetCpaPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(com.google.ads.googleads.v5.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetCpaPointList(
        com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder builderForValue) {
      if (targetCpaPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetCpaPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetCpaPointList(com.google.ads.googleads.v5.common.TargetCpaSimulationPointList value) {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 9 &&
            pointList_ != com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.newBuilder((com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 9) {
          targetCpaPointListBuilder_.mergeFrom(value);
        }
        targetCpaPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 9;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetCpaPointList() {
      if (targetCpaPointListBuilder_ == null) {
        if (pointListCase_ == 9) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 9) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetCpaPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder getTargetCpaPointListBuilder() {
      return getTargetCpaPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.TargetCpaSimulationPointListOrBuilder getTargetCpaPointListOrBuilder() {
      if ((pointListCase_ == 9) && (targetCpaPointListBuilder_ != null)) {
        return targetCpaPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 9) {
          return (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_CPA.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetCpaSimulationPointList target_cpa_point_list = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.TargetCpaSimulationPointList, com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetCpaSimulationPointListOrBuilder> 
        getTargetCpaPointListFieldBuilder() {
      if (targetCpaPointListBuilder_ == null) {
        if (!(pointListCase_ == 9)) {
          pointList_ = com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.getDefaultInstance();
        }
        targetCpaPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v5.common.TargetCpaSimulationPointList, com.google.ads.googleads.v5.common.TargetCpaSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetCpaSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v5.common.TargetCpaSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 9;
      onChanged();;
      return targetCpaPointListBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.TargetRoasSimulationPointList, com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetRoasSimulationPointListOrBuilder> targetRoasPointListBuilder_;
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the targetRoasPointList field is set.
     */
    @java.lang.Override
    public boolean hasTargetRoasPointList() {
      return pointListCase_ == 11;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The targetRoasPointList.
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.TargetRoasSimulationPointList getTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 11) {
          return (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
      } else {
        if (pointListCase_ == 11) {
          return targetRoasPointListBuilder_.getMessage();
        }
        return com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(com.google.ads.googleads.v5.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pointList_ = value;
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setTargetRoasPointList(
        com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder builderForValue) {
      if (targetRoasPointListBuilder_ == null) {
        pointList_ = builderForValue.build();
        onChanged();
      } else {
        targetRoasPointListBuilder_.setMessage(builderForValue.build());
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeTargetRoasPointList(com.google.ads.googleads.v5.common.TargetRoasSimulationPointList value) {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 11 &&
            pointList_ != com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance()) {
          pointList_ = com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.newBuilder((com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_)
              .mergeFrom(value).buildPartial();
        } else {
          pointList_ = value;
        }
        onChanged();
      } else {
        if (pointListCase_ == 11) {
          targetRoasPointListBuilder_.mergeFrom(value);
        }
        targetRoasPointListBuilder_.setMessage(value);
      }
      pointListCase_ = 11;
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearTargetRoasPointList() {
      if (targetRoasPointListBuilder_ == null) {
        if (pointListCase_ == 11) {
          pointListCase_ = 0;
          pointList_ = null;
          onChanged();
        }
      } else {
        if (pointListCase_ == 11) {
          pointListCase_ = 0;
          pointList_ = null;
        }
        targetRoasPointListBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder getTargetRoasPointListBuilder() {
      return getTargetRoasPointListFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v5.common.TargetRoasSimulationPointListOrBuilder getTargetRoasPointListOrBuilder() {
      if ((pointListCase_ == 11) && (targetRoasPointListBuilder_ != null)) {
        return targetRoasPointListBuilder_.getMessageOrBuilder();
      } else {
        if (pointListCase_ == 11) {
          return (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_;
        }
        return com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Output only. Simulation points if the simulation type is TARGET_ROAS.
     * </pre>
     *
     * <code>.google.ads.googleads.v5.common.TargetRoasSimulationPointList target_roas_point_list = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v5.common.TargetRoasSimulationPointList, com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetRoasSimulationPointListOrBuilder> 
        getTargetRoasPointListFieldBuilder() {
      if (targetRoasPointListBuilder_ == null) {
        if (!(pointListCase_ == 11)) {
          pointList_ = com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.getDefaultInstance();
        }
        targetRoasPointListBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v5.common.TargetRoasSimulationPointList, com.google.ads.googleads.v5.common.TargetRoasSimulationPointList.Builder, com.google.ads.googleads.v5.common.TargetRoasSimulationPointListOrBuilder>(
                (com.google.ads.googleads.v5.common.TargetRoasSimulationPointList) pointList_,
                getParentForChildren(),
                isClean());
        pointList_ = null;
      }
      pointListCase_ = 11;
      onChanged();;
      return targetRoasPointListBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v5.resources.AdGroupSimulation)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v5.resources.AdGroupSimulation)
  private static final com.google.ads.googleads.v5.resources.AdGroupSimulation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v5.resources.AdGroupSimulation();
  }

  public static com.google.ads.googleads.v5.resources.AdGroupSimulation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupSimulation>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupSimulation>() {
    @java.lang.Override
    public AdGroupSimulation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AdGroupSimulation(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AdGroupSimulation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupSimulation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v5.resources.AdGroupSimulation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

