// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v6/common/ad_type_infos.proto

package com.google.ads.googleads.v6.common;

/**
 * <pre>
 * A responsive search ad.
 * Responsive search ads let you create an ad that adapts to show more text, and
 * more relevant messages, to your customers. Enter multiple headlines and
 * descriptions when creating a responsive search ad, and over time, Google Ads
 * will automatically test different combinations and learn which combinations
 * perform best. By adapting your ad's content to more closely match potential
 * customers' search terms, responsive search ads may improve your campaign's
 * performance.
 * More information at https://support.google.com/google-ads/answer/7684791
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v6.common.ResponsiveSearchAdInfo}
 */
public final class ResponsiveSearchAdInfo extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v6.common.ResponsiveSearchAdInfo)
    ResponsiveSearchAdInfoOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResponsiveSearchAdInfo.newBuilder() to construct.
  private ResponsiveSearchAdInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResponsiveSearchAdInfo() {
    headlines_ = java.util.Collections.emptyList();
    descriptions_ = java.util.Collections.emptyList();
    path1_ = "";
    path2_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new ResponsiveSearchAdInfo();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResponsiveSearchAdInfo(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            if (!((mutable_bitField0_ & 0x00000001) != 0)) {
              headlines_ = new java.util.ArrayList<com.google.ads.googleads.v6.common.AdTextAsset>();
              mutable_bitField0_ |= 0x00000001;
            }
            headlines_.add(
                input.readMessage(com.google.ads.googleads.v6.common.AdTextAsset.parser(), extensionRegistry));
            break;
          }
          case 18: {
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              descriptions_ = new java.util.ArrayList<com.google.ads.googleads.v6.common.AdTextAsset>();
              mutable_bitField0_ |= 0x00000002;
            }
            descriptions_.add(
                input.readMessage(com.google.ads.googleads.v6.common.AdTextAsset.parser(), extensionRegistry));
            break;
          }
          case 42: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000001;
            path1_ = s;
            break;
          }
          case 50: {
            java.lang.String s = input.readStringRequireUtf8();
            bitField0_ |= 0x00000002;
            path2_ = s;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        headlines_ = java.util.Collections.unmodifiableList(headlines_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        descriptions_ = java.util.Collections.unmodifiableList(descriptions_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v6.common.AdTypeInfosProto.internal_static_google_ads_googleads_v6_common_ResponsiveSearchAdInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v6.common.AdTypeInfosProto.internal_static_google_ads_googleads_v6_common_ResponsiveSearchAdInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.class, com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.Builder.class);
  }

  private int bitField0_;
  public static final int HEADLINES_FIELD_NUMBER = 1;
  private java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> headlines_;
  /**
   * <pre>
   * List of text assets for headlines. When the ad serves the headlines will
   * be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> getHeadlinesList() {
    return headlines_;
  }
  /**
   * <pre>
   * List of text assets for headlines. When the ad serves the headlines will
   * be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
      getHeadlinesOrBuilderList() {
    return headlines_;
  }
  /**
   * <pre>
   * List of text assets for headlines. When the ad serves the headlines will
   * be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
   */
  @java.lang.Override
  public int getHeadlinesCount() {
    return headlines_.size();
  }
  /**
   * <pre>
   * List of text assets for headlines. When the ad serves the headlines will
   * be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.AdTextAsset getHeadlines(int index) {
    return headlines_.get(index);
  }
  /**
   * <pre>
   * List of text assets for headlines. When the ad serves the headlines will
   * be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.AdTextAssetOrBuilder getHeadlinesOrBuilder(
      int index) {
    return headlines_.get(index);
  }

  public static final int DESCRIPTIONS_FIELD_NUMBER = 2;
  private java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> descriptions_;
  /**
   * <pre>
   * List of text assets for descriptions. When the ad serves the descriptions
   * will be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> getDescriptionsList() {
    return descriptions_;
  }
  /**
   * <pre>
   * List of text assets for descriptions. When the ad serves the descriptions
   * will be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
      getDescriptionsOrBuilderList() {
    return descriptions_;
  }
  /**
   * <pre>
   * List of text assets for descriptions. When the ad serves the descriptions
   * will be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
   */
  @java.lang.Override
  public int getDescriptionsCount() {
    return descriptions_.size();
  }
  /**
   * <pre>
   * List of text assets for descriptions. When the ad serves the descriptions
   * will be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.AdTextAsset getDescriptions(int index) {
    return descriptions_.get(index);
  }
  /**
   * <pre>
   * List of text assets for descriptions. When the ad serves the descriptions
   * will be selected from this list.
   * </pre>
   *
   * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.AdTextAssetOrBuilder getDescriptionsOrBuilder(
      int index) {
    return descriptions_.get(index);
  }

  public static final int PATH1_FIELD_NUMBER = 5;
  private volatile java.lang.Object path1_;
  /**
   * <pre>
   * First part of text that may appear appended to the url displayed in the ad.
   * </pre>
   *
   * <code>string path1 = 5;</code>
   * @return Whether the path1 field is set.
   */
  @java.lang.Override
  public boolean hasPath1() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * First part of text that may appear appended to the url displayed in the ad.
   * </pre>
   *
   * <code>string path1 = 5;</code>
   * @return The path1.
   */
  @java.lang.Override
  public java.lang.String getPath1() {
    java.lang.Object ref = path1_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path1_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * First part of text that may appear appended to the url displayed in the ad.
   * </pre>
   *
   * <code>string path1 = 5;</code>
   * @return The bytes for path1.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPath1Bytes() {
    java.lang.Object ref = path1_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      path1_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATH2_FIELD_NUMBER = 6;
  private volatile java.lang.Object path2_;
  /**
   * <pre>
   * Second part of text that may appear appended to the url displayed in the
   * ad. This field can only be set when path1 is also set.
   * </pre>
   *
   * <code>string path2 = 6;</code>
   * @return Whether the path2 field is set.
   */
  @java.lang.Override
  public boolean hasPath2() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Second part of text that may appear appended to the url displayed in the
   * ad. This field can only be set when path1 is also set.
   * </pre>
   *
   * <code>string path2 = 6;</code>
   * @return The path2.
   */
  @java.lang.Override
  public java.lang.String getPath2() {
    java.lang.Object ref = path2_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      path2_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Second part of text that may appear appended to the url displayed in the
   * ad. This field can only be set when path1 is also set.
   * </pre>
   *
   * <code>string path2 = 6;</code>
   * @return The bytes for path2.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getPath2Bytes() {
    java.lang.Object ref = path2_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      path2_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    for (int i = 0; i < headlines_.size(); i++) {
      output.writeMessage(1, headlines_.get(i));
    }
    for (int i = 0; i < descriptions_.size(); i++) {
      output.writeMessage(2, descriptions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, path1_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, path2_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < headlines_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, headlines_.get(i));
    }
    for (int i = 0; i < descriptions_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, descriptions_.get(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, path1_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, path2_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo other = (com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo) obj;

    if (!getHeadlinesList()
        .equals(other.getHeadlinesList())) return false;
    if (!getDescriptionsList()
        .equals(other.getDescriptionsList())) return false;
    if (hasPath1() != other.hasPath1()) return false;
    if (hasPath1()) {
      if (!getPath1()
          .equals(other.getPath1())) return false;
    }
    if (hasPath2() != other.hasPath2()) return false;
    if (hasPath2()) {
      if (!getPath2()
          .equals(other.getPath2())) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getHeadlinesCount() > 0) {
      hash = (37 * hash) + HEADLINES_FIELD_NUMBER;
      hash = (53 * hash) + getHeadlinesList().hashCode();
    }
    if (getDescriptionsCount() > 0) {
      hash = (37 * hash) + DESCRIPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDescriptionsList().hashCode();
    }
    if (hasPath1()) {
      hash = (37 * hash) + PATH1_FIELD_NUMBER;
      hash = (53 * hash) + getPath1().hashCode();
    }
    if (hasPath2()) {
      hash = (37 * hash) + PATH2_FIELD_NUMBER;
      hash = (53 * hash) + getPath2().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A responsive search ad.
   * Responsive search ads let you create an ad that adapts to show more text, and
   * more relevant messages, to your customers. Enter multiple headlines and
   * descriptions when creating a responsive search ad, and over time, Google Ads
   * will automatically test different combinations and learn which combinations
   * perform best. By adapting your ad's content to more closely match potential
   * customers' search terms, responsive search ads may improve your campaign's
   * performance.
   * More information at https://support.google.com/google-ads/answer/7684791
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v6.common.ResponsiveSearchAdInfo}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v6.common.ResponsiveSearchAdInfo)
      com.google.ads.googleads.v6.common.ResponsiveSearchAdInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v6.common.AdTypeInfosProto.internal_static_google_ads_googleads_v6_common_ResponsiveSearchAdInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v6.common.AdTypeInfosProto.internal_static_google_ads_googleads_v6_common_ResponsiveSearchAdInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.class, com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.Builder.class);
    }

    // Construct using com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getHeadlinesFieldBuilder();
        getDescriptionsFieldBuilder();
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (headlinesBuilder_ == null) {
        headlines_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        headlinesBuilder_.clear();
      }
      if (descriptionsBuilder_ == null) {
        descriptions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        descriptionsBuilder_.clear();
      }
      path1_ = "";
      bitField0_ = (bitField0_ & ~0x00000004);
      path2_ = "";
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v6.common.AdTypeInfosProto.internal_static_google_ads_googleads_v6_common_ResponsiveSearchAdInfo_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo getDefaultInstanceForType() {
      return com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo build() {
      com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo buildPartial() {
      com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo result = new com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (headlinesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          headlines_ = java.util.Collections.unmodifiableList(headlines_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.headlines_ = headlines_;
      } else {
        result.headlines_ = headlinesBuilder_.build();
      }
      if (descriptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          descriptions_ = java.util.Collections.unmodifiableList(descriptions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.descriptions_ = descriptions_;
      } else {
        result.descriptions_ = descriptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        to_bitField0_ |= 0x00000001;
      }
      result.path1_ = path1_;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        to_bitField0_ |= 0x00000002;
      }
      result.path2_ = path2_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo) {
        return mergeFrom((com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo other) {
      if (other == com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo.getDefaultInstance()) return this;
      if (headlinesBuilder_ == null) {
        if (!other.headlines_.isEmpty()) {
          if (headlines_.isEmpty()) {
            headlines_ = other.headlines_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureHeadlinesIsMutable();
            headlines_.addAll(other.headlines_);
          }
          onChanged();
        }
      } else {
        if (!other.headlines_.isEmpty()) {
          if (headlinesBuilder_.isEmpty()) {
            headlinesBuilder_.dispose();
            headlinesBuilder_ = null;
            headlines_ = other.headlines_;
            bitField0_ = (bitField0_ & ~0x00000001);
            headlinesBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getHeadlinesFieldBuilder() : null;
          } else {
            headlinesBuilder_.addAllMessages(other.headlines_);
          }
        }
      }
      if (descriptionsBuilder_ == null) {
        if (!other.descriptions_.isEmpty()) {
          if (descriptions_.isEmpty()) {
            descriptions_ = other.descriptions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureDescriptionsIsMutable();
            descriptions_.addAll(other.descriptions_);
          }
          onChanged();
        }
      } else {
        if (!other.descriptions_.isEmpty()) {
          if (descriptionsBuilder_.isEmpty()) {
            descriptionsBuilder_.dispose();
            descriptionsBuilder_ = null;
            descriptions_ = other.descriptions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            descriptionsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getDescriptionsFieldBuilder() : null;
          } else {
            descriptionsBuilder_.addAllMessages(other.descriptions_);
          }
        }
      }
      if (other.hasPath1()) {
        bitField0_ |= 0x00000004;
        path1_ = other.path1_;
        onChanged();
      }
      if (other.hasPath2()) {
        bitField0_ |= 0x00000008;
        path2_ = other.path2_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> headlines_ =
      java.util.Collections.emptyList();
    private void ensureHeadlinesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        headlines_ = new java.util.ArrayList<com.google.ads.googleads.v6.common.AdTextAsset>(headlines_);
        bitField0_ |= 0x00000001;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> headlinesBuilder_;

    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> getHeadlinesList() {
      if (headlinesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(headlines_);
      } else {
        return headlinesBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public int getHeadlinesCount() {
      if (headlinesBuilder_ == null) {
        return headlines_.size();
      } else {
        return headlinesBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset getHeadlines(int index) {
      if (headlinesBuilder_ == null) {
        return headlines_.get(index);
      } else {
        return headlinesBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder setHeadlines(
        int index, com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (headlinesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadlinesIsMutable();
        headlines_.set(index, value);
        onChanged();
      } else {
        headlinesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder setHeadlines(
        int index, com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (headlinesBuilder_ == null) {
        ensureHeadlinesIsMutable();
        headlines_.set(index, builderForValue.build());
        onChanged();
      } else {
        headlinesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder addHeadlines(com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (headlinesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadlinesIsMutable();
        headlines_.add(value);
        onChanged();
      } else {
        headlinesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder addHeadlines(
        int index, com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (headlinesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHeadlinesIsMutable();
        headlines_.add(index, value);
        onChanged();
      } else {
        headlinesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder addHeadlines(
        com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (headlinesBuilder_ == null) {
        ensureHeadlinesIsMutable();
        headlines_.add(builderForValue.build());
        onChanged();
      } else {
        headlinesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder addHeadlines(
        int index, com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (headlinesBuilder_ == null) {
        ensureHeadlinesIsMutable();
        headlines_.add(index, builderForValue.build());
        onChanged();
      } else {
        headlinesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder addAllHeadlines(
        java.lang.Iterable<? extends com.google.ads.googleads.v6.common.AdTextAsset> values) {
      if (headlinesBuilder_ == null) {
        ensureHeadlinesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, headlines_);
        onChanged();
      } else {
        headlinesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder clearHeadlines() {
      if (headlinesBuilder_ == null) {
        headlines_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        headlinesBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public Builder removeHeadlines(int index) {
      if (headlinesBuilder_ == null) {
        ensureHeadlinesIsMutable();
        headlines_.remove(index);
        onChanged();
      } else {
        headlinesBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder getHeadlinesBuilder(
        int index) {
      return getHeadlinesFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAssetOrBuilder getHeadlinesOrBuilder(
        int index) {
      if (headlinesBuilder_ == null) {
        return headlines_.get(index);  } else {
        return headlinesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
         getHeadlinesOrBuilderList() {
      if (headlinesBuilder_ != null) {
        return headlinesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(headlines_);
      }
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder addHeadlinesBuilder() {
      return getHeadlinesFieldBuilder().addBuilder(
          com.google.ads.googleads.v6.common.AdTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder addHeadlinesBuilder(
        int index) {
      return getHeadlinesFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v6.common.AdTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * List of text assets for headlines. When the ad serves the headlines will
     * be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset headlines = 1;</code>
     */
    public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset.Builder> 
         getHeadlinesBuilderList() {
      return getHeadlinesFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
        getHeadlinesFieldBuilder() {
      if (headlinesBuilder_ == null) {
        headlinesBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder>(
                headlines_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        headlines_ = null;
      }
      return headlinesBuilder_;
    }

    private java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> descriptions_ =
      java.util.Collections.emptyList();
    private void ensureDescriptionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        descriptions_ = new java.util.ArrayList<com.google.ads.googleads.v6.common.AdTextAsset>(descriptions_);
        bitField0_ |= 0x00000002;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> descriptionsBuilder_;

    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset> getDescriptionsList() {
      if (descriptionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(descriptions_);
      } else {
        return descriptionsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public int getDescriptionsCount() {
      if (descriptionsBuilder_ == null) {
        return descriptions_.size();
      } else {
        return descriptionsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset getDescriptions(int index) {
      if (descriptionsBuilder_ == null) {
        return descriptions_.get(index);
      } else {
        return descriptionsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder setDescriptions(
        int index, com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (descriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescriptionsIsMutable();
        descriptions_.set(index, value);
        onChanged();
      } else {
        descriptionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder setDescriptions(
        int index, com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (descriptionsBuilder_ == null) {
        ensureDescriptionsIsMutable();
        descriptions_.set(index, builderForValue.build());
        onChanged();
      } else {
        descriptionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder addDescriptions(com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (descriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescriptionsIsMutable();
        descriptions_.add(value);
        onChanged();
      } else {
        descriptionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder addDescriptions(
        int index, com.google.ads.googleads.v6.common.AdTextAsset value) {
      if (descriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDescriptionsIsMutable();
        descriptions_.add(index, value);
        onChanged();
      } else {
        descriptionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder addDescriptions(
        com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (descriptionsBuilder_ == null) {
        ensureDescriptionsIsMutable();
        descriptions_.add(builderForValue.build());
        onChanged();
      } else {
        descriptionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder addDescriptions(
        int index, com.google.ads.googleads.v6.common.AdTextAsset.Builder builderForValue) {
      if (descriptionsBuilder_ == null) {
        ensureDescriptionsIsMutable();
        descriptions_.add(index, builderForValue.build());
        onChanged();
      } else {
        descriptionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder addAllDescriptions(
        java.lang.Iterable<? extends com.google.ads.googleads.v6.common.AdTextAsset> values) {
      if (descriptionsBuilder_ == null) {
        ensureDescriptionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, descriptions_);
        onChanged();
      } else {
        descriptionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder clearDescriptions() {
      if (descriptionsBuilder_ == null) {
        descriptions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        descriptionsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public Builder removeDescriptions(int index) {
      if (descriptionsBuilder_ == null) {
        ensureDescriptionsIsMutable();
        descriptions_.remove(index);
        onChanged();
      } else {
        descriptionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder getDescriptionsBuilder(
        int index) {
      return getDescriptionsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAssetOrBuilder getDescriptionsOrBuilder(
        int index) {
      if (descriptionsBuilder_ == null) {
        return descriptions_.get(index);  } else {
        return descriptionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public java.util.List<? extends com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
         getDescriptionsOrBuilderList() {
      if (descriptionsBuilder_ != null) {
        return descriptionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(descriptions_);
      }
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder addDescriptionsBuilder() {
      return getDescriptionsFieldBuilder().addBuilder(
          com.google.ads.googleads.v6.common.AdTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public com.google.ads.googleads.v6.common.AdTextAsset.Builder addDescriptionsBuilder(
        int index) {
      return getDescriptionsFieldBuilder().addBuilder(
          index, com.google.ads.googleads.v6.common.AdTextAsset.getDefaultInstance());
    }
    /**
     * <pre>
     * List of text assets for descriptions. When the ad serves the descriptions
     * will be selected from this list.
     * </pre>
     *
     * <code>repeated .google.ads.googleads.v6.common.AdTextAsset descriptions = 2;</code>
     */
    public java.util.List<com.google.ads.googleads.v6.common.AdTextAsset.Builder> 
         getDescriptionsBuilderList() {
      return getDescriptionsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder> 
        getDescriptionsFieldBuilder() {
      if (descriptionsBuilder_ == null) {
        descriptionsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.ads.googleads.v6.common.AdTextAsset, com.google.ads.googleads.v6.common.AdTextAsset.Builder, com.google.ads.googleads.v6.common.AdTextAssetOrBuilder>(
                descriptions_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        descriptions_ = null;
      }
      return descriptionsBuilder_;
    }

    private java.lang.Object path1_ = "";
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @return Whether the path1 field is set.
     */
    public boolean hasPath1() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @return The path1.
     */
    public java.lang.String getPath1() {
      java.lang.Object ref = path1_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path1_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @return The bytes for path1.
     */
    public com.google.protobuf.ByteString
        getPath1Bytes() {
      java.lang.Object ref = path1_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path1_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @param value The path1 to set.
     * @return This builder for chaining.
     */
    public Builder setPath1(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
      path1_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @return This builder for chaining.
     */
    public Builder clearPath1() {
      bitField0_ = (bitField0_ & ~0x00000004);
      path1_ = getDefaultInstance().getPath1();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * First part of text that may appear appended to the url displayed in the ad.
     * </pre>
     *
     * <code>string path1 = 5;</code>
     * @param value The bytes for path1 to set.
     * @return This builder for chaining.
     */
    public Builder setPath1Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000004;
      path1_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object path2_ = "";
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @return Whether the path2 field is set.
     */
    public boolean hasPath2() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @return The path2.
     */
    public java.lang.String getPath2() {
      java.lang.Object ref = path2_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        path2_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @return The bytes for path2.
     */
    public com.google.protobuf.ByteString
        getPath2Bytes() {
      java.lang.Object ref = path2_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        path2_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @param value The path2 to set.
     * @return This builder for chaining.
     */
    public Builder setPath2(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
      path2_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @return This builder for chaining.
     */
    public Builder clearPath2() {
      bitField0_ = (bitField0_ & ~0x00000008);
      path2_ = getDefaultInstance().getPath2();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Second part of text that may appear appended to the url displayed in the
     * ad. This field can only be set when path1 is also set.
     * </pre>
     *
     * <code>string path2 = 6;</code>
     * @param value The bytes for path2 to set.
     * @return This builder for chaining.
     */
    public Builder setPath2Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      bitField0_ |= 0x00000008;
      path2_ = value;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v6.common.ResponsiveSearchAdInfo)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v6.common.ResponsiveSearchAdInfo)
  private static final com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo();
  }

  public static com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResponsiveSearchAdInfo>
      PARSER = new com.google.protobuf.AbstractParser<ResponsiveSearchAdInfo>() {
    @java.lang.Override
    public ResponsiveSearchAdInfo parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResponsiveSearchAdInfo(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResponsiveSearchAdInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResponsiveSearchAdInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v6.common.ResponsiveSearchAdInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

