package com.google.ads.googleads.lib;

import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_GoogleAdsClient extends GoogleAdsClient {

  private final GoogleAdsAllVersions googleAdsAllVersions;

  private final Credentials credentials;

  private final String developerToken;

  private final String endpoint;

  private final Long loginCustomerId;

  private final Long linkedCustomerId;

  private final TransportChannelProvider transportChannelProvider;

  private AutoValue_GoogleAdsClient(
      GoogleAdsAllVersions googleAdsAllVersions,
      @Nullable Credentials credentials,
      String developerToken,
      String endpoint,
      @Nullable Long loginCustomerId,
      @Nullable Long linkedCustomerId,
      TransportChannelProvider transportChannelProvider) {
    this.googleAdsAllVersions = googleAdsAllVersions;
    this.credentials = credentials;
    this.developerToken = developerToken;
    this.endpoint = endpoint;
    this.loginCustomerId = loginCustomerId;
    this.linkedCustomerId = linkedCustomerId;
    this.transportChannelProvider = transportChannelProvider;
  }

  @Override
  protected GoogleAdsAllVersions getGoogleAdsAllVersions() {
    return googleAdsAllVersions;
  }

  @Nullable
  @Override
  public Credentials getCredentials() {
    return credentials;
  }

  @Override
  public String getDeveloperToken() {
    return developerToken;
  }

  @Override
  public String getEndpoint() {
    return endpoint;
  }

  @Nullable
  @Override
  public Long getLoginCustomerId() {
    return loginCustomerId;
  }

  @Nullable
  @Override
  public Long getLinkedCustomerId() {
    return linkedCustomerId;
  }

  @Override
  TransportChannelProvider getTransportChannelProvider() {
    return transportChannelProvider;
  }

  @Override
  public String toString() {
    return "GoogleAdsClient{"
        + "googleAdsAllVersions=" + googleAdsAllVersions + ", "
        + "credentials=" + credentials + ", "
        + "developerToken=" + developerToken + ", "
        + "endpoint=" + endpoint + ", "
        + "loginCustomerId=" + loginCustomerId + ", "
        + "linkedCustomerId=" + linkedCustomerId + ", "
        + "transportChannelProvider=" + transportChannelProvider
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof GoogleAdsClient) {
      GoogleAdsClient that = (GoogleAdsClient) o;
      return this.googleAdsAllVersions.equals(that.getGoogleAdsAllVersions())
          && (this.credentials == null ? that.getCredentials() == null : this.credentials.equals(that.getCredentials()))
          && this.developerToken.equals(that.getDeveloperToken())
          && this.endpoint.equals(that.getEndpoint())
          && (this.loginCustomerId == null ? that.getLoginCustomerId() == null : this.loginCustomerId.equals(that.getLoginCustomerId()))
          && (this.linkedCustomerId == null ? that.getLinkedCustomerId() == null : this.linkedCustomerId.equals(that.getLinkedCustomerId()))
          && this.transportChannelProvider.equals(that.getTransportChannelProvider());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= googleAdsAllVersions.hashCode();
    h$ *= 1000003;
    h$ ^= (credentials == null) ? 0 : credentials.hashCode();
    h$ *= 1000003;
    h$ ^= developerToken.hashCode();
    h$ *= 1000003;
    h$ ^= endpoint.hashCode();
    h$ *= 1000003;
    h$ ^= (loginCustomerId == null) ? 0 : loginCustomerId.hashCode();
    h$ *= 1000003;
    h$ ^= (linkedCustomerId == null) ? 0 : linkedCustomerId.hashCode();
    h$ *= 1000003;
    h$ ^= transportChannelProvider.hashCode();
    return h$;
  }

  @Override
  public GoogleAdsClient.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends GoogleAdsClient.Builder {
    private GoogleAdsAllVersions googleAdsAllVersions;
    private Credentials credentials;
    private String developerToken;
    private String endpoint;
    private Long loginCustomerId;
    private Long linkedCustomerId;
    private TransportChannelProvider transportChannelProvider;
    Builder() {
    }
    private Builder(GoogleAdsClient source) {
      this.googleAdsAllVersions = source.getGoogleAdsAllVersions();
      this.credentials = source.getCredentials();
      this.developerToken = source.getDeveloperToken();
      this.endpoint = source.getEndpoint();
      this.loginCustomerId = source.getLoginCustomerId();
      this.linkedCustomerId = source.getLinkedCustomerId();
      this.transportChannelProvider = source.getTransportChannelProvider();
    }
    @Override
    GoogleAdsClient.Builder setGoogleAdsAllVersions(GoogleAdsAllVersions googleAdsAllVersions) {
      if (googleAdsAllVersions == null) {
        throw new NullPointerException("Null googleAdsAllVersions");
      }
      this.googleAdsAllVersions = googleAdsAllVersions;
      return this;
    }
    @Override
    public GoogleAdsClient.Builder setCredentials(Credentials credentials) {
      this.credentials = credentials;
      return this;
    }
    @Override
    @Nullable public Credentials getCredentials() {
      return credentials;
    }
    @Override
    public GoogleAdsClient.Builder setDeveloperToken(String developerToken) {
      if (developerToken == null) {
        throw new NullPointerException("Null developerToken");
      }
      this.developerToken = developerToken;
      return this;
    }
    @Override
    public String getDeveloperToken() {
      if (developerToken == null) {
        throw new IllegalStateException("Property \"developerToken\" has not been set");
      }
      return developerToken;
    }
    @Override
    public GoogleAdsClient.Builder setEndpoint(String endpoint) {
      if (endpoint == null) {
        throw new NullPointerException("Null endpoint");
      }
      this.endpoint = endpoint;
      return this;
    }
    @Override
    public String getEndpoint() {
      if (endpoint == null) {
        throw new IllegalStateException("Property \"endpoint\" has not been set");
      }
      return endpoint;
    }
    @Override
    public GoogleAdsClient.Builder setLoginCustomerId(Long loginCustomerId) {
      this.loginCustomerId = loginCustomerId;
      return this;
    }
    @Override
    @Nullable public Long getLoginCustomerId() {
      return loginCustomerId;
    }
    @Override
    public GoogleAdsClient.Builder setLinkedCustomerId(Long linkedCustomerId) {
      this.linkedCustomerId = linkedCustomerId;
      return this;
    }
    @Override
    @Nullable public Long getLinkedCustomerId() {
      return linkedCustomerId;
    }
    @Override
    GoogleAdsClient.Builder setTransportChannelProvider(TransportChannelProvider transportChannelProvider) {
      if (transportChannelProvider == null) {
        throw new NullPointerException("Null transportChannelProvider");
      }
      this.transportChannelProvider = transportChannelProvider;
      return this;
    }
    @Override
    TransportChannelProvider getTransportChannelProvider() {
      if (transportChannelProvider == null) {
        throw new IllegalStateException("Property \"transportChannelProvider\" has not been set");
      }
      return transportChannelProvider;
    }
    @Override
    GoogleAdsClient autoBuild() {
      String missing = "";
      if (this.googleAdsAllVersions == null) {
        missing += " googleAdsAllVersions";
      }
      if (this.developerToken == null) {
        missing += " developerToken";
      }
      if (this.endpoint == null) {
        missing += " endpoint";
      }
      if (this.transportChannelProvider == null) {
        missing += " transportChannelProvider";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_GoogleAdsClient(
          this.googleAdsAllVersions,
          this.credentials,
          this.developerToken,
          this.endpoint,
          this.loginCustomerId,
          this.linkedCustomerId,
          this.transportChannelProvider);
    }
  }

}
