// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v6/resources/feed_item_set.proto

package com.google.ads.googleads.v6.resources;

/**
 * <pre>
 * Represents a set of feed items. The set can be used and shared among certain
 * feed item features. For instance, the set can be referenced within the
 * matching functions of CustomerFeed, CampaignFeed, and AdGroupFeed.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v6.resources.FeedItemSet}
 */
public final class FeedItemSet extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v6.resources.FeedItemSet)
    FeedItemSetOrBuilder {
private static final long serialVersionUID = 0L;
  // Use FeedItemSet.newBuilder() to construct.
  private FeedItemSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private FeedItemSet() {
    resourceName_ = "";
    feed_ = "";
    displayName_ = "";
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new FeedItemSet();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private FeedItemSet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            resourceName_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            feed_ = s;
            break;
          }
          case 24: {

            feedItemSetId_ = input.readInt64();
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();

            displayName_ = s;
            break;
          }
          case 42: {
            com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder subBuilder = null;
            if (dynamicSetFilterCase_ == 5) {
              subBuilder = ((com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_).toBuilder();
            }
            dynamicSetFilter_ =
                input.readMessage(com.google.ads.googleads.v6.common.DynamicLocationSetFilter.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_);
              dynamicSetFilter_ = subBuilder.buildPartial();
            }
            dynamicSetFilterCase_ = 5;
            break;
          }
          case 50: {
            com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder subBuilder = null;
            if (dynamicSetFilterCase_ == 6) {
              subBuilder = ((com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_).toBuilder();
            }
            dynamicSetFilter_ =
                input.readMessage(com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_);
              dynamicSetFilter_ = subBuilder.buildPartial();
            }
            dynamicSetFilterCase_ = 6;
            break;
          }
          case 64: {
            int rawValue = input.readEnum();

            status_ = rawValue;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v6.resources.FeedItemSetProto.internal_static_google_ads_googleads_v6_resources_FeedItemSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v6.resources.FeedItemSetProto.internal_static_google_ads_googleads_v6_resources_FeedItemSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v6.resources.FeedItemSet.class, com.google.ads.googleads.v6.resources.FeedItemSet.Builder.class);
  }

  private int dynamicSetFilterCase_ = 0;
  private java.lang.Object dynamicSetFilter_;
  public enum DynamicSetFilterCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DYNAMIC_LOCATION_SET_FILTER(5),
    DYNAMIC_AFFILIATE_LOCATION_SET_FILTER(6),
    DYNAMICSETFILTER_NOT_SET(0);
    private final int value;
    private DynamicSetFilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DynamicSetFilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static DynamicSetFilterCase forNumber(int value) {
      switch (value) {
        case 5: return DYNAMIC_LOCATION_SET_FILTER;
        case 6: return DYNAMIC_AFFILIATE_LOCATION_SET_FILTER;
        case 0: return DYNAMICSETFILTER_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public DynamicSetFilterCase
  getDynamicSetFilterCase() {
    return DynamicSetFilterCase.forNumber(
        dynamicSetFilterCase_);
  }

  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object resourceName_;
  /**
   * <pre>
   * Immutable. The resource name of the feed item set.
   * Feed item set resource names have the form:
   * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the feed item set.
   * Feed item set resource names have the form:
   * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEED_FIELD_NUMBER = 2;
  private volatile java.lang.Object feed_;
  /**
   * <pre>
   * Immutable. The resource name of the feed containing the feed items in the set.
   * Immutable. Required.
   * </pre>
   *
   * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The feed.
   */
  @java.lang.Override
  public java.lang.String getFeed() {
    java.lang.Object ref = feed_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      feed_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the feed containing the feed items in the set.
   * Immutable. Required.
   * </pre>
   *
   * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for feed.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getFeedBytes() {
    java.lang.Object ref = feed_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      feed_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEED_ITEM_SET_ID_FIELD_NUMBER = 3;
  private long feedItemSetId_;
  /**
   * <pre>
   * Output only. ID of the set.
   * </pre>
   *
   * <code>int64 feed_item_set_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The feedItemSetId.
   */
  @java.lang.Override
  public long getFeedItemSetId() {
    return feedItemSetId_;
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 4;
  private volatile java.lang.Object displayName_;
  /**
   * <pre>
   * Name of the set. Must be unique within the account.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name of the set. Must be unique within the account.
   * </pre>
   *
   * <code>string display_name = 4;</code>
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 8;
  private int status_;
  /**
   * <pre>
   * Output only. Status of the feed item set.
   * This field is read-only.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. Status of the feed item set.
   * This field is read-only.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus getStatus() {
    @SuppressWarnings("deprecation")
    com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus result = com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.valueOf(status_);
    return result == null ? com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.UNRECOGNIZED : result;
  }

  public static final int DYNAMIC_LOCATION_SET_FILTER_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Filter for dynamic location set.
   * It is only used for sets of locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
   * @return Whether the dynamicLocationSetFilter field is set.
   */
  @java.lang.Override
  public boolean hasDynamicLocationSetFilter() {
    return dynamicSetFilterCase_ == 5;
  }
  /**
   * <pre>
   * Filter for dynamic location set.
   * It is only used for sets of locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
   * @return The dynamicLocationSetFilter.
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.DynamicLocationSetFilter getDynamicLocationSetFilter() {
    if (dynamicSetFilterCase_ == 5) {
       return (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_;
    }
    return com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
  }
  /**
   * <pre>
   * Filter for dynamic location set.
   * It is only used for sets of locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.DynamicLocationSetFilterOrBuilder getDynamicLocationSetFilterOrBuilder() {
    if (dynamicSetFilterCase_ == 5) {
       return (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_;
    }
    return com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
  }

  public static final int DYNAMIC_AFFILIATE_LOCATION_SET_FILTER_FIELD_NUMBER = 6;
  /**
   * <pre>
   * Filter for dynamic affiliate location set.
   * This field doesn't apply generally to feed item sets. It is only used for
   * sets of affiliate locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
   * @return Whether the dynamicAffiliateLocationSetFilter field is set.
   */
  @java.lang.Override
  public boolean hasDynamicAffiliateLocationSetFilter() {
    return dynamicSetFilterCase_ == 6;
  }
  /**
   * <pre>
   * Filter for dynamic affiliate location set.
   * This field doesn't apply generally to feed item sets. It is only used for
   * sets of affiliate locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
   * @return The dynamicAffiliateLocationSetFilter.
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter getDynamicAffiliateLocationSetFilter() {
    if (dynamicSetFilterCase_ == 6) {
       return (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_;
    }
    return com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
  }
  /**
   * <pre>
   * Filter for dynamic affiliate location set.
   * This field doesn't apply generally to feed item sets. It is only used for
   * sets of affiliate locations.
   * </pre>
   *
   * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilterOrBuilder getDynamicAffiliateLocationSetFilterOrBuilder() {
    if (dynamicSetFilterCase_ == 6) {
       return (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_;
    }
    return com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getResourceNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (!getFeedBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, feed_);
    }
    if (feedItemSetId_ != 0L) {
      output.writeInt64(3, feedItemSetId_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, displayName_);
    }
    if (dynamicSetFilterCase_ == 5) {
      output.writeMessage(5, (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_);
    }
    if (dynamicSetFilterCase_ == 6) {
      output.writeMessage(6, (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_);
    }
    if (status_ != com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(8, status_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getResourceNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (!getFeedBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, feed_);
    }
    if (feedItemSetId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(3, feedItemSetId_);
    }
    if (!getDisplayNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, displayName_);
    }
    if (dynamicSetFilterCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_);
    }
    if (dynamicSetFilterCase_ == 6) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_);
    }
    if (status_ != com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(8, status_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v6.resources.FeedItemSet)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v6.resources.FeedItemSet other = (com.google.ads.googleads.v6.resources.FeedItemSet) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (!getFeed()
        .equals(other.getFeed())) return false;
    if (getFeedItemSetId()
        != other.getFeedItemSetId()) return false;
    if (!getDisplayName()
        .equals(other.getDisplayName())) return false;
    if (status_ != other.status_) return false;
    if (!getDynamicSetFilterCase().equals(other.getDynamicSetFilterCase())) return false;
    switch (dynamicSetFilterCase_) {
      case 5:
        if (!getDynamicLocationSetFilter()
            .equals(other.getDynamicLocationSetFilter())) return false;
        break;
      case 6:
        if (!getDynamicAffiliateLocationSetFilter()
            .equals(other.getDynamicAffiliateLocationSetFilter())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + FEED_FIELD_NUMBER;
    hash = (53 * hash) + getFeed().hashCode();
    hash = (37 * hash) + FEED_ITEM_SET_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
        getFeedItemSetId());
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    switch (dynamicSetFilterCase_) {
      case 5:
        hash = (37 * hash) + DYNAMIC_LOCATION_SET_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getDynamicLocationSetFilter().hashCode();
        break;
      case 6:
        hash = (37 * hash) + DYNAMIC_AFFILIATE_LOCATION_SET_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getDynamicAffiliateLocationSetFilter().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v6.resources.FeedItemSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v6.resources.FeedItemSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents a set of feed items. The set can be used and shared among certain
   * feed item features. For instance, the set can be referenced within the
   * matching functions of CustomerFeed, CampaignFeed, and AdGroupFeed.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v6.resources.FeedItemSet}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v6.resources.FeedItemSet)
      com.google.ads.googleads.v6.resources.FeedItemSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v6.resources.FeedItemSetProto.internal_static_google_ads_googleads_v6_resources_FeedItemSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v6.resources.FeedItemSetProto.internal_static_google_ads_googleads_v6_resources_FeedItemSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v6.resources.FeedItemSet.class, com.google.ads.googleads.v6.resources.FeedItemSet.Builder.class);
    }

    // Construct using com.google.ads.googleads.v6.resources.FeedItemSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      resourceName_ = "";

      feed_ = "";

      feedItemSetId_ = 0L;

      displayName_ = "";

      status_ = 0;

      dynamicSetFilterCase_ = 0;
      dynamicSetFilter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v6.resources.FeedItemSetProto.internal_static_google_ads_googleads_v6_resources_FeedItemSet_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.resources.FeedItemSet getDefaultInstanceForType() {
      return com.google.ads.googleads.v6.resources.FeedItemSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.resources.FeedItemSet build() {
      com.google.ads.googleads.v6.resources.FeedItemSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v6.resources.FeedItemSet buildPartial() {
      com.google.ads.googleads.v6.resources.FeedItemSet result = new com.google.ads.googleads.v6.resources.FeedItemSet(this);
      result.resourceName_ = resourceName_;
      result.feed_ = feed_;
      result.feedItemSetId_ = feedItemSetId_;
      result.displayName_ = displayName_;
      result.status_ = status_;
      if (dynamicSetFilterCase_ == 5) {
        if (dynamicLocationSetFilterBuilder_ == null) {
          result.dynamicSetFilter_ = dynamicSetFilter_;
        } else {
          result.dynamicSetFilter_ = dynamicLocationSetFilterBuilder_.build();
        }
      }
      if (dynamicSetFilterCase_ == 6) {
        if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
          result.dynamicSetFilter_ = dynamicSetFilter_;
        } else {
          result.dynamicSetFilter_ = dynamicAffiliateLocationSetFilterBuilder_.build();
        }
      }
      result.dynamicSetFilterCase_ = dynamicSetFilterCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v6.resources.FeedItemSet) {
        return mergeFrom((com.google.ads.googleads.v6.resources.FeedItemSet)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v6.resources.FeedItemSet other) {
      if (other == com.google.ads.googleads.v6.resources.FeedItemSet.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        onChanged();
      }
      if (!other.getFeed().isEmpty()) {
        feed_ = other.feed_;
        onChanged();
      }
      if (other.getFeedItemSetId() != 0L) {
        setFeedItemSetId(other.getFeedItemSetId());
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      switch (other.getDynamicSetFilterCase()) {
        case DYNAMIC_LOCATION_SET_FILTER: {
          mergeDynamicLocationSetFilter(other.getDynamicLocationSetFilter());
          break;
        }
        case DYNAMIC_AFFILIATE_LOCATION_SET_FILTER: {
          mergeDynamicAffiliateLocationSetFilter(other.getDynamicAffiliateLocationSetFilter());
          break;
        }
        case DYNAMICSETFILTER_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.ads.googleads.v6.resources.FeedItemSet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.ads.googleads.v6.resources.FeedItemSet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int dynamicSetFilterCase_ = 0;
    private java.lang.Object dynamicSetFilter_;
    public DynamicSetFilterCase
        getDynamicSetFilterCase() {
      return DynamicSetFilterCase.forNumber(
          dynamicSetFilterCase_);
    }

    public Builder clearDynamicSetFilter() {
      dynamicSetFilterCase_ = 0;
      dynamicSetFilter_ = null;
      onChanged();
      return this;
    }


    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the feed item set.
     * Feed item set resource names have the form:
     * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed item set.
     * Feed item set resource names have the form:
     * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed item set.
     * Feed item set resource names have the form:
     * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      resourceName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed item set.
     * Feed item set resource names have the form:
     * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      
      resourceName_ = getDefaultInstance().getResourceName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed item set.
     * Feed item set resource names have the form:
     * `customers/{customer_id}/feedItemSets/{feed_id}~{feed_item_set_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      resourceName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object feed_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the feed containing the feed items in the set.
     * Immutable. Required.
     * </pre>
     *
     * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The feed.
     */
    public java.lang.String getFeed() {
      java.lang.Object ref = feed_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        feed_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed containing the feed items in the set.
     * Immutable. Required.
     * </pre>
     *
     * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for feed.
     */
    public com.google.protobuf.ByteString
        getFeedBytes() {
      java.lang.Object ref = feed_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        feed_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed containing the feed items in the set.
     * Immutable. Required.
     * </pre>
     *
     * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The feed to set.
     * @return This builder for chaining.
     */
    public Builder setFeed(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      feed_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed containing the feed items in the set.
     * Immutable. Required.
     * </pre>
     *
     * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearFeed() {
      
      feed_ = getDefaultInstance().getFeed();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the feed containing the feed items in the set.
     * Immutable. Required.
     * </pre>
     *
     * <code>string feed = 2 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for feed to set.
     * @return This builder for chaining.
     */
    public Builder setFeedBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      feed_ = value;
      onChanged();
      return this;
    }

    private long feedItemSetId_ ;
    /**
     * <pre>
     * Output only. ID of the set.
     * </pre>
     *
     * <code>int64 feed_item_set_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The feedItemSetId.
     */
    @java.lang.Override
    public long getFeedItemSetId() {
      return feedItemSetId_;
    }
    /**
     * <pre>
     * Output only. ID of the set.
     * </pre>
     *
     * <code>int64 feed_item_set_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The feedItemSetId to set.
     * @return This builder for chaining.
     */
    public Builder setFeedItemSetId(long value) {
      
      feedItemSetId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. ID of the set.
     * </pre>
     *
     * <code>int64 feed_item_set_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearFeedItemSetId() {
      
      feedItemSetId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     * <pre>
     * Name of the set. Must be unique within the account.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name of the set. Must be unique within the account.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString
        getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name of the set. Must be unique within the account.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      displayName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the set. Must be unique within the account.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      
      displayName_ = getDefaultInstance().getDisplayName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of the set. Must be unique within the account.
     * </pre>
     *
     * <code>string display_name = 4;</code>
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      displayName_ = value;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. Status of the feed item set.
     * This field is read-only.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. Status of the feed item set.
     * This field is read-only.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of the feed item set.
     * This field is read-only.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus getStatus() {
      @SuppressWarnings("deprecation")
      com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus result = com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.valueOf(status_);
      return result == null ? com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Status of the feed item set.
     * This field is read-only.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Status of the feed item set.
     * This field is read-only.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.enums.FeedItemSetStatusEnum.FeedItemSetStatus status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v6.common.DynamicLocationSetFilter, com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicLocationSetFilterOrBuilder> dynamicLocationSetFilterBuilder_;
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     * @return Whether the dynamicLocationSetFilter field is set.
     */
    @java.lang.Override
    public boolean hasDynamicLocationSetFilter() {
      return dynamicSetFilterCase_ == 5;
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     * @return The dynamicLocationSetFilter.
     */
    @java.lang.Override
    public com.google.ads.googleads.v6.common.DynamicLocationSetFilter getDynamicLocationSetFilter() {
      if (dynamicLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 5) {
          return (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_;
        }
        return com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
      } else {
        if (dynamicSetFilterCase_ == 5) {
          return dynamicLocationSetFilterBuilder_.getMessage();
        }
        return com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    public Builder setDynamicLocationSetFilter(com.google.ads.googleads.v6.common.DynamicLocationSetFilter value) {
      if (dynamicLocationSetFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dynamicSetFilter_ = value;
        onChanged();
      } else {
        dynamicLocationSetFilterBuilder_.setMessage(value);
      }
      dynamicSetFilterCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    public Builder setDynamicLocationSetFilter(
        com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder builderForValue) {
      if (dynamicLocationSetFilterBuilder_ == null) {
        dynamicSetFilter_ = builderForValue.build();
        onChanged();
      } else {
        dynamicLocationSetFilterBuilder_.setMessage(builderForValue.build());
      }
      dynamicSetFilterCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    public Builder mergeDynamicLocationSetFilter(com.google.ads.googleads.v6.common.DynamicLocationSetFilter value) {
      if (dynamicLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 5 &&
            dynamicSetFilter_ != com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance()) {
          dynamicSetFilter_ = com.google.ads.googleads.v6.common.DynamicLocationSetFilter.newBuilder((com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_)
              .mergeFrom(value).buildPartial();
        } else {
          dynamicSetFilter_ = value;
        }
        onChanged();
      } else {
        if (dynamicSetFilterCase_ == 5) {
          dynamicLocationSetFilterBuilder_.mergeFrom(value);
        }
        dynamicLocationSetFilterBuilder_.setMessage(value);
      }
      dynamicSetFilterCase_ = 5;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    public Builder clearDynamicLocationSetFilter() {
      if (dynamicLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 5) {
          dynamicSetFilterCase_ = 0;
          dynamicSetFilter_ = null;
          onChanged();
        }
      } else {
        if (dynamicSetFilterCase_ == 5) {
          dynamicSetFilterCase_ = 0;
          dynamicSetFilter_ = null;
        }
        dynamicLocationSetFilterBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    public com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder getDynamicLocationSetFilterBuilder() {
      return getDynamicLocationSetFilterFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v6.common.DynamicLocationSetFilterOrBuilder getDynamicLocationSetFilterOrBuilder() {
      if ((dynamicSetFilterCase_ == 5) && (dynamicLocationSetFilterBuilder_ != null)) {
        return dynamicLocationSetFilterBuilder_.getMessageOrBuilder();
      } else {
        if (dynamicSetFilterCase_ == 5) {
          return (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_;
        }
        return com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Filter for dynamic location set.
     * It is only used for sets of locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicLocationSetFilter dynamic_location_set_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v6.common.DynamicLocationSetFilter, com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicLocationSetFilterOrBuilder> 
        getDynamicLocationSetFilterFieldBuilder() {
      if (dynamicLocationSetFilterBuilder_ == null) {
        if (!(dynamicSetFilterCase_ == 5)) {
          dynamicSetFilter_ = com.google.ads.googleads.v6.common.DynamicLocationSetFilter.getDefaultInstance();
        }
        dynamicLocationSetFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v6.common.DynamicLocationSetFilter, com.google.ads.googleads.v6.common.DynamicLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicLocationSetFilterOrBuilder>(
                (com.google.ads.googleads.v6.common.DynamicLocationSetFilter) dynamicSetFilter_,
                getParentForChildren(),
                isClean());
        dynamicSetFilter_ = null;
      }
      dynamicSetFilterCase_ = 5;
      onChanged();;
      return dynamicLocationSetFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilterOrBuilder> dynamicAffiliateLocationSetFilterBuilder_;
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     * @return Whether the dynamicAffiliateLocationSetFilter field is set.
     */
    @java.lang.Override
    public boolean hasDynamicAffiliateLocationSetFilter() {
      return dynamicSetFilterCase_ == 6;
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     * @return The dynamicAffiliateLocationSetFilter.
     */
    @java.lang.Override
    public com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter getDynamicAffiliateLocationSetFilter() {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 6) {
          return (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_;
        }
        return com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
      } else {
        if (dynamicSetFilterCase_ == 6) {
          return dynamicAffiliateLocationSetFilterBuilder_.getMessage();
        }
        return com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    public Builder setDynamicAffiliateLocationSetFilter(com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter value) {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dynamicSetFilter_ = value;
        onChanged();
      } else {
        dynamicAffiliateLocationSetFilterBuilder_.setMessage(value);
      }
      dynamicSetFilterCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    public Builder setDynamicAffiliateLocationSetFilter(
        com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder builderForValue) {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        dynamicSetFilter_ = builderForValue.build();
        onChanged();
      } else {
        dynamicAffiliateLocationSetFilterBuilder_.setMessage(builderForValue.build());
      }
      dynamicSetFilterCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    public Builder mergeDynamicAffiliateLocationSetFilter(com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter value) {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 6 &&
            dynamicSetFilter_ != com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance()) {
          dynamicSetFilter_ = com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.newBuilder((com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_)
              .mergeFrom(value).buildPartial();
        } else {
          dynamicSetFilter_ = value;
        }
        onChanged();
      } else {
        if (dynamicSetFilterCase_ == 6) {
          dynamicAffiliateLocationSetFilterBuilder_.mergeFrom(value);
        }
        dynamicAffiliateLocationSetFilterBuilder_.setMessage(value);
      }
      dynamicSetFilterCase_ = 6;
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    public Builder clearDynamicAffiliateLocationSetFilter() {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        if (dynamicSetFilterCase_ == 6) {
          dynamicSetFilterCase_ = 0;
          dynamicSetFilter_ = null;
          onChanged();
        }
      } else {
        if (dynamicSetFilterCase_ == 6) {
          dynamicSetFilterCase_ = 0;
          dynamicSetFilter_ = null;
        }
        dynamicAffiliateLocationSetFilterBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    public com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder getDynamicAffiliateLocationSetFilterBuilder() {
      return getDynamicAffiliateLocationSetFilterFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    @java.lang.Override
    public com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilterOrBuilder getDynamicAffiliateLocationSetFilterOrBuilder() {
      if ((dynamicSetFilterCase_ == 6) && (dynamicAffiliateLocationSetFilterBuilder_ != null)) {
        return dynamicAffiliateLocationSetFilterBuilder_.getMessageOrBuilder();
      } else {
        if (dynamicSetFilterCase_ == 6) {
          return (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_;
        }
        return com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Filter for dynamic affiliate location set.
     * This field doesn't apply generally to feed item sets. It is only used for
     * sets of affiliate locations.
     * </pre>
     *
     * <code>.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter dynamic_affiliate_location_set_filter = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilterOrBuilder> 
        getDynamicAffiliateLocationSetFilterFieldBuilder() {
      if (dynamicAffiliateLocationSetFilterBuilder_ == null) {
        if (!(dynamicSetFilterCase_ == 6)) {
          dynamicSetFilter_ = com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.getDefaultInstance();
        }
        dynamicAffiliateLocationSetFilterBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter.Builder, com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilterOrBuilder>(
                (com.google.ads.googleads.v6.common.DynamicAffiliateLocationSetFilter) dynamicSetFilter_,
                getParentForChildren(),
                isClean());
        dynamicSetFilter_ = null;
      }
      dynamicSetFilterCase_ = 6;
      onChanged();;
      return dynamicAffiliateLocationSetFilterBuilder_;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v6.resources.FeedItemSet)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v6.resources.FeedItemSet)
  private static final com.google.ads.googleads.v6.resources.FeedItemSet DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v6.resources.FeedItemSet();
  }

  public static com.google.ads.googleads.v6.resources.FeedItemSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeedItemSet>
      PARSER = new com.google.protobuf.AbstractParser<FeedItemSet>() {
    @java.lang.Override
    public FeedItemSet parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new FeedItemSet(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<FeedItemSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeedItemSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v6.resources.FeedItemSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

