/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.callables;

import com.google.ads.googleads.lib.callables.ExceptionTransformation;
import com.google.api.core.AbstractApiFuture;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;

public class ExceptionTransformingUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> callable;
    private final ExceptionTransformation transformation;

    public ExceptionTransformingUnaryCallable(UnaryCallable<RequestT, ResponseT> callable, ExceptionTransformation transformation) {
        this.callable = (UnaryCallable)Preconditions.checkNotNull(callable);
        this.transformation = transformation;
    }

    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        GrpcCallContext context = GrpcCallContext.createDefault().nullToSelf(inputContext);
        ApiFuture innerCallFuture = this.callable.futureCall(request, (ApiCallContext)context);
        ExceptionTransformingFuture transformingFuture = new ExceptionTransformingFuture(innerCallFuture);
        ApiFutures.addCallback((ApiFuture)innerCallFuture, (ApiFutureCallback)transformingFuture);
        return transformingFuture;
    }

    private class ExceptionTransformingFuture
    extends AbstractApiFuture<ResponseT>
    implements ApiFutureCallback<ResponseT> {
        private ApiFuture<ResponseT> innerCallFuture;
        private volatile boolean cancelled = false;

        public ExceptionTransformingFuture(ApiFuture<ResponseT> innerCallFuture) {
            this.innerCallFuture = innerCallFuture;
        }

        protected void interruptTask() {
            this.cancelled = true;
            this.innerCallFuture.cancel(true);
        }

        public void onSuccess(ResponseT r) {
            super.set(r);
        }

        public void onFailure(Throwable throwable) {
            if (!(throwable instanceof CancellationException) || !this.cancelled) {
                this.setException(ExceptionTransformingUnaryCallable.this.transformation.transform(throwable));
            }
        }
    }
}

