/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.utils;

import com.google.ads.googleads.lib.reflect.ReflectionFieldAccessor;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.FieldMask;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Message;
import java.util.List;
import java.util.Objects;

public class FieldMasks {
    public static <T extends GeneratedMessageV3> FieldMask compare(T original, T modified) {
        Preconditions.checkNotNull(original, (Object)"original is null");
        Preconditions.checkNotNull(modified, (Object)"modified is null");
        FieldMask.Builder mask = FieldMask.newBuilder();
        FieldMasks.compare(mask, "", original, modified);
        return mask.build();
    }

    public static <T extends GeneratedMessageV3> FieldMask allSetFieldsOf(T message) {
        Preconditions.checkNotNull(message, (Object)"message is null");
        return FieldMasks.compare((GeneratedMessageV3)message.getDefaultInstanceForType(), message);
    }

    private static void compare(FieldMask.Builder mask, String currentField, Message original, Message modified) {
        Descriptors.Descriptor descriptor = original.getDescriptorForType();
        block4: for (Descriptors.FieldDescriptor field : descriptor.getFields()) {
            String fieldName = FieldMasks.getFieldName(currentField, field);
            Object originalValue = original.getField(field);
            Object modifiedValue = modified.getField(field);
            if (field.isRepeated()) {
                if (Objects.equals(originalValue, modifiedValue)) continue;
                mask.addPaths(fieldName);
                continue;
            }
            boolean hasValueChanged = original.hasField(field) != modified.hasField(field) || !Objects.equals(originalValue, modifiedValue);
            switch (field.getJavaType()) {
                case MESSAGE: {
                    if (!hasValueChanged) continue block4;
                    if (FieldMasks.isWrapperType(field.getMessageType())) {
                        mask.addPaths(fieldName);
                        continue block4;
                    }
                    if (!modified.hasField(field)) {
                        mask.addPaths(fieldName);
                        continue block4;
                    }
                    FieldMasks.compare(mask, fieldName, (Message)originalValue, (Message)modifiedValue);
                    continue block4;
                }
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case BYTE_STRING: 
                case ENUM: {
                    if (!hasValueChanged) continue block4;
                    mask.addPaths(fieldName);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected java type " + field.getJavaType() + " encountered for field " + fieldName);
        }
    }

    public static <T> List<T> getFieldValue(String fieldMaskPath, Message entity) {
        return new ReflectionFieldAccessor(fieldMaskPath).getValues(entity);
    }

    private static String getFieldName(String currentField, Descriptors.FieldDescriptor field) {
        if (currentField.isEmpty()) {
            return field.getName();
        }
        return currentField + "." + field.getName();
    }

    private static boolean isWrapperType(Descriptors.Descriptor descriptor) {
        return descriptor.getFile().getPackage().equals("google.protobuf") && descriptor.getFile().getFullName().equals("google/protobuf/wrappers.proto");
    }
}

