/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.resources;

import com.google.ads.googleads.v5.enums.ExtensionSettingDeviceEnum;
import com.google.ads.googleads.v5.enums.ExtensionTypeEnum;
import com.google.ads.googleads.v5.resources.CampaignExtensionSettingOrBuilder;
import com.google.ads.googleads.v5.resources.CampaignExtensionSettingProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.StringValue;
import com.google.protobuf.StringValueOrBuilder;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CampaignExtensionSetting
extends GeneratedMessageV3
implements CampaignExtensionSettingOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_;
    public static final int EXTENSION_TYPE_FIELD_NUMBER = 2;
    private int extensionType_;
    public static final int CAMPAIGN_FIELD_NUMBER = 3;
    private StringValue campaign_;
    public static final int EXTENSION_FEED_ITEMS_FIELD_NUMBER = 4;
    private List<StringValue> extensionFeedItems_;
    public static final int DEVICE_FIELD_NUMBER = 5;
    private int device_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final CampaignExtensionSetting DEFAULT_INSTANCE = new CampaignExtensionSetting();
    private static final Parser<CampaignExtensionSetting> PARSER = new AbstractParser<CampaignExtensionSetting>(){

        public CampaignExtensionSetting parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new CampaignExtensionSetting(input, extensionRegistry);
        }
    };

    private CampaignExtensionSetting(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private CampaignExtensionSetting() {
        this.resourceName_ = "";
        this.extensionType_ = 0;
        this.extensionFeedItems_ = Collections.emptyList();
        this.device_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new CampaignExtensionSetting();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private CampaignExtensionSetting(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        boolean mutable_bitField0_ = false;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block14: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block14;
                    }
                    case 10: {
                        String s = input.readStringRequireUtf8();
                        this.resourceName_ = s;
                        continue block14;
                    }
                    case 16: {
                        int rawValue;
                        this.extensionType_ = rawValue = input.readEnum();
                        continue block14;
                    }
                    case 26: {
                        StringValue.Builder subBuilder = null;
                        if (this.campaign_ != null) {
                            subBuilder = this.campaign_.toBuilder();
                        }
                        this.campaign_ = (StringValue)input.readMessage(StringValue.parser(), extensionRegistry);
                        if (subBuilder == null) continue block14;
                        subBuilder.mergeFrom(this.campaign_);
                        this.campaign_ = subBuilder.buildPartial();
                        continue block14;
                    }
                    case 34: {
                        if (!(mutable_bitField0_ & true)) {
                            this.extensionFeedItems_ = new ArrayList<StringValue>();
                            mutable_bitField0_ |= true;
                        }
                        this.extensionFeedItems_.add((StringValue)input.readMessage(StringValue.parser(), extensionRegistry));
                        continue block14;
                    }
                    case 40: {
                        int rawValue;
                        this.device_ = rawValue = input.readEnum();
                        continue block14;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.extensionFeedItems_ = Collections.unmodifiableList(this.extensionFeedItems_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return CampaignExtensionSettingProto.internal_static_google_ads_googleads_v5_resources_CampaignExtensionSetting_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return CampaignExtensionSettingProto.internal_static_google_ads_googleads_v5_resources_CampaignExtensionSetting_fieldAccessorTable.ensureFieldAccessorsInitialized(CampaignExtensionSetting.class, Builder.class);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getExtensionTypeValue() {
        return this.extensionType_;
    }

    @Override
    public ExtensionTypeEnum.ExtensionType getExtensionType() {
        ExtensionTypeEnum.ExtensionType result = ExtensionTypeEnum.ExtensionType.valueOf(this.extensionType_);
        return result == null ? ExtensionTypeEnum.ExtensionType.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasCampaign() {
        return this.campaign_ != null;
    }

    @Override
    public StringValue getCampaign() {
        return this.campaign_ == null ? StringValue.getDefaultInstance() : this.campaign_;
    }

    @Override
    public StringValueOrBuilder getCampaignOrBuilder() {
        return this.getCampaign();
    }

    @Override
    public List<StringValue> getExtensionFeedItemsList() {
        return this.extensionFeedItems_;
    }

    @Override
    public List<? extends StringValueOrBuilder> getExtensionFeedItemsOrBuilderList() {
        return this.extensionFeedItems_;
    }

    @Override
    public int getExtensionFeedItemsCount() {
        return this.extensionFeedItems_.size();
    }

    @Override
    public StringValue getExtensionFeedItems(int index) {
        return this.extensionFeedItems_.get(index);
    }

    @Override
    public StringValueOrBuilder getExtensionFeedItemsOrBuilder(int index) {
        return (StringValueOrBuilder)this.extensionFeedItems_.get(index);
    }

    @Override
    public int getDeviceValue() {
        return this.device_;
    }

    @Override
    public ExtensionSettingDeviceEnum.ExtensionSettingDevice getDevice() {
        ExtensionSettingDeviceEnum.ExtensionSettingDevice result = ExtensionSettingDeviceEnum.ExtensionSettingDevice.valueOf(this.device_);
        return result == null ? ExtensionSettingDeviceEnum.ExtensionSettingDevice.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!this.getResourceNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        if (this.extensionType_ != ExtensionTypeEnum.ExtensionType.UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.extensionType_);
        }
        if (this.campaign_ != null) {
            output.writeMessage(3, (MessageLite)this.getCampaign());
        }
        for (int i = 0; i < this.extensionFeedItems_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.extensionFeedItems_.get(i));
        }
        if (this.device_ != ExtensionSettingDeviceEnum.ExtensionSettingDevice.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.device_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getResourceNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        if (this.extensionType_ != ExtensionTypeEnum.ExtensionType.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.extensionType_);
        }
        if (this.campaign_ != null) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCampaign());
        }
        for (int i = 0; i < this.extensionFeedItems_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.extensionFeedItems_.get(i)));
        }
        if (this.device_ != ExtensionSettingDeviceEnum.ExtensionSettingDevice.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.device_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CampaignExtensionSetting)) {
            return super.equals(obj);
        }
        CampaignExtensionSetting other = (CampaignExtensionSetting)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.extensionType_ != other.extensionType_) {
            return false;
        }
        if (this.hasCampaign() != other.hasCampaign()) {
            return false;
        }
        if (this.hasCampaign() && !this.getCampaign().equals((Object)other.getCampaign())) {
            return false;
        }
        if (!this.getExtensionFeedItemsList().equals(other.getExtensionFeedItemsList())) {
            return false;
        }
        if (this.device_ != other.device_) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + CampaignExtensionSetting.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.extensionType_;
        if (this.hasCampaign()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCampaign().hashCode();
        }
        if (this.getExtensionFeedItemsCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getExtensionFeedItemsList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.device_;
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static CampaignExtensionSetting parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data);
    }

    public static CampaignExtensionSetting parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CampaignExtensionSetting parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data);
    }

    public static CampaignExtensionSetting parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CampaignExtensionSetting parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data);
    }

    public static CampaignExtensionSetting parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (CampaignExtensionSetting)PARSER.parseFrom(data, extensionRegistry);
    }

    public static CampaignExtensionSetting parseFrom(InputStream input) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static CampaignExtensionSetting parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CampaignExtensionSetting parseDelimitedFrom(InputStream input) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static CampaignExtensionSetting parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static CampaignExtensionSetting parseFrom(CodedInputStream input) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static CampaignExtensionSetting parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (CampaignExtensionSetting)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return CampaignExtensionSetting.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(CampaignExtensionSetting prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static CampaignExtensionSetting getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<CampaignExtensionSetting> parser() {
        return PARSER;
    }

    public Parser<CampaignExtensionSetting> getParserForType() {
        return PARSER;
    }

    public CampaignExtensionSetting getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements CampaignExtensionSettingOrBuilder {
        private int bitField0_;
        private Object resourceName_ = "";
        private int extensionType_ = 0;
        private StringValue campaign_;
        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> campaignBuilder_;
        private List<StringValue> extensionFeedItems_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> extensionFeedItemsBuilder_;
        private int device_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return CampaignExtensionSettingProto.internal_static_google_ads_googleads_v5_resources_CampaignExtensionSetting_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return CampaignExtensionSettingProto.internal_static_google_ads_googleads_v5_resources_CampaignExtensionSetting_fieldAccessorTable.ensureFieldAccessorsInitialized(CampaignExtensionSetting.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getExtensionFeedItemsFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.resourceName_ = "";
            this.extensionType_ = 0;
            if (this.campaignBuilder_ == null) {
                this.campaign_ = null;
            } else {
                this.campaign_ = null;
                this.campaignBuilder_ = null;
            }
            if (this.extensionFeedItemsBuilder_ == null) {
                this.extensionFeedItems_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
            } else {
                this.extensionFeedItemsBuilder_.clear();
            }
            this.device_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return CampaignExtensionSettingProto.internal_static_google_ads_googleads_v5_resources_CampaignExtensionSetting_descriptor;
        }

        public CampaignExtensionSetting getDefaultInstanceForType() {
            return CampaignExtensionSetting.getDefaultInstance();
        }

        public CampaignExtensionSetting build() {
            CampaignExtensionSetting result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public CampaignExtensionSetting buildPartial() {
            CampaignExtensionSetting result = new CampaignExtensionSetting(this);
            int from_bitField0_ = this.bitField0_;
            result.resourceName_ = this.resourceName_;
            result.extensionType_ = this.extensionType_;
            if (this.campaignBuilder_ == null) {
                result.campaign_ = this.campaign_;
            } else {
                result.campaign_ = (StringValue)this.campaignBuilder_.build();
            }
            if (this.extensionFeedItemsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.extensionFeedItems_ = Collections.unmodifiableList(this.extensionFeedItems_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.extensionFeedItems_ = this.extensionFeedItems_;
            } else {
                result.extensionFeedItems_ = this.extensionFeedItemsBuilder_.build();
            }
            result.device_ = this.device_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof CampaignExtensionSetting) {
                return this.mergeFrom((CampaignExtensionSetting)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(CampaignExtensionSetting other) {
            if (other == CampaignExtensionSetting.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.onChanged();
            }
            if (other.extensionType_ != 0) {
                this.setExtensionTypeValue(other.getExtensionTypeValue());
            }
            if (other.hasCampaign()) {
                this.mergeCampaign(other.getCampaign());
            }
            if (this.extensionFeedItemsBuilder_ == null) {
                if (!other.extensionFeedItems_.isEmpty()) {
                    if (this.extensionFeedItems_.isEmpty()) {
                        this.extensionFeedItems_ = other.extensionFeedItems_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureExtensionFeedItemsIsMutable();
                        this.extensionFeedItems_.addAll(other.extensionFeedItems_);
                    }
                    this.onChanged();
                }
            } else if (!other.extensionFeedItems_.isEmpty()) {
                if (this.extensionFeedItemsBuilder_.isEmpty()) {
                    this.extensionFeedItemsBuilder_.dispose();
                    this.extensionFeedItemsBuilder_ = null;
                    this.extensionFeedItems_ = other.extensionFeedItems_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.extensionFeedItemsBuilder_ = alwaysUseFieldBuilders ? this.getExtensionFeedItemsFieldBuilder() : null;
                } else {
                    this.extensionFeedItemsBuilder_.addAllMessages((Iterable)other.extensionFeedItems_);
                }
            }
            if (other.device_ != 0) {
                this.setDeviceValue(other.getDeviceValue());
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            CampaignExtensionSetting parsedMessage = null;
            try {
                parsedMessage = (CampaignExtensionSetting)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (CampaignExtensionSetting)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = CampaignExtensionSetting.getDefaultInstance().getResourceName();
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            CampaignExtensionSetting.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getExtensionTypeValue() {
            return this.extensionType_;
        }

        public Builder setExtensionTypeValue(int value) {
            this.extensionType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ExtensionTypeEnum.ExtensionType getExtensionType() {
            ExtensionTypeEnum.ExtensionType result = ExtensionTypeEnum.ExtensionType.valueOf(this.extensionType_);
            return result == null ? ExtensionTypeEnum.ExtensionType.UNRECOGNIZED : result;
        }

        public Builder setExtensionType(ExtensionTypeEnum.ExtensionType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.extensionType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearExtensionType() {
            this.extensionType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCampaign() {
            return this.campaignBuilder_ != null || this.campaign_ != null;
        }

        @Override
        public StringValue getCampaign() {
            if (this.campaignBuilder_ == null) {
                return this.campaign_ == null ? StringValue.getDefaultInstance() : this.campaign_;
            }
            return (StringValue)this.campaignBuilder_.getMessage();
        }

        public Builder setCampaign(StringValue value) {
            if (this.campaignBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.campaign_ = value;
                this.onChanged();
            } else {
                this.campaignBuilder_.setMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder setCampaign(StringValue.Builder builderForValue) {
            if (this.campaignBuilder_ == null) {
                this.campaign_ = builderForValue.build();
                this.onChanged();
            } else {
                this.campaignBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder mergeCampaign(StringValue value) {
            if (this.campaignBuilder_ == null) {
                this.campaign_ = this.campaign_ != null ? StringValue.newBuilder((StringValue)this.campaign_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else {
                this.campaignBuilder_.mergeFrom((AbstractMessage)value);
            }
            return this;
        }

        public Builder clearCampaign() {
            if (this.campaignBuilder_ == null) {
                this.campaign_ = null;
                this.onChanged();
            } else {
                this.campaign_ = null;
                this.campaignBuilder_ = null;
            }
            return this;
        }

        public StringValue.Builder getCampaignBuilder() {
            this.onChanged();
            return (StringValue.Builder)this.getCampaignFieldBuilder().getBuilder();
        }

        @Override
        public StringValueOrBuilder getCampaignOrBuilder() {
            if (this.campaignBuilder_ != null) {
                return (StringValueOrBuilder)this.campaignBuilder_.getMessageOrBuilder();
            }
            return this.campaign_ == null ? StringValue.getDefaultInstance() : this.campaign_;
        }

        private SingleFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> getCampaignFieldBuilder() {
            if (this.campaignBuilder_ == null) {
                this.campaignBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCampaign(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.campaign_ = null;
            }
            return this.campaignBuilder_;
        }

        private void ensureExtensionFeedItemsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.extensionFeedItems_ = new ArrayList<StringValue>(this.extensionFeedItems_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<StringValue> getExtensionFeedItemsList() {
            if (this.extensionFeedItemsBuilder_ == null) {
                return Collections.unmodifiableList(this.extensionFeedItems_);
            }
            return this.extensionFeedItemsBuilder_.getMessageList();
        }

        @Override
        public int getExtensionFeedItemsCount() {
            if (this.extensionFeedItemsBuilder_ == null) {
                return this.extensionFeedItems_.size();
            }
            return this.extensionFeedItemsBuilder_.getCount();
        }

        @Override
        public StringValue getExtensionFeedItems(int index) {
            if (this.extensionFeedItemsBuilder_ == null) {
                return this.extensionFeedItems_.get(index);
            }
            return (StringValue)this.extensionFeedItemsBuilder_.getMessage(index);
        }

        public Builder setExtensionFeedItems(int index, StringValue value) {
            if (this.extensionFeedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.set(index, value);
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setExtensionFeedItems(int index, StringValue.Builder builderForValue) {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addExtensionFeedItems(StringValue value) {
            if (this.extensionFeedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.add(value);
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addExtensionFeedItems(int index, StringValue value) {
            if (this.extensionFeedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.add(index, value);
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addExtensionFeedItems(StringValue.Builder builderForValue) {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addExtensionFeedItems(int index, StringValue.Builder builderForValue) {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllExtensionFeedItems(Iterable<? extends StringValue> values) {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.ensureExtensionFeedItemsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.extensionFeedItems_);
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearExtensionFeedItems() {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.extensionFeedItems_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.clear();
            }
            return this;
        }

        public Builder removeExtensionFeedItems(int index) {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.ensureExtensionFeedItemsIsMutable();
                this.extensionFeedItems_.remove(index);
                this.onChanged();
            } else {
                this.extensionFeedItemsBuilder_.remove(index);
            }
            return this;
        }

        public StringValue.Builder getExtensionFeedItemsBuilder(int index) {
            return (StringValue.Builder)this.getExtensionFeedItemsFieldBuilder().getBuilder(index);
        }

        @Override
        public StringValueOrBuilder getExtensionFeedItemsOrBuilder(int index) {
            if (this.extensionFeedItemsBuilder_ == null) {
                return (StringValueOrBuilder)this.extensionFeedItems_.get(index);
            }
            return (StringValueOrBuilder)this.extensionFeedItemsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends StringValueOrBuilder> getExtensionFeedItemsOrBuilderList() {
            if (this.extensionFeedItemsBuilder_ != null) {
                return this.extensionFeedItemsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.extensionFeedItems_);
        }

        public StringValue.Builder addExtensionFeedItemsBuilder() {
            return (StringValue.Builder)this.getExtensionFeedItemsFieldBuilder().addBuilder((AbstractMessage)StringValue.getDefaultInstance());
        }

        public StringValue.Builder addExtensionFeedItemsBuilder(int index) {
            return (StringValue.Builder)this.getExtensionFeedItemsFieldBuilder().addBuilder(index, (AbstractMessage)StringValue.getDefaultInstance());
        }

        public List<StringValue.Builder> getExtensionFeedItemsBuilderList() {
            return this.getExtensionFeedItemsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<StringValue, StringValue.Builder, StringValueOrBuilder> getExtensionFeedItemsFieldBuilder() {
            if (this.extensionFeedItemsBuilder_ == null) {
                this.extensionFeedItemsBuilder_ = new RepeatedFieldBuilderV3(this.extensionFeedItems_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.extensionFeedItems_ = null;
            }
            return this.extensionFeedItemsBuilder_;
        }

        @Override
        public int getDeviceValue() {
            return this.device_;
        }

        public Builder setDeviceValue(int value) {
            this.device_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ExtensionSettingDeviceEnum.ExtensionSettingDevice getDevice() {
            ExtensionSettingDeviceEnum.ExtensionSettingDevice result = ExtensionSettingDeviceEnum.ExtensionSettingDevice.valueOf(this.device_);
            return result == null ? ExtensionSettingDeviceEnum.ExtensionSettingDevice.UNRECOGNIZED : result;
        }

        public Builder setDevice(ExtensionSettingDeviceEnum.ExtensionSettingDevice value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.device_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDevice() {
            this.device_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

