/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccountBudgetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/accountBudgets/{account_budget}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String accountBudget;

    public String getCustomer() {
        return this.customer;
    }

    public String getAccountBudget() {
        return this.accountBudget;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AccountBudgetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.accountBudget = (String)Preconditions.checkNotNull((Object)builder.getAccountBudget());
    }

    public static AccountBudgetName of(String customer, String accountBudget) {
        return AccountBudgetName.newBuilder().setCustomer(customer).setAccountBudget(accountBudget).build();
    }

    public static String format(String customer, String accountBudget) {
        return AccountBudgetName.newBuilder().setCustomer(customer).setAccountBudget(accountBudget).build().toString();
    }

    public static AccountBudgetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AccountBudgetName.parse: formattedString not in valid format");
        return AccountBudgetName.of((String)matchMap.get("customer"), (String)matchMap.get("account_budget"));
    }

    public static List<AccountBudgetName> parseList(List<String> formattedStrings) {
        ArrayList<AccountBudgetName> list = new ArrayList<AccountBudgetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountBudgetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountBudgetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountBudgetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountBudgetName accountBudgetName = this;
            synchronized (accountBudgetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"accountBudget", (Object)this.accountBudget);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "account_budget", this.accountBudget});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccountBudgetName) {
            AccountBudgetName that = (AccountBudgetName)o;
            return this.customer.equals(that.customer) && this.accountBudget.equals(that.accountBudget);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.accountBudget.hashCode();
    }

    public static class Builder {
        private String customer;
        private String accountBudget;

        public String getCustomer() {
            return this.customer;
        }

        public String getAccountBudget() {
            return this.accountBudget;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAccountBudget(String accountBudget) {
            this.accountBudget = accountBudget;
            return this;
        }

        private Builder() {
        }

        private Builder(AccountBudgetName accountBudgetName) {
            this.customer = accountBudgetName.customer;
            this.accountBudget = accountBudgetName.accountBudget;
        }

        public AccountBudgetName build() {
            return new AccountBudgetName(this);
        }
    }
}

