/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccountBudgetProposalName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/accountBudgetProposals/{account_budget_proposal}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String accountBudgetProposal;

    public String getCustomer() {
        return this.customer;
    }

    public String getAccountBudgetProposal() {
        return this.accountBudgetProposal;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AccountBudgetProposalName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.accountBudgetProposal = (String)Preconditions.checkNotNull((Object)builder.getAccountBudgetProposal());
    }

    public static AccountBudgetProposalName of(String customer, String accountBudgetProposal) {
        return AccountBudgetProposalName.newBuilder().setCustomer(customer).setAccountBudgetProposal(accountBudgetProposal).build();
    }

    public static String format(String customer, String accountBudgetProposal) {
        return AccountBudgetProposalName.newBuilder().setCustomer(customer).setAccountBudgetProposal(accountBudgetProposal).build().toString();
    }

    public static AccountBudgetProposalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AccountBudgetProposalName.parse: formattedString not in valid format");
        return AccountBudgetProposalName.of((String)matchMap.get("customer"), (String)matchMap.get("account_budget_proposal"));
    }

    public static List<AccountBudgetProposalName> parseList(List<String> formattedStrings) {
        ArrayList<AccountBudgetProposalName> list = new ArrayList<AccountBudgetProposalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountBudgetProposalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountBudgetProposalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountBudgetProposalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountBudgetProposalName accountBudgetProposalName = this;
            synchronized (accountBudgetProposalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"accountBudgetProposal", (Object)this.accountBudgetProposal);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "account_budget_proposal", this.accountBudgetProposal});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccountBudgetProposalName) {
            AccountBudgetProposalName that = (AccountBudgetProposalName)o;
            return this.customer.equals(that.customer) && this.accountBudgetProposal.equals(that.accountBudgetProposal);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.accountBudgetProposal.hashCode();
    }

    public static class Builder {
        private String customer;
        private String accountBudgetProposal;

        public String getCustomer() {
            return this.customer;
        }

        public String getAccountBudgetProposal() {
            return this.accountBudgetProposal;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAccountBudgetProposal(String accountBudgetProposal) {
            this.accountBudgetProposal = accountBudgetProposal;
            return this;
        }

        private Builder() {
        }

        private Builder(AccountBudgetProposalName accountBudgetProposalName) {
            this.customer = accountBudgetProposalName.customer;
            this.accountBudgetProposal = accountBudgetProposalName.accountBudgetProposal;
        }

        public AccountBudgetProposalName build() {
            return new AccountBudgetProposalName(this);
        }
    }
}

