/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AccountLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/accountLinks/{account_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String accountLink;

    public String getCustomer() {
        return this.customer;
    }

    public String getAccountLink() {
        return this.accountLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AccountLinkName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.accountLink = (String)Preconditions.checkNotNull((Object)builder.getAccountLink());
    }

    public static AccountLinkName of(String customer, String accountLink) {
        return AccountLinkName.newBuilder().setCustomer(customer).setAccountLink(accountLink).build();
    }

    public static String format(String customer, String accountLink) {
        return AccountLinkName.newBuilder().setCustomer(customer).setAccountLink(accountLink).build().toString();
    }

    public static AccountLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AccountLinkName.parse: formattedString not in valid format");
        return AccountLinkName.of((String)matchMap.get("customer"), (String)matchMap.get("account_link"));
    }

    public static List<AccountLinkName> parseList(List<String> formattedStrings) {
        ArrayList<AccountLinkName> list = new ArrayList<AccountLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AccountLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AccountLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AccountLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AccountLinkName accountLinkName = this;
            synchronized (accountLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"accountLink", (Object)this.accountLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "account_link", this.accountLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AccountLinkName) {
            AccountLinkName that = (AccountLinkName)o;
            return this.customer.equals(that.customer) && this.accountLink.equals(that.accountLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.accountLink.hashCode();
    }

    public static class Builder {
        private String customer;
        private String accountLink;

        public String getCustomer() {
            return this.customer;
        }

        public String getAccountLink() {
            return this.accountLink;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAccountLink(String accountLink) {
            this.accountLink = accountLink;
            return this;
        }

        private Builder() {
        }

        private Builder(AccountLinkName accountLinkName) {
            this.customer = accountLinkName.customer;
            this.accountLink = accountLinkName.accountLink;
        }

        public AccountLinkName build() {
            return new AccountLinkName(this);
        }
    }
}

