/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupAdAssetViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupAdAssetViews/{ad_group_ad_asset_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupAdAssetView;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupAdAssetView() {
        return this.adGroupAdAssetView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupAdAssetViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupAdAssetView = (String)Preconditions.checkNotNull((Object)builder.getAdGroupAdAssetView());
    }

    public static AdGroupAdAssetViewName of(String customer, String adGroupAdAssetView) {
        return AdGroupAdAssetViewName.newBuilder().setCustomer(customer).setAdGroupAdAssetView(adGroupAdAssetView).build();
    }

    public static String format(String customer, String adGroupAdAssetView) {
        return AdGroupAdAssetViewName.newBuilder().setCustomer(customer).setAdGroupAdAssetView(adGroupAdAssetView).build().toString();
    }

    public static AdGroupAdAssetViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupAdAssetViewName.parse: formattedString not in valid format");
        return AdGroupAdAssetViewName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_ad_asset_view"));
    }

    public static List<AdGroupAdAssetViewName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdAssetViewName> list = new ArrayList<AdGroupAdAssetViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdAssetViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdAssetViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdAssetViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdAssetViewName adGroupAdAssetViewName = this;
            synchronized (adGroupAdAssetViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupAdAssetView", (Object)this.adGroupAdAssetView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_ad_asset_view", this.adGroupAdAssetView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupAdAssetViewName) {
            AdGroupAdAssetViewName that = (AdGroupAdAssetViewName)o;
            return this.customer.equals(that.customer) && this.adGroupAdAssetView.equals(that.adGroupAdAssetView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupAdAssetView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupAdAssetView;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupAdAssetView() {
            return this.adGroupAdAssetView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupAdAssetView(String adGroupAdAssetView) {
            this.adGroupAdAssetView = adGroupAdAssetView;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupAdAssetViewName adGroupAdAssetViewName) {
            this.customer = adGroupAdAssetViewName.customer;
            this.adGroupAdAssetView = adGroupAdAssetViewName.adGroupAdAssetView;
        }

        public AdGroupAdAssetViewName build() {
            return new AdGroupAdAssetViewName(this);
        }
    }
}

