/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupAdLabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupAdLabels/{ad_group_ad_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupAdLabel;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupAdLabel() {
        return this.adGroupAdLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupAdLabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupAdLabel = (String)Preconditions.checkNotNull((Object)builder.getAdGroupAdLabel());
    }

    public static AdGroupAdLabelName of(String customer, String adGroupAdLabel) {
        return AdGroupAdLabelName.newBuilder().setCustomer(customer).setAdGroupAdLabel(adGroupAdLabel).build();
    }

    public static String format(String customer, String adGroupAdLabel) {
        return AdGroupAdLabelName.newBuilder().setCustomer(customer).setAdGroupAdLabel(adGroupAdLabel).build().toString();
    }

    public static AdGroupAdLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupAdLabelName.parse: formattedString not in valid format");
        return AdGroupAdLabelName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_ad_label"));
    }

    public static List<AdGroupAdLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdLabelName> list = new ArrayList<AdGroupAdLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdLabelName adGroupAdLabelName = this;
            synchronized (adGroupAdLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupAdLabel", (Object)this.adGroupAdLabel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_ad_label", this.adGroupAdLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupAdLabelName) {
            AdGroupAdLabelName that = (AdGroupAdLabelName)o;
            return this.customer.equals(that.customer) && this.adGroupAdLabel.equals(that.adGroupAdLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupAdLabel.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupAdLabel;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupAdLabel() {
            return this.adGroupAdLabel;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupAdLabel(String adGroupAdLabel) {
            this.adGroupAdLabel = adGroupAdLabel;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupAdLabelName adGroupAdLabelName) {
            this.customer = adGroupAdLabelName.customer;
            this.adGroupAdLabel = adGroupAdLabelName.adGroupAdLabel;
        }

        public AdGroupAdLabelName build() {
            return new AdGroupAdLabelName(this);
        }
    }
}

