/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupAdName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupAds/{ad_group_ad}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupAd;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupAd() {
        return this.adGroupAd;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupAdName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupAd = (String)Preconditions.checkNotNull((Object)builder.getAdGroupAd());
    }

    public static AdGroupAdName of(String customer, String adGroupAd) {
        return AdGroupAdName.newBuilder().setCustomer(customer).setAdGroupAd(adGroupAd).build();
    }

    public static String format(String customer, String adGroupAd) {
        return AdGroupAdName.newBuilder().setCustomer(customer).setAdGroupAd(adGroupAd).build().toString();
    }

    public static AdGroupAdName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupAdName.parse: formattedString not in valid format");
        return AdGroupAdName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_ad"));
    }

    public static List<AdGroupAdName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAdName> list = new ArrayList<AdGroupAdName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAdName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAdName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAdName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAdName adGroupAdName = this;
            synchronized (adGroupAdName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupAd", (Object)this.adGroupAd);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_ad", this.adGroupAd});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupAdName) {
            AdGroupAdName that = (AdGroupAdName)o;
            return this.customer.equals(that.customer) && this.adGroupAd.equals(that.adGroupAd);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupAd.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupAd;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupAd() {
            return this.adGroupAd;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupAd(String adGroupAd) {
            this.adGroupAd = adGroupAd;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupAdName adGroupAdName) {
            this.customer = adGroupAdName.customer;
            this.adGroupAd = adGroupAdName.adGroupAd;
        }

        public AdGroupAdName build() {
            return new AdGroupAdName(this);
        }
    }
}

