/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupAudienceViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupAudienceViews/{ad_group_audience_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupAudienceView;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupAudienceView() {
        return this.adGroupAudienceView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupAudienceViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupAudienceView = (String)Preconditions.checkNotNull((Object)builder.getAdGroupAudienceView());
    }

    public static AdGroupAudienceViewName of(String customer, String adGroupAudienceView) {
        return AdGroupAudienceViewName.newBuilder().setCustomer(customer).setAdGroupAudienceView(adGroupAudienceView).build();
    }

    public static String format(String customer, String adGroupAudienceView) {
        return AdGroupAudienceViewName.newBuilder().setCustomer(customer).setAdGroupAudienceView(adGroupAudienceView).build().toString();
    }

    public static AdGroupAudienceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupAudienceViewName.parse: formattedString not in valid format");
        return AdGroupAudienceViewName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_audience_view"));
    }

    public static List<AdGroupAudienceViewName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAudienceViewName> list = new ArrayList<AdGroupAudienceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAudienceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAudienceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAudienceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAudienceViewName adGroupAudienceViewName = this;
            synchronized (adGroupAudienceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupAudienceView", (Object)this.adGroupAudienceView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_audience_view", this.adGroupAudienceView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupAudienceViewName) {
            AdGroupAudienceViewName that = (AdGroupAudienceViewName)o;
            return this.customer.equals(that.customer) && this.adGroupAudienceView.equals(that.adGroupAudienceView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupAudienceView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupAudienceView;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupAudienceView() {
            return this.adGroupAudienceView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupAudienceView(String adGroupAudienceView) {
            this.adGroupAudienceView = adGroupAudienceView;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupAudienceViewName adGroupAudienceViewName) {
            this.customer = adGroupAudienceViewName.customer;
            this.adGroupAudienceView = adGroupAudienceViewName.adGroupAudienceView;
        }

        public AdGroupAudienceViewName build() {
            return new AdGroupAudienceViewName(this);
        }
    }
}

