/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupBidModifierName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupBidModifiers/{ad_group_bid_modifier}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupBidModifier;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupBidModifier() {
        return this.adGroupBidModifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupBidModifierName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupBidModifier = (String)Preconditions.checkNotNull((Object)builder.getAdGroupBidModifier());
    }

    public static AdGroupBidModifierName of(String customer, String adGroupBidModifier) {
        return AdGroupBidModifierName.newBuilder().setCustomer(customer).setAdGroupBidModifier(adGroupBidModifier).build();
    }

    public static String format(String customer, String adGroupBidModifier) {
        return AdGroupBidModifierName.newBuilder().setCustomer(customer).setAdGroupBidModifier(adGroupBidModifier).build().toString();
    }

    public static AdGroupBidModifierName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupBidModifierName.parse: formattedString not in valid format");
        return AdGroupBidModifierName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_bid_modifier"));
    }

    public static List<AdGroupBidModifierName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupBidModifierName> list = new ArrayList<AdGroupBidModifierName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupBidModifierName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupBidModifierName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupBidModifierName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupBidModifierName adGroupBidModifierName = this;
            synchronized (adGroupBidModifierName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupBidModifier", (Object)this.adGroupBidModifier);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_bid_modifier", this.adGroupBidModifier});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupBidModifierName) {
            AdGroupBidModifierName that = (AdGroupBidModifierName)o;
            return this.customer.equals(that.customer) && this.adGroupBidModifier.equals(that.adGroupBidModifier);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupBidModifier.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupBidModifier;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupBidModifier() {
            return this.adGroupBidModifier;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupBidModifier(String adGroupBidModifier) {
            this.adGroupBidModifier = adGroupBidModifier;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupBidModifierName adGroupBidModifierName) {
            this.customer = adGroupBidModifierName.customer;
            this.adGroupBidModifier = adGroupBidModifierName.adGroupBidModifier;
        }

        public AdGroupBidModifierName build() {
            return new AdGroupBidModifierName(this);
        }
    }
}

