/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.AdGroupBidModifier;
import com.google.ads.googleads.v5.services.AdGroupBidModifierName;
import com.google.ads.googleads.v5.services.AdGroupBidModifierOperation;
import com.google.ads.googleads.v5.services.AdGroupBidModifierServiceSettings;
import com.google.ads.googleads.v5.services.GetAdGroupBidModifierRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupBidModifiersRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupBidModifiersResponse;
import com.google.ads.googleads.v5.services.stub.AdGroupBidModifierServiceStub;
import com.google.ads.googleads.v5.services.stub.AdGroupBidModifierServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AdGroupBidModifierServiceClient
implements BackgroundResource {
    private final AdGroupBidModifierServiceSettings settings;
    private final AdGroupBidModifierServiceStub stub;

    public static final AdGroupBidModifierServiceClient create() throws IOException {
        return AdGroupBidModifierServiceClient.create(AdGroupBidModifierServiceSettings.newBuilder().build());
    }

    public static final AdGroupBidModifierServiceClient create(AdGroupBidModifierServiceSettings settings) throws IOException {
        return new AdGroupBidModifierServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupBidModifierServiceClient create(AdGroupBidModifierServiceStub stub) {
        return new AdGroupBidModifierServiceClient(stub);
    }

    protected AdGroupBidModifierServiceClient(AdGroupBidModifierServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupBidModifierServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupBidModifierServiceClient(AdGroupBidModifierServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupBidModifierServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupBidModifierServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupBidModifier getAdGroupBidModifier(AdGroupBidModifierName resourceName) {
        GetAdGroupBidModifierRequest request = GetAdGroupBidModifierRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupBidModifier(request);
    }

    public final AdGroupBidModifier getAdGroupBidModifier(String resourceName) {
        GetAdGroupBidModifierRequest request = GetAdGroupBidModifierRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupBidModifier(request);
    }

    public final AdGroupBidModifier getAdGroupBidModifier(GetAdGroupBidModifierRequest request) {
        return (AdGroupBidModifier)this.getAdGroupBidModifierCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupBidModifierRequest, AdGroupBidModifier> getAdGroupBidModifierCallable() {
        return this.stub.getAdGroupBidModifierCallable();
    }

    public final MutateAdGroupBidModifiersResponse mutateAdGroupBidModifiers(String customerId, List<AdGroupBidModifierOperation> operations) {
        MutateAdGroupBidModifiersRequest request = MutateAdGroupBidModifiersRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupBidModifiers(request);
    }

    public final MutateAdGroupBidModifiersResponse mutateAdGroupBidModifiers(MutateAdGroupBidModifiersRequest request) {
        return (MutateAdGroupBidModifiersResponse)this.mutateAdGroupBidModifiersCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupBidModifiersRequest, MutateAdGroupBidModifiersResponse> mutateAdGroupBidModifiersCallable() {
        return this.stub.mutateAdGroupBidModifiersCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

