/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupCriterionLabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupCriterionLabels/{ad_group_criterion_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupCriterionLabel;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupCriterionLabel() {
        return this.adGroupCriterionLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupCriterionLabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupCriterionLabel = (String)Preconditions.checkNotNull((Object)builder.getAdGroupCriterionLabel());
    }

    public static AdGroupCriterionLabelName of(String customer, String adGroupCriterionLabel) {
        return AdGroupCriterionLabelName.newBuilder().setCustomer(customer).setAdGroupCriterionLabel(adGroupCriterionLabel).build();
    }

    public static String format(String customer, String adGroupCriterionLabel) {
        return AdGroupCriterionLabelName.newBuilder().setCustomer(customer).setAdGroupCriterionLabel(adGroupCriterionLabel).build().toString();
    }

    public static AdGroupCriterionLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupCriterionLabelName.parse: formattedString not in valid format");
        return AdGroupCriterionLabelName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_criterion_label"));
    }

    public static List<AdGroupCriterionLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCriterionLabelName> list = new ArrayList<AdGroupCriterionLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCriterionLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCriterionLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCriterionLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCriterionLabelName adGroupCriterionLabelName = this;
            synchronized (adGroupCriterionLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupCriterionLabel", (Object)this.adGroupCriterionLabel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_criterion_label", this.adGroupCriterionLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupCriterionLabelName) {
            AdGroupCriterionLabelName that = (AdGroupCriterionLabelName)o;
            return this.customer.equals(that.customer) && this.adGroupCriterionLabel.equals(that.adGroupCriterionLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupCriterionLabel.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupCriterionLabel;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupCriterionLabel() {
            return this.adGroupCriterionLabel;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupCriterionLabel(String adGroupCriterionLabel) {
            this.adGroupCriterionLabel = adGroupCriterionLabel;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupCriterionLabelName adGroupCriterionLabelName) {
            this.customer = adGroupCriterionLabelName.customer;
            this.adGroupCriterionLabel = adGroupCriterionLabelName.adGroupCriterionLabel;
        }

        public AdGroupCriterionLabelName build() {
            return new AdGroupCriterionLabelName(this);
        }
    }
}

