/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupCriterionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupCriteria/{ad_group_criterion}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupCriterion;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupCriterion() {
        return this.adGroupCriterion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupCriterionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupCriterion = (String)Preconditions.checkNotNull((Object)builder.getAdGroupCriterion());
    }

    public static AdGroupCriterionName of(String customer, String adGroupCriterion) {
        return AdGroupCriterionName.newBuilder().setCustomer(customer).setAdGroupCriterion(adGroupCriterion).build();
    }

    public static String format(String customer, String adGroupCriterion) {
        return AdGroupCriterionName.newBuilder().setCustomer(customer).setAdGroupCriterion(adGroupCriterion).build().toString();
    }

    public static AdGroupCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupCriterionName.parse: formattedString not in valid format");
        return AdGroupCriterionName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_criterion"));
    }

    public static List<AdGroupCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCriterionName> list = new ArrayList<AdGroupCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCriterionName adGroupCriterionName = this;
            synchronized (adGroupCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupCriterion", (Object)this.adGroupCriterion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_criterion", this.adGroupCriterion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupCriterionName) {
            AdGroupCriterionName that = (AdGroupCriterionName)o;
            return this.customer.equals(that.customer) && this.adGroupCriterion.equals(that.adGroupCriterion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupCriterion.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupCriterion;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupCriterion() {
            return this.adGroupCriterion;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupCriterion(String adGroupCriterion) {
            this.adGroupCriterion = adGroupCriterion;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupCriterionName adGroupCriterionName) {
            this.customer = adGroupCriterionName.customer;
            this.adGroupCriterion = adGroupCriterionName.adGroupCriterion;
        }

        public AdGroupCriterionName build() {
            return new AdGroupCriterionName(this);
        }
    }
}

