/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupCriterionSimulationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupCriterionSimulations/{ad_group_criterion_simulation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupCriterionSimulation;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupCriterionSimulation() {
        return this.adGroupCriterionSimulation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupCriterionSimulationName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupCriterionSimulation = (String)Preconditions.checkNotNull((Object)builder.getAdGroupCriterionSimulation());
    }

    public static AdGroupCriterionSimulationName of(String customer, String adGroupCriterionSimulation) {
        return AdGroupCriterionSimulationName.newBuilder().setCustomer(customer).setAdGroupCriterionSimulation(adGroupCriterionSimulation).build();
    }

    public static String format(String customer, String adGroupCriterionSimulation) {
        return AdGroupCriterionSimulationName.newBuilder().setCustomer(customer).setAdGroupCriterionSimulation(adGroupCriterionSimulation).build().toString();
    }

    public static AdGroupCriterionSimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupCriterionSimulationName.parse: formattedString not in valid format");
        return AdGroupCriterionSimulationName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_criterion_simulation"));
    }

    public static List<AdGroupCriterionSimulationName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupCriterionSimulationName> list = new ArrayList<AdGroupCriterionSimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupCriterionSimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupCriterionSimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupCriterionSimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupCriterionSimulationName adGroupCriterionSimulationName = this;
            synchronized (adGroupCriterionSimulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupCriterionSimulation", (Object)this.adGroupCriterionSimulation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_criterion_simulation", this.adGroupCriterionSimulation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupCriterionSimulationName) {
            AdGroupCriterionSimulationName that = (AdGroupCriterionSimulationName)o;
            return this.customer.equals(that.customer) && this.adGroupCriterionSimulation.equals(that.adGroupCriterionSimulation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupCriterionSimulation.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupCriterionSimulation;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupCriterionSimulation() {
            return this.adGroupCriterionSimulation;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupCriterionSimulation(String adGroupCriterionSimulation) {
            this.adGroupCriterionSimulation = adGroupCriterionSimulation;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupCriterionSimulationName adGroupCriterionSimulationName) {
            this.customer = adGroupCriterionSimulationName.customer;
            this.adGroupCriterionSimulation = adGroupCriterionSimulationName.adGroupCriterionSimulation;
        }

        public AdGroupCriterionSimulationName build() {
            return new AdGroupCriterionSimulationName(this);
        }
    }
}

