/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupExtensionSettingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupExtensionSettings/{ad_group_extension_setting}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupExtensionSetting;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupExtensionSetting() {
        return this.adGroupExtensionSetting;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupExtensionSettingName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupExtensionSetting = (String)Preconditions.checkNotNull((Object)builder.getAdGroupExtensionSetting());
    }

    public static AdGroupExtensionSettingName of(String customer, String adGroupExtensionSetting) {
        return AdGroupExtensionSettingName.newBuilder().setCustomer(customer).setAdGroupExtensionSetting(adGroupExtensionSetting).build();
    }

    public static String format(String customer, String adGroupExtensionSetting) {
        return AdGroupExtensionSettingName.newBuilder().setCustomer(customer).setAdGroupExtensionSetting(adGroupExtensionSetting).build().toString();
    }

    public static AdGroupExtensionSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupExtensionSettingName.parse: formattedString not in valid format");
        return AdGroupExtensionSettingName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_extension_setting"));
    }

    public static List<AdGroupExtensionSettingName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupExtensionSettingName> list = new ArrayList<AdGroupExtensionSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupExtensionSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupExtensionSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupExtensionSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupExtensionSettingName adGroupExtensionSettingName = this;
            synchronized (adGroupExtensionSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupExtensionSetting", (Object)this.adGroupExtensionSetting);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_extension_setting", this.adGroupExtensionSetting});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupExtensionSettingName) {
            AdGroupExtensionSettingName that = (AdGroupExtensionSettingName)o;
            return this.customer.equals(that.customer) && this.adGroupExtensionSetting.equals(that.adGroupExtensionSetting);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupExtensionSetting.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupExtensionSetting;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupExtensionSetting() {
            return this.adGroupExtensionSetting;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupExtensionSetting(String adGroupExtensionSetting) {
            this.adGroupExtensionSetting = adGroupExtensionSetting;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupExtensionSettingName adGroupExtensionSettingName) {
            this.customer = adGroupExtensionSettingName.customer;
            this.adGroupExtensionSetting = adGroupExtensionSettingName.adGroupExtensionSetting;
        }

        public AdGroupExtensionSettingName build() {
            return new AdGroupExtensionSettingName(this);
        }
    }
}

