/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupFeedName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupFeeds/{ad_group_feed}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupFeed;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupFeed() {
        return this.adGroupFeed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupFeedName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupFeed = (String)Preconditions.checkNotNull((Object)builder.getAdGroupFeed());
    }

    public static AdGroupFeedName of(String customer, String adGroupFeed) {
        return AdGroupFeedName.newBuilder().setCustomer(customer).setAdGroupFeed(adGroupFeed).build();
    }

    public static String format(String customer, String adGroupFeed) {
        return AdGroupFeedName.newBuilder().setCustomer(customer).setAdGroupFeed(adGroupFeed).build().toString();
    }

    public static AdGroupFeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupFeedName.parse: formattedString not in valid format");
        return AdGroupFeedName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_feed"));
    }

    public static List<AdGroupFeedName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupFeedName> list = new ArrayList<AdGroupFeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupFeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupFeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupFeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupFeedName adGroupFeedName = this;
            synchronized (adGroupFeedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupFeed", (Object)this.adGroupFeed);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_feed", this.adGroupFeed});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupFeedName) {
            AdGroupFeedName that = (AdGroupFeedName)o;
            return this.customer.equals(that.customer) && this.adGroupFeed.equals(that.adGroupFeed);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupFeed.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupFeed;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupFeed() {
            return this.adGroupFeed;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupFeed(String adGroupFeed) {
            this.adGroupFeed = adGroupFeed;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupFeedName adGroupFeedName) {
            this.customer = adGroupFeedName.customer;
            this.adGroupFeed = adGroupFeedName.adGroupFeed;
        }

        public AdGroupFeedName build() {
            return new AdGroupFeedName(this);
        }
    }
}

