/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupLabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupLabels/{ad_group_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupLabel;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupLabel() {
        return this.adGroupLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupLabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupLabel = (String)Preconditions.checkNotNull((Object)builder.getAdGroupLabel());
    }

    public static AdGroupLabelName of(String customer, String adGroupLabel) {
        return AdGroupLabelName.newBuilder().setCustomer(customer).setAdGroupLabel(adGroupLabel).build();
    }

    public static String format(String customer, String adGroupLabel) {
        return AdGroupLabelName.newBuilder().setCustomer(customer).setAdGroupLabel(adGroupLabel).build().toString();
    }

    public static AdGroupLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupLabelName.parse: formattedString not in valid format");
        return AdGroupLabelName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_label"));
    }

    public static List<AdGroupLabelName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupLabelName> list = new ArrayList<AdGroupLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupLabelName adGroupLabelName = this;
            synchronized (adGroupLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupLabel", (Object)this.adGroupLabel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_label", this.adGroupLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupLabelName) {
            AdGroupLabelName that = (AdGroupLabelName)o;
            return this.customer.equals(that.customer) && this.adGroupLabel.equals(that.adGroupLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupLabel.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupLabel;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupLabel() {
            return this.adGroupLabel;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupLabel(String adGroupLabel) {
            this.adGroupLabel = adGroupLabel;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupLabelName adGroupLabelName) {
            this.customer = adGroupLabelName.customer;
            this.adGroupLabel = adGroupLabelName.adGroupLabel;
        }

        public AdGroupLabelName build() {
            return new AdGroupLabelName(this);
        }
    }
}

