/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.AdGroupLabel;
import com.google.ads.googleads.v5.services.AdGroupLabelName;
import com.google.ads.googleads.v5.services.AdGroupLabelOperation;
import com.google.ads.googleads.v5.services.AdGroupLabelServiceSettings;
import com.google.ads.googleads.v5.services.GetAdGroupLabelRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupLabelsRequest;
import com.google.ads.googleads.v5.services.MutateAdGroupLabelsResponse;
import com.google.ads.googleads.v5.services.stub.AdGroupLabelServiceStub;
import com.google.ads.googleads.v5.services.stub.AdGroupLabelServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AdGroupLabelServiceClient
implements BackgroundResource {
    private final AdGroupLabelServiceSettings settings;
    private final AdGroupLabelServiceStub stub;

    public static final AdGroupLabelServiceClient create() throws IOException {
        return AdGroupLabelServiceClient.create(AdGroupLabelServiceSettings.newBuilder().build());
    }

    public static final AdGroupLabelServiceClient create(AdGroupLabelServiceSettings settings) throws IOException {
        return new AdGroupLabelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AdGroupLabelServiceClient create(AdGroupLabelServiceStub stub) {
        return new AdGroupLabelServiceClient(stub);
    }

    protected AdGroupLabelServiceClient(AdGroupLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AdGroupLabelServiceClient(AdGroupLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupLabelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AdGroupLabelServiceStub getStub() {
        return this.stub;
    }

    public final AdGroupLabel getAdGroupLabel(AdGroupLabelName resourceName) {
        GetAdGroupLabelRequest request = GetAdGroupLabelRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAdGroupLabel(request);
    }

    public final AdGroupLabel getAdGroupLabel(String resourceName) {
        GetAdGroupLabelRequest request = GetAdGroupLabelRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAdGroupLabel(request);
    }

    public final AdGroupLabel getAdGroupLabel(GetAdGroupLabelRequest request) {
        return (AdGroupLabel)this.getAdGroupLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdGroupLabelRequest, AdGroupLabel> getAdGroupLabelCallable() {
        return this.stub.getAdGroupLabelCallable();
    }

    public final MutateAdGroupLabelsResponse mutateAdGroupLabels(String customerId, List<AdGroupLabelOperation> operations) {
        MutateAdGroupLabelsRequest request = MutateAdGroupLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupLabels(request);
    }

    public final MutateAdGroupLabelsResponse mutateAdGroupLabels(MutateAdGroupLabelsRequest request) {
        return (MutateAdGroupLabelsResponse)this.mutateAdGroupLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupLabelsRequest, MutateAdGroupLabelsResponse> mutateAdGroupLabelsCallable() {
        return this.stub.mutateAdGroupLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

