/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroups/{ad_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroup;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroup() {
        return this.adGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroup = (String)Preconditions.checkNotNull((Object)builder.getAdGroup());
    }

    public static AdGroupName of(String customer, String adGroup) {
        return AdGroupName.newBuilder().setCustomer(customer).setAdGroup(adGroup).build();
    }

    public static String format(String customer, String adGroup) {
        return AdGroupName.newBuilder().setCustomer(customer).setAdGroup(adGroup).build().toString();
    }

    public static AdGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupName.parse: formattedString not in valid format");
        return AdGroupName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group"));
    }

    public static List<AdGroupName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupName> list = new ArrayList<AdGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupName adGroupName = this;
            synchronized (adGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroup", (Object)this.adGroup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group", this.adGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupName) {
            AdGroupName that = (AdGroupName)o;
            return this.customer.equals(that.customer) && this.adGroup.equals(that.adGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroup.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroup;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroup() {
            return this.adGroup;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroup(String adGroup) {
            this.adGroup = adGroup;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupName adGroupName) {
            this.customer = adGroupName.customer;
            this.adGroup = adGroupName.adGroup;
        }

        public AdGroupName build() {
            return new AdGroupName(this);
        }
    }
}

