/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdGroupSimulationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adGroupSimulations/{ad_group_simulation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adGroupSimulation;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdGroupSimulation() {
        return this.adGroupSimulation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdGroupSimulationName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adGroupSimulation = (String)Preconditions.checkNotNull((Object)builder.getAdGroupSimulation());
    }

    public static AdGroupSimulationName of(String customer, String adGroupSimulation) {
        return AdGroupSimulationName.newBuilder().setCustomer(customer).setAdGroupSimulation(adGroupSimulation).build();
    }

    public static String format(String customer, String adGroupSimulation) {
        return AdGroupSimulationName.newBuilder().setCustomer(customer).setAdGroupSimulation(adGroupSimulation).build().toString();
    }

    public static AdGroupSimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdGroupSimulationName.parse: formattedString not in valid format");
        return AdGroupSimulationName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_group_simulation"));
    }

    public static List<AdGroupSimulationName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupSimulationName> list = new ArrayList<AdGroupSimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupSimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupSimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupSimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupSimulationName adGroupSimulationName = this;
            synchronized (adGroupSimulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adGroupSimulation", (Object)this.adGroupSimulation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_group_simulation", this.adGroupSimulation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdGroupSimulationName) {
            AdGroupSimulationName that = (AdGroupSimulationName)o;
            return this.customer.equals(that.customer) && this.adGroupSimulation.equals(that.adGroupSimulation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adGroupSimulation.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adGroupSimulation;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdGroupSimulation() {
            return this.adGroupSimulation;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdGroupSimulation(String adGroupSimulation) {
            this.adGroupSimulation = adGroupSimulation;
            return this;
        }

        private Builder() {
        }

        private Builder(AdGroupSimulationName adGroupSimulationName) {
            this.customer = adGroupSimulationName.customer;
            this.adGroupSimulation = adGroupSimulationName.adGroupSimulation;
        }

        public AdGroupSimulationName build() {
            return new AdGroupSimulationName(this);
        }
    }
}

