/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/ads/{ad}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String ad;

    public String getCustomer() {
        return this.customer;
    }

    public String getAd() {
        return this.ad;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.ad = (String)Preconditions.checkNotNull((Object)builder.getAd());
    }

    public static AdName of(String customer, String ad) {
        return AdName.newBuilder().setCustomer(customer).setAd(ad).build();
    }

    public static String format(String customer, String ad) {
        return AdName.newBuilder().setCustomer(customer).setAd(ad).build().toString();
    }

    public static AdName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdName.parse: formattedString not in valid format");
        return AdName.of((String)matchMap.get("customer"), (String)matchMap.get("ad"));
    }

    public static List<AdName> parseList(List<String> formattedStrings) {
        ArrayList<AdName> list = new ArrayList<AdName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdName adName = this;
            synchronized (adName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"ad", (Object)this.ad);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad", this.ad});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdName) {
            AdName that = (AdName)o;
            return this.customer.equals(that.customer) && this.ad.equals(that.ad);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.ad.hashCode();
    }

    public static class Builder {
        private String customer;
        private String ad;

        public String getCustomer() {
            return this.customer;
        }

        public String getAd() {
            return this.ad;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAd(String ad) {
            this.ad = ad;
            return this;
        }

        private Builder() {
        }

        private Builder(AdName adName) {
            this.customer = adName.customer;
            this.ad = adName.ad;
        }

        public AdName build() {
            return new AdName(this);
        }
    }
}

