/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdParameterName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adParameters/{ad_parameter}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adParameter;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdParameter() {
        return this.adParameter;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdParameterName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adParameter = (String)Preconditions.checkNotNull((Object)builder.getAdParameter());
    }

    public static AdParameterName of(String customer, String adParameter) {
        return AdParameterName.newBuilder().setCustomer(customer).setAdParameter(adParameter).build();
    }

    public static String format(String customer, String adParameter) {
        return AdParameterName.newBuilder().setCustomer(customer).setAdParameter(adParameter).build().toString();
    }

    public static AdParameterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdParameterName.parse: formattedString not in valid format");
        return AdParameterName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_parameter"));
    }

    public static List<AdParameterName> parseList(List<String> formattedStrings) {
        ArrayList<AdParameterName> list = new ArrayList<AdParameterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdParameterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdParameterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdParameterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdParameterName adParameterName = this;
            synchronized (adParameterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adParameter", (Object)this.adParameter);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_parameter", this.adParameter});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdParameterName) {
            AdParameterName that = (AdParameterName)o;
            return this.customer.equals(that.customer) && this.adParameter.equals(that.adParameter);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adParameter.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adParameter;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdParameter() {
            return this.adParameter;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdParameter(String adParameter) {
            this.adParameter = adParameter;
            return this;
        }

        private Builder() {
        }

        private Builder(AdParameterName adParameterName) {
            this.customer = adParameterName.customer;
            this.adParameter = adParameterName.adParameter;
        }

        public AdParameterName build() {
            return new AdParameterName(this);
        }
    }
}

