/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AdScheduleViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/adScheduleViews/{ad_schedule_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String adScheduleView;

    public String getCustomer() {
        return this.customer;
    }

    public String getAdScheduleView() {
        return this.adScheduleView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AdScheduleViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.adScheduleView = (String)Preconditions.checkNotNull((Object)builder.getAdScheduleView());
    }

    public static AdScheduleViewName of(String customer, String adScheduleView) {
        return AdScheduleViewName.newBuilder().setCustomer(customer).setAdScheduleView(adScheduleView).build();
    }

    public static String format(String customer, String adScheduleView) {
        return AdScheduleViewName.newBuilder().setCustomer(customer).setAdScheduleView(adScheduleView).build().toString();
    }

    public static AdScheduleViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AdScheduleViewName.parse: formattedString not in valid format");
        return AdScheduleViewName.of((String)matchMap.get("customer"), (String)matchMap.get("ad_schedule_view"));
    }

    public static List<AdScheduleViewName> parseList(List<String> formattedStrings) {
        ArrayList<AdScheduleViewName> list = new ArrayList<AdScheduleViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdScheduleViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdScheduleViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdScheduleViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdScheduleViewName adScheduleViewName = this;
            synchronized (adScheduleViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"adScheduleView", (Object)this.adScheduleView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "ad_schedule_view", this.adScheduleView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AdScheduleViewName) {
            AdScheduleViewName that = (AdScheduleViewName)o;
            return this.customer.equals(that.customer) && this.adScheduleView.equals(that.adScheduleView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.adScheduleView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String adScheduleView;

        public String getCustomer() {
            return this.customer;
        }

        public String getAdScheduleView() {
            return this.adScheduleView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAdScheduleView(String adScheduleView) {
            this.adScheduleView = adScheduleView;
            return this;
        }

        private Builder() {
        }

        private Builder(AdScheduleViewName adScheduleViewName) {
            this.customer = adScheduleViewName.customer;
            this.adScheduleView = adScheduleViewName.adScheduleView;
        }

        public AdScheduleViewName build() {
            return new AdScheduleViewName(this);
        }
    }
}

