/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AgeRangeViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/ageRangeViews/{age_range_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String ageRangeView;

    public String getCustomer() {
        return this.customer;
    }

    public String getAgeRangeView() {
        return this.ageRangeView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AgeRangeViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.ageRangeView = (String)Preconditions.checkNotNull((Object)builder.getAgeRangeView());
    }

    public static AgeRangeViewName of(String customer, String ageRangeView) {
        return AgeRangeViewName.newBuilder().setCustomer(customer).setAgeRangeView(ageRangeView).build();
    }

    public static String format(String customer, String ageRangeView) {
        return AgeRangeViewName.newBuilder().setCustomer(customer).setAgeRangeView(ageRangeView).build().toString();
    }

    public static AgeRangeViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AgeRangeViewName.parse: formattedString not in valid format");
        return AgeRangeViewName.of((String)matchMap.get("customer"), (String)matchMap.get("age_range_view"));
    }

    public static List<AgeRangeViewName> parseList(List<String> formattedStrings) {
        ArrayList<AgeRangeViewName> list = new ArrayList<AgeRangeViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AgeRangeViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AgeRangeViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AgeRangeViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AgeRangeViewName ageRangeViewName = this;
            synchronized (ageRangeViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"ageRangeView", (Object)this.ageRangeView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "age_range_view", this.ageRangeView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AgeRangeViewName) {
            AgeRangeViewName that = (AgeRangeViewName)o;
            return this.customer.equals(that.customer) && this.ageRangeView.equals(that.ageRangeView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.ageRangeView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String ageRangeView;

        public String getCustomer() {
            return this.customer;
        }

        public String getAgeRangeView() {
            return this.ageRangeView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setAgeRangeView(String ageRangeView) {
            this.ageRangeView = ageRangeView;
            return this;
        }

        private Builder() {
        }

        private Builder(AgeRangeViewName ageRangeViewName) {
            this.customer = ageRangeViewName.customer;
            this.ageRangeView = ageRangeViewName.ageRangeView;
        }

        public AgeRangeViewName build() {
            return new AgeRangeViewName(this);
        }
    }
}

