/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchJobName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/batchJobs/{batch_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String batchJob;

    public String getCustomer() {
        return this.customer;
    }

    public String getBatchJob() {
        return this.batchJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BatchJobName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.batchJob = (String)Preconditions.checkNotNull((Object)builder.getBatchJob());
    }

    public static BatchJobName of(String customer, String batchJob) {
        return BatchJobName.newBuilder().setCustomer(customer).setBatchJob(batchJob).build();
    }

    public static String format(String customer, String batchJob) {
        return BatchJobName.newBuilder().setCustomer(customer).setBatchJob(batchJob).build().toString();
    }

    public static BatchJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BatchJobName.parse: formattedString not in valid format");
        return BatchJobName.of((String)matchMap.get("customer"), (String)matchMap.get("batch_job"));
    }

    public static List<BatchJobName> parseList(List<String> formattedStrings) {
        ArrayList<BatchJobName> list = new ArrayList<BatchJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BatchJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BatchJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BatchJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BatchJobName batchJobName = this;
            synchronized (batchJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"batchJob", (Object)this.batchJob);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "batch_job", this.batchJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BatchJobName) {
            BatchJobName that = (BatchJobName)o;
            return this.customer.equals(that.customer) && this.batchJob.equals(that.batchJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.batchJob.hashCode();
    }

    public static class Builder {
        private String customer;
        private String batchJob;

        public String getCustomer() {
            return this.customer;
        }

        public String getBatchJob() {
            return this.batchJob;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setBatchJob(String batchJob) {
            this.batchJob = batchJob;
            return this;
        }

        private Builder() {
        }

        private Builder(BatchJobName batchJobName) {
            this.customer = batchJobName.customer;
            this.batchJob = batchJobName.batchJob;
        }

        public BatchJobName build() {
            return new BatchJobName(this);
        }
    }
}

