/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BiddingStrategyName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/biddingStrategies/{bidding_strategy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String biddingStrategy;

    public String getCustomer() {
        return this.customer;
    }

    public String getBiddingStrategy() {
        return this.biddingStrategy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BiddingStrategyName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.biddingStrategy = (String)Preconditions.checkNotNull((Object)builder.getBiddingStrategy());
    }

    public static BiddingStrategyName of(String customer, String biddingStrategy) {
        return BiddingStrategyName.newBuilder().setCustomer(customer).setBiddingStrategy(biddingStrategy).build();
    }

    public static String format(String customer, String biddingStrategy) {
        return BiddingStrategyName.newBuilder().setCustomer(customer).setBiddingStrategy(biddingStrategy).build().toString();
    }

    public static BiddingStrategyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BiddingStrategyName.parse: formattedString not in valid format");
        return BiddingStrategyName.of((String)matchMap.get("customer"), (String)matchMap.get("bidding_strategy"));
    }

    public static List<BiddingStrategyName> parseList(List<String> formattedStrings) {
        ArrayList<BiddingStrategyName> list = new ArrayList<BiddingStrategyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BiddingStrategyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BiddingStrategyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BiddingStrategyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BiddingStrategyName biddingStrategyName = this;
            synchronized (biddingStrategyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"biddingStrategy", (Object)this.biddingStrategy);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "bidding_strategy", this.biddingStrategy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BiddingStrategyName) {
            BiddingStrategyName that = (BiddingStrategyName)o;
            return this.customer.equals(that.customer) && this.biddingStrategy.equals(that.biddingStrategy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.biddingStrategy.hashCode();
    }

    public static class Builder {
        private String customer;
        private String biddingStrategy;

        public String getCustomer() {
            return this.customer;
        }

        public String getBiddingStrategy() {
            return this.biddingStrategy;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setBiddingStrategy(String biddingStrategy) {
            this.biddingStrategy = biddingStrategy;
            return this;
        }

        private Builder() {
        }

        private Builder(BiddingStrategyName biddingStrategyName) {
            this.customer = biddingStrategyName.customer;
            this.biddingStrategy = biddingStrategyName.biddingStrategy;
        }

        public BiddingStrategyName build() {
            return new BiddingStrategyName(this);
        }
    }
}

