/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.BiddingStrategy;
import com.google.ads.googleads.v5.services.BiddingStrategyName;
import com.google.ads.googleads.v5.services.BiddingStrategyOperation;
import com.google.ads.googleads.v5.services.BiddingStrategyServiceSettings;
import com.google.ads.googleads.v5.services.GetBiddingStrategyRequest;
import com.google.ads.googleads.v5.services.MutateBiddingStrategiesRequest;
import com.google.ads.googleads.v5.services.MutateBiddingStrategiesResponse;
import com.google.ads.googleads.v5.services.stub.BiddingStrategyServiceStub;
import com.google.ads.googleads.v5.services.stub.BiddingStrategyServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BiddingStrategyServiceClient
implements BackgroundResource {
    private final BiddingStrategyServiceSettings settings;
    private final BiddingStrategyServiceStub stub;

    public static final BiddingStrategyServiceClient create() throws IOException {
        return BiddingStrategyServiceClient.create(BiddingStrategyServiceSettings.newBuilder().build());
    }

    public static final BiddingStrategyServiceClient create(BiddingStrategyServiceSettings settings) throws IOException {
        return new BiddingStrategyServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BiddingStrategyServiceClient create(BiddingStrategyServiceStub stub) {
        return new BiddingStrategyServiceClient(stub);
    }

    protected BiddingStrategyServiceClient(BiddingStrategyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BiddingStrategyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BiddingStrategyServiceClient(BiddingStrategyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BiddingStrategyServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BiddingStrategyServiceStub getStub() {
        return this.stub;
    }

    public final BiddingStrategy getBiddingStrategy(BiddingStrategyName resourceName) {
        GetBiddingStrategyRequest request = GetBiddingStrategyRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getBiddingStrategy(request);
    }

    public final BiddingStrategy getBiddingStrategy(String resourceName) {
        GetBiddingStrategyRequest request = GetBiddingStrategyRequest.newBuilder().setResourceName(resourceName).build();
        return this.getBiddingStrategy(request);
    }

    public final BiddingStrategy getBiddingStrategy(GetBiddingStrategyRequest request) {
        return (BiddingStrategy)this.getBiddingStrategyCallable().call((Object)request);
    }

    public final UnaryCallable<GetBiddingStrategyRequest, BiddingStrategy> getBiddingStrategyCallable() {
        return this.stub.getBiddingStrategyCallable();
    }

    public final MutateBiddingStrategiesResponse mutateBiddingStrategies(String customerId, List<BiddingStrategyOperation> operations) {
        MutateBiddingStrategiesRequest request = MutateBiddingStrategiesRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateBiddingStrategies(request);
    }

    public final MutateBiddingStrategiesResponse mutateBiddingStrategies(MutateBiddingStrategiesRequest request) {
        return (MutateBiddingStrategiesResponse)this.mutateBiddingStrategiesCallable().call((Object)request);
    }

    public final UnaryCallable<MutateBiddingStrategiesRequest, MutateBiddingStrategiesResponse> mutateBiddingStrategiesCallable() {
        return this.stub.mutateBiddingStrategiesCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

