/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BillingSetupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/billingSetups/{billing_setup}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String billingSetup;

    public String getCustomer() {
        return this.customer;
    }

    public String getBillingSetup() {
        return this.billingSetup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingSetupName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.billingSetup = (String)Preconditions.checkNotNull((Object)builder.getBillingSetup());
    }

    public static BillingSetupName of(String customer, String billingSetup) {
        return BillingSetupName.newBuilder().setCustomer(customer).setBillingSetup(billingSetup).build();
    }

    public static String format(String customer, String billingSetup) {
        return BillingSetupName.newBuilder().setCustomer(customer).setBillingSetup(billingSetup).build().toString();
    }

    public static BillingSetupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingSetupName.parse: formattedString not in valid format");
        return BillingSetupName.of((String)matchMap.get("customer"), (String)matchMap.get("billing_setup"));
    }

    public static List<BillingSetupName> parseList(List<String> formattedStrings) {
        ArrayList<BillingSetupName> list = new ArrayList<BillingSetupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingSetupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingSetupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingSetupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingSetupName billingSetupName = this;
            synchronized (billingSetupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"billingSetup", (Object)this.billingSetup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "billing_setup", this.billingSetup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingSetupName) {
            BillingSetupName that = (BillingSetupName)o;
            return this.customer.equals(that.customer) && this.billingSetup.equals(that.billingSetup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.billingSetup.hashCode();
    }

    public static class Builder {
        private String customer;
        private String billingSetup;

        public String getCustomer() {
            return this.customer;
        }

        public String getBillingSetup() {
            return this.billingSetup;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setBillingSetup(String billingSetup) {
            this.billingSetup = billingSetup;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingSetupName billingSetupName) {
            this.customer = billingSetupName.customer;
            this.billingSetup = billingSetupName.billingSetup;
        }

        public BillingSetupName build() {
            return new BillingSetupName(this);
        }
    }
}

