/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.BillingSetup;
import com.google.ads.googleads.v5.services.BillingSetupName;
import com.google.ads.googleads.v5.services.BillingSetupOperation;
import com.google.ads.googleads.v5.services.BillingSetupServiceSettings;
import com.google.ads.googleads.v5.services.GetBillingSetupRequest;
import com.google.ads.googleads.v5.services.MutateBillingSetupRequest;
import com.google.ads.googleads.v5.services.MutateBillingSetupResponse;
import com.google.ads.googleads.v5.services.stub.BillingSetupServiceStub;
import com.google.ads.googleads.v5.services.stub.BillingSetupServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BillingSetupServiceClient
implements BackgroundResource {
    private final BillingSetupServiceSettings settings;
    private final BillingSetupServiceStub stub;

    public static final BillingSetupServiceClient create() throws IOException {
        return BillingSetupServiceClient.create(BillingSetupServiceSettings.newBuilder().build());
    }

    public static final BillingSetupServiceClient create(BillingSetupServiceSettings settings) throws IOException {
        return new BillingSetupServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BillingSetupServiceClient create(BillingSetupServiceStub stub) {
        return new BillingSetupServiceClient(stub);
    }

    protected BillingSetupServiceClient(BillingSetupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BillingSetupServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BillingSetupServiceClient(BillingSetupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BillingSetupServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BillingSetupServiceStub getStub() {
        return this.stub;
    }

    public final BillingSetup getBillingSetup(BillingSetupName resourceName) {
        GetBillingSetupRequest request = GetBillingSetupRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getBillingSetup(request);
    }

    public final BillingSetup getBillingSetup(String resourceName) {
        GetBillingSetupRequest request = GetBillingSetupRequest.newBuilder().setResourceName(resourceName).build();
        return this.getBillingSetup(request);
    }

    public final BillingSetup getBillingSetup(GetBillingSetupRequest request) {
        return (BillingSetup)this.getBillingSetupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBillingSetupRequest, BillingSetup> getBillingSetupCallable() {
        return this.stub.getBillingSetupCallable();
    }

    public final MutateBillingSetupResponse mutateBillingSetup(String customerId, BillingSetupOperation operation) {
        MutateBillingSetupRequest request = MutateBillingSetupRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateBillingSetup(request);
    }

    public final MutateBillingSetupResponse mutateBillingSetup(MutateBillingSetupRequest request) {
        return (MutateBillingSetupResponse)this.mutateBillingSetupCallable().call((Object)request);
    }

    public final UnaryCallable<MutateBillingSetupRequest, MutateBillingSetupResponse> mutateBillingSetupCallable() {
        return this.stub.mutateBillingSetupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

