/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignAssetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignAssets/{campaign_asset}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignAsset;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignAsset() {
        return this.campaignAsset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignAssetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignAsset = (String)Preconditions.checkNotNull((Object)builder.getCampaignAsset());
    }

    public static CampaignAssetName of(String customer, String campaignAsset) {
        return CampaignAssetName.newBuilder().setCustomer(customer).setCampaignAsset(campaignAsset).build();
    }

    public static String format(String customer, String campaignAsset) {
        return CampaignAssetName.newBuilder().setCustomer(customer).setCampaignAsset(campaignAsset).build().toString();
    }

    public static CampaignAssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignAssetName.parse: formattedString not in valid format");
        return CampaignAssetName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_asset"));
    }

    public static List<CampaignAssetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignAssetName> list = new ArrayList<CampaignAssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignAssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignAssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignAssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignAssetName campaignAssetName = this;
            synchronized (campaignAssetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignAsset", (Object)this.campaignAsset);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_asset", this.campaignAsset});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignAssetName) {
            CampaignAssetName that = (CampaignAssetName)o;
            return this.customer.equals(that.customer) && this.campaignAsset.equals(that.campaignAsset);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignAsset.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignAsset;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignAsset() {
            return this.campaignAsset;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignAsset(String campaignAsset) {
            this.campaignAsset = campaignAsset;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignAssetName campaignAssetName) {
            this.customer = campaignAssetName.customer;
            this.campaignAsset = campaignAssetName.campaignAsset;
        }

        public CampaignAssetName build() {
            return new CampaignAssetName(this);
        }
    }
}

