/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignAudienceViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignAudienceViews/{campaign_audience_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignAudienceView;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignAudienceView() {
        return this.campaignAudienceView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignAudienceViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignAudienceView = (String)Preconditions.checkNotNull((Object)builder.getCampaignAudienceView());
    }

    public static CampaignAudienceViewName of(String customer, String campaignAudienceView) {
        return CampaignAudienceViewName.newBuilder().setCustomer(customer).setCampaignAudienceView(campaignAudienceView).build();
    }

    public static String format(String customer, String campaignAudienceView) {
        return CampaignAudienceViewName.newBuilder().setCustomer(customer).setCampaignAudienceView(campaignAudienceView).build().toString();
    }

    public static CampaignAudienceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignAudienceViewName.parse: formattedString not in valid format");
        return CampaignAudienceViewName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_audience_view"));
    }

    public static List<CampaignAudienceViewName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignAudienceViewName> list = new ArrayList<CampaignAudienceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignAudienceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignAudienceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignAudienceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignAudienceViewName campaignAudienceViewName = this;
            synchronized (campaignAudienceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignAudienceView", (Object)this.campaignAudienceView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_audience_view", this.campaignAudienceView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignAudienceViewName) {
            CampaignAudienceViewName that = (CampaignAudienceViewName)o;
            return this.customer.equals(that.customer) && this.campaignAudienceView.equals(that.campaignAudienceView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignAudienceView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignAudienceView;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignAudienceView() {
            return this.campaignAudienceView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignAudienceView(String campaignAudienceView) {
            this.campaignAudienceView = campaignAudienceView;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignAudienceViewName campaignAudienceViewName) {
            this.customer = campaignAudienceViewName.customer;
            this.campaignAudienceView = campaignAudienceViewName.campaignAudienceView;
        }

        public CampaignAudienceViewName build() {
            return new CampaignAudienceViewName(this);
        }
    }
}

