/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignBidModifierName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignBidModifiers/{campaign_bid_modifier}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignBidModifier;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignBidModifier() {
        return this.campaignBidModifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignBidModifierName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignBidModifier = (String)Preconditions.checkNotNull((Object)builder.getCampaignBidModifier());
    }

    public static CampaignBidModifierName of(String customer, String campaignBidModifier) {
        return CampaignBidModifierName.newBuilder().setCustomer(customer).setCampaignBidModifier(campaignBidModifier).build();
    }

    public static String format(String customer, String campaignBidModifier) {
        return CampaignBidModifierName.newBuilder().setCustomer(customer).setCampaignBidModifier(campaignBidModifier).build().toString();
    }

    public static CampaignBidModifierName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignBidModifierName.parse: formattedString not in valid format");
        return CampaignBidModifierName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_bid_modifier"));
    }

    public static List<CampaignBidModifierName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignBidModifierName> list = new ArrayList<CampaignBidModifierName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignBidModifierName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignBidModifierName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignBidModifierName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignBidModifierName campaignBidModifierName = this;
            synchronized (campaignBidModifierName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignBidModifier", (Object)this.campaignBidModifier);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_bid_modifier", this.campaignBidModifier});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignBidModifierName) {
            CampaignBidModifierName that = (CampaignBidModifierName)o;
            return this.customer.equals(that.customer) && this.campaignBidModifier.equals(that.campaignBidModifier);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignBidModifier.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignBidModifier;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignBidModifier() {
            return this.campaignBidModifier;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignBidModifier(String campaignBidModifier) {
            this.campaignBidModifier = campaignBidModifier;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignBidModifierName campaignBidModifierName) {
            this.customer = campaignBidModifierName.customer;
            this.campaignBidModifier = campaignBidModifierName.campaignBidModifier;
        }

        public CampaignBidModifierName build() {
            return new CampaignBidModifierName(this);
        }
    }
}

