/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignBudgetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignBudgets/{campaign_budget}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignBudget;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignBudget() {
        return this.campaignBudget;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignBudgetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignBudget = (String)Preconditions.checkNotNull((Object)builder.getCampaignBudget());
    }

    public static CampaignBudgetName of(String customer, String campaignBudget) {
        return CampaignBudgetName.newBuilder().setCustomer(customer).setCampaignBudget(campaignBudget).build();
    }

    public static String format(String customer, String campaignBudget) {
        return CampaignBudgetName.newBuilder().setCustomer(customer).setCampaignBudget(campaignBudget).build().toString();
    }

    public static CampaignBudgetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignBudgetName.parse: formattedString not in valid format");
        return CampaignBudgetName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_budget"));
    }

    public static List<CampaignBudgetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignBudgetName> list = new ArrayList<CampaignBudgetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignBudgetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignBudgetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignBudgetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignBudgetName campaignBudgetName = this;
            synchronized (campaignBudgetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignBudget", (Object)this.campaignBudget);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_budget", this.campaignBudget});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignBudgetName) {
            CampaignBudgetName that = (CampaignBudgetName)o;
            return this.customer.equals(that.customer) && this.campaignBudget.equals(that.campaignBudget);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignBudget.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignBudget;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignBudget() {
            return this.campaignBudget;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignBudget(String campaignBudget) {
            this.campaignBudget = campaignBudget;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignBudgetName campaignBudgetName) {
            this.customer = campaignBudgetName.customer;
            this.campaignBudget = campaignBudgetName.campaignBudget;
        }

        public CampaignBudgetName build() {
            return new CampaignBudgetName(this);
        }
    }
}

