/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.CampaignBudget;
import com.google.ads.googleads.v5.services.CampaignBudgetName;
import com.google.ads.googleads.v5.services.CampaignBudgetOperation;
import com.google.ads.googleads.v5.services.CampaignBudgetServiceSettings;
import com.google.ads.googleads.v5.services.GetCampaignBudgetRequest;
import com.google.ads.googleads.v5.services.MutateCampaignBudgetsRequest;
import com.google.ads.googleads.v5.services.MutateCampaignBudgetsResponse;
import com.google.ads.googleads.v5.services.stub.CampaignBudgetServiceStub;
import com.google.ads.googleads.v5.services.stub.CampaignBudgetServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CampaignBudgetServiceClient
implements BackgroundResource {
    private final CampaignBudgetServiceSettings settings;
    private final CampaignBudgetServiceStub stub;

    public static final CampaignBudgetServiceClient create() throws IOException {
        return CampaignBudgetServiceClient.create(CampaignBudgetServiceSettings.newBuilder().build());
    }

    public static final CampaignBudgetServiceClient create(CampaignBudgetServiceSettings settings) throws IOException {
        return new CampaignBudgetServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignBudgetServiceClient create(CampaignBudgetServiceStub stub) {
        return new CampaignBudgetServiceClient(stub);
    }

    protected CampaignBudgetServiceClient(CampaignBudgetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignBudgetServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignBudgetServiceClient(CampaignBudgetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignBudgetServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignBudgetServiceStub getStub() {
        return this.stub;
    }

    public final CampaignBudget getCampaignBudget(CampaignBudgetName resourceName) {
        GetCampaignBudgetRequest request = GetCampaignBudgetRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignBudget(request);
    }

    public final CampaignBudget getCampaignBudget(String resourceName) {
        GetCampaignBudgetRequest request = GetCampaignBudgetRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignBudget(request);
    }

    public final CampaignBudget getCampaignBudget(GetCampaignBudgetRequest request) {
        return (CampaignBudget)this.getCampaignBudgetCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignBudgetRequest, CampaignBudget> getCampaignBudgetCallable() {
        return this.stub.getCampaignBudgetCallable();
    }

    public final MutateCampaignBudgetsResponse mutateCampaignBudgets(String customerId, List<CampaignBudgetOperation> operations) {
        MutateCampaignBudgetsRequest request = MutateCampaignBudgetsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignBudgets(request);
    }

    public final MutateCampaignBudgetsResponse mutateCampaignBudgets(MutateCampaignBudgetsRequest request) {
        return (MutateCampaignBudgetsResponse)this.mutateCampaignBudgetsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignBudgetsRequest, MutateCampaignBudgetsResponse> mutateCampaignBudgetsCallable() {
        return this.stub.mutateCampaignBudgetsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

