/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignCriterionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignCriteria/{campaign_criterion}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignCriterion;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignCriterion() {
        return this.campaignCriterion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignCriterionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignCriterion = (String)Preconditions.checkNotNull((Object)builder.getCampaignCriterion());
    }

    public static CampaignCriterionName of(String customer, String campaignCriterion) {
        return CampaignCriterionName.newBuilder().setCustomer(customer).setCampaignCriterion(campaignCriterion).build();
    }

    public static String format(String customer, String campaignCriterion) {
        return CampaignCriterionName.newBuilder().setCustomer(customer).setCampaignCriterion(campaignCriterion).build().toString();
    }

    public static CampaignCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignCriterionName.parse: formattedString not in valid format");
        return CampaignCriterionName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_criterion"));
    }

    public static List<CampaignCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignCriterionName> list = new ArrayList<CampaignCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignCriterionName campaignCriterionName = this;
            synchronized (campaignCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignCriterion", (Object)this.campaignCriterion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_criterion", this.campaignCriterion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignCriterionName) {
            CampaignCriterionName that = (CampaignCriterionName)o;
            return this.customer.equals(that.customer) && this.campaignCriterion.equals(that.campaignCriterion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignCriterion.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignCriterion;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignCriterion() {
            return this.campaignCriterion;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignCriterion(String campaignCriterion) {
            this.campaignCriterion = campaignCriterion;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignCriterionName campaignCriterionName) {
            this.customer = campaignCriterionName.customer;
            this.campaignCriterion = campaignCriterionName.campaignCriterion;
        }

        public CampaignCriterionName build() {
            return new CampaignCriterionName(this);
        }
    }
}

