/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignCriterionSimulationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignCriterionSimulations/{campaign_criterion_simulation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignCriterionSimulation;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignCriterionSimulation() {
        return this.campaignCriterionSimulation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignCriterionSimulationName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignCriterionSimulation = (String)Preconditions.checkNotNull((Object)builder.getCampaignCriterionSimulation());
    }

    public static CampaignCriterionSimulationName of(String customer, String campaignCriterionSimulation) {
        return CampaignCriterionSimulationName.newBuilder().setCustomer(customer).setCampaignCriterionSimulation(campaignCriterionSimulation).build();
    }

    public static String format(String customer, String campaignCriterionSimulation) {
        return CampaignCriterionSimulationName.newBuilder().setCustomer(customer).setCampaignCriterionSimulation(campaignCriterionSimulation).build().toString();
    }

    public static CampaignCriterionSimulationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignCriterionSimulationName.parse: formattedString not in valid format");
        return CampaignCriterionSimulationName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_criterion_simulation"));
    }

    public static List<CampaignCriterionSimulationName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignCriterionSimulationName> list = new ArrayList<CampaignCriterionSimulationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignCriterionSimulationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignCriterionSimulationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignCriterionSimulationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignCriterionSimulationName campaignCriterionSimulationName = this;
            synchronized (campaignCriterionSimulationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignCriterionSimulation", (Object)this.campaignCriterionSimulation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_criterion_simulation", this.campaignCriterionSimulation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignCriterionSimulationName) {
            CampaignCriterionSimulationName that = (CampaignCriterionSimulationName)o;
            return this.customer.equals(that.customer) && this.campaignCriterionSimulation.equals(that.campaignCriterionSimulation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignCriterionSimulation.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignCriterionSimulation;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignCriterionSimulation() {
            return this.campaignCriterionSimulation;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignCriterionSimulation(String campaignCriterionSimulation) {
            this.campaignCriterionSimulation = campaignCriterionSimulation;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignCriterionSimulationName campaignCriterionSimulationName) {
            this.customer = campaignCriterionSimulationName.customer;
            this.campaignCriterionSimulation = campaignCriterionSimulationName.campaignCriterionSimulation;
        }

        public CampaignCriterionSimulationName build() {
            return new CampaignCriterionSimulationName(this);
        }
    }
}

