/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignDraftName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignDrafts/{campaign_draft}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignDraft;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignDraft() {
        return this.campaignDraft;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignDraftName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignDraft = (String)Preconditions.checkNotNull((Object)builder.getCampaignDraft());
    }

    public static CampaignDraftName of(String customer, String campaignDraft) {
        return CampaignDraftName.newBuilder().setCustomer(customer).setCampaignDraft(campaignDraft).build();
    }

    public static String format(String customer, String campaignDraft) {
        return CampaignDraftName.newBuilder().setCustomer(customer).setCampaignDraft(campaignDraft).build().toString();
    }

    public static CampaignDraftName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignDraftName.parse: formattedString not in valid format");
        return CampaignDraftName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_draft"));
    }

    public static List<CampaignDraftName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignDraftName> list = new ArrayList<CampaignDraftName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignDraftName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignDraftName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignDraftName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignDraftName campaignDraftName = this;
            synchronized (campaignDraftName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignDraft", (Object)this.campaignDraft);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_draft", this.campaignDraft});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignDraftName) {
            CampaignDraftName that = (CampaignDraftName)o;
            return this.customer.equals(that.customer) && this.campaignDraft.equals(that.campaignDraft);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignDraft.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignDraft;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignDraft() {
            return this.campaignDraft;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignDraft(String campaignDraft) {
            this.campaignDraft = campaignDraft;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignDraftName campaignDraftName) {
            this.customer = campaignDraftName.customer;
            this.campaignDraft = campaignDraftName.campaignDraft;
        }

        public CampaignDraftName build() {
            return new CampaignDraftName(this);
        }
    }
}

