/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignExperimentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignExperiments/{campaign_experiment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignExperiment;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignExperiment() {
        return this.campaignExperiment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignExperimentName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignExperiment = (String)Preconditions.checkNotNull((Object)builder.getCampaignExperiment());
    }

    public static CampaignExperimentName of(String customer, String campaignExperiment) {
        return CampaignExperimentName.newBuilder().setCustomer(customer).setCampaignExperiment(campaignExperiment).build();
    }

    public static String format(String customer, String campaignExperiment) {
        return CampaignExperimentName.newBuilder().setCustomer(customer).setCampaignExperiment(campaignExperiment).build().toString();
    }

    public static CampaignExperimentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignExperimentName.parse: formattedString not in valid format");
        return CampaignExperimentName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_experiment"));
    }

    public static List<CampaignExperimentName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignExperimentName> list = new ArrayList<CampaignExperimentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignExperimentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignExperimentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignExperimentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignExperimentName campaignExperimentName = this;
            synchronized (campaignExperimentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignExperiment", (Object)this.campaignExperiment);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_experiment", this.campaignExperiment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignExperimentName) {
            CampaignExperimentName that = (CampaignExperimentName)o;
            return this.customer.equals(that.customer) && this.campaignExperiment.equals(that.campaignExperiment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignExperiment.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignExperiment;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignExperiment() {
            return this.campaignExperiment;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignExperiment(String campaignExperiment) {
            this.campaignExperiment = campaignExperiment;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignExperimentName campaignExperimentName) {
            this.customer = campaignExperimentName.customer;
            this.campaignExperiment = campaignExperimentName.campaignExperiment;
        }

        public CampaignExperimentName build() {
            return new CampaignExperimentName(this);
        }
    }
}

