/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.CampaignExperiment;
import com.google.ads.googleads.v5.services.CampaignExperimentName;
import com.google.ads.googleads.v5.services.CampaignExperimentOperation;
import com.google.ads.googleads.v5.services.CampaignExperimentServiceSettings;
import com.google.ads.googleads.v5.services.CreateCampaignExperimentMetadata;
import com.google.ads.googleads.v5.services.CreateCampaignExperimentRequest;
import com.google.ads.googleads.v5.services.EndCampaignExperimentRequest;
import com.google.ads.googleads.v5.services.GetCampaignExperimentRequest;
import com.google.ads.googleads.v5.services.GraduateCampaignExperimentRequest;
import com.google.ads.googleads.v5.services.GraduateCampaignExperimentResponse;
import com.google.ads.googleads.v5.services.ListCampaignExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v5.services.ListCampaignExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v5.services.MutateCampaignExperimentsRequest;
import com.google.ads.googleads.v5.services.MutateCampaignExperimentsResponse;
import com.google.ads.googleads.v5.services.PromoteCampaignExperimentRequest;
import com.google.ads.googleads.v5.services.stub.CampaignExperimentServiceStub;
import com.google.ads.googleads.v5.services.stub.CampaignExperimentServiceStubSettings;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CampaignExperimentServiceClient
implements BackgroundResource {
    private final CampaignExperimentServiceSettings settings;
    private final CampaignExperimentServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CampaignExperimentServiceClient create() throws IOException {
        return CampaignExperimentServiceClient.create(CampaignExperimentServiceSettings.newBuilder().build());
    }

    public static final CampaignExperimentServiceClient create(CampaignExperimentServiceSettings settings) throws IOException {
        return new CampaignExperimentServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignExperimentServiceClient create(CampaignExperimentServiceStub stub) {
        return new CampaignExperimentServiceClient(stub);
    }

    protected CampaignExperimentServiceClient(CampaignExperimentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignExperimentServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignExperimentServiceClient(CampaignExperimentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CampaignExperimentServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignExperimentServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final CampaignExperiment getCampaignExperiment(CampaignExperimentName resourceName) {
        GetCampaignExperimentRequest request = GetCampaignExperimentRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignExperiment(request);
    }

    public final CampaignExperiment getCampaignExperiment(String resourceName) {
        GetCampaignExperimentRequest request = GetCampaignExperimentRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignExperiment(request);
    }

    public final CampaignExperiment getCampaignExperiment(GetCampaignExperimentRequest request) {
        return (CampaignExperiment)this.getCampaignExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignExperimentRequest, CampaignExperiment> getCampaignExperimentCallable() {
        return this.stub.getCampaignExperimentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, CreateCampaignExperimentMetadata> createCampaignExperimentAsync(String customerId, CampaignExperiment campaignExperiment) {
        CreateCampaignExperimentRequest request = CreateCampaignExperimentRequest.newBuilder().setCustomerId(customerId).setCampaignExperiment(campaignExperiment).build();
        return this.createCampaignExperimentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, CreateCampaignExperimentMetadata> createCampaignExperimentAsync(CreateCampaignExperimentRequest request) {
        return this.createCampaignExperimentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationCallable() {
        return this.stub.createCampaignExperimentOperationCallable();
    }

    public final UnaryCallable<CreateCampaignExperimentRequest, Operation> createCampaignExperimentCallable() {
        return this.stub.createCampaignExperimentCallable();
    }

    public final MutateCampaignExperimentsResponse mutateCampaignExperiments(String customerId, List<CampaignExperimentOperation> operations) {
        MutateCampaignExperimentsRequest request = MutateCampaignExperimentsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignExperiments(request);
    }

    public final MutateCampaignExperimentsResponse mutateCampaignExperiments(MutateCampaignExperimentsRequest request) {
        return (MutateCampaignExperimentsResponse)this.mutateCampaignExperimentsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsCallable() {
        return this.stub.mutateCampaignExperimentsCallable();
    }

    public final GraduateCampaignExperimentResponse graduateCampaignExperiment(String campaignExperiment, String campaignBudget) {
        GraduateCampaignExperimentRequest request = GraduateCampaignExperimentRequest.newBuilder().setCampaignExperiment(campaignExperiment).setCampaignBudget(campaignBudget).build();
        return this.graduateCampaignExperiment(request);
    }

    public final GraduateCampaignExperimentResponse graduateCampaignExperiment(GraduateCampaignExperimentRequest request) {
        return (GraduateCampaignExperimentResponse)this.graduateCampaignExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentCallable() {
        return this.stub.graduateCampaignExperimentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> promoteCampaignExperimentAsync(String campaignExperiment) {
        PromoteCampaignExperimentRequest request = PromoteCampaignExperimentRequest.newBuilder().setCampaignExperiment(campaignExperiment).build();
        return this.promoteCampaignExperimentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, Empty> promoteCampaignExperimentAsync(PromoteCampaignExperimentRequest request) {
        return this.promoteCampaignExperimentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationCallable() {
        return this.stub.promoteCampaignExperimentOperationCallable();
    }

    public final UnaryCallable<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentCallable() {
        return this.stub.promoteCampaignExperimentCallable();
    }

    public final void endCampaignExperiment(String campaignExperiment) {
        EndCampaignExperimentRequest request = EndCampaignExperimentRequest.newBuilder().setCampaignExperiment(campaignExperiment).build();
        this.endCampaignExperiment(request);
    }

    public final void endCampaignExperiment(EndCampaignExperimentRequest request) {
        this.endCampaignExperimentCallable().call((Object)request);
    }

    public final UnaryCallable<EndCampaignExperimentRequest, Empty> endCampaignExperimentCallable() {
        return this.stub.endCampaignExperimentCallable();
    }

    public final ListCampaignExperimentAsyncErrorsPagedResponse listCampaignExperimentAsyncErrors(CampaignExperimentName resourceName) {
        ListCampaignExperimentAsyncErrorsRequest request = ListCampaignExperimentAsyncErrorsRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.listCampaignExperimentAsyncErrors(request);
    }

    public final ListCampaignExperimentAsyncErrorsPagedResponse listCampaignExperimentAsyncErrors(String resourceName) {
        ListCampaignExperimentAsyncErrorsRequest request = ListCampaignExperimentAsyncErrorsRequest.newBuilder().setResourceName(resourceName).build();
        return this.listCampaignExperimentAsyncErrors(request);
    }

    public final ListCampaignExperimentAsyncErrorsPagedResponse listCampaignExperimentAsyncErrors(ListCampaignExperimentAsyncErrorsRequest request) {
        return (ListCampaignExperimentAsyncErrorsPagedResponse)((Object)this.listCampaignExperimentAsyncErrorsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsPagedCallable() {
        return this.stub.listCampaignExperimentAsyncErrorsPagedCallable();
    }

    public final UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse> listCampaignExperimentAsyncErrorsCallable() {
        return this.stub.listCampaignExperimentAsyncErrorsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListCampaignExperimentAsyncErrorsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status, ListCampaignExperimentAsyncErrorsPage, ListCampaignExperimentAsyncErrorsFixedSizeCollection> {
        private ListCampaignExperimentAsyncErrorsFixedSizeCollection(List<ListCampaignExperimentAsyncErrorsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCampaignExperimentAsyncErrorsFixedSizeCollection createEmptyCollection() {
            return new ListCampaignExperimentAsyncErrorsFixedSizeCollection(null, 0);
        }

        protected ListCampaignExperimentAsyncErrorsFixedSizeCollection createCollection(List<ListCampaignExperimentAsyncErrorsPage> pages, int collectionSize) {
            return new ListCampaignExperimentAsyncErrorsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCampaignExperimentAsyncErrorsPage
    extends AbstractPage<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status, ListCampaignExperimentAsyncErrorsPage> {
        private ListCampaignExperimentAsyncErrorsPage(PageContext<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status> context, ListCampaignExperimentAsyncErrorsResponse response) {
            super(context, (Object)response);
        }

        private static ListCampaignExperimentAsyncErrorsPage createEmptyPage() {
            return new ListCampaignExperimentAsyncErrorsPage(null, null);
        }

        protected ListCampaignExperimentAsyncErrorsPage createPage(PageContext<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status> context, ListCampaignExperimentAsyncErrorsResponse response) {
            return new ListCampaignExperimentAsyncErrorsPage(context, response);
        }

        public ApiFuture<ListCampaignExperimentAsyncErrorsPage> createPageAsync(PageContext<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status> context, ApiFuture<ListCampaignExperimentAsyncErrorsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCampaignExperimentAsyncErrorsPagedResponse
    extends AbstractPagedListResponse<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status, ListCampaignExperimentAsyncErrorsPage, ListCampaignExperimentAsyncErrorsFixedSizeCollection> {
        public static ApiFuture<ListCampaignExperimentAsyncErrorsPagedResponse> createAsync(PageContext<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status> context, ApiFuture<ListCampaignExperimentAsyncErrorsResponse> futureResponse) {
            ApiFuture<ListCampaignExperimentAsyncErrorsPage> futurePage = ListCampaignExperimentAsyncErrorsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListCampaignExperimentAsyncErrorsPage, ListCampaignExperimentAsyncErrorsPagedResponse>(){

                public ListCampaignExperimentAsyncErrorsPagedResponse apply(ListCampaignExperimentAsyncErrorsPage input) {
                    return new ListCampaignExperimentAsyncErrorsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListCampaignExperimentAsyncErrorsPagedResponse(ListCampaignExperimentAsyncErrorsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCampaignExperimentAsyncErrorsFixedSizeCollection.createEmptyCollection());
        }
    }
}

